/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.generator;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

public final class CraftChunkData
implements ChunkGenerator.ChunkData {
    private final int maxHeight;
    private final int minHeight;
    private final WeakReference<efy> weakChunk;

    public CraftChunkData(World world, efy chunkAccess) {
        this(world.getMaxHeight(), world.getMinHeight(), chunkAccess);
    }

    CraftChunkData(int maxHeight, int minHeight, efy chunkAccess) {
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
        this.weakChunk = new WeakReference<efy>(chunkAccess);
    }

    public efy getHandle() {
        efy access = (efy)this.weakChunk.get();
        Preconditions.checkState((access != null ? 1 : 0) != 0, (Object)"IChunkAccess no longer present, are you using it in a different tick?");
        return access;
    }

    public void breakLink() {
        this.weakChunk.clear();
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public Biome getBiome(int x2, int y2, int z2) {
        return CraftBiome.minecraftHolderToBukkit(this.getHandle().getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
    }

    public void setBlock(int x2, int y2, int z2, Material material) {
        this.setBlock(x2, y2, z2, material.createBlockData());
    }

    public void setBlock(int x2, int y2, int z2, MaterialData material) {
        this.setBlock(x2, y2, z2, CraftMagicNumbers.getBlock(material));
    }

    public void setBlock(int x2, int y2, int z2, BlockData blockData) {
        this.setBlock(x2, y2, z2, ((CraftBlockData)blockData).getState());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    public Material getType(int x2, int y2, int z2) {
        return CraftBlockType.minecraftToBukkit(this.getTypeId(x2, y2, z2).b());
    }

    public MaterialData getTypeAndData(int x2, int y2, int z2) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x2, y2, z2));
    }

    public BlockData getBlockData(int x2, int y2, int z2) {
        return CraftBlockData.fromData(this.getTypeId(x2, y2, z2));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, eeb type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < this.minHeight) {
            yMin = this.minHeight;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y2 = yMin; y2 < yMax; ++y2) {
            for (int x2 = xMin; x2 < xMax; ++x2) {
                for (int z2 = zMin; z2 < zMax; ++z2) {
                    this.setBlock(x2, y2, z2, type);
                }
            }
        }
    }

    public eeb getTypeId(int x2, int y2, int z2) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return dqb.a.m();
        }
        efy access = this.getHandle();
        return access.a_(new jb(access.f().d() + x2, y2, access.f().e() + z2));
    }

    public byte getData(int x2, int y2, int z2) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x2, y2, z2));
    }

    private void setBlock(int x2, int y2, int z2, eeb type) {
        if (x2 != (x2 & 0xF) || y2 < this.minHeight || y2 >= this.maxHeight || z2 != (z2 & 0xF)) {
            return;
        }
        efy access = this.getHandle();
        jb blockPosition = new jb(access.f().d() + x2, y2, access.f().e() + z2);
        eeb oldBlockData = access.a(blockPosition, type, 256);
        if (type.x()) {
            eaz tileEntity = ((dsu)((Object)type.b())).a(blockPosition, type);
            if (tileEntity == null) {
                access.d(blockPosition);
            } else {
                access.a(tileEntity);
            }
        } else if (oldBlockData != null && oldBlockData.x()) {
            access.d(blockPosition);
        }
    }
}

