/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemFlag;

public class CraftItemFlag {
    private static final BiMap<ItemFlag, kp<?>> BUKKIT_TO_NMS = HashBiMap.create();
    private static final Collection<kp<?>> HIDE_ADDITIONAL_TOOLTIP = Arrays.asList(kq.R, kq.U, kq.V, kq.aj, kq.ai, kq.L, kq.N, kq.M, kq.O, kq.am, kq.J);

    public static Collection<kp<?>> bukkitToNMS(ItemFlag bukkit) {
        if (bukkit == ItemFlag.HIDE_ADDITIONAL_TOOLTIP) {
            return HIDE_ADDITIONAL_TOOLTIP;
        }
        kp<?> type = (kp<?>)BUKKIT_TO_NMS.get((Object)bukkit);
        if (type == null) {
            NamespacedKey key = bukkit.getComponent();
            Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"Unknown flag %s must have component key", (Object)bukkit);
            type = mm.am.a(CraftNamespacedKey.toMinecraft(key));
        }
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown flag %s", (Object)bukkit);
        return Arrays.asList(type);
    }

    public static ItemFlag nmsToBukkit(kp<?> nms) {
        ItemFlag inverse = (ItemFlag)BUKKIT_TO_NMS.inverse().get(nms);
        if (inverse == null) {
            ame key = mm.am.b(nms);
            if (key == null) {
                throw new IllegalArgumentException("Unregistered component " + String.valueOf(nms));
            }
            inverse = ItemFlag.valueOf((String)("HIDE_" + key.a().toUpperCase(Locale.ROOT).replace('/', '_')));
        }
        return inverse;
    }

    public static String bukkitToString(ItemFlag bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.name();
    }

    public static ItemFlag stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertItemFlagName(ApiVersion.CURRENT, string);
        return ItemFlag.valueOf((String)string);
    }

    static {
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ARMOR_TRIM, kq.W);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ATTRIBUTES, kq.o);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_DESTROYS, kq.n);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_DYE, kq.K);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_ENCHANTS, kq.l);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_PLACED_ON, kq.m);
        BUKKIT_TO_NMS.put((Object)ItemFlag.HIDE_UNBREAKABLE, kq.f);
    }
}

