/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class CraftShapedRecipe
extends ShapedRecipe
implements CraftRecipe {
    private dia recipe;

    public CraftShapedRecipe(NamespacedKey key, ItemStack result) {
        super(key, result);
    }

    public CraftShapedRecipe(NamespacedKey key, ItemStack result, dia recipe) {
        this(key, result);
        this.recipe = recipe;
    }

    public static CraftShapedRecipe fromBukkitRecipe(ShapedRecipe recipe) {
        if (recipe instanceof CraftShapedRecipe) {
            return (CraftShapedRecipe)recipe;
        }
        CraftShapedRecipe ret = new CraftShapedRecipe(recipe.getKey(), recipe.getResult());
        ret.setGroup(recipe.getGroup());
        ret.setCategory(recipe.getCategory());
        String[] shape = recipe.getShape();
        ret.shape(shape);
        Map ingredientMap = recipe.getChoiceMap();
        Iterator iterator = ingredientMap.keySet().iterator();
        while (iterator.hasNext()) {
            char c2 = ((Character)iterator.next()).charValue();
            RecipeChoice stack = (RecipeChoice)ingredientMap.get(Character.valueOf(c2));
            if (stack == null) continue;
            ret.setIngredient(c2, stack);
        }
        return ret;
    }

    @Override
    public void addToCraftingManager() {
        Map ingred = this.getChoiceMap();
        String[] shape = CraftShapedRecipe.replaceUndefinedIngredientsWithEmpty(this.getShape(), ingred);
        ingred.values().removeIf(Objects::isNull);
        Map data = Maps.transformValues((Map)ingred, bukkit -> this.toNMS((RecipeChoice)bukkit, false));
        dib pattern = dib.a((Map<Character, dhi>)data, shape);
        MinecraftServer.getServer().aI().addRecipe(new dhr<dia>(CraftRecipe.toMinecraft(this.getKey()), new dia(this.getGroup(), CraftRecipe.getCategory(this.getCategory()), pattern, CraftItemStack.asNMSCopy(this.getResult()))));
    }

    private static String[] replaceUndefinedIngredientsWithEmpty(String[] shape, Map<Character, RecipeChoice> ingredients) {
        for (int i2 = 0; i2 < shape.length; ++i2) {
            String row = shape[i2];
            StringBuilder filteredRow = new StringBuilder(row.length());
            for (char character : row.toCharArray()) {
                filteredRow.append(ingredients.get(Character.valueOf(character)) == null ? (char)' ' : character);
            }
            shape[i2] = filteredRow.toString();
        }
        return shape;
    }
}

