/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory.components.consumable.effects;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.craftbukkit.v1_21_R5.inventory.ItemMetaKey;
import org.bukkit.craftbukkit.v1_21_R5.inventory.SerializableMeta;
import org.bukkit.craftbukkit.v1_21_R5.inventory.components.consumable.effects.CraftConsumableEffect;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.inventory.meta.components.consumable.effects.ConsumableRemoveEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftConsumableRemoveEffect
extends CraftConsumableEffect<dgl>
implements ConsumableRemoveEffect {
    static final ItemMetaKey POTION_TYPES = new ItemMetaKey("effects");

    public CraftConsumableRemoveEffect(dgl consumeEffect) {
        super(consumeEffect);
    }

    public CraftConsumableRemoveEffect(CraftConsumableRemoveEffect consumeEffect) {
        super(consumeEffect);
    }

    public CraftConsumableRemoveEffect(Map<String, Object> map) {
        super(map);
        ArrayList<PotionEffectType> effectTypeList = new ArrayList<PotionEffectType>();
        Iterable rawEffectTypeList = SerializableMeta.getObject(Iterable.class, map, CraftConsumableRemoveEffect.POTION_TYPES.BUKKIT, true);
        if (rawEffectTypeList == null) {
            return;
        }
        for (Object obj : rawEffectTypeList) {
            Preconditions.checkArgument((boolean)(obj instanceof PotionEffectType), (String)"Object (%s) in effect type list is not valid", obj.getClass());
            effectTypeList.add((PotionEffectType)obj);
        }
        this.handle = new dgl(jp.a(effectTypeList.stream().map(CraftPotionEffectType::bukkitToMinecraftHolder).collect(Collectors.toList())));
    }

    @Override
    public dgl getHandle() {
        return (dgl)super.getHandle();
    }

    public List<PotionEffectType> getEffectTypes() {
        return this.getHandle().b().a().map(CraftPotionEffectType::minecraftHolderToBukkit).collect(Collectors.toList());
    }

    public void setEffectTypes(List<PotionEffectType> effectTypeList) {
        this.handle = new dgl(jp.a(effectTypeList.stream().map(CraftPotionEffectType::bukkitToMinecraftHolder).collect(Collectors.toList())));
    }

    public PotionEffectType addEffectType(PotionEffectType potionEffect) {
        List<PotionEffectType> list = this.getEffectTypes();
        list.add(potionEffect);
        this.setEffectTypes(list);
        return potionEffect;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(CraftConsumableRemoveEffect.POTION_TYPES.BUKKIT, ImmutableList.copyOf(this.getEffectTypes()));
        return result;
    }
}

