/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory.view.builder;

import com.google.common.base.Preconditions;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;

public abstract class CraftAbstractInventoryViewBuilder<V extends InventoryView>
implements InventoryViewBuilder<V> {
    protected final czv<?> handle;
    protected boolean checkReachable = false;
    protected String title = null;

    public CraftAbstractInventoryViewBuilder(czv<?> handle) {
        this.handle = handle;
    }

    public InventoryViewBuilder<V> title(String title) {
        this.title = title;
        return this;
    }

    public V build(HumanEntity player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"The given player must not be null");
        Preconditions.checkArgument((this.title != null ? 1 : 0) != 0, (Object)"The given title must not be null");
        Preconditions.checkArgument((boolean)(player instanceof CraftHumanEntity), (Object)"The given player must be a CraftHumanEntity");
        CraftHumanEntity craftHuman = (CraftHumanEntity)player;
        Preconditions.checkArgument((boolean)(craftHuman.getHandle() instanceof auc), (Object)"The given player must be an EntityPlayer");
        auc serverPlayer = (auc)craftHuman.getHandle();
        cym container = this.buildContainer(serverPlayer);
        container.checkReachable = this.checkReachable;
        container.setTitle(CraftChatMessage.fromString(this.title)[0]);
        return (V)container.getBukkitView();
    }

    protected abstract cym buildContainer(auc var1);
}

