/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory.view.builder;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.inventory.view.builder.CraftAbstractInventoryViewBuilder;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.view.builder.LocationInventoryViewBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class CraftAbstractLocationInventoryViewBuilder<V extends InventoryView>
extends CraftAbstractInventoryViewBuilder<V>
implements LocationInventoryViewBuilder<V> {
    protected dmu world;
    protected jb position;

    public CraftAbstractLocationInventoryViewBuilder(czv<?> handle) {
        super(handle);
    }

    @Override
    public LocationInventoryViewBuilder<V> title(@NotNull String title) {
        return (LocationInventoryViewBuilder)super.title(title);
    }

    public LocationInventoryViewBuilder<V> copy() {
        throw new UnsupportedOperationException("copy is not implemented on CraftAbstractLocationInventoryViewBuilder");
    }

    public LocationInventoryViewBuilder<V> checkReachable(boolean checkReachable) {
        this.checkReachable = checkReachable;
        return this;
    }

    public LocationInventoryViewBuilder<V> location(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"The provided location must not be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"The provided location must be associated with a world");
        this.world = ((CraftWorld)location.getWorld()).getHandle();
        this.position = CraftLocation.toBlockPosition(location);
        return this;
    }
}

