/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.packs.DataPack;

public class CraftDataPack
implements DataPack {
    private final aww handle;
    private final awp resourcePackInfo;

    public CraftDataPack(aww handler) {
        this.handle = handler;
        try (awb iresourcepack = this.handle.c.a(this.handle.a());){
            this.resourcePackInfo = iresourcepack.a(awp.b);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public aww getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().g();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().b());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().c());
    }

    public int getPackFormat() {
        return this.resourcePackInfo.b();
    }

    public int getMinSupportedPackFormat() {
        return this.resourcePackInfo.c().orElse(new bbt<Integer>(this.getPackFormat())).a();
    }

    public int getMaxSupportedPackFormat() {
        return this.resourcePackInfo.c().orElse(new bbt<Integer>(this.getPackFormat())).b();
    }

    public boolean isRequired() {
        return this.getHandle().i();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().d()) {
            default -> throw new MatchException(null, null);
            case awx.c -> DataPack.Compatibility.COMPATIBLE;
            case awx.b -> DataPack.Compatibility.NEW;
            case awx.a -> DataPack.Compatibility.OLD;
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().aF().e().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().l() == axa.c) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().l() == axa.d) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().l() == axa.e) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().l() == axa.f) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().e()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + String.valueOf(this.getKey()) + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + String.valueOf(this.getCompatibility()) + ",source=" + String.valueOf(this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

