/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.potion;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_21_R5.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionType
implements PotionType.InternalPotionData {
    private final NamespacedKey key;
    private final dep potion;
    private final Supplier<List<PotionEffect>> potionEffects;
    private final Supplier<Boolean> upgradeable;
    private final Supplier<Boolean> extendable;
    private final Supplier<Integer> maxLevel;

    public static PotionType minecraftHolderToBukkit(jl<dep> minecraft) {
        return CraftPotionType.minecraftToBukkit(minecraft.a());
    }

    public static PotionType minecraftToBukkit(dep minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.ah);
        PotionType bukkit = (PotionType)Registry.POTION.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit;
    }

    public static dep bukkitToMinecraft(PotionType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return (dep)CraftRegistry.getMinecraftRegistry(mn.ah).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static jl<dep> bukkitToMinecraftHolder(PotionType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        jy registry = CraftRegistry.getMinecraftRegistry(mn.ah);
        jl<dep> jl2 = registry.e(CraftPotionType.bukkitToMinecraft(bukkit));
        if (jl2 instanceof jl.c) {
            jl.c holder = (jl.c)jl2;
            return holder;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own sound effect with out properly registering it.");
    }

    public static String bukkitToString(PotionType bukkit) {
        Preconditions.checkArgument((bukkit != null ? 1 : 0) != 0);
        return bukkit.getKey().toString();
    }

    public static PotionType stringToBukkit(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        string = FieldRename.convertPotionTypeName(ApiVersion.CURRENT, string);
        string = string.toLowerCase(Locale.ROOT);
        NamespacedKey key = NamespacedKey.fromString((String)string);
        return (PotionType)CraftRegistry.get(Registry.POTION, key, ApiVersion.CURRENT);
    }

    public CraftPotionType(NamespacedKey key, dep potion) {
        this.key = key;
        this.potion = potion;
        this.potionEffects = Suppliers.memoize(() -> potion.a().stream().map(CraftPotionUtil::toBukkit).toList());
        this.upgradeable = Suppliers.memoize(() -> Registry.POTION.get(new NamespacedKey(key.getNamespace(), "strong_" + key.getKey())) != null);
        this.extendable = Suppliers.memoize(() -> Registry.POTION.get(new NamespacedKey(key.getNamespace(), "long_" + key.getKey())) != null);
        this.maxLevel = Suppliers.memoize(() -> this.isUpgradeable() ? 2 : 1);
    }

    public PotionEffectType getEffectType() {
        return this.getPotionEffects().isEmpty() ? null : this.getPotionEffects().get(0).getType();
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects.get();
    }

    public boolean isInstant() {
        return this.potion.c();
    }

    public boolean isUpgradeable() {
        return this.upgradeable.get();
    }

    public boolean isExtendable() {
        return this.extendable.get();
    }

    public int getMaxLevel() {
        return this.maxLevel.get();
    }
}

