/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.scoreboard;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_21_R5.util.WeakCollection;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.spigotmc.AsyncCatcher;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, fjx scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    public CraftScoreboard getNewScoreboard() {
        AsyncCatcher.catchOp("scoreboard creation");
        CraftScoreboard scoreboard = new CraftScoreboard(new amx(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) {
        Preconditions.checkArgument((boolean)(bukkitScoreboard instanceof CraftScoreboard), (Object)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        fjx oldboard = this.getPlayerBoard(player).getHandle();
        fjx newboard = scoreboard.getHandle();
        auc entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<fjp> removed = new HashSet<fjp>();
        for (int i2 = 0; i2 < 3; ++i2) {
            fjp scoreboardobjective = oldboard.a(fjo.u.apply(i2));
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.g.b(new agg(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (fjs scoreboardteam : oldboard.f()) {
            entityplayer.g.b(agj.a(scoreboardteam));
        }
        this.server.ag().a((amx)newboard, player.getHandle());
    }

    public void removePlayer(CraftPlayer player) {
        this.playerBoards.remove(player);
    }

    public void forAllObjectives(fka criteria, fjw holder, Consumer<fjv> consumer) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            fjx board = scoreboard.board;
            board.a(criteria, holder, score -> consumer.accept((fjv)score));
        }
    }
}

