/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.VersionedComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, o> formatMap;

    public static VersionedComponentSerializer getBungee() {
        return VersionedComponentSerializer.forVersion((ChatVersion)ChatVersion.V1_21_5);
    }

    public static o getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(o format) {
        return ChatColor.getByChar((char)format.C);
    }

    public static Optional<xo> fromStringOrOptional(String message) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message));
    }

    public static Optional<xo> fromStringOrOptional(String message, boolean keepNewlines) {
        return Optional.ofNullable(CraftChatMessage.fromStringOrNull(message, keepNewlines));
    }

    public static xo fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static xo fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static xo fromStringOrEmpty(String message) {
        return CraftChatMessage.fromStringOrEmpty(message, false);
    }

    public static xo fromStringOrEmpty(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static xo[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static xo[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static xo[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(xo component) {
        return ChatSerializer.toJson(component, MinecraftServer.getDefaultRegistryAccess());
    }

    public static String toJSONOrNull(xo component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static xo fromJSON(String jsonMessage) throws JsonParseException {
        return ChatSerializer.fromJson(jsonMessage, MinecraftServer.getDefaultRegistryAccess());
    }

    public static xo fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex2) {
            return null;
        }
    }

    public static xo fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static xo fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    public static xo fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, nullable, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static xo fromJSONOrString(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        xo component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromString(trimmedContent, keepNewlines)[0];
            }
            return component;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromComponent(xo component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (xo c2 : component) {
            yl modi = c2.a();
            yn color = modi.a();
            if (c2.b() != yv.c || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        for (char magic : color.b().substring(1).toCharArray()) {
                            out.append('\u00a7').append(magic);
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.c()) {
                out.append(o.r);
                hadFormat = true;
            }
            if (modi.d()) {
                out.append(o.u);
                hadFormat = true;
            }
            if (modi.f()) {
                out.append(o.t);
                hadFormat = true;
            }
            if (modi.e()) {
                out.append(o.s);
                hadFormat = true;
            }
            if (modi.g()) {
                out.append(o.q);
                hadFormat = true;
            }
            c2.b().a(x2 -> {
                out.append(x2);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static xo fixComponent(yc component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static xo fixComponent(yc component, Matcher matcher) {
        yv text;
        String msg;
        if (component.b() instanceof yv && matcher.reset(msg = (text = (yv)component.b()).b()).find()) {
            matcher.reset();
            yl modifier = component.a();
            ArrayList<xo> extras = new ArrayList<xo>();
            ArrayList<xo> extrasOld = new ArrayList<xo>(component.c());
            component = xo.i();
            int pos = 0;
            while (matcher.find()) {
                Object match = matcher.group();
                if (!((String)match).startsWith("http://") && !((String)match).startsWith("https://")) {
                    match = "http://" + (String)match;
                }
                yc prev = xo.b(msg.substring(pos, matcher.start()));
                prev.b(modifier);
                extras.add(prev);
                yc link = xo.b(matcher.group());
                try {
                    yl linkModi = modifier.a(new xm.f(ag.a((String)match)));
                    link.b(linkModi);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                extras.add(link);
                pos = matcher.end();
            }
            yc prev = xo.b(msg.substring(pos));
            prev.b(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (xo c2 : extras) {
                component.b(c2);
            }
        }
        List<xo> extras = component.c();
        for (int i2 = 0; i2 < extras.size(); ++i2) {
            xo comp = extras.get(i2);
            if (comp.a() == null || comp.a().i() != null) continue;
            extras.set(i2, CraftChatMessage.fixComponent(comp.f(), matcher));
        }
        if (component.b() instanceof yz) {
            Object[] subs = ((yz)component.b()).d();
            for (int i3 = 0; i3 < subs.length; ++i3) {
                Object comp = subs[i3];
                if (comp instanceof xo) {
                    xo c3 = (xo)comp;
                    if (c3.a() == null || c3.a().i() != null) continue;
                    subs[i3] = CraftChatMessage.fixComponent(c3.f(), matcher);
                    continue;
                }
                if (!(comp instanceof String) || !matcher.reset((String)comp).find()) continue;
                subs[i3] = CraftChatMessage.fixComponent(xo.b((String)comp), matcher);
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (o format : o.values()) {
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
        }
        formatMap = builder.build();
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final yl RESET = yl.a.a(false).b(false).c(false).d(false).e(false);
        private final List<xo> list = new ArrayList<xo>();
        private yc currentChatComponent = xo.i();
        private yl modifier = yl.a;
        private final xo[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new xo[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ROOT).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.a((yn)yn.a(this.hex.toString()).result().get());
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.d() || format == o.v) ** GOTO lbl55
                        switch (1.$SwitchMap$net$minecraft$EnumChatFormat[format.ordinal()]) {
                            case 1: {
                                this.modifier = this.modifier.a(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 2: {
                                this.modifier = this.modifier.b(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 3: {
                                this.modifier = this.modifier.d(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 4: {
                                this.modifier = this.modifier.c(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 5: {
                                this.modifier = this.modifier.e(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.a(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + (String)match;
                        }
                        try {
                            this.modifier = this.modifier.a(new xm.f(ag.a((String)match)));
                        }
                        catch (URISyntaxException var11_11) {
                            // empty catch block
                        }
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.a((xm)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new xo[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            yc addition = xo.b(this.message.substring(this.currentIndex, index)).b(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = xo.i();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.b(addition);
        }

        private xo[] getOutput() {
            return this.output;
        }
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        private static yc deserialize(JsonElement jsonelement, jn.a holderlookup_a) {
            return (yc)xq.a.parse(holderlookup_a.a(JsonOps.INSTANCE), (Object)jsonelement).getOrThrow(JsonParseException::new);
        }

        private static JsonElement serialize(xo ichatbasecomponent, jn.a holderlookup_a) {
            return (JsonElement)xq.a.encodeStart(holderlookup_a.a(JsonOps.INSTANCE), (Object)ichatbasecomponent).getOrThrow(JsonParseException::new);
        }

        public static String toJson(xo ichatbasecomponent, jn.a holderlookup_a) {
            return GSON.toJson(ChatSerializer.serialize(ichatbasecomponent, holderlookup_a));
        }

        @Nullable
        public static yc fromJson(String s2, jn.a holderlookup_a) {
            JsonElement jsonelement = JsonParser.parseString((String)s2);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }
    }
}

