/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R5.damage.CraftDamageSourceBuilder;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_21_R5.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_21_R5.util.ApiVersion;
import org.bukkit.craftbukkit.v1_21_R5.util.Commodore;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.damage.DamageEffect;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.potion.PotionType;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final CraftMagicNumbers INSTANCE = new CraftMagicNumbers();
    private final Commodore commodore = new Commodore();
    private static final Map<dpz, Material> BLOCK_MATERIAL = new HashMap<dpz, Material>();
    private static final Map<dcr, Material> ITEM_MATERIAL = new HashMap<dcr, Material>();
    private static final Map<Material, dcr> MATERIAL_ITEM = new HashMap<Material, dcr>();
    private static final Map<Material, dpz> MATERIAL_BLOCK = new HashMap<Material, dpz>();
    private Biome customBiome;

    private CraftMagicNumbers() {
    }

    public static eeb getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static eeb getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(eeb data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.b())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static dcr getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(dcr item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(dpz block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(dcr item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static dcr getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static dpz getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static ame key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public static byte toLegacyData(eeb data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Commodore getCommodore() {
        return this.commodore;
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic name = new Dynamic((DynamicOps)uw.a, (Object)vg.a("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = bds.a().update(blp.G, name, version, this.getDataVersion())))) {
            converted = bds.a().update(blp.F, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    public String getMappingsVersion() {
        return "164f8e872cb3dff744982fca079642b2";
    }

    public int getDataVersion() {
        return ac.b().a().b();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        dcv nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.b(new gz(el.a(MinecraftServer.getDefaultRegistryAccess())).a(new StringReader(arguments)).b());
        }
        catch (CommandSyntaxException ex2) {
            Logger.getLogger(CraftMagicNumbers.class.getName()).log(Level.SEVERE, null, ex2);
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().a(fcq.j).toFile(), "bukkit");
    }

    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement((NamespacedKey)key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        ame minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = JsonParser.parseString((String)advancement);
        ai nms = (ai)ai.a.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement).getOrThrow(JsonParseException::new);
        if (nms != null) {
            MinecraftServer.getServer().aD().b.put(minecraftkey, new aj(minecraftkey, nms));
            Advancement bukkit = Bukkit.getAdvancement((NamespacedKey)key);
            if (bukkit != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex2) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + String.valueOf(key), ex2);
                }
                MinecraftServer.getServer().ag().u();
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        ApiVersion toCheck = ApiVersion.getOrCreateVersion(pdf.getAPIVersion());
        ApiVersion minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        if (toCheck.isNewerThan(ApiVersion.CURRENT)) {
            throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
        }
        if (toCheck.isOlderThan(minimumVersion)) {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
        if (toCheck.isOlderThan(ApiVersion.FLATTENING)) {
            CraftLegacy.init();
        }
        if (toCheck == ApiVersion.NONE) {
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        try {
            clazz = this.commodore.convert(clazz, pdf.getName(), ApiVersion.getOrCreateVersion(pdf.getAPIVersion()), ((CraftServer)Bukkit.getServer()).activeCompatibilities);
        }
        catch (Exception ex2) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex2);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        return material.getDefaultAttributeModifiers(slot);
    }

    public CreativeCategory getCreativeCategory(Material material) {
        return material.getCreativeCategory();
    }

    public String getBlockTranslationKey(Material material) {
        return material.getBlockTranslationKey();
    }

    public String getItemTranslationKey(Material material) {
        return material.getItemTranslationKey();
    }

    public String getTranslationKey(EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        return bzv.a(entityType.getName()).map(bzv::g).orElseThrow();
    }

    public String getTranslationKey(ItemStack itemStack) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.h().j();
    }

    public String getTranslationKey(Attribute attribute) {
        return attribute.getTranslationKey();
    }

    public FeatureFlag getFeatureFlag(NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"NamespaceKey cannot be null");
        return CraftFeatureFlag.getFromNMS(namespacedKey);
    }

    public PotionType.InternalPotionData getInternalPotionData(NamespacedKey namespacedKey) {
        dep potionRegistry = (dep)CraftRegistry.getMinecraftRegistry(mn.ah).b(CraftNamespacedKey.toMinecraft(namespacedKey)).orElseThrow();
        return new CraftPotionType(namespacedKey, potionRegistry);
    }

    public DamageEffect getDamageEffect(String key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key cannot be null");
        return CraftDamageEffect.getById(key);
    }

    public DamageSource.Builder createDamageSourceBuilder(DamageType damageType) {
        return new CraftDamageSourceBuilder(damageType);
    }

    public String get(Class<?> aClass, String s2) {
        if (aClass == Enchantment.class) {
            return FieldRename.convertEnchantmentName(ApiVersion.CURRENT, s2);
        }
        return s2;
    }

    public <B extends Keyed> B get(Registry<B> registry, NamespacedKey namespacedKey) {
        return CraftRegistry.get(registry, namespacedKey, ApiVersion.CURRENT);
    }

    public Biome getCustomBiome() {
        if (this.customBiome == null) {
            this.customBiome = new CraftBiome(NamespacedKey.minecraft((String)"custom"), null);
        }
        return this.customBiome;
    }

    public Villager.ReputationType createReputationType(String key) {
        return Optional.ofNullable(CraftVillager.CraftReputationType.BY_ID.get(key)).orElseThrow(() -> new IllegalArgumentException("Invalid ReputationType key: " + key));
    }

    public Villager.ReputationEvent createReputationEvent(String key) {
        return Optional.ofNullable(clm.BY_ID.get(key)).map(CraftVillager.CraftReputationEvent::new).orElseThrow(() -> new IllegalArgumentException("Invalid ReputationEvent key: " + key));
    }

    static {
        for (dpz block2 : mm.e) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)mm.e.b(block2).a().toUpperCase(Locale.ROOT)));
        }
        for (dcr item2 : mm.g) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)mm.g.b(item2).a().toUpperCase(Locale.ROOT)));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            ame key = CraftMagicNumbers.key(material);
            mm.g.b(key).ifPresent(item -> MATERIAL_ITEM.put(material, (dcr)item));
            mm.e.b(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (dpz)block));
        }
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

