/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedBytes;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.chars.CharList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.SnbtOperations;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.DelayedException;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.GreedyPatternParseRule;
import net.minecraft.util.parsing.packrat.commands.GreedyPredicateParseRule;
import net.minecraft.util.parsing.packrat.commands.NumberRunParseRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.UnquotedStringParseRule;

public class SnbtGrammar {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("snbt.parser.number_parse_failure", var0));
    static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("snbt.parser.expected_hex_escape", var0));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("snbt.parser.invalid_codepoint", var0));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("snbt.parser.no_such_operation", var0));
    static final DelayedException<CommandSyntaxException> e = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_integer_type")));
    private static final DelayedException<CommandSyntaxException> f = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_float_type")));
    static final DelayedException<CommandSyntaxException> g = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_non_negative_number")));
    private static final DelayedException<CommandSyntaxException> h = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_character_name")));
    static final DelayedException<CommandSyntaxException> i = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_array_element_type")));
    private static final DelayedException<CommandSyntaxException> j = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_unquoted_start")));
    private static final DelayedException<CommandSyntaxException> k = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_unquoted_string")));
    private static final DelayedException<CommandSyntaxException> l = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.invalid_string_contents")));
    private static final DelayedException<CommandSyntaxException> m = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_binary_numeral")));
    private static final DelayedException<CommandSyntaxException> n = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.underscore_not_allowed")));
    private static final DelayedException<CommandSyntaxException> o = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_decimal_numeral")));
    private static final DelayedException<CommandSyntaxException> p = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.expected_hex_numeral")));
    private static final DelayedException<CommandSyntaxException> q = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.empty_key")));
    private static final DelayedException<CommandSyntaxException> r = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.leading_zero_not_allowed")));
    private static final DelayedException<CommandSyntaxException> s = DelayedException.a(new SimpleCommandExceptionType((Message)IChatBaseComponent.c("snbt.parser.infinity_not_allowed")));
    private static final HexFormat t = HexFormat.of().withUpperCase();
    private static final NumberRunParseRule u = new NumberRunParseRule((DelayedException)m, (DelayedException)n){

        @Override
        protected boolean a(char var0) {
            return switch (var0) {
                case '0', '1', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule v = new NumberRunParseRule((DelayedException)o, (DelayedException)n){

        @Override
        protected boolean a(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_' -> true;
                default -> false;
            };
        }
    };
    private static final NumberRunParseRule w = new NumberRunParseRule((DelayedException)p, (DelayedException)n){

        @Override
        protected boolean a(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', '_', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    };
    private static final GreedyPredicateParseRule x = new GreedyPredicateParseRule(1, (DelayedException)l){

        @Override
        protected boolean a(char var0) {
            return switch (var0) {
                case '\"', '\'', '\\' -> false;
                default -> true;
            };
        }
    };
    private static final StringReaderTerms.a y = new StringReaderTerms.a(CharList.of()){

        @Override
        protected boolean a(char var0) {
            return SnbtGrammar.c(var0);
        }
    };
    private static final Pattern z = Pattern.compile("[-a-zA-Z0-9 ]+");

    static DelayedException<CommandSyntaxException> a(NumberFormatException var0) {
        return DelayedException.a(a, var0.getMessage());
    }

    @Nullable
    public static String a(char var0) {
        return switch (var0) {
            case '\b' -> "b";
            case '\t' -> "t";
            case '\n' -> "n";
            case '\f' -> "f";
            case '\r' -> "r";
            default -> var0 < ' ' ? "x" + t.toHexDigits((byte)var0) : null;
        };
    }

    private static boolean b(char var0) {
        return !SnbtGrammar.c(var0);
    }

    static boolean c(char var0) {
        return switch (var0) {
            case '+', '-', '.', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> true;
            default -> false;
        };
    }

    static boolean a(String var0) {
        return var0.indexOf(95) != -1;
    }

    private static void a(StringBuilder var0, String var1) {
        SnbtGrammar.a(var0, var1, SnbtGrammar.a(var1));
    }

    static void a(StringBuilder var0, String var1, boolean var2) {
        if (var2) {
            for (char var6 : var1.toCharArray()) {
                if (var6 == '_') continue;
                var0.append(var6);
            }
        } else {
            var0.append(var1);
        }
    }

    static short a(String var0, int var1) {
        int var2 = Integer.parseInt(var0, var1);
        if (var2 >> 16 == 0) {
            return (short)var2;
        }
        throw new NumberFormatException("out of range: " + var2);
    }

    @Nullable
    private static <T> T a(DynamicOps<T> var0, e var1, @Nullable String var2, @Nullable String var3, @Nullable f<String> var4, @Nullable i var5, ParseState<?> var6) {
        StringBuilder var7 = new StringBuilder();
        var1.a(var7);
        if (var2 != null) {
            SnbtGrammar.a(var7, var2);
        }
        if (var3 != null) {
            var7.append('.');
            SnbtGrammar.a(var7, var3);
        }
        if (var4 != null) {
            var7.append('e');
            var4.a().a(var7);
            SnbtGrammar.a(var7, (String)var4.b);
        }
        try {
            String var8 = var7.toString();
            i i2 = var5;
            int n2 = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"FLOAT", "DOUBLE"}, (i)i2, n2)) {
                case 0 -> SnbtGrammar.a(var0, var6, var8);
                case 1 -> SnbtGrammar.b(var0, var6, var8);
                case -1 -> SnbtGrammar.b(var0, var6, var8);
                default -> {
                    var6.b().a(var6.g(), f);
                    yield null;
                }
            };
        }
        catch (NumberFormatException var8) {
            var6.b().a(var6.g(), SnbtGrammar.a(var8));
            return null;
        }
    }

    @Nullable
    private static <T> T a(DynamicOps<T> var0, ParseState<?> var1, String var2) {
        float var3 = Float.parseFloat(var2);
        if (!Float.isFinite(var3)) {
            var1.b().a(var1.g(), s);
            return null;
        }
        return (T)var0.createFloat(var3);
    }

    @Nullable
    private static <T> T b(DynamicOps<T> var0, ParseState<?> var1, String var2) {
        double var3 = Double.parseDouble(var2);
        if (!Double.isFinite(var3)) {
            var1.b().a(var1.g(), s);
            return null;
        }
        return (T)var0.createDouble(var3);
    }

    private static String a(List<String> var0) {
        return switch (var0.size()) {
            case 0 -> "";
            case 1 -> var0.getFirst();
            default -> String.join((CharSequence)"", var0);
        };
    }

    public static <T> Grammar<T> a(DynamicOps<T> var0) {
        Object var12 = var0.createBoolean(true);
        Object var22 = var0.createBoolean(false);
        Object var32 = var0.emptyMap();
        Object var42 = var0.emptyList();
        Dictionary<StringReader> var52 = new Dictionary<StringReader>();
        Atom var62 = Atom.a("sign");
        var52.a(var62, Term.b(Term.a(StringReaderTerms.a('+'), Term.a(var62, net.minecraft.nbt.SnbtGrammar$e.a)), Term.a(StringReaderTerms.a('-'), Term.a(var62, net.minecraft.nbt.SnbtGrammar$e.b))), var1 -> (e)((Object)((Object)var1.b(var62))));
        Atom var7 = Atom.a("integer_suffix");
        var52.a(var7, Term.b(Term.a(StringReaderTerms.a('u', 'U'), Term.b(Term.a(StringReaderTerms.a('b', 'B'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.b, net.minecraft.nbt.SnbtGrammar$i.f))))), Term.a(StringReaderTerms.a('s', 'S'), Term.b(Term.a(StringReaderTerms.a('b', 'B'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(var7, new d(net.minecraft.nbt.SnbtGrammar$g.a, net.minecraft.nbt.SnbtGrammar$i.f))))), Term.a(StringReaderTerms.a('b', 'B'), Term.a(var7, new d(null, net.minecraft.nbt.SnbtGrammar$i.c))), Term.a(StringReaderTerms.a('s', 'S'), Term.a(var7, new d(null, net.minecraft.nbt.SnbtGrammar$i.d))), Term.a(StringReaderTerms.a('i', 'I'), Term.a(var7, new d(null, net.minecraft.nbt.SnbtGrammar$i.e))), Term.a(StringReaderTerms.a('l', 'L'), Term.a(var7, new d(null, net.minecraft.nbt.SnbtGrammar$i.f)))), var1 -> (d)var1.b(var7));
        Atom var8 = Atom.a("binary_numeral");
        var52.a(var8, u);
        Atom var9 = Atom.a("decimal_numeral");
        var52.a(var9, v);
        Atom var10 = Atom.a("hex_numeral");
        var52.a(var10, w);
        Atom var11 = Atom.a("integer_literal");
        NamedRule var122 = var52.a(var11, Term.a(Term.a(var52.c(var62)), Term.b(Term.a(StringReaderTerms.a('0'), Term.c(), Term.b(Term.a(StringReaderTerms.a('x', 'X'), Term.c(), var52.c(var10)), Term.a(StringReaderTerms.a('b', 'B'), var52.c(var8)), Term.a(var52.c(var9), Term.c(), Term.a(r)), Term.a(var9, "0"))), var52.c(var9)), Term.a(var52.c(var7))), var5 -> {
            d var6 = var5.b(var7, net.minecraft.nbt.SnbtGrammar$d.a);
            e var7 = var5.b(var62, net.minecraft.nbt.SnbtGrammar$e.a);
            String var8 = (String)var5.a(var9);
            if (var8 != null) {
                return new c(var7, net.minecraft.nbt.SnbtGrammar$b.b, var8, var6);
            }
            String var9 = (String)var5.a(var10);
            if (var9 != null) {
                return new c(var7, net.minecraft.nbt.SnbtGrammar$b.c, var9, var6);
            }
            String var10 = (String)var5.b(var8);
            return new c(var7, net.minecraft.nbt.SnbtGrammar$b.a, var10, var6);
        });
        Atom var13 = Atom.a("float_type_suffix");
        var52.a(var13, Term.b(Term.a(StringReaderTerms.a('f', 'F'), Term.a(var13, net.minecraft.nbt.SnbtGrammar$i.a)), Term.a(StringReaderTerms.a('d', 'D'), Term.a(var13, net.minecraft.nbt.SnbtGrammar$i.b))), var1 -> (i)((Object)((Object)var1.b(var13))));
        Atom var14 = Atom.a("float_exponent_part");
        var52.a(var14, Term.a(StringReaderTerms.a('e', 'E'), Term.a(var52.c(var62)), var52.c(var9)), var2 -> new f<String>(var2.b(var62, net.minecraft.nbt.SnbtGrammar$e.a), (String)var2.b(var9)));
        Atom var15 = Atom.a("float_whole_part");
        Atom var16 = Atom.a("float_fraction_part");
        Atom var17 = Atom.a("float_literal");
        var52.a(var17, Term.a(Term.a(var52.c(var62)), Term.b(Term.a(var52.a(var9, var15), StringReaderTerms.a('.'), Term.c(), Term.a(var52.a(var9, var16)), Term.a(var52.c(var14)), Term.a(var52.c(var13))), Term.a(StringReaderTerms.a('.'), Term.c(), var52.a(var9, var16), Term.a(var52.c(var14)), Term.a(var52.c(var13))), Term.a(var52.a(var9, var15), var52.c(var14), Term.c(), Term.a(var52.c(var13))), Term.a(var52.a(var9, var15), Term.a(var52.c(var14)), var52.c(var13)))), var6 -> {
            Scope var7 = var6.a();
            e var8 = var7.b(var62, net.minecraft.nbt.SnbtGrammar$e.a);
            String var9 = (String)var7.a(var15);
            String var10 = (String)var7.a(var16);
            f var11 = (f)var7.a(var14);
            i var12 = (i)((Object)((Object)var7.a(var13)));
            return SnbtGrammar.a(var0, var8, var9, var10, var11, var12, var6);
        });
        Atom var18 = Atom.a("string_hex_2");
        var52.a(var18, new h(2));
        Atom var19 = Atom.a("string_hex_4");
        var52.a(var19, new h(4));
        Atom var20 = Atom.a("string_hex_8");
        var52.a(var20, new h(8));
        Atom var21 = Atom.a("string_unicode_name");
        var52.a(var21, new GreedyPatternParseRule(z, h));
        Atom var222 = Atom.a("string_escape_sequence");
        var52.a(var222, Term.b(Term.a(StringReaderTerms.a('b'), Term.a(var222, "\b")), Term.a(StringReaderTerms.a('s'), Term.a(var222, " ")), Term.a(StringReaderTerms.a('t'), Term.a(var222, "\t")), Term.a(StringReaderTerms.a('n'), Term.a(var222, "\n")), Term.a(StringReaderTerms.a('f'), Term.a(var222, "\f")), Term.a(StringReaderTerms.a('r'), Term.a(var222, "\r")), Term.a(StringReaderTerms.a('\\'), Term.a(var222, "\\")), Term.a(StringReaderTerms.a('\''), Term.a(var222, "'")), Term.a(StringReaderTerms.a('\"'), Term.a(var222, "\"")), Term.a(StringReaderTerms.a('x'), var52.c(var18)), Term.a(StringReaderTerms.a('u'), var52.c(var19)), Term.a(StringReaderTerms.a('U'), var52.c(var20)), Term.a(StringReaderTerms.a('N'), StringReaderTerms.a('{'), var52.c(var21), StringReaderTerms.a('}'))), var5 -> {
            int var10;
            Scope var6 = var5.a();
            String var7 = (String)var6.b(new Atom[]{var222});
            if (var7 != null) {
                return var7;
            }
            String var8 = (String)var6.b(var18, var19, var20);
            if (var8 != null) {
                int var9 = HexFormat.fromHexDigits(var8);
                if (!Character.isValidCodePoint(var9)) {
                    var5.b().a(var5.g(), DelayedException.a(c, String.format(Locale.ROOT, "U+%08X", var9)));
                    return null;
                }
                return Character.toString(var9);
            }
            String var9 = (String)var6.b(var21);
            try {
                var10 = Character.codePointOf(var9);
            }
            catch (IllegalArgumentException var11) {
                var5.b().a(var5.g(), h);
                return null;
            }
            return Character.toString(var10);
        });
        Atom var23 = Atom.a("string_plain_contents");
        var52.a(var23, x);
        Atom var24 = Atom.a("string_chunks");
        Atom var25 = Atom.a("string_contents");
        Atom var26 = Atom.a("single_quoted_string_chunk");
        NamedRule var27 = var52.a(var26, Term.b(var52.a(var23, var25), Term.a(StringReaderTerms.a('\\'), var52.a(var222, var25)), Term.a(StringReaderTerms.a('\"'), Term.a(var25, "\""))), var1 -> (String)var1.b(var25));
        Atom var28 = Atom.a("single_quoted_string_contents");
        var52.a(var28, Term.a(var27, var24), var1 -> SnbtGrammar.a((List)var1.b(var24)));
        Atom var29 = Atom.a("double_quoted_string_chunk");
        NamedRule var30 = var52.a(var29, Term.b(var52.a(var23, var25), Term.a(StringReaderTerms.a('\\'), var52.a(var222, var25)), Term.a(StringReaderTerms.a('\''), Term.a(var25, "'"))), var1 -> (String)var1.b(var25));
        Atom var31 = Atom.a("double_quoted_string_contents");
        var52.a(var31, Term.a(var30, var24), var1 -> SnbtGrammar.a((List)var1.b(var24)));
        Atom var322 = Atom.a("quoted_string_literal");
        var52.a(var322, Term.b(Term.a(StringReaderTerms.a('\"'), Term.c(), Term.a(var52.a(var31, var25)), StringReaderTerms.a('\"')), Term.a(StringReaderTerms.a('\''), Term.a(var52.a(var28, var25)), StringReaderTerms.a('\''))), var1 -> (String)var1.b(var25));
        Atom var33 = Atom.a("unquoted_string");
        var52.a(var33, new UnquotedStringParseRule(1, k));
        Atom var34 = Atom.a("literal");
        Atom var35 = Atom.a("arguments");
        var52.a(var35, Term.a(var52.b(var34), var35, StringReaderTerms.a(',')), var1 -> (List)var1.b(var35));
        Atom var36 = Atom.a("unquoted_string_or_builtin");
        var52.a(var36, Term.a(var52.c(var33), Term.a(Term.a(StringReaderTerms.a('('), var52.c(var35), StringReaderTerms.a(')')))), var5 -> {
            Scope var6 = var5.a();
            String var7 = (String)var6.b(var33);
            if (var7.isEmpty() || !SnbtGrammar.b(var7.charAt(0))) {
                var5.b().a(var5.g(), SnbtOperations.d, j);
                return null;
            }
            List var8 = (List)var6.a(var35);
            if (var8 != null) {
                SnbtOperations.a var9 = new SnbtOperations.a(var7, var8.size());
                SnbtOperations.b var10 = SnbtOperations.c.get(var9);
                if (var10 != null) {
                    return var10.a(var0, var8, var5);
                }
                var5.b().a(var5.g(), DelayedException.a(d, var9.toString()));
                return null;
            }
            if (var7.equalsIgnoreCase("true")) {
                return var12;
            }
            if (var7.equalsIgnoreCase("false")) {
                return var22;
            }
            return var0.createString(var7);
        });
        Atom var37 = Atom.a("map_key");
        var52.a(var37, Term.b(var52.c(var322), var52.c(var33)), var2 -> (String)var2.c(var322, var33));
        Atom var38 = Atom.a("map_entry");
        NamedRule var39 = var52.a(var38, Term.a(var52.c(var37), StringReaderTerms.a(':'), var52.c(var34)), var2 -> {
            Scope var3 = var2.a();
            String var4 = (String)var3.b(var37);
            if (var4.isEmpty()) {
                var2.b().a(var2.g(), q);
                return null;
            }
            Object var5 = var3.b(var34);
            return Map.entry(var4, var5);
        });
        Atom var40 = Atom.a("map_entries");
        var52.a(var40, Term.a(var39, var40, StringReaderTerms.a(',')), var1 -> (List)var1.b(var40));
        Atom var41 = Atom.a("map_literal");
        var52.a(var41, Term.a(StringReaderTerms.a('{'), var52.c(var40), StringReaderTerms.a('}')), var3 -> {
            List var4 = (List)var3.b(var40);
            if (var4.isEmpty()) {
                return var32;
            }
            ImmutableMap.Builder var5 = ImmutableMap.builderWithExpectedSize((int)var4.size());
            for (Map.Entry var7 : var4) {
                var5.put(var0.createString((String)var7.getKey()), var7.getValue());
            }
            return var0.createMap((Map)var5.buildKeepingLast());
        });
        Atom var422 = Atom.a("list_entries");
        var52.a(var422, Term.a(var52.b(var34), var422, StringReaderTerms.a(',')), var1 -> (List)var1.b(var422));
        Atom var43 = Atom.a("array_prefix");
        var52.a(var43, Term.b(Term.a(StringReaderTerms.a('B'), Term.a(var43, net.minecraft.nbt.SnbtGrammar$a.a)), Term.a(StringReaderTerms.a('L'), Term.a(var43, net.minecraft.nbt.SnbtGrammar$a.c)), Term.a(StringReaderTerms.a('I'), Term.a(var43, net.minecraft.nbt.SnbtGrammar$a.b))), var1 -> (a)((Object)((Object)var1.b(var43))));
        Atom var44 = Atom.a("int_array_entries");
        var52.a(var44, Term.a(var122, var44, StringReaderTerms.a(',')), var1 -> (List)var1.b(var44));
        Atom var45 = Atom.a("list_literal");
        var52.a(var45, Term.a(StringReaderTerms.a('['), Term.b(Term.a(var52.c(var43), StringReaderTerms.a(';'), var52.c(var44)), var52.c(var422)), StringReaderTerms.a(']')), var5 -> {
            Scope var6 = var5.a();
            a var7 = (a)((Object)((Object)var6.a(var43)));
            if (var7 != null) {
                List var8 = (List)var6.b(var44);
                return var8.isEmpty() ? var7.a(var0) : var7.a(var0, var8, var5);
            }
            List var8 = (List)var6.b(var422);
            return var8.isEmpty() ? var42 : var0.createList(var8.stream());
        });
        NamedRule var46 = var52.a(var34, Term.b(Term.a(Term.b(y), Term.b(var52.a(var17, var34), var52.c(var11))), Term.a(Term.b(StringReaderTerms.a('\"', '\'')), Term.c(), var52.c(var322)), Term.a(Term.b(StringReaderTerms.a('{')), Term.c(), var52.a(var41, var34)), Term.a(Term.b(StringReaderTerms.a('[')), Term.c(), var52.a(var45, var34)), var52.a(var36, var34)), var4 -> {
            Scope var5 = var4.a();
            String var6 = (String)var5.a(var322);
            if (var6 != null) {
                return var0.createString(var6);
            }
            c var7 = (c)var5.a(var11);
            if (var7 != null) {
                return var7.a(var0, var4);
            }
            return var5.b(var34);
        });
        return new Grammar<Object>(var52, var46);
    }

    static final class e
    extends Enum<e> {
        public static final /* enum */ e a = new e();
        public static final /* enum */ e b = new e();
        private static final /* synthetic */ e[] c;

        public static e[] values() {
            return (e[])c.clone();
        }

        public static e valueOf(String var0) {
            return Enum.valueOf(e.class, var0);
        }

        public void a(StringBuilder var0) {
            if (this == b) {
                var0.append("-");
            }
        }

        private static /* synthetic */ e[] a() {
            return new e[]{a, b};
        }

        static {
            c = net.minecraft.nbt.SnbtGrammar$e.a();
        }
    }

    static final class f<T>
    extends Record {
        private final e a;
        final T b;

        f(e var0, T var1) {
            this.a = var0;
            this.b = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{f.class, "sign;value", "a", "b"}, this, var0);
        }

        public e a() {
            return this.a;
        }

        public T b() {
            return this.b;
        }
    }

    static final class i
    extends Enum<i> {
        public static final /* enum */ i a = new i();
        public static final /* enum */ i b = new i();
        public static final /* enum */ i c = new i();
        public static final /* enum */ i d = new i();
        public static final /* enum */ i e = new i();
        public static final /* enum */ i f = new i();
        private static final /* synthetic */ i[] g;

        public static i[] values() {
            return (i[])g.clone();
        }

        public static i valueOf(String var0) {
            return Enum.valueOf(i.class, var0);
        }

        private static /* synthetic */ i[] a() {
            return new i[]{a, b, c, d, e, f};
        }

        static {
            g = net.minecraft.nbt.SnbtGrammar$i.a();
        }
    }

    static final class d
    extends Record {
        @Nullable
        final g b;
        @Nullable
        final i c;
        public static final d a = new d(null, null);

        d(@Nullable g var0, @Nullable i var1) {
            this.b = var0;
            this.c = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "signed;type", "b", "c"}, this, var0);
        }

        @Nullable
        public g a() {
            return this.b;
        }

        @Nullable
        public i b() {
            return this.c;
        }
    }

    static final class g
    extends Enum<g> {
        public static final /* enum */ g a = new g();
        public static final /* enum */ g b = new g();
        private static final /* synthetic */ g[] c;

        public static g[] values() {
            return (g[])c.clone();
        }

        public static g valueOf(String var0) {
            return Enum.valueOf(g.class, var0);
        }

        private static /* synthetic */ g[] a() {
            return new g[]{a, b};
        }

        static {
            c = net.minecraft.nbt.SnbtGrammar$g.a();
        }
    }

    static class h
    extends GreedyPredicateParseRule {
        public h(int var0) {
            super(var0, var0, DelayedException.a(b, String.valueOf(var0)));
        }

        @Override
        protected boolean a(char var0) {
            return switch (var0) {
                case '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f' -> true;
                default -> false;
            };
        }
    }

    static abstract sealed class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(net.minecraft.nbt.SnbtGrammar$i.c, new i[0]){
            private static final ByteBuffer d = ByteBuffer.wrap(new byte[0]);

            @Override
            public <T> T a(DynamicOps<T> var0) {
                return (T)var0.createByteList(d);
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> var0, List<c> var1, ParseState<?> var2) {
                ByteArrayList var3 = new ByteArrayList();
                for (c var5 : var1) {
                    Number var6 = this.a(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.byteValue());
                }
                return (T)var0.createByteList(ByteBuffer.wrap(var3.toByteArray()));
            }
        };
        public static final /* enum */ a b = new a(net.minecraft.nbt.SnbtGrammar$i.e, new i[]{net.minecraft.nbt.SnbtGrammar$i.c, net.minecraft.nbt.SnbtGrammar$i.d}){

            @Override
            public <T> T a(DynamicOps<T> var0) {
                return (T)var0.createIntList(IntStream.empty());
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> var0, List<c> var1, ParseState<?> var2) {
                IntStream.Builder var3 = IntStream.builder();
                for (c var5 : var1) {
                    Number var6 = this.a(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.intValue());
                }
                return (T)var0.createIntList(var3.build());
            }
        };
        public static final /* enum */ a c = new a(net.minecraft.nbt.SnbtGrammar$i.f, new i[]{net.minecraft.nbt.SnbtGrammar$i.c, net.minecraft.nbt.SnbtGrammar$i.d, net.minecraft.nbt.SnbtGrammar$i.e}){

            @Override
            public <T> T a(DynamicOps<T> var0) {
                return (T)var0.createLongList(LongStream.empty());
            }

            @Override
            @Nullable
            public <T> T a(DynamicOps<T> var0, List<c> var1, ParseState<?> var2) {
                LongStream.Builder var3 = LongStream.builder();
                for (c var5 : var1) {
                    Number var6 = this.a(var5, var2);
                    if (var6 == null) {
                        return null;
                    }
                    var3.add(var6.longValue());
                }
                return (T)var0.createLongList(var3.build());
            }
        };
        private final i d;
        private final Set<i> e;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        a(i var2, i ... var3) {
            this.e = Set.of(var3);
            this.d = var2;
        }

        public boolean a(i var0) {
            return var0 == this.d || this.e.contains((Object)var0);
        }

        public abstract <T> T a(DynamicOps<T> var1);

        @Nullable
        public abstract <T> T a(DynamicOps<T> var1, List<c> var2, ParseState<?> var3);

        @Nullable
        protected Number a(c var0, ParseState<?> var1) {
            i var2 = this.a(var0.d);
            if (var2 == null) {
                var1.b().a(var1.g(), i);
                return null;
            }
            return (Number)var0.a(JavaOps.INSTANCE, var2, var1);
        }

        @Nullable
        private i a(d var0) {
            i var1 = var0.b();
            if (var1 == null) {
                return this.d;
            }
            if (!this.a(var1)) {
                return null;
            }
            return var1;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            f = net.minecraft.nbt.SnbtGrammar$a.a();
        }
    }

    static final class c
    extends Record {
        private final e a;
        private final b b;
        private final String c;
        final d d;

        c(e var0, b var1, String var2, d var3) {
            this.a = var0;
            this.b = var1;
            this.c = var2;
            this.d = var3;
        }

        private g e() {
            if (this.d.b != null) {
                return this.d.b;
            }
            return switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> net.minecraft.nbt.SnbtGrammar$g.b;
                case 1 -> net.minecraft.nbt.SnbtGrammar$g.a;
            };
        }

        private String a(e var0) {
            boolean var1 = SnbtGrammar.a(this.c);
            if (var0 == net.minecraft.nbt.SnbtGrammar$e.b || var1) {
                StringBuilder var2 = new StringBuilder();
                var0.a(var2);
                SnbtGrammar.a(var2, this.c, var1);
                return var2.toString();
            }
            return this.c;
        }

        @Nullable
        public <T> T a(DynamicOps<T> var0, ParseState<?> var1) {
            return this.a(var0, Objects.requireNonNullElse(this.d.c, net.minecraft.nbt.SnbtGrammar$i.e), var1);
        }

        @Nullable
        public <T> T a(DynamicOps<T> var0, i var1, ParseState<?> var2) {
            boolean var3;
            boolean bl = var3 = this.e() == net.minecraft.nbt.SnbtGrammar$g.a;
            if (!var3 && this.a == net.minecraft.nbt.SnbtGrammar$e.b) {
                var2.b().a(var2.g(), g);
                return null;
            }
            String var4 = this.a(this.a);
            int var5 = switch (this.b.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 2;
                case 1 -> 10;
                case 2 -> 16;
            };
            try {
                if (var3) {
                    return (T)(switch (var1.ordinal()) {
                        case 2 -> var0.createByte(Byte.parseByte(var4, var5));
                        case 3 -> var0.createShort(Short.parseShort(var4, var5));
                        case 4 -> var0.createInt(Integer.parseInt(var4, var5));
                        case 5 -> var0.createLong(Long.parseLong(var4, var5));
                        default -> {
                            var2.b().a(var2.g(), e);
                            yield null;
                        }
                    });
                }
                return (T)(switch (var1.ordinal()) {
                    case 2 -> var0.createByte(UnsignedBytes.parseUnsignedByte((String)var4, (int)var5));
                    case 3 -> var0.createShort(SnbtGrammar.a(var4, var5));
                    case 4 -> var0.createInt(Integer.parseUnsignedInt(var4, var5));
                    case 5 -> var0.createLong(Long.parseUnsignedLong(var4, var5));
                    default -> {
                        var2.b().a(var2.g(), e);
                        yield null;
                    }
                });
            }
            catch (NumberFormatException var6) {
                var2.b().a(var2.g(), SnbtGrammar.a(var6));
                return null;
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "sign;base;digits;suffix", "a", "b", "c", "d"}, this, var0);
        }

        public e a() {
            return this.a;
        }

        public b b() {
            return this.b;
        }

        public String c() {
            return this.c;
        }

        public d d() {
            return this.d;
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b();
        public static final /* enum */ b b = new b();
        public static final /* enum */ b c = new b();
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{a, b, c};
        }

        static {
            d = net.minecraft.nbt.SnbtGrammar$b.a();
        }
    }
}

