/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SignatureUpdater;
import net.minecraft.util.SignatureValidator;

public record MessageSignature(byte[] c) {
    public static final Codec<MessageSignature> a = ExtraCodecs.u.xmap(MessageSignature::new, MessageSignature::c);
    public static final int b = 256;

    public MessageSignature {
        Preconditions.checkState((var0.length == 256 ? 1 : 0) != 0, (Object)"Invalid message signature size");
    }

    public static MessageSignature a(PacketDataSerializer var0) {
        byte[] var1 = new byte[256];
        var0.b(var1);
        return new MessageSignature(var1);
    }

    public static void a(PacketDataSerializer var0, MessageSignature var1) {
        var0.c(var1.c);
    }

    public boolean a(SignatureValidator var0, SignatureUpdater var1) {
        return var0.validate(var1, this.c);
    }

    public ByteBuffer a() {
        return ByteBuffer.wrap(this.c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object var0) {
        if (this == var0) return true;
        if (!(var0 instanceof MessageSignature)) return false;
        MessageSignature var1 = (MessageSignature)var0;
        if (!Arrays.equals(this.c, var1.c)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public String toString() {
        return Base64.getEncoder().encodeToString(this.c);
    }

    public static String a(@Nullable MessageSignature var0) {
        if (var0 == null) {
            return "<no signature>";
        }
        return var0.toString();
    }

    public a a(MessageSignatureCache var0) {
        int var1 = var0.a(this);
        return var1 != -1 ? new a(var1) : new a(this);
    }

    public int b() {
        return Arrays.hashCode(this.c);
    }

    public static final class a
    extends Record {
        private final int b;
        @Nullable
        private final MessageSignature c;
        public static final int a = -1;

        public a(MessageSignature var0) {
            this(-1, var0);
        }

        public a(int var0) {
            this(var0, null);
        }

        public a(int var0, @Nullable MessageSignature var1) {
            this.b = var0;
            this.c = var1;
        }

        public static a a(PacketDataSerializer var0) {
            int var1 = var0.l() - 1;
            if (var1 == -1) {
                return new a(MessageSignature.a(var0));
            }
            return new a(var1);
        }

        public static void a(PacketDataSerializer var0, a var1) {
            var0.c(var1.a() + 1);
            if (var1.b() != null) {
                MessageSignature.a(var0, var1.b());
            }
        }

        public Optional<MessageSignature> a(MessageSignatureCache var0) {
            if (this.c != null) {
                return Optional.of(this.c);
            }
            return Optional.ofNullable(var0.a(this.b));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "id;fullSignature", "b", "c"}, this, var0);
        }

        public int a() {
            return this.b;
        }

        @Nullable
        public MessageSignature b() {
            return this.c;
        }
    }
}

