/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger d = LogUtils.getLogger();
    public static final MapCodec<NbtContents> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::b), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::c), (App)ComponentSerialization.a.lenientOptionalFieldOf("separator").forGetter(NbtContents::d), (App)DataSource.c.forGetter(NbtContents::e)).apply((Applicative)var0, NbtContents::new));
    public static final ComponentContents.a<NbtContents> b = new ComponentContents.a<NbtContents>(a, "nbt");
    private final boolean e;
    private final Optional<IChatBaseComponent> f;
    private final String g;
    private final DataSource h;
    @Nullable
    protected final ArgumentNBTKey.g c;

    public NbtContents(String var0, boolean var1, Optional<IChatBaseComponent> var2, DataSource var3) {
        this(var0, NbtContents.a(var0), var1, var2, var3);
    }

    private NbtContents(String var0, @Nullable ArgumentNBTKey.g var1, boolean var2, Optional<IChatBaseComponent> var3, DataSource var4) {
        this.g = var0;
        this.c = var1;
        this.e = var2;
        this.f = var3;
        this.h = var4;
    }

    @Nullable
    private static ArgumentNBTKey.g a(String var0) {
        try {
            return new ArgumentNBTKey().a(new StringReader(var0));
        }
        catch (CommandSyntaxException var1) {
            return null;
        }
    }

    public String b() {
        return this.g;
    }

    public boolean c() {
        return this.e;
    }

    public Optional<IChatBaseComponent> d() {
        return this.f;
    }

    public DataSource e() {
        return this.h;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof NbtContents)) return false;
        NbtContents var1 = (NbtContents)var0;
        if (!this.h.equals(var1.h)) return false;
        if (!this.f.equals(var1.f)) return false;
        if (this.e != var1.e) return false;
        if (!this.g.equals(var1.g)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.e ? 1 : 0;
        var0 = 31 * var0 + this.f.hashCode();
        var0 = 31 * var0 + this.g.hashCode();
        var0 = 31 * var0 + this.h.hashCode();
        return var0;
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.h) + ", interpreting=" + this.e + ", separator=" + String.valueOf(this.f) + "}";
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper var02, @Nullable Entity var13, int var22) throws CommandSyntaxException {
        if (var02 == null || this.c == null) {
            return IChatBaseComponent.i();
        }
        Stream<String> var3 = this.h.a(var02).flatMap(var0 -> {
            try {
                return this.c.a((NBTBase)var0).stream();
            }
            catch (CommandSyntaxException var1) {
                return Stream.empty();
            }
        });
        if (this.e) {
            RegistryOps<NBTBase> var42 = var02.u().a(DynamicOpsNBT.a);
            IChatBaseComponent var5 = (IChatBaseComponent)DataFixUtils.orElse(ChatComponentUtils.a(var02, this.f, var13, var22), (Object)ChatComponentUtils.c);
            return var3.flatMap(var4 -> {
                try {
                    IChatBaseComponent var5 = (IChatBaseComponent)ComponentSerialization.a.parse((DynamicOps)var42, var4).getOrThrow();
                    return Stream.of(ChatComponentUtils.a(var02, var5, var13, var22));
                }
                catch (Exception var5) {
                    d.warn("Failed to parse component: {}", var4, (Object)var5);
                    return Stream.of(new IChatMutableComponent[0]);
                }
            }).reduce((var1, var2) -> var1.b(var5).b((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::i);
        }
        Stream<String> var43 = var3.map(NbtContents::a);
        return ChatComponentUtils.a(var02, this.f, var13, var22).map(var12 -> var43.map(IChatBaseComponent::b).reduce((var1, var2) -> var1.b((IChatBaseComponent)var12).b((IChatBaseComponent)var2)).orElseGet(IChatBaseComponent::i)).orElseGet(() -> IChatBaseComponent.b(var43.collect(Collectors.joining(", "))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String a(NBTBase var0) {
        if (!(var0 instanceof NBTTagString)) return var0.toString();
        NBTTagString nBTTagString = (NBTTagString)var0;
        try {
            String string = nBTTagString.k();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public ComponentContents.a<?> a() {
        return b;
    }
}

