/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] a = new Object[0];
    private static final Codec<Object> d = ExtraCodecs.b.validate(TranslatableContents::b);
    private static final Codec<Object> e = Codec.either(d, ComponentSerialization.a).xmap(var02 -> var02.map(var0 -> var0, var0 -> Objects.requireNonNullElse(var0.d(), var0)), var0 -> {
        Either either;
        if (var0 instanceof IChatBaseComponent) {
            IChatBaseComponent var1 = (IChatBaseComponent)var0;
            either = Either.right((Object)var1);
        } else {
            either = Either.left((Object)var0);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> b = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.STRING.fieldOf("translate").forGetter(var0 -> var0.h), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(var0 -> Optional.ofNullable(var0.i)), (App)e.listOf().optionalFieldOf("with").forGetter(var0 -> TranslatableContents.a(var0.j))).apply((Applicative)var02, TranslatableContents::a));
    public static final ComponentContents.a<TranslatableContents> c = new ComponentContents.a<TranslatableContents>(b, "translatable");
    private static final IChatFormatted f = IChatFormatted.e("%");
    private static final IChatFormatted g = IChatFormatted.e("null");
    private final String h;
    @Nullable
    private final String i;
    private final Object[] j;
    @Nullable
    private LocaleLanguage k;
    private List<IChatFormatted> l = ImmutableList.of();
    private static final Pattern m = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private static DataResult<Object> b(@Nullable Object var0) {
        if (!TranslatableContents.a(var0)) {
            return DataResult.error(() -> "This value needs to be parsed as component");
        }
        return DataResult.success((Object)var0);
    }

    public static boolean a(@Nullable Object var0) {
        return var0 instanceof Number || var0 instanceof Boolean || var0 instanceof String;
    }

    private static Optional<List<Object>> a(Object[] var0) {
        return var0.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(var0));
    }

    private static Object[] a(Optional<List<Object>> var02) {
        return var02.map(var0 -> var0.isEmpty() ? a : var0.toArray()).orElse(a);
    }

    private static TranslatableContents a(String var0, Optional<String> var1, Optional<List<Object>> var2) {
        return new TranslatableContents(var0, var1.orElse(null), TranslatableContents.a(var2));
    }

    public TranslatableContents(String var0, @Nullable String var1, Object[] var2) {
        this.h = var0;
        this.i = var1;
        this.j = var2;
    }

    @Override
    public ComponentContents.a<?> a() {
        return c;
    }

    private void e() {
        LocaleLanguage var0 = LocaleLanguage.a();
        if (var0 == this.k) {
            return;
        }
        this.k = var0;
        String var1 = this.i != null ? var0.a(this.h, this.i) : var0.a(this.h);
        try {
            ImmutableList.Builder var2 = ImmutableList.builder();
            this.a(var1, arg_0 -> ((ImmutableList.Builder)var2).add(arg_0));
            this.l = var2.build();
        }
        catch (TranslatableFormatException var2) {
            this.l = ImmutableList.of((Object)IChatFormatted.e(var1));
        }
    }

    private void a(String var0, Consumer<IChatFormatted> var1) {
        Matcher var2 = m.matcher(var0);
        try {
            int var3 = 0;
            int var4 = 0;
            while (var2.find(var4)) {
                String var7;
                int var5 = var2.start();
                int var6 = var2.end();
                if (var5 > var4) {
                    var7 = var0.substring(var4, var5);
                    if (var7.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    var1.accept(IChatFormatted.e(var7));
                }
                var7 = var2.group(2);
                String var8 = var0.substring(var5, var6);
                if ("%".equals(var7) && "%%".equals(var8)) {
                    var1.accept(f);
                } else if ("s".equals(var7)) {
                    String var9 = var2.group(1);
                    int var10 = var9 != null ? Integer.parseInt(var9) - 1 : var3++;
                    var1.accept(this.a(var10));
                } else {
                    throw new TranslatableFormatException(this, "Unsupported format: '" + var8 + "'");
                }
                var4 = var6;
            }
            if (var4 < var0.length()) {
                String var5 = var0.substring(var4);
                if (var5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                var1.accept(IChatFormatted.e(var5));
            }
        }
        catch (IllegalArgumentException var3) {
            throw new TranslatableFormatException(this, (Throwable)var3);
        }
    }

    private IChatFormatted a(int var0) {
        if (var0 < 0 || var0 >= this.j.length) {
            throw new TranslatableFormatException(this, var0);
        }
        Object var1 = this.j[var0];
        if (var1 instanceof IChatBaseComponent) {
            IChatBaseComponent var2 = (IChatBaseComponent)var1;
            return var2;
        }
        return var1 == null ? g : IChatFormatted.e(var1.toString());
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.b<T> var0, ChatModifier var1) {
        this.e();
        for (IChatFormatted var3 : this.l) {
            Optional<T> var4 = var3.a(var0, var1);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> a(IChatFormatted.a<T> var0) {
        this.e();
        for (IChatFormatted var2 : this.l) {
            Optional<T> var3 = var2.a(var0);
            if (!var3.isPresent()) continue;
            return var3;
        }
        return Optional.empty();
    }

    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        Object[] var3 = new Object[this.j.length];
        for (int var4 = 0; var4 < var3.length; ++var4) {
            Object var5 = this.j[var4];
            if (var5 instanceof IChatBaseComponent) {
                IChatBaseComponent var6 = (IChatBaseComponent)var5;
                var3[var4] = ChatComponentUtils.a(var0, var6, var1, var2);
                continue;
            }
            var3[var4] = var5;
        }
        return IChatMutableComponent.a(new TranslatableContents(this.h, this.i, var3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof TranslatableContents)) return false;
        TranslatableContents var1 = (TranslatableContents)var0;
        if (!Objects.equals(this.h, var1.h)) return false;
        if (!Objects.equals(this.i, var1.i)) return false;
        if (!Arrays.equals(this.j, var1.j)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = Objects.hashCode(this.h);
        var0 = 31 * var0 + Objects.hashCode(this.i);
        var0 = 31 * var0 + Arrays.hashCode(this.j);
        return var0;
    }

    public String toString() {
        return "translation{key='" + this.h + "'" + (String)(this.i != null ? ", fallback='" + this.i + "'" : "") + ", args=" + Arrays.toString(this.j) + "}";
    }

    public String b() {
        return this.h;
    }

    @Nullable
    public String c() {
        return this.i;
    }

    public Object[] d() {
        return this.j;
    }
}

