/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class ItemCommands {
    static final Dynamic3CommandExceptionType a = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.b("commands.item.target.not_a_container", var0, var1, var2));
    static final Dynamic3CommandExceptionType b = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.b("commands.item.source.not_a_container", var0, var1, var2));
    static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.item.target.no_such_slot", var0));
    private static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.item.source.no_such_slot", var0));
    private static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.b("commands.item.target.no_changes", var0));
    private static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.b("commands.item.target.no_changed.known_item", var0, var1));

    public static void a(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("item").requires(net.minecraft.commands.CommandDispatcher.a(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("replace").then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.b("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.a(var0, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)99)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.a(var0, "item").a(IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("from").then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))))))).then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.b("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("item", ArgumentItemStack.a(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.a(var0, "item").a(1, false)))).then(net.minecraft.commands.CommandDispatcher.a("count", IntegerArgumentType.integer((int)1, (int)99)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.a(var0, "item").a(IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("from").then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentPosition.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("source", ArgumentEntity.a()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("sourceSlot", ArgumentInventorySlot.a()).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier"))))))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.b("modify").then(net.minecraft.commands.CommandDispatcher.b("block").then(net.minecraft.commands.CommandDispatcher.a("pos", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.b("entity").then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(net.minecraft.commands.CommandDispatcher.a("slot", ArgumentInventorySlot.a()).then(net.minecraft.commands.CommandDispatcher.a("modifier", ResourceOrIdArgument.b(var1)).executes(var0 -> ItemCommands.a((CommandListenerWrapper)var0.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.a((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.b((CommandContext<CommandListenerWrapper>)var0, "modifier"))))))))));
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, Holder<LootItemFunction> var3) throws CommandSyntaxException {
        IInventory var4 = ItemCommands.a(var0, var1, a);
        if (var2 < 0 || var2 >= var4.b()) {
            throw c.create((Object)var2);
        }
        ItemStack var5 = ItemCommands.a(var0, var3, var4.a(var2));
        var4.a(var2, var5);
        var0.a(() -> IChatBaseComponent.a("commands.item.block.set.success", var1.u(), var1.v(), var1.w(), var5.K()), true);
        return 1;
    }

    private static int a(CommandListenerWrapper var0, Collection<? extends Entity> var1, int var2, Holder<LootItemFunction> var3) throws CommandSyntaxException {
        HashMap var4 = Maps.newHashMapWithExpectedSize((int)var1.size());
        for (Entity entity : var1) {
            ItemStack var8;
            SlotAccess var7 = entity.a_(var2);
            if (var7 == SlotAccess.a || !var7.a(var8 = ItemCommands.a(var0, var3, var7.a().v()))) continue;
            var4.put(entity, var8);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).cn.d();
        }
        if (var4.isEmpty()) {
            throw e.create((Object)var2);
        }
        if (var4.size() == 1) {
            Map.Entry var5 = var4.entrySet().iterator().next();
            var0.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)var5.getKey()).Q_(), ((ItemStack)var5.getValue()).K()), true);
        } else {
            var0.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", var4.size()), true);
        }
        return var4.size();
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, ItemStack var3) throws CommandSyntaxException {
        IInventory var4 = ItemCommands.a(var0, var1, a);
        if (var2 < 0 || var2 >= var4.b()) {
            throw c.create((Object)var2);
        }
        var4.a(var2, var3);
        var0.a(() -> IChatBaseComponent.a("commands.item.block.set.success", var1.u(), var1.v(), var1.w(), var3.K()), true);
        return 1;
    }

    static IInventory a(CommandListenerWrapper var0, BlockPosition var1, Dynamic3CommandExceptionType var2) throws CommandSyntaxException {
        TileEntity var3 = var0.e().c_(var1);
        if (!(var3 instanceof IInventory)) {
            throw var2.create((Object)var1.u(), (Object)var1.v(), (Object)var1.w());
        }
        return (IInventory)((Object)var3);
    }

    private static int a(CommandListenerWrapper var0, Collection<? extends Entity> var1, int var2, ItemStack var3) throws CommandSyntaxException {
        ArrayList var4 = Lists.newArrayListWithCapacity((int)var1.size());
        for (Entity entity : var1) {
            SlotAccess var7 = entity.a_(var2);
            if (var7 == SlotAccess.a || !var7.a(var3.v())) continue;
            var4.add(entity);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).cn.d();
        }
        if (var4.isEmpty()) {
            throw f.create((Object)var3.K(), (Object)var2);
        }
        if (var4.size() == 1) {
            var0.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.single", ((Entity)var4.iterator().next()).Q_(), var3.K()), true);
        } else {
            var0.a(() -> IChatBaseComponent.a("commands.item.entity.set.success.multiple", var4.size(), var3.K()), true);
        }
        return var4.size();
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, Collection<? extends Entity> var3, int var4) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var1, var2));
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, Collection<? extends Entity> var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var5, ItemCommands.a(var0, var1, var2)));
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, BlockPosition var3, int var4) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var1, var2));
    }

    private static int a(CommandListenerWrapper var0, BlockPosition var1, int var2, BlockPosition var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var5, ItemCommands.a(var0, var1, var2)));
    }

    private static int a(CommandListenerWrapper var0, Entity var1, int var2, BlockPosition var3, int var4) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var1, var2));
    }

    private static int a(CommandListenerWrapper var0, Entity var1, int var2, BlockPosition var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var5, ItemCommands.a(var1, var2)));
    }

    private static int a(CommandListenerWrapper var0, Entity var1, int var2, Collection<? extends Entity> var3, int var4) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var1, var2));
    }

    private static int a(CommandListenerWrapper var0, Entity var1, int var2, Collection<? extends Entity> var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.a(var0, var3, var4, ItemCommands.a(var0, var5, ItemCommands.a(var1, var2)));
    }

    private static ItemStack a(CommandListenerWrapper var0, Holder<LootItemFunction> var1, ItemStack var2) {
        WorldServer var3 = var0.e();
        LootParams var4 = new LootParams.a(var3).a(LootContextParameters.f, var0.d()).b(LootContextParameters.a, var0.f()).a(LootContextParameterSets.d);
        LootTableInfo var5 = new LootTableInfo.Builder(var4).a(Optional.empty());
        var5.b(LootTableInfo.a(var1.a()));
        ItemStack var6 = (ItemStack)var1.a().apply(var2, var5);
        var6.f(var6.k());
        return var6;
    }

    private static ItemStack a(Entity var0, int var1) throws CommandSyntaxException {
        SlotAccess var2 = var0.a_(var1);
        if (var2 == SlotAccess.a) {
            throw d.create((Object)var1);
        }
        return var2.a().v();
    }

    private static ItemStack a(CommandListenerWrapper var0, BlockPosition var1, int var2) throws CommandSyntaxException {
        IInventory var3 = ItemCommands.a(var0, var1, b);
        if (var2 < 0 || var2 >= var3.b()) {
            throw d.create((Object)var2);
        }
        return var3.a(var2).v();
    }
}

