/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dialog.input;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;

public final class NumberRangeInput
extends Record
implements InputControl {
    private final int c;
    private final IChatBaseComponent d;
    private final String e;
    private final a f;
    public static final MapCodec<NumberRangeInput> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Dialog.b.optionalFieldOf("width", (Object)200).forGetter(NumberRangeInput::b), (App)ComponentSerialization.a.fieldOf("label").forGetter(NumberRangeInput::c), (App)Codec.STRING.optionalFieldOf("label_format", (Object)"options.generic_value").forGetter(NumberRangeInput::d), (App)net.minecraft.server.dialog.input.NumberRangeInput$a.a.forGetter(NumberRangeInput::e)).apply((Applicative)var0, NumberRangeInput::new));

    public NumberRangeInput(int var0, IChatBaseComponent var1, String var2, a var3) {
        this.c = var0;
        this.d = var1;
        this.e = var2;
        this.f = var3;
    }

    public MapCodec<NumberRangeInput> a() {
        return a;
    }

    public IChatBaseComponent a(String var0) {
        return IChatBaseComponent.a(this.e, this.d, var0);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this);
    }

    @Override
    public final boolean equals(Object var0) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NumberRangeInput.class, "width;label;labelFormat;rangeInfo", "c", "d", "e", "f"}, this, var0);
    }

    public int b() {
        return this.c;
    }

    public IChatBaseComponent c() {
        return this.d;
    }

    public String d() {
        return this.e;
    }

    public a e() {
        return this.f;
    }

    public record a(float b, float c, Optional<Float> d, Optional<Float> e) {
        public static final MapCodec<a> a = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("start").forGetter(a::b), (App)Codec.FLOAT.fieldOf("end").forGetter(a::c), (App)Codec.FLOAT.optionalFieldOf("initial").forGetter(a::d), (App)ExtraCodecs.r.optionalFieldOf("step").forGetter(a::e)).apply((Applicative)var0, a::new)).validate(var0 -> {
            if (var0.d.isPresent()) {
                double var1 = var0.d.get().floatValue();
                double var3 = Math.min(var0.b, var0.c);
                double var5 = Math.max(var0.b, var0.c);
                if (var1 < var3 || var1 > var5) {
                    return DataResult.error(() -> "Initial value " + var1 + " is outside of range [" + var3 + ", " + var5 + "]");
                }
            }
            return DataResult.success((Object)var0);
        });

        public float a(float var0) {
            float var4;
            int var5;
            float var1 = MathHelper.h(var0, this.b, this.c);
            if (this.e.isEmpty()) {
                return var1;
            }
            float var2 = this.e.get().floatValue();
            float var3 = this.f();
            float var6 = var3 + (float)(var5 = Math.round((var4 = var1 - var3) / var2)) * var2;
            if (!this.b(var6)) {
                return var6;
            }
            int var7 = var5 - MathHelper.j((double)var5);
            return var3 + (float)var7 * var2;
        }

        private boolean b(float var0) {
            float var1 = this.c(var0);
            return (double)var1 < 0.0 || (double)var1 > 1.0;
        }

        private float f() {
            if (this.d.isPresent()) {
                return this.d.get().floatValue();
            }
            return (this.b + this.c) / 2.0f;
        }

        public float a() {
            float var0 = this.f();
            return this.c(var0);
        }

        private float c(float var0) {
            if (this.b == this.c) {
                return 0.5f;
            }
            return MathHelper.f(var0, this.b, this.c);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "start;end;initial;step", "b", "c", "d", "e"}, this, var0);
        }
    }
}

