/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ServerboundSelectKnownPacks;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.network.config.SynchronizeRegistriesTask;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R5.CraftServerLinks;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerLinksSendEvent;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements ServerConfigurationPacketListener,
TickablePacketListener {
    private static final Logger f = LogUtils.getLogger();
    private static final IChatBaseComponent g = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
    private final GameProfile h;
    private final Queue<ConfigurationTask> i = new ConcurrentLinkedQueue<ConfigurationTask>();
    @Nullable
    private ConfigurationTask j;
    private ClientInformation k;
    @Nullable
    private SynchronizeRegistriesTask l;

    public ServerConfigurationPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        super(minecraftserver, networkmanager, commonlistenercookie, player);
        this.h = commonlistenercookie.a();
        this.k = commonlistenercookie.c();
    }

    @Override
    protected GameProfile i() {
        return this.h;
    }

    @Override
    public void a(DisconnectionDetails disconnectiondetails) {
        f.info("{} lost connection: {}", (Object)this.h, (Object)disconnectiondetails.a().getString());
        super.a(disconnectiondetails);
    }

    @Override
    public boolean c() {
        return this.e.i();
    }

    public void l() {
        this.b(new ClientboundCustomPayloadPacket(new BrandPayload(this.d.getServerModName())));
        ServerLinks serverlinks = this.d.bp();
        CraftServerLinks wrapper = new CraftServerLinks(serverlinks);
        PlayerLinksSendEvent event = new PlayerLinksSendEvent((Player)this.player.getBukkitEntity(), (org.bukkit.ServerLinks)wrapper);
        this.player.getBukkitEntity().getServer().getPluginManager().callEvent((Event)event);
        serverlinks = wrapper.getServerLinks();
        if (!serverlinks.a()) {
            this.b(new ClientboundServerLinksPacket(serverlinks.b()));
        }
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = this.d.bb();
        List<KnownPack> list = this.d.be().b().flatMap(iresourcepack -> iresourcepack.a().d().stream()).toList();
        this.b(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.e.b(this.d.aZ().K())));
        this.l = new SynchronizeRegistriesTask(list, layeredregistryaccess);
        this.i.add(this.l);
        this.n();
        this.i.add(new JoinWorldTask());
        this.o();
    }

    public void m() {
        this.i.add(new JoinWorldTask());
        this.o();
    }

    private void n() {
        this.d.Y().ifPresent(minecraftserver_serverresourcepackinfo -> this.i.add(new ServerResourcePackConfigurationTask((MinecraftServer.ServerResourcePackInfo)minecraftserver_serverresourcepackinfo)));
    }

    @Override
    public void a(ServerboundClientInformationPacket serverboundclientinformationpacket) {
        this.k = serverboundclientinformationpacket.b();
    }

    @Override
    public void a(ServerboundResourcePackPacket serverboundresourcepackpacket) {
        super.a(serverboundresourcepackpacket);
        if (serverboundresourcepackpacket.e().a()) {
            this.a(ServerResourcePackConfigurationTask.a);
        }
    }

    @Override
    public void a(ServerboundSelectKnownPacks serverboundselectknownpacks) {
        PlayerConnectionUtils.a(serverboundselectknownpacks, this, this.d);
        if (this.l == null) {
            throw new IllegalStateException("Unexpected response from client: received pack selection, but no negotiation ongoing");
        }
        this.l.a(serverboundselectknownpacks.b(), this::b);
        this.a(SynchronizeRegistriesTask.a);
    }

    @Override
    public void a(ServerboundFinishConfigurationPacket serverboundfinishconfigurationpacket) {
        PlayerConnectionUtils.a(serverboundfinishconfigurationpacket, this, this.d);
        this.a(JoinWorldTask.a);
        this.e.a(GameProtocols.c.a(RegistryFriendlyByteBuf.a(this.d.ba())));
        try {
            PlayerList playerlist = this.d.ag();
            if (playerlist.a(this.h.getId()) != null) {
                this.a(PlayerList.f);
                return;
            }
            IChatBaseComponent ichatbasecomponent = null;
            if (ichatbasecomponent != null) {
                this.a(ichatbasecomponent);
                return;
            }
            EntityPlayer entityplayer = this.player;
            entityplayer.a(this.k);
            playerlist.a(this.e, entityplayer, this.a(this.k));
        }
        catch (Exception exception) {
            f.error("Couldn't place player in world", (Throwable)exception);
            this.e.a(new ClientboundDisconnectPacket(g));
            this.e.a(g);
        }
    }

    @Override
    public void d() {
        this.e();
    }

    private void o() {
        ConfigurationTask configurationtask;
        if (this.j != null) {
            throw new IllegalStateException("Task " + this.j.a().a() + " has not finished yet");
        }
        if (this.c() && (configurationtask = this.i.poll()) != null) {
            this.j = configurationtask;
            configurationtask.a(this::b);
        }
    }

    private void a(ConfigurationTask.a configurationtask_a) {
        ConfigurationTask.a configurationtask_a1;
        ConfigurationTask.a a2 = configurationtask_a1 = this.j != null ? this.j.a() : null;
        if (!configurationtask_a.equals(configurationtask_a1)) {
            String s2 = String.valueOf(configurationtask_a1);
            throw new IllegalStateException("Unexpected request for task finish, current task: " + s2 + ", requested: " + String.valueOf(configurationtask_a));
        }
        this.j = null;
        this.o();
    }
}

