/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import jline.console.completer.Completer;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.command.ColouredConsoleSender;
import org.bukkit.craftbukkit.v1_21_R5.command.ConsoleCommandCompleter;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.event.player.PlayerSpawnLocationEvent;

public abstract class PlayerList {
    public static final File a = new File("banned-players.json");
    public static final File b = new File("banned-ips.json");
    public static final File c = new File("ops.json");
    public static final File d = new File("whitelist.json");
    public static final IChatBaseComponent e = IChatBaseComponent.c("chat.filtered_full");
    public static final IChatBaseComponent f = IChatBaseComponent.c("multiplayer.disconnect.duplicate_login");
    private static final Logger h = LogUtils.getLogger();
    private static final int i = 600;
    private static final SimpleDateFormat j = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer k;
    public final List<EntityPlayer> l = new CopyOnWriteArrayList<EntityPlayer>();
    private final Map<UUID, EntityPlayer> m = Maps.newHashMap();
    private final GameProfileBanList n;
    private final IpBanList o;
    private final OpList p;
    private final WhiteList q;
    public final WorldNBTStorage t;
    private boolean u;
    private final LayeredRegistryAccess<RegistryLayer> v;
    public int g;
    private int w;
    private int x;
    private boolean y;
    private static final boolean z = false;
    private int A;
    private CraftServer cserver;
    private final Map<String, EntityPlayer> playersByName = new HashMap<String, EntityPlayer>();

    public PlayerList(MinecraftServer minecraftserver, LayeredRegistryAccess<RegistryLayer> layeredregistryaccess, WorldNBTStorage worldnbtstorage, int i2) {
        this.cserver = minecraftserver.server = new CraftServer((DedicatedServer)minecraftserver, this);
        minecraftserver.console = ColouredConsoleSender.getInstance();
        minecraftserver.reader.addCompleter((Completer)new ConsoleCommandCompleter(minecraftserver.server));
        this.n = new GameProfileBanList(a);
        this.o = new IpBanList(b);
        this.p = new OpList(c);
        this.q = new WhiteList(d);
        this.k = minecraftserver;
        this.v = layeredregistryaccess;
        this.g = i2;
        this.t = worldnbtstorage;
    }

    public void a(NetworkManager networkmanager, EntityPlayer entityplayer, CommonListenerCookie commonlistenercookie) {
        String s2;
        GameProfile gameprofile = entityplayer.gr();
        UserCache usercache = this.k.at();
        if (usercache != null) {
            Optional<GameProfile> optional = usercache.a(gameprofile.getId());
            s2 = optional.map(GameProfile::getName).orElse(gameprofile.getName());
            usercache.a(gameprofile);
        } else {
            s2 = gameprofile.getName();
        }
        try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(entityplayer.ef(), h);){
            WorldServer worldserver1;
            ResourceKey<net.minecraft.world.level.World> resourcekey;
            WorldServer worldserver;
            Optional<ValueInput> optional1 = this.a(entityplayer, problemreporter_j);
            if (optional1.isPresent()) {
                ValueInput valueinput2 = optional1.get();
                ValueInput bukkit = valueinput2.b("bukkit");
                s2 = bukkit.a("lastKnownName", s2);
            }
            if ((worldserver = this.k.a(resourcekey = optional1.flatMap(valueinput -> valueinput.a("Dimension", net.minecraft.world.level.World.h)).orElse(entityplayer.y().aj()))) == null) {
                h.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey);
                worldserver1 = this.k.J();
            } else {
                worldserver1 = worldserver;
            }
            entityplayer.a(worldserver1);
            if (optional1.isEmpty()) {
                entityplayer.b(entityplayer.a(worldserver1, worldserver1.ab()).c(), worldserver1.ac(), 0.0f);
            }
            worldserver1.a(entityplayer.dz(), 1);
            String s1 = networkmanager.a(this.k.bl());
            CraftPlayer spawnPlayer = entityplayer.getBukkitEntity();
            PlayerSpawnLocationEvent ev = new PlayerSpawnLocationEvent((Player)spawnPlayer, spawnPlayer.getLocation());
            this.cserver.getPluginManager().callEvent((Event)ev);
            Location loc = ev.getSpawnLocation();
            worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
            entityplayer.spawnIn(worldserver1, true);
            entityplayer.h.a(entityplayer.y());
            entityplayer.a(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
            WorldData worlddata = worldserver1.D_();
            entityplayer.d((ValueInput)optional1.orElse(null));
            PlayerConnection playerconnection = new PlayerConnection(this.k, networkmanager, entityplayer, commonlistenercookie);
            networkmanager.a(GameProtocols.b.a(RegistryFriendlyByteBuf.a(this.k.ba()), playerconnection), playerconnection);
            GameRules gamerules = worldserver1.P();
            boolean flag = gamerules.c(GameRules.F);
            boolean flag1 = gamerules.c(GameRules.r);
            boolean flag2 = gamerules.c(GameRules.y);
            playerconnection.b(new PacketPlayOutLogin(entityplayer.ar(), worlddata.l(), this.k.K(), this.n(), worldserver1.spigotConfig.viewDistance, worldserver1.spigotConfig.simulationDistance, flag1, !flag, flag2, entityplayer.b(worldserver1), this.k.aA()));
            entityplayer.getBukkitEntity().sendSupportedChannels();
            playerconnection.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
            playerconnection.b(new PacketPlayOutAbilities(entityplayer.gt()));
            playerconnection.b(new PacketPlayOutHeldItemSlot(entityplayer.gs().f()));
            CraftingManager craftingmanager = this.k.aI();
            playerconnection.b(new PacketPlayOutRecipeUpdate(craftingmanager.b(), craftingmanager.c()));
            this.d(entityplayer);
            entityplayer.I().c();
            entityplayer.J().a(entityplayer);
            this.a(worldserver1.g(), entityplayer);
            this.k.av();
            IChatMutableComponent ichatmutablecomponent = entityplayer.gr().getName().equalsIgnoreCase(s2) ? IChatBaseComponent.a("multiplayer.player.joined", entityplayer.Q_()) : IChatBaseComponent.a("multiplayer.player.joined.renamed", entityplayer.Q_(), s2);
            ichatmutablecomponent.a(EnumChatFormat.o);
            String joinMessage = CraftChatMessage.fromComponent(ichatmutablecomponent);
            playerconnection.a(entityplayer.dC(), entityplayer.dE(), entityplayer.dI(), entityplayer.dP(), entityplayer.dR());
            ServerPing serverping = this.k.au();
            if (serverping != null && !commonlistenercookie.d()) {
                entityplayer.a(serverping);
            }
            this.l.add(entityplayer);
            this.playersByName.put(entityplayer.cM().toLowerCase(Locale.ROOT), entityplayer);
            this.m.put(entityplayer.cK(), entityplayer);
            CraftPlayer bukkitPlayer = entityplayer.getBukkitEntity();
            entityplayer.cn.transferTo(entityplayer.cn, bukkitPlayer);
            PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((Player)bukkitPlayer, joinMessage);
            this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
            if (!entityplayer.g.c()) {
                return;
            }
            joinMessage = playerJoinEvent.getJoinMessage();
            if (joinMessage != null && joinMessage.length() > 0) {
                for (IChatBaseComponent line : CraftChatMessage.fromString(joinMessage)) {
                    this.k.ag().a(line, false);
                }
            }
            ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer));
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer entityplayer1 = this.l.get(i2);
                if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                    entityplayer1.g.b(packet);
                }
                if (!bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
                entityplayer.g.b(ClientboundPlayerInfoUpdatePacket.a(List.of(entityplayer1)));
            }
            entityplayer.sentListPacket = true;
            entityplayer.refreshEntityData(entityplayer);
            this.a(entityplayer, worldserver1);
            if (entityplayer.y() == worldserver1 && !worldserver1.A().contains(entityplayer)) {
                worldserver1.a(entityplayer);
                this.k.aM().a(entityplayer);
            }
            worldserver1 = entityplayer.y();
            this.c(entityplayer);
            optional1.ifPresent(valueinput -> {
                entityplayer.c((ValueInput)valueinput);
                entityplayer.b((ValueInput)valueinput);
            });
            entityplayer.c();
            h.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{entityplayer.aj().getString(), s1, entityplayer.ar(), worldserver1.L.e(), entityplayer.dC(), entityplayer.dE(), entityplayer.dI()});
        }
    }

    public void a(ScoreboardServer scoreboardserver, EntityPlayer entityplayer) {
        HashSet set = Sets.newHashSet();
        for (ScoreboardTeam scoreboardteam : scoreboardserver.f()) {
            entityplayer.g.b(PacketPlayOutScoreboardTeam.a(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            ScoreboardObjective scoreboardobjective = scoreboardserver.a(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            for (Packet<?> packet : scoreboardserver.d(scoreboardobjective)) {
                entityplayer.g.b(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void a(WorldServer worldserver) {
        if (this.t != null) {
            return;
        }
        worldserver.F_().a(new IWorldBorderListener(){

            @Override
            public void a(WorldBorder worldborder, double d0) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1, long i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, double d0, double d1) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(worldborder), worldborder.world);
            }

            @Override
            public void a(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, int i2) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(worldborder), worldborder.world);
            }

            @Override
            public void b(WorldBorder worldborder, double d0) {
            }

            @Override
            public void c(WorldBorder worldborder, double d0) {
            }
        });
    }

    public Optional<ValueInput> a(EntityPlayer entityplayer, ProblemReporter problemreporter) {
        Optional<ValueInput> optional;
        NBTTagCompound nbttagcompound = this.k.aZ().w();
        if (this.k.a(entityplayer.gr()) && nbttagcompound != null) {
            ValueInput valueinput = TagValueInput.a(problemreporter, (HolderLookup.a)entityplayer.eb(), nbttagcompound);
            optional = Optional.of(valueinput);
            entityplayer.e(valueinput);
            h.debug("loading single player");
        } else {
            optional = this.t.a(entityplayer, problemreporter);
        }
        return optional;
    }

    protected void a(EntityPlayer entityplayer) {
        AdvancementDataPlayer advancementdataplayer;
        if (!entityplayer.getBukkitEntity().isPersistent()) {
            return;
        }
        this.t.a(entityplayer);
        ServerStatisticManager serverstatisticmanager = entityplayer.I();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.a();
        }
        if ((advancementdataplayer = entityplayer.S()) != null) {
            advancementdataplayer.b();
        }
    }

    public String remove(EntityPlayer entityplayer) {
        Object entity;
        WorldServer worldserver = entityplayer.y();
        entityplayer.a(StatisticList.j);
        if (entityplayer.cn != entityplayer.cm) {
            entityplayer.p();
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((Player)entityplayer.getBukkitEntity(), (String)(entityplayer.kickLeaveMessage != null ? entityplayer.kickLeaveMessage : "\u00a7e" + entityplayer.cM() + " left the game"));
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        entityplayer.h();
        this.a(entityplayer);
        if (entityplayer.cc() && ((Entity)(entity = entityplayer.dh())).dg()) {
            h.debug("Removing player mount");
            entityplayer.bS();
            ((Entity)entity).dd().forEach(entity1 -> entity1.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT));
        }
        entityplayer.an();
        for (EntityEnderPearl entityenderpearl : entityplayer.ah()) {
            entityenderpearl.setRemoved(Entity.RemovalReason.d, EntityRemoveEvent.Cause.PLAYER_QUIT);
        }
        worldserver.a(entityplayer, Entity.RemovalReason.d);
        entityplayer.S().a();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cM().toLowerCase(Locale.ROOT));
        this.k.aM().b(entityplayer);
        UUID uuid = entityplayer.cK();
        EntityPlayer entityplayer1 = this.m.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.m.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.cK()));
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer2 = this.l.get(i2);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.g.b(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.getQuitMessage();
    }

    public EntityPlayer canPlayerLogin(LoginListener loginlistener, GameProfile gameprofile) {
        UUID uuid = gameprofile.getId();
        Set set = Sets.newIdentityHashSet();
        for (EntityPlayer entityplayer : this.l) {
            if (!entityplayer.cK().equals(uuid)) continue;
            set.add(entityplayer);
        }
        for (EntityPlayer entityplayer2 : set) {
            this.a(entityplayer2);
            entityplayer2.g.a(f);
        }
        SocketAddress socketaddress = loginlistener.g.d();
        EntityPlayer entity = new EntityPlayer(this.k, this.k.a(net.minecraft.world.level.World.i), gameprofile, ClientInformation.a());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((Player)player, loginlistener.g.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.g.n.remoteAddress()).getAddress());
        if (this.n.a(gameprofile)) {
            GameProfileBanEntry gameprofilebanentry = (GameProfileBanEntry)this.n.b(gameprofile);
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("multiplayer.disconnect.banned.reason", new Object[]{gameprofilebanentry.d()});
            if (gameprofilebanentry.c() != null) {
                ichatmutablecomponent.b(IChatBaseComponent.a("multiplayer.disconnect.banned.expiration", new Object[]{j.format(gameprofilebanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent));
        } else if (!this.c(gameprofile)) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.c("multiplayer.disconnect.not_whitelisted");
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, SpigotConfig.whitelistMessage);
        } else if (this.o.a(socketaddress)) {
            IpBanEntry ipbanentry = this.o.b(socketaddress);
            IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("multiplayer.disconnect.banned_ip.reason", new Object[]{ipbanentry.d()});
            if (ipbanentry.c() != null) {
                ichatmutablecomponent1.b(IChatBaseComponent.a("multiplayer.disconnect.banned_ip.expiration", new Object[]{j.format(ipbanentry.c())}));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, CraftChatMessage.fromComponent(ichatmutablecomponent1));
        } else if (this.l.size() >= this.g && !this.d(gameprofile)) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, SpigotConfig.serverFullMessage);
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(event.getKickMessage());
            return null;
        }
        return entity;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameprofile, EntityPlayer player) {
        return player == null;
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, flag, entity_removalreason, reason, null);
    }

    public EntityPlayer respawn(EntityPlayer entityplayer, boolean flag, Entity.RemovalReason entity_removalreason, PlayerRespawnEvent.RespawnReason reason, Location location) {
        BlockPosition blockposition;
        IBlockData iblockdata;
        Object worldserver2;
        TeleportTransition teleporttransition;
        entityplayer.bS();
        this.l.remove(entityplayer);
        this.playersByName.remove(entityplayer.cM().toLowerCase(Locale.ROOT));
        entityplayer.y().a(entityplayer, entity_removalreason);
        EntityPlayer entityplayer1 = entityplayer;
        WorldServer fromWorld = entityplayer.y();
        entityplayer.k = false;
        entityplayer1.g = entityplayer.g;
        entityplayer1.a(entityplayer, flag);
        entityplayer1.e(entityplayer.ar());
        entityplayer1.b(entityplayer.fF());
        for (String s2 : entityplayer.as()) {
            entityplayer1.a(s2);
        }
        if (location == null) {
            teleporttransition = entityplayer.findRespawnPositionAndUseSpawnBlock(!flag, TeleportTransition.a, reason);
            if (!flag) {
                entityplayer.reset();
            }
        } else {
            teleporttransition = new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.c, location.getYaw(), location.getPitch(), TeleportTransition.a);
        }
        if (teleporttransition == null) {
            return entityplayer;
        }
        WorldServer worldserver = teleporttransition.b();
        entityplayer1.spawnIn(worldserver, flag);
        entityplayer1.dW();
        entityplayer1.h(false);
        Vec3D vec3d = teleporttransition.c();
        entityplayer1.forceSetPositionRotation(vec3d.d, vec3d.e, vec3d.f, teleporttransition.e(), teleporttransition.f());
        if (teleporttransition.g()) {
            entityplayer1.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
            entityplayer1.setRespawnPosition(null, false, PlayerSpawnChangeEvent.Cause.RESET);
        }
        byte b0 = (byte)(flag ? 1 : 0);
        WorldServer worldserver1 = entityplayer1.y();
        WorldData worlddata = worldserver1.D_();
        entityplayer1.g.b(new PacketPlayOutRespawn(entityplayer1.b(worldserver1), b0));
        entityplayer1.g.b(new PacketPlayOutViewDistance(worldserver1.spigotConfig.viewDistance));
        entityplayer1.g.b(new ClientboundSetSimulationDistancePacket(worldserver1.spigotConfig.simulationDistance));
        entityplayer1.g.teleport(CraftLocation.toBukkit(entityplayer1.dv(), (World)worldserver1.getWorld(), entityplayer1.dP(), entityplayer1.dR()));
        entityplayer1.g.b(new PacketPlayOutSpawnPosition(worldserver.ab(), worldserver.ac()));
        entityplayer1.g.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        entityplayer1.g.b(new PacketPlayOutExperience(entityplayer1.cD, entityplayer1.cC, entityplayer1.cB));
        this.c(entityplayer1);
        this.a(entityplayer1, worldserver);
        this.d(entityplayer1);
        if (!entityplayer.g.isDisconnected()) {
            worldserver.b(entityplayer1);
            this.l.add(entityplayer1);
            this.playersByName.put(entityplayer1.cM().toLowerCase(Locale.ROOT), entityplayer1);
            this.m.put(entityplayer1.cK(), entityplayer1);
        }
        entityplayer1.x(entityplayer1.eL());
        EntityPlayer.RespawnConfig entityplayer_respawnconfig = entityplayer1.T();
        if (!flag && entityplayer_respawnconfig != null && (worldserver2 = this.k.a(entityplayer_respawnconfig.a())) != null && (iblockdata = ((net.minecraft.world.level.World)worldserver2).a_(blockposition = entityplayer_respawnconfig.b())).a(Blocks.pU)) {
            entityplayer1.g.b(new PacketPlayOutNamedSoundEffect(SoundEffects.wK, SoundCategory.e, blockposition.u(), blockposition.v(), blockposition.w(), 1.0f, 1.0f, worldserver.H_().g()));
        }
        this.e(entityplayer);
        entityplayer.x();
        for (MobEffect mobEffect : entityplayer.eI()) {
            entityplayer.g.b(new PacketPlayOutEntityEffect(entityplayer.ar(), mobEffect, false));
        }
        entityplayer.g(worldserver);
        if (fromWorld != worldserver) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((Player)entityplayer.getBukkitEntity(), (World)fromWorld.getWorld());
            this.k.server.getPluginManager().callEvent((Event)event);
        }
        if (entityplayer.g.isDisconnected()) {
            this.a(entityplayer);
        }
        return entityplayer1;
    }

    public void c(EntityPlayer entityplayer) {
        this.a((EntityLiving)entityplayer, entityplayer.g);
    }

    public void a(EntityLiving entityliving, PlayerConnection playerconnection) {
        for (MobEffect mobeffect : entityliving.eI()) {
            playerconnection.b(new PacketPlayOutEntityEffect(entityliving.ar(), mobeffect, false));
        }
    }

    public void d(EntityPlayer entityplayer) {
        GameProfile gameprofile = entityplayer.gr();
        int i2 = this.k.c(gameprofile);
        this.a(entityplayer, i2);
    }

    public void d() {
        if (++this.A > 600) {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                final EntityPlayer target = this.l.get(i2);
                target.g.b(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.e), this.l.stream().filter(new Predicate<EntityPlayer>(){

                    @Override
                    public boolean test(EntityPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.A = 0;
        }
    }

    public void a(Packet<?> packet) {
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.g.b(packet);
        }
    }

    public void broadcastAll(Packet packet, EntityHuman entityhuman) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.l.get((int)i2).g.b(packet);
        }
    }

    public void broadcastAll(Packet packet, net.minecraft.world.level.World world) {
        for (int i2 = 0; i2 < world.A().size(); ++i2) {
            ((EntityPlayer)world.A().get((int)i2)).g.b(packet);
        }
    }

    public void a(Packet<?> packet, ResourceKey<net.minecraft.world.level.World> resourcekey) {
        for (EntityPlayer entityplayer : this.l) {
            if (entityplayer.y().aj() != resourcekey) continue;
            entityplayer.g.b(packet);
        }
    }

    public void a(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteambase = entityhuman.cu();
        if (scoreboardteambase != null) {
            for (String s2 : ((ScoreboardTeamBase)scoreboardteambase).h()) {
                EntityPlayer entityplayer = this.a(s2);
                if (entityplayer == null || entityplayer == entityhuman) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public void b(EntityHuman entityhuman, IChatBaseComponent ichatbasecomponent) {
        ScoreboardTeam scoreboardteambase = entityhuman.cu();
        if (scoreboardteambase == null) {
            this.a(ichatbasecomponent, false);
        } else {
            for (int i2 = 0; i2 < this.l.size(); ++i2) {
                EntityPlayer entityplayer = this.l.get(i2);
                if (entityplayer.cu() == scoreboardteambase) continue;
                entityplayer.a(ichatbasecomponent);
            }
        }
    }

    public String[] e() {
        String[] astring = new String[this.l.size()];
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            astring[i2] = this.l.get(i2).gr().getName();
        }
        return astring;
    }

    public GameProfileBanList f() {
        return this.n;
    }

    public IpBanList g() {
        return this.o;
    }

    public void a(GameProfile gameprofile) {
        this.p.a(new OpListEntry(gameprofile, this.k.k(), this.p.a(gameprofile)));
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    public void b(GameProfile gameprofile) {
        this.p.c(gameprofile);
        EntityPlayer entityplayer = this.a(gameprofile.getId());
        if (entityplayer != null) {
            this.d(entityplayer);
        }
    }

    private void a(EntityPlayer entityplayer, int i2) {
        if (entityplayer.g != null) {
            byte b0 = i2 <= 0 ? (byte)24 : (i2 >= 4 ? (byte)28 : (byte)((byte)(24 + i2)));
            entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, b0));
        }
        entityplayer.getBukkitEntity().recalculatePermissions();
        this.k.aG().a(entityplayer);
    }

    public boolean c(GameProfile gameprofile) {
        return !this.u || this.p.d(gameprofile) || this.q.d(gameprofile);
    }

    public boolean f(GameProfile gameprofile) {
        return this.p.d(gameprofile) || this.k.a(gameprofile) && this.k.aZ().m() || this.y;
    }

    @Nullable
    public EntityPlayer a(String s2) {
        return this.playersByName.get(s2.toLowerCase(Locale.ROOT));
    }

    public void a(@Nullable EntityHuman entityhuman, double d0, double d1, double d2, double d3, ResourceKey<net.minecraft.world.level.World> resourcekey, Packet<?> packet) {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            double d6;
            double d5;
            double d4;
            EntityPlayer entityplayer = this.l.get(i2);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || entityplayer == entityhuman || entityplayer.y().aj() != resourcekey || !((d4 = d0 - entityplayer.dC()) * d4 + (d5 = d1 - entityplayer.dE()) * d5 + (d6 = d2 - entityplayer.dI()) * d6 < d3 * d3)) continue;
            entityplayer.g.b(packet);
        }
    }

    public void h() {
        for (int i2 = 0; i2 < this.l.size(); ++i2) {
            this.a(this.l.get(i2));
        }
    }

    public WhiteList i() {
        return this.q;
    }

    public String[] j() {
        return this.q.a();
    }

    public OpList k() {
        return this.p;
    }

    public String[] l() {
        return this.p.a();
    }

    public void a() {
    }

    public void a(EntityPlayer entityplayer, WorldServer worldserver) {
        WorldBorder worldborder = entityplayer.y().F_();
        entityplayer.g.b(new ClientboundInitializeBorderPacket(worldborder));
        entityplayer.g.b(new PacketPlayOutUpdateTime(worldserver.ae(), worldserver.af(), worldserver.P().c(GameRules.m)));
        entityplayer.g.b(new PacketPlayOutSpawnPosition(worldserver.ab(), worldserver.ac()));
        if (worldserver.ah()) {
            entityplayer.setPlayerWeather(WeatherType.DOWNFALL, false);
            entityplayer.updateWeather(-worldserver.x, worldserver.x, -worldserver.z, worldserver.z);
        }
        entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.o, 0.0f));
        this.k.aP().a(entityplayer);
    }

    public void e(EntityPlayer entityplayer) {
        entityplayer.cm.b();
        entityplayer.getBukkitEntity().updateScaledHealth();
        entityplayer.refreshEntityData(entityplayer);
        entityplayer.g.b(new PacketPlayOutHeldItemSlot(entityplayer.gs().f()));
        int i2 = entityplayer.y().P().c(GameRules.r) ? 22 : 23;
        entityplayer.g.b(new PacketPlayOutEntityStatus(entityplayer, (byte)i2));
        float immediateRespawn = entityplayer.y().P().c(GameRules.F) ? 1.0f : 0.0f;
        entityplayer.g.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.m, immediateRespawn));
    }

    public int m() {
        return this.l.size();
    }

    public int n() {
        return this.g;
    }

    public boolean o() {
        return this.u;
    }

    public void a(boolean flag) {
        this.u = flag;
    }

    public List<EntityPlayer> b(String s2) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.l) {
            if (!entityplayer.B().equals(s2)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int p() {
        return this.w;
    }

    public int q() {
        return this.x;
    }

    public MinecraftServer c() {
        return this.k;
    }

    @Nullable
    public NBTTagCompound r() {
        return null;
    }

    public void b(boolean flag) {
        this.y = flag;
    }

    public void s() {
        for (EntityPlayer player : this.l) {
            player.g.a(CraftChatMessage.fromStringOrEmpty(this.k.server.getShutdownMessage()));
        }
    }

    public void broadcastMessage(IChatBaseComponent[] iChatBaseComponents) {
        for (IChatBaseComponent component : iChatBaseComponents) {
            this.a(component, false);
        }
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
        this.a(ichatbasecomponent, (EntityPlayer entityplayer) -> ichatbasecomponent, flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent, Function<EntityPlayer, IChatBaseComponent> function, boolean flag) {
        this.k.a(ichatbasecomponent);
        for (EntityPlayer entityplayer : this.l) {
            IChatBaseComponent ichatbasecomponent1 = function.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.b(ichatbasecomponent1, flag);
        }
    }

    public void a(PlayerChatMessage playerchatmessage, CommandListenerWrapper commandlistenerwrapper, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(commandlistenerwrapper);
        this.a(playerchatmessage, commandlistenerwrapper::a, commandlistenerwrapper.i(), chatmessagetype_a);
    }

    public void a(PlayerChatMessage playerchatmessage, EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        Objects.requireNonNull(entityplayer);
        this.a(playerchatmessage, entityplayer::c, entityplayer, chatmessagetype_a);
    }

    private void a(PlayerChatMessage playerchatmessage, Predicate<EntityPlayer> predicate, @Nullable EntityPlayer entityplayer, ChatMessageType.a chatmessagetype_a) {
        boolean flag = this.a(playerchatmessage);
        this.k.a(playerchatmessage.d(), chatmessagetype_a, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.a(playerchatmessage);
        boolean flag1 = false;
        for (EntityPlayer entityplayer1 : this.l) {
            boolean flag2 = predicate.test(entityplayer1);
            entityplayer1.a(outgoingchatmessage, flag2, chatmessagetype_a);
            flag1 |= flag2 && playerchatmessage.j();
        }
        if (flag1 && entityplayer != null) {
            entityplayer.a(e);
        }
    }

    private boolean a(PlayerChatMessage playerchatmessage) {
        return playerchatmessage.i() && !playerchatmessage.a(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityPlayer entityhuman) {
        ServerStatisticManager serverstatisticmanager = entityhuman.I();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.cK(), entityhuman.Q_().getString()) : serverstatisticmanager;
    }

    public ServerStatisticManager getPlayerStats(UUID uuid, String displayName) {
        ServerStatisticManager serverstatisticmanager;
        EntityPlayer entityhuman = this.a(uuid);
        ServerStatisticManager serverStatisticManager = serverstatisticmanager = entityhuman == null ? null : entityhuman.I();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.k.a(SavedFile.b).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtils.a(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtils.b(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatisticManager(this.k, file1);
        }
        return serverstatisticmanager;
    }

    public AdvancementDataPlayer f(EntityPlayer entityplayer) {
        UUID uuid = entityplayer.cK();
        AdvancementDataPlayer advancementdataplayer = entityplayer.S();
        if (advancementdataplayer == null) {
            Path path = this.k.a(SavedFile.a).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new AdvancementDataPlayer(this.k.aC(), this, this.k.aD(), path, entityplayer);
        }
        advancementdataplayer.a(entityplayer);
        return advancementdataplayer;
    }

    public void a(int i2) {
        this.w = i2;
        this.a(new PacketPlayOutViewDistance(i2));
        for (WorldServer worldserver : this.k.L()) {
            if (worldserver == null) continue;
            worldserver.n().a(i2);
        }
    }

    public void b(int i2) {
        this.x = i2;
        this.a(new ClientboundSetSimulationDistancePacket(i2));
        for (WorldServer worldserver : this.k.L()) {
            if (worldserver == null) continue;
            worldserver.n().b(i2);
        }
    }

    public List<EntityPlayer> t() {
        return this.l;
    }

    @Nullable
    public EntityPlayer a(UUID uuid) {
        return this.m.get(uuid);
    }

    public boolean d(GameProfile gameprofile) {
        return false;
    }

    public void u() {
        for (EntityPlayer player : this.l) {
            player.S().a(this.k.aD());
            player.S().a(player, false);
        }
        this.a(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(this.v)));
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        CraftingManager craftingmanager = this.k.aI();
        PacketPlayOutRecipeUpdate packetplayoutrecipeupdate = new PacketPlayOutRecipeUpdate(craftingmanager.b(), craftingmanager.c());
        for (EntityPlayer entityplayer : this.l) {
            entityplayer.g.b(packetplayoutrecipeupdate);
            entityplayer.J().a(entityplayer);
        }
    }

    public boolean v() {
        return this.y;
    }
}

