/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterUUID
extends DataFix {
    public DataConverterUUID(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("EntityStringUuidFix", this.getInputSchema().getType(DataConverterTypes.E), var02 -> var02.update(DSL.remainderFinder(), var0 -> {
            Optional var1 = var0.get("UUID").asString().result();
            if (var1.isPresent()) {
                UUID var2 = UUID.fromString((String)var1.get());
                return var0.remove("UUID").set("UUIDMost", var0.createLong(var2.getMostSignificantBits())).set("UUIDLeast", var0.createLong(var2.getLeastSignificantBits()));
            }
            return var0;
        }));
    }
}

