/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.DropChances;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.entity.EquipmentUser;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerJump;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.EntitySenses;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.VanillaEnchantmentProviders;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.ContainerSingleItem;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.inventory.InventoryHolder;

public abstract class EntityInsentient
extends EntityLiving
implements EquipmentUser,
Leashable,
Targeting {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntityInsentient.class, DataWatcherRegistry.a);
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 4;
    protected static final int bQ = 1;
    private static final BaseBlockPosition e = new BaseBlockPosition(1, 0, 1);
    private static final List<EnumItemSlot> cj = List.of(EnumItemSlot.f, EnumItemSlot.e, EnumItemSlot.d, EnumItemSlot.c);
    public static final float bR = 0.15f;
    public static final float bS = 0.55f;
    public static final float bT = 0.5f;
    public static final float bU = 0.25f;
    public static final int bV = 2;
    private static final double ck = Math.sqrt(2.04f) - (double)0.6f;
    private static final boolean cl = false;
    private static final boolean cm = false;
    private static final boolean cn = false;
    private static final boolean co = false;
    protected static final MinecraftKey bW = MinecraftKey.b("random_spawn_bonus");
    public static final String bX = "drop_chances";
    public static final String bY = "LeftHanded";
    public static final String bZ = "CanPickUpLoot";
    public static final String ca = "NoAI";
    public int cb;
    protected int cc;
    protected ControllerLook cd;
    protected ControllerMove ce;
    protected ControllerJump cf;
    private final EntityAIBodyControl cp;
    protected NavigationAbstract cg;
    public PathfinderGoalSelector ch;
    public PathfinderGoalSelector ci;
    @Nullable
    private EntityLiving cq;
    private final EntitySenses cr;
    private DropChances cs = DropChances.d;
    private boolean ct = false;
    private boolean cu = false;
    private final Map<PathType, Float> cv = Maps.newEnumMap(PathType.class);
    public Optional<ResourceKey<LootTable>> cw = Optional.empty();
    public long cx;
    @Nullable
    private Leashable.a cy;
    private BlockPosition cz = BlockPosition.c;
    private int cA = -1;
    public boolean aware = true;

    protected EntityInsentient(EntityTypes<? extends EntityInsentient> entitytypes, World world) {
        super((EntityTypes<? extends EntityLiving>)entitytypes, world);
        this.ch = new PathfinderGoalSelector();
        this.ci = new PathfinderGoalSelector();
        this.cd = new ControllerLook(this);
        this.ce = new ControllerMove(this);
        this.cf = new ControllerJump(this);
        this.cp = this.O();
        this.cg = this.b(world);
        this.cr = new EntitySenses(this);
        if (world instanceof WorldServer) {
            this.H();
        }
    }

    public void setPersistenceRequired(boolean persistenceRequired) {
        this.cu = persistenceRequired;
    }

    protected void H() {
    }

    public static AttributeProvider.Builder I() {
        return EntityLiving.ej().a(GenericAttributes.n, 16.0);
    }

    protected NavigationAbstract b(World world) {
        return new Navigation(this, world);
    }

    protected boolean J() {
        return false;
    }

    public float a(PathType pathtype) {
        EntityInsentient entityinsentient1;
        Entity entity = this.dn();
        EntityInsentient entityinsentient = entity instanceof EntityInsentient && (entityinsentient1 = (EntityInsentient)entity).J() ? entityinsentient1 : this;
        Float ofloat = entityinsentient.cv.get((Object)pathtype);
        return ofloat == null ? pathtype.a() : ofloat.floatValue();
    }

    public void a(PathType pathtype, float f2) {
        this.cv.put(pathtype, Float.valueOf(f2));
    }

    public void L() {
    }

    public void N() {
    }

    protected EntityAIBodyControl O() {
        return new EntityAIBodyControl(this);
    }

    public ControllerLook P() {
        return this.cd;
    }

    public ControllerMove Q() {
        Entity entity = this.dn();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.Q();
        }
        return this.ce;
    }

    public ControllerJump R() {
        return this.cf;
    }

    public NavigationAbstract S() {
        Entity entity = this.dn();
        if (entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient = (EntityInsentient)entity;
            return entityinsentient.S();
        }
        return this.cg;
    }

    @Override
    @Nullable
    public EntityLiving cY() {
        Entity entity = this.db();
        if (!this.gw() && entity instanceof EntityInsentient) {
            EntityInsentient entityinsentient1 = (EntityInsentient)entity;
            if (entity.cf()) {
                EntityInsentient entityinsentient = entityinsentient1;
                return entityinsentient;
            }
        }
        EntityLiving entityinsentient = null;
        return entityinsentient;
    }

    public EntitySenses T() {
        return this.cr;
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.cq;
    }

    @Nullable
    protected final EntityLiving U() {
        return this.eh().c(MemoryModuleType.p).orElse(null);
    }

    public void g(@Nullable EntityLiving entityliving) {
        this.setTarget(entityliving, EntityTargetEvent.TargetReason.UNKNOWN, true);
    }

    public boolean setTarget(EntityLiving entityliving, EntityTargetEvent.TargetReason reason, boolean fireEvent) {
        if (this.e() == entityliving) {
            return false;
        }
        if (fireEvent) {
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN && this.e() != null && entityliving == null) {
                EntityTargetEvent.TargetReason targetReason = reason = this.e().bO() ? EntityTargetEvent.TargetReason.FORGOT_TARGET : EntityTargetEvent.TargetReason.TARGET_DIED;
            }
            if (reason == EntityTargetEvent.TargetReason.UNKNOWN) {
                this.ai().getCraftServer().getLogger().log(Level.WARNING, "Unknown target reason, please report on the issue tracker", new Exception());
            }
            CraftLivingEntity ctarget = null;
            if (entityliving != null) {
                ctarget = (CraftLivingEntity)entityliving.getBukkitEntity();
            }
            EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (LivingEntity)ctarget, reason);
            this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            entityliving = event.getTarget() != null ? ((CraftLivingEntity)event.getTarget()).getHandle() : null;
        }
        this.cq = entityliving;
        return true;
    }

    @Override
    public boolean a(EntityTypes<?> entitytypes) {
        return entitytypes != EntityTypes.ae;
    }

    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return false;
    }

    public void V() {
        this.c(GameEvent.m);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, (byte)0);
    }

    public int W() {
        return 80;
    }

    public void X() {
        this.b(this.p());
    }

    @Override
    public void az() {
        super.az();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("mobBaseTick");
        if (this.bO() && this.ar.a(1000) < this.cb++) {
            this.l();
            this.X();
        }
        gameprofilerfiller.c();
    }

    @Override
    protected void h(DamageSource damagesource) {
        this.l();
        super.h(damagesource);
    }

    private void l() {
        this.cb = -this.W();
    }

    @Override
    protected int e(WorldServer worldserver) {
        if (this.cc > 0) {
            int i2 = this.cc;
            for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
                ItemStack itemstack;
                if (!enumitemslot.g() || (itemstack = this.a(enumitemslot)).f() || !(this.cs.b(enumitemslot) <= 1.0f)) continue;
                i2 += 1 + this.ar.a(3);
            }
            return i2;
        }
        return this.cc;
    }

    public void Y() {
        if (this.ai().C) {
            this.fe();
        } else {
            this.ai().a((Entity)this, (byte)20);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 20) {
            this.Y();
        } else {
            super.b(b0);
        }
    }

    @Override
    public void g() {
        super.g();
        if (!this.ai().C && this.as % 5 == 0) {
            this.Z();
        }
    }

    protected void Z() {
        boolean flag = !(this.cY() instanceof EntityInsentient);
        boolean flag1 = !(this.dm() instanceof AbstractBoat);
        this.ch.a(PathfinderGoal.Type.a, flag);
        this.ch.a(PathfinderGoal.Type.c, flag && flag1);
        this.ch.a(PathfinderGoal.Type.b, flag);
    }

    @Override
    protected void C(float f2) {
        this.cp.a();
    }

    @Nullable
    protected SoundEffect p() {
        return null;
    }

    public SoundEffect getAmbientSound0() {
        return this.p();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a(bZ, this.fU());
        valueoutput.a("PersistenceRequired", this.cu);
        if (!this.cs.equals(DropChances.d)) {
            valueoutput.a(bX, DropChances.e, this.cs);
        }
        this.a(valueoutput, this.cy);
        if (this.gv()) {
            valueoutput.a("home_radius", this.cA);
            valueoutput.a("home_pos", BlockPosition.a, this.cz);
        }
        valueoutput.a(bY, this.gx());
        this.cw.ifPresent(resourcekey -> valueoutput.a("DeathLootTable", LootTable.a, resourcekey));
        if (this.cx != 0L) {
            valueoutput.a("DeathLootTableSeed", this.cx);
        }
        if (this.gw()) {
            valueoutput.a(ca, this.gw());
        }
        valueoutput.a("Bukkit.Aware", this.aware);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        boolean canPickUpLoot = valueinput.a(bZ, false);
        if (EntityInsentient.isLevelAtLeast(valueinput, 1) || canPickUpLoot) {
            this.a_(canPickUpLoot);
        }
        boolean persistenceRequired = valueinput.a("PersistenceRequired", false);
        if (EntityInsentient.isLevelAtLeast(valueinput, 1) || persistenceRequired) {
            this.cu = persistenceRequired;
        }
        this.cs = valueinput.a(bX, DropChances.e).orElse(DropChances.d);
        this.b(valueinput);
        this.cA = valueinput.a("home_radius", -1);
        if (this.cA >= 0) {
            this.cz = valueinput.a("home_pos", BlockPosition.a).orElse(BlockPosition.c);
        }
        this.v(valueinput.a(bY, false));
        this.cw = valueinput.a("DeathLootTable", LootTable.a);
        this.cx = valueinput.a("DeathLootTableSeed", 0L);
        this.u(valueinput.a(ca, false));
        this.aware = valueinput.a("Bukkit.Aware", this.aware);
    }

    @Override
    protected void b(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.b(worldserver, damagesource, flag);
        this.cw = Optional.empty();
    }

    @Override
    public final Optional<ResourceKey<LootTable>> ee() {
        return this.cw.isPresent() ? this.cw : super.ee();
    }

    @Override
    public long eO() {
        return this.cx;
    }

    public void G(float f2) {
        this.bE = f2;
    }

    public void H(float f2) {
        this.bD = f2;
    }

    public void I(float f2) {
        this.bC = f2;
    }

    @Override
    public void B(float f2) {
        super.B(f2);
        this.G(f2);
    }

    public void aa() {
        this.S().n();
        this.I(0.0f);
        this.H(0.0f);
        this.B(0.0f);
        this.n(0.0, 0.0, 0.0);
        this.gD();
    }

    @Override
    public void e_() {
        super.e_();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("looting");
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.fU() && this.bO() && !this.by && worldserver.P().c(GameRules.d)) {
                BaseBlockPosition baseblockposition = this.ac();
                for (EntityItem entityitem : this.ai().a(EntityItem.class, this.cV().c(baseblockposition.u(), baseblockposition.v(), baseblockposition.w()))) {
                    if (entityitem.dU() || entityitem.e().f() || entityitem.n() || !this.c(worldserver, entityitem.e())) continue;
                    this.a(worldserver, entityitem);
                }
            }
        }
        gameprofilerfiller.c();
    }

    protected BaseBlockPosition ac() {
        return e;
    }

    protected void a(WorldServer worldserver, EntityItem entityitem) {
        ItemStack itemstack = entityitem.e();
        ItemStack itemstack1 = this.equipItemIfPossible(worldserver, itemstack.v(), entityitem);
        if (!itemstack1.f()) {
            this.a(entityitem);
            this.a((Entity)entityitem, itemstack1.M());
            itemstack.h(itemstack1.M());
            if (itemstack.f()) {
                entityitem.discard(EntityRemoveEvent.Cause.PICKUP);
            }
        }
    }

    public ItemStack b(WorldServer worldserver, ItemStack itemstack) {
        return this.equipItemIfPossible(worldserver, itemstack, null);
    }

    public ItemStack equipItemIfPossible(WorldServer worldserver, ItemStack itemstack, EntityItem entityitem) {
        boolean canPickup;
        EnumItemSlot enumitemslot = this.f(itemstack);
        if (!this.a(itemstack, enumitemslot)) {
            return ItemStack.l;
        }
        ItemStack itemstack1 = this.a(enumitemslot);
        boolean flag = this.a(itemstack, itemstack1, enumitemslot);
        if (enumitemslot.f() && !flag) {
            enumitemslot = EnumItemSlot.a;
            itemstack1 = this.a(enumitemslot);
            flag = itemstack1.f();
        }
        boolean bl = canPickup = flag && this.g(itemstack);
        if (entityitem != null) {
            boolean bl2 = canPickup = !CraftEventFactory.callEntityPickupItemEvent(this, entityitem, 0, !canPickup).isCancelled();
        }
        if (canPickup) {
            double d0 = this.cs.b(enumitemslot);
            if (!itemstack1.f() && (double)Math.max(this.ar.i() - 0.1f, 0.0f) < d0) {
                this.forceDrops = true;
                this.a(worldserver, itemstack1);
                this.forceDrops = false;
            }
            ItemStack itemstack2 = enumitemslot.a(itemstack);
            this.b(enumitemslot, itemstack2);
            return itemstack2;
        }
        return ItemStack.l;
    }

    protected void b(EnumItemSlot enumitemslot, ItemStack itemstack) {
        this.a(enumitemslot, itemstack);
        this.g(enumitemslot);
        this.cu = true;
    }

    protected boolean a(EntityHuman entityhuman) {
        return !this.cd();
    }

    public void g(EnumItemSlot enumitemslot) {
        this.cs = this.cs.a(enumitemslot);
    }

    protected boolean a(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        return itemstack1.f() ? true : (enumitemslot.f() ? this.b(itemstack, itemstack1, enumitemslot) : (enumitemslot == EnumItemSlot.a ? this.c(itemstack, itemstack1, enumitemslot) : false));
    }

    private boolean b(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        if (EnchantmentManager.a(itemstack1, EnchantmentEffectComponents.E)) {
            return false;
        }
        double d0 = this.a(itemstack, GenericAttributes.a, enumitemslot);
        double d1 = this.a(itemstack1, GenericAttributes.a, enumitemslot);
        double d2 = this.a(itemstack, GenericAttributes.b, enumitemslot);
        double d3 = this.a(itemstack1, GenericAttributes.b, enumitemslot);
        return d0 != d1 ? d0 > d1 : (d2 != d3 ? d2 > d3 : this.b(itemstack, itemstack1));
    }

    private boolean c(ItemStack itemstack, ItemStack itemstack1, EnumItemSlot enumitemslot) {
        double d1;
        double d0;
        TagKey<Item> tagkey = this.ad();
        if (tagkey != null) {
            if (itemstack1.a(tagkey) && !itemstack.a(tagkey)) {
                return false;
            }
            if (!itemstack1.a(tagkey) && itemstack.a(tagkey)) {
                return true;
            }
        }
        return (d0 = this.a(itemstack, GenericAttributes.c, enumitemslot)) != (d1 = this.a(itemstack1, GenericAttributes.c, enumitemslot)) ? d0 > d1 : this.b(itemstack, itemstack1);
    }

    private double a(ItemStack itemstack, Holder<AttributeBase> holder, EnumItemSlot enumitemslot) {
        double d0 = this.fg().b(holder) ? this.j(holder) : 0.0;
        ItemAttributeModifiers itemattributemodifiers = itemstack.a(DataComponents.o, ItemAttributeModifiers.a);
        return itemattributemodifiers.a(d0, enumitemslot);
    }

    public boolean b(ItemStack itemstack, ItemStack itemstack1) {
        int j2;
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set = itemstack1.a(DataComponents.l, ItemEnchantments.a).b();
        Set<Object2IntMap.Entry<Holder<Enchantment>>> set1 = itemstack.a(DataComponents.l, ItemEnchantments.a).b();
        if (set1.size() != set.size()) {
            return set1.size() > set.size();
        }
        int i2 = itemstack.o();
        return i2 != (j2 = itemstack1.o()) ? i2 < j2 : itemstack.c(DataComponents.g) && !itemstack1.c(DataComponents.g);
    }

    public boolean g(ItemStack itemstack) {
        return true;
    }

    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        return this.g(itemstack);
    }

    @Nullable
    public TagKey<Item> ad() {
        return null;
    }

    public boolean h(double d0) {
        return true;
    }

    public boolean af() {
        return this.cc();
    }

    protected boolean ag() {
        return false;
    }

    @Override
    public void dJ() {
        if (this.ai().an() == EnumDifficulty.a && this.ag()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else if (!this.gq() && !this.af()) {
            EntityHuman entity = this.ai().a((Entity)this, -1.0);
            if (entity != null) {
                int i2;
                int j2;
                double d0 = entity.g(this);
                if (d0 > (double)(j2 = (i2 = this.ap().f().f()) * i2) && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                }
                int k2 = this.ap().f().g();
                int l2 = k2 * k2;
                if (this.bz > 600 && this.ar.a(800) == 0 && d0 > (double)l2 && this.h(d0)) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else if (d0 < (double)l2) {
                    this.bz = 0;
                }
            }
        } else {
            this.bz = 0;
        }
    }

    @Override
    protected final void fB() {
        ++this.bz;
        if (!this.aware) {
            return;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("sensing");
        this.cr.a();
        gameprofilerfiller.c();
        int i2 = this.as + this.ar();
        if (i2 % 2 != 0 && this.as > 1) {
            gameprofilerfiller.a("targetSelector");
            this.ci.a(false);
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.ch.a(false);
            gameprofilerfiller.c();
        } else {
            gameprofilerfiller.a("targetSelector");
            this.ci.a();
            gameprofilerfiller.c();
            gameprofilerfiller.a("goalSelector");
            this.ch.a();
            gameprofilerfiller.c();
        }
        gameprofilerfiller.a("navigation");
        this.cg.d();
        gameprofilerfiller.c();
        gameprofilerfiller.a("mob tick");
        this.a((WorldServer)this.ai());
        gameprofilerfiller.c();
        gameprofilerfiller.a("controls");
        gameprofilerfiller.a("move");
        this.ce.a();
        gameprofilerfiller.b("look");
        this.cd.a();
        gameprofilerfiller.b("jump");
        this.cf.b();
        gameprofilerfiller.c();
        gameprofilerfiller.c();
        this.ah();
    }

    protected void ah() {
        PacketDebug.a(this.ai(), this, this.ch);
    }

    protected void a(WorldServer worldserver) {
    }

    public int gg() {
        return 40;
    }

    public int gh() {
        return 75;
    }

    protected void gi() {
        float f2 = this.gh();
        float f1 = this.cE();
        float f22 = MathHelper.h(this.br - f1);
        float f3 = MathHelper.a(MathHelper.h(this.br - f1), -f2, f2);
        float f4 = f1 + f22 - f3;
        this.r(f4);
    }

    public int gj() {
        return 10;
    }

    public void a(Entity entity, float f2, float f1) {
        double d2;
        double d0 = entity.dC() - this.dC();
        double d1 = entity.dI() - this.dI();
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            d2 = entityliving.dG() - this.dG();
        } else {
            d2 = (entity.cV().b + entity.cV().e) / 2.0 - this.dG();
        }
        double d3 = Math.sqrt(d0 * d0 + d1 * d1);
        float f22 = (float)(MathHelper.d(d1, d0) * 57.2957763671875) - 90.0f;
        float f3 = (float)(-(MathHelper.d(d2, d3) * 57.2957763671875));
        this.w(this.a(this.dR(), f3, f1));
        this.v(this.a(this.dP(), f22, f2));
    }

    private float a(float f2, float f1, float f22) {
        float f3 = MathHelper.h(f1 - f2);
        if (f3 > f22) {
            f3 = f22;
        }
        if (f3 < -f22) {
            f3 = -f22;
        }
        return f2 + f3;
    }

    public static boolean a(EntityTypes<? extends EntityInsentient> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        BlockPosition blockposition1 = blockposition.e();
        return EntitySpawnReason.a(entityspawnreason) || generatoraccess.a_(blockposition1).a((IBlockAccess)generatoraccess, blockposition1, entitytypes);
    }

    public boolean a(GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason) {
        return true;
    }

    public boolean a(IWorldReader iworldreader) {
        return !iworldreader.d(this.cV()) && iworldreader.f(this);
    }

    public int gk() {
        return 4;
    }

    public boolean q(int i2) {
        return false;
    }

    @Override
    public int cI() {
        if (this.e() == null) {
            return this.y(0.0f);
        }
        int i2 = (int)(this.eL() - this.fa() * 0.33f);
        if ((i2 -= (3 - this.ai().an().a()) * 4) < 0) {
            i2 = 0;
        }
        return this.y(i2);
    }

    public ItemStack gl() {
        return this.a(EnumItemSlot.g);
    }

    public boolean gm() {
        return this.i(EnumItemSlot.h);
    }

    public boolean gn() {
        return this.i(EnumItemSlot.g);
    }

    private boolean i(EnumItemSlot enumitemslot) {
        return this.d(enumitemslot) && this.a(this.a(enumitemslot), enumitemslot);
    }

    public void h(ItemStack itemstack) {
        this.b(EnumItemSlot.g, itemstack);
    }

    public IInventory h(final EnumItemSlot enumitemslot) {
        return new ContainerSingleItem(){
            public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
            private int maxStack = 99;

            @Override
            public ItemStack f() {
                return EntityInsentient.this.a(enumitemslot);
            }

            @Override
            public void b(ItemStack itemstack) {
                EntityInsentient.this.a(enumitemslot, itemstack);
                if (!itemstack.f()) {
                    EntityInsentient.this.g(enumitemslot);
                    EntityInsentient.this.gp();
                }
            }

            @Override
            public void e() {
            }

            @Override
            public boolean a(EntityHuman entityhuman) {
                return entityhuman.dm() == EntityInsentient.this || entityhuman.b((Entity)EntityInsentient.this, 4.0);
            }

            @Override
            public List<ItemStack> getContents() {
                return Arrays.asList(this.f());
            }

            @Override
            public void onOpen(CraftHumanEntity who) {
                this.transaction.add(who);
            }

            @Override
            public void onClose(CraftHumanEntity who) {
                this.transaction.remove(who);
            }

            @Override
            public List<HumanEntity> getViewers() {
                return this.transaction;
            }

            @Override
            public int an_() {
                return this.maxStack;
            }

            @Override
            public void setMaxStackSize(int size) {
                this.maxStack = size;
            }

            @Override
            public InventoryHolder getOwner() {
                return (InventoryHolder)EntityInsentient.this.getBukkitEntity();
            }

            @Override
            public Location getLocation() {
                return EntityInsentient.this.getBukkitEntity().getLocation();
            }
        };
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        super.a(worldserver, damagesource, flag);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            float f2 = this.cs.b(enumitemslot);
            if (f2 == 0.0f) continue;
            boolean flag1 = this.cs.c(enumitemslot);
            Entity entity = damagesource.d();
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                World world = this.ai();
                if (world instanceof WorldServer) {
                    WorldServer worldserver1 = (WorldServer)world;
                    f2 = EnchantmentManager.a(worldserver1, entityliving, damagesource, f2);
                }
            }
            if (itemstack.f() || EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D) || !flag && !flag1 || !(this.ar.i() < f2)) continue;
            if (!flag1 && itemstack.m()) {
                itemstack.b(itemstack.p() - this.ar.a(1 + this.ar.a(Math.max(itemstack.p() - 3, 1))));
            }
            this.a(worldserver, itemstack);
            this.a(enumitemslot, ItemStack.l);
        }
    }

    public DropChances go() {
        return this.cs;
    }

    public void b(WorldServer worldserver) {
        this.a(worldserver, (ItemStack itemstack) -> true);
    }

    public Set<EnumItemSlot> a(WorldServer worldserver, Predicate<ItemStack> predicate) {
        HashSet<EnumItemSlot> set = new HashSet<EnumItemSlot>();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            if (!predicate.test(itemstack)) {
                set.add(enumitemslot);
                continue;
            }
            if (!this.cs.c(enumitemslot)) continue;
            this.a(enumitemslot, ItemStack.l);
            this.a(worldserver, itemstack);
        }
        return set;
    }

    private LootParams g(WorldServer worldserver) {
        return new LootParams.a(worldserver).a(LootContextParameters.f, this.dv()).a(LootContextParameters.a, this).a(LootContextParameterSets.h);
    }

    public void a(EquipmentTable equipmenttable) {
        this.a(equipmenttable.a(), equipmenttable.b());
    }

    public void a(ResourceKey<LootTable> resourcekey, Map<EnumItemSlot, Float> map) {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(resourcekey, this.g(worldserver), map);
        }
    }

    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        if (randomsource.i() < 0.15f * difficultydamagescaler.d()) {
            float f2;
            int i2 = randomsource.a(2);
            float f3 = f2 = this.ai().an() == EnumDifficulty.d ? 0.1f : 0.25f;
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            if (randomsource.i() < 0.095f) {
                ++i2;
            }
            boolean flag = true;
            for (EnumItemSlot enumitemslot : cj) {
                Item item;
                ItemStack itemstack = this.a(enumitemslot);
                if (!flag && randomsource.i() < f2) break;
                flag = false;
                if (!itemstack.f() || (item = EntityInsentient.a(enumitemslot, i2)) == null) continue;
                this.a(enumitemslot, new ItemStack(item));
            }
        }
    }

    @Nullable
    public static Item a(EnumItemSlot enumitemslot, int i2) {
        switch (enumitemslot) {
            case f: {
                if (i2 == 0) {
                    return Items.qD;
                }
                if (i2 == 1) {
                    return Items.qT;
                }
                if (i2 == 2) {
                    return Items.qH;
                }
                if (i2 == 3) {
                    return Items.qL;
                }
                if (i2 == 4) {
                    return Items.qP;
                }
            }
            case e: {
                if (i2 == 0) {
                    return Items.qE;
                }
                if (i2 == 1) {
                    return Items.qU;
                }
                if (i2 == 2) {
                    return Items.qI;
                }
                if (i2 == 3) {
                    return Items.qM;
                }
                if (i2 == 4) {
                    return Items.qQ;
                }
            }
            case d: {
                if (i2 == 0) {
                    return Items.qF;
                }
                if (i2 == 1) {
                    return Items.qV;
                }
                if (i2 == 2) {
                    return Items.qJ;
                }
                if (i2 == 3) {
                    return Items.qN;
                }
                if (i2 == 4) {
                    return Items.qR;
                }
            }
            case c: {
                if (i2 == 0) {
                    return Items.qG;
                }
                if (i2 == 1) {
                    return Items.qW;
                }
                if (i2 == 2) {
                    return Items.qK;
                }
                if (i2 == 3) {
                    return Items.qO;
                }
                if (i2 != 4) break;
                return Items.qS;
            }
        }
        return null;
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.b(worldaccess, randomsource, difficultydamagescaler);
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            if (enumitemslot.a() != EnumItemSlot.Function.b) continue;
            this.a(worldaccess, randomsource, enumitemslot, difficultydamagescaler);
        }
    }

    protected void b(WorldAccess worldaccess, RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, EnumItemSlot.a, randomsource, 0.25f, difficultydamagescaler);
    }

    protected void a(WorldAccess worldaccess, RandomSource randomsource, EnumItemSlot enumitemslot, DifficultyDamageScaler difficultydamagescaler) {
        this.a(worldaccess, enumitemslot, randomsource, 0.5f, difficultydamagescaler);
    }

    private void a(WorldAccess worldaccess, EnumItemSlot enumitemslot, RandomSource randomsource, float f2, DifficultyDamageScaler difficultydamagescaler) {
        ItemStack itemstack = this.a(enumitemslot);
        if (!itemstack.f() && randomsource.i() < f2 * difficultydamagescaler.d()) {
            EnchantmentManager.a(itemstack, worldaccess.K_(), VanillaEnchantmentProviders.a, difficultydamagescaler, randomsource);
            this.a(enumitemslot, itemstack);
        }
    }

    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.H_();
        AttributeModifiable attributemodifiable = Objects.requireNonNull(this.h(GenericAttributes.n));
        if (!attributemodifiable.b(bW)) {
            attributemodifiable.d(new AttributeModifier(bW, randomsource.a(0.0, 0.11485000000000001), AttributeModifier.Operation.b));
        }
        this.v(randomsource.i() < 0.05f);
        return groupdataentity;
    }

    public void gp() {
        this.cu = true;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, float f2) {
        this.cs = this.cs.a(enumitemslot, f2);
    }

    @Override
    public boolean fU() {
        return this.ct;
    }

    public void a_(boolean flag) {
        this.ct = flag;
    }

    @Override
    protected boolean f(EnumItemSlot enumitemslot) {
        return this.fU();
    }

    public boolean gq() {
        return this.cu;
    }

    @Override
    public final EnumInteractionResult a(EntityHuman entityhuman, EnumHand enumhand) {
        if (!this.bO()) {
            return EnumInteractionResult.e;
        }
        EnumInteractionResult enuminteractionresult = this.c(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        EnumInteractionResult enuminteractionresult1 = super.a(entityhuman, enumhand);
        if (enuminteractionresult1 != EnumInteractionResult.e) {
            return enuminteractionresult1;
        }
        enuminteractionresult = this.b(entityhuman, enumhand);
        if (enuminteractionresult.a()) {
            this.a(GameEvent.r, (Entity)entityhuman);
            return enuminteractionresult;
        }
        return EnumInteractionResult.e;
    }

    private EnumInteractionResult c(EntityHuman entityhuman, EnumHand enumhand) {
        EnumInteractionResult enuminteractionresult;
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.wo) && (enuminteractionresult = itemstack.a(entityhuman, (EntityLiving)this, enumhand)).a()) {
            return enuminteractionresult;
        }
        if (itemstack.h() instanceof ItemMonsterEgg) {
            if (this.ai() instanceof WorldServer) {
                ItemMonsterEgg itemmonsteregg = (ItemMonsterEgg)itemstack.h();
                Optional<EntityInsentient> optional = itemmonsteregg.a(entityhuman, this, this.ap(), (WorldServer)this.ai(), this.dv(), itemstack);
                optional.ifPresent(entityinsentient -> this.a(entityhuman, (EntityInsentient)entityinsentient));
                if (optional.isEmpty()) {
                    return EnumInteractionResult.e;
                }
            }
            return EnumInteractionResult.b;
        }
        return EnumInteractionResult.e;
    }

    protected void a(EntityHuman entityhuman, EntityInsentient entityinsentient) {
    }

    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        return EnumInteractionResult.e;
    }

    public boolean gr() {
        return this.a(this.dx());
    }

    public boolean a(BlockPosition blockposition) {
        return this.cA == -1 ? true : this.cz.j(blockposition) < (double)(this.cA * this.cA);
    }

    public boolean a(Vec3D vec3d) {
        return this.cA == -1 ? true : this.cz.b(vec3d) < (double)(this.cA * this.cA);
    }

    public void a(BlockPosition blockposition, int i2) {
        this.cz = blockposition;
        this.cA = i2;
    }

    public BlockPosition gs() {
        return this.cz;
    }

    public int gt() {
        return this.cA;
    }

    public void gu() {
        this.cA = -1;
    }

    public boolean gv() {
        return this.cA != -1;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, entityspawnreason, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, EntitySpawnReason entityspawnreason, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (this.dU()) {
            return null;
        }
        EntityInsentient t0 = (EntityInsentient)entitytypes.a(this.ai(), entityspawnreason);
        if (t0 == null) {
            return null;
        }
        conversionparams.a().a(this, t0, conversionparams);
        conversionparams_a.finalizeConversion(t0);
        World world = this.ai();
        if (transformReason == null) {
            return (T)t0;
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, t0, transformReason).isCancelled()) {
            return null;
        }
        conversionparams.a().postConvert(this, t0, conversionparams);
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            worldserver.addFreshEntity(t0, spawnReason);
        }
        if (conversionparams.a().a()) {
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
        }
        return (T)t0;
    }

    @Nullable
    public <T extends EntityInsentient> T a(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a) {
        return this.convertTo(entitytypes, conversionparams, conversionparams_a, EntityTransformEvent.TransformReason.UNKNOWN, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Nullable
    public <T extends EntityInsentient> T convertTo(EntityTypes<T> entitytypes, ConversionParams conversionparams, ConversionParams.a<T> conversionparams_a, EntityTransformEvent.TransformReason transformReason, CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.convertTo(entitytypes, conversionparams, EntitySpawnReason.i, conversionparams_a, transformReason, spawnReason);
    }

    @Override
    @Nullable
    public Leashable.a T_() {
        return this.cy;
    }

    private void gD() {
        if (this.cy != null) {
            this.cy.d = 0.0;
        }
    }

    @Override
    public void a(@Nullable Leashable.a leashable_a) {
        this.cy = leashable_a;
    }

    @Override
    public void y() {
        if (this.T_() == null) {
            this.gu();
        }
    }

    @Override
    public void C() {
        Leashable.super.C();
        this.ch.a(PathfinderGoal.Type.a);
    }

    @Override
    public boolean v() {
        return !(this instanceof IMonster);
    }

    @Override
    public boolean a(Entity entity, boolean flag) {
        boolean flag1 = super.a(entity, flag);
        if (flag1 && this.R_()) {
            this.ai().getCraftServer().getPluginManager().callEvent((Event)new EntityUnleashEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), EntityUnleashEvent.UnleashReason.UNKNOWN));
            this.S_();
        }
        return flag1;
    }

    @Override
    public boolean dl() {
        return super.dl() && !this.gw();
    }

    public void u(boolean flag) {
        byte b0 = this.ay.a(a);
        this.ay.a(a, flag ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE));
    }

    public void v(boolean flag) {
        byte b0 = this.ay.a(a);
        this.ay.a(a, flag ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD));
    }

    public void w(boolean flag) {
        byte b0 = this.ay.a(a);
        this.ay.a(a, flag ? (byte)(b0 | 4) : (byte)(b0 & 0xFFFFFFFB));
    }

    public boolean gw() {
        return (this.ay.a(a) & 1) != 0;
    }

    public boolean gx() {
        return (this.ay.a(a) & 2) != 0;
    }

    public boolean gy() {
        return (this.ay.a(a) & 4) != 0;
    }

    public void a(boolean flag) {
    }

    @Override
    public EnumMainHand fF() {
        return this.gx() ? EnumMainHand.a : EnumMainHand.b;
    }

    public boolean h(EntityLiving entityliving) {
        return this.gz().c(entityliving.eS());
    }

    protected AxisAlignedBB gz() {
        AxisAlignedBB axisalignedbb;
        Entity entity = this.dm();
        if (entity != null) {
            AxisAlignedBB axisalignedbb1 = entity.cV();
            AxisAlignedBB axisalignedbb2 = this.cV();
            axisalignedbb = new AxisAlignedBB(Math.min(axisalignedbb2.a, axisalignedbb1.a), axisalignedbb2.b, Math.min(axisalignedbb2.c, axisalignedbb1.c), Math.max(axisalignedbb2.d, axisalignedbb1.d), axisalignedbb2.e, Math.max(axisalignedbb2.f, axisalignedbb1.f));
        } else {
            axisalignedbb = this.cV();
        }
        return axisalignedbb.c(ck, 0.0, ck);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        boolean flag;
        float f2 = (float)this.i(GenericAttributes.c);
        ItemStack itemstack = this.ed();
        DamageSource damagesource = Optional.ofNullable(itemstack.h().a(this)).orElse(this.ea().b(this));
        f2 = EnchantmentManager.a(worldserver, itemstack, entity, damagesource, f2);
        if (flag = entity.a(worldserver, damagesource, f2 += itemstack.h().a(entity, f2, damagesource))) {
            float f1 = this.b(entity, damagesource);
            if (f1 > 0.0f && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                entityliving.knockback(f1 * 0.5f, MathHelper.a(this.dP() * ((float)Math.PI / 180)), -MathHelper.b(this.dP() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                this.i(this.dA().d(0.6, 1.0, 0.6));
            }
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving1 = (EntityLiving)entity;
                itemstack.a(entityliving1, (EntityLiving)this);
            }
            EnchantmentManager.a(worldserver, entity, damagesource);
            this.C(entity);
            this.gA();
        }
        return flag;
    }

    protected void gA() {
    }

    protected boolean gB() {
        if (this.ai().W() && !this.ai().C) {
            boolean flag;
            float f2 = this.bB();
            BlockPosition blockposition = BlockPosition.a(this.dC(), this.dG(), this.dI());
            boolean bl = flag = this.bo() || this.aI || this.aJ;
            if (f2 > 0.5f && this.ar.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.ai().h(blockposition)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void c(TagKey<FluidType> tagkey) {
        if (this.S().p()) {
            super.c(tagkey);
        } else {
            this.i(this.dA().b(0.0, 0.3, 0.0));
        }
    }

    @VisibleForTesting
    public void gC() {
        this.c((PathfinderGoal pathfindergoal) -> true);
        this.eh().h();
    }

    public void c(Predicate<PathfinderGoal> predicate) {
        this.ch.a(predicate);
    }

    @Override
    protected void cH() {
        super.cH();
        for (EnumItemSlot enumitemslot : EnumItemSlot.j) {
            ItemStack itemstack = this.a(enumitemslot);
            if (itemstack.f()) continue;
            itemstack.e(0);
        }
    }

    @Override
    @Nullable
    public ItemStack dM() {
        ItemMonsterEgg itemmonsteregg = ItemMonsterEgg.a(this.ap());
        return itemmonsteregg == null ? null : new ItemStack(itemmonsteregg);
    }

    @Override
    protected void a(Holder<AttributeBase> holder) {
        super.a(holder);
        if (holder.a(GenericAttributes.n) || holder.a(GenericAttributes.F)) {
            this.S().f();
        }
    }
}

