/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int cn = 6000;
    private static final int ck = 0;
    public int cl = 0;
    @Nullable
    public EntityReference<EntityPlayer> cm;
    public ItemStack breedItem;

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> entitytypes, World world) {
        super((EntityTypes<? extends EntityAgeable>)entitytypes, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    public static AttributeProvider.Builder gM() {
        return EntityInsentient.I().a(GenericAttributes.F, 10.0);
    }

    @Override
    protected void a(WorldServer worldserver) {
        if (this.Z_() != 0) {
            this.cl = 0;
        }
        super.a(worldserver);
    }

    @Override
    public void e_() {
        super.e_();
        if (this.Z_() != 0) {
            this.cl = 0;
        }
        if (this.cl > 0) {
            --this.cl;
            if (this.cl % 10 == 0) {
                double d0 = this.ar.k() * 0.02;
                double d1 = this.ar.k() * 0.02;
                double d2 = this.ar.k() * 0.02;
                this.ai().a(Particles.S, this.d(1.0), this.dF() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f2, event);
        if (!damageResult) {
            return false;
        }
        this.gS();
        return true;
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.i) ? 10.0f : iworldreader.y(blockposition);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("InLove", this.cl);
        EntityReference.a(this.cm, valueoutput, "LoveCause");
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cl = valueinput.a("InLove", 0);
        this.cm = EntityReference.a(valueinput, "LoveCause");
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        boolean flag = EntitySpawnReason.b(entityspawnreason) || EntityAnimal.a(generatoraccess, blockposition);
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cb) && flag;
    }

    protected static boolean a(IBlockLightAccess iblocklightaccess, BlockPosition blockposition) {
        return iblocklightaccess.b(blockposition, 0) > 8;
    }

    @Override
    public int W() {
        return 120;
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    protected int e(WorldServer worldserver) {
        return 1 + this.ar.a(3);
    }

    public abstract boolean i(ItemStack var1);

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (this.i(itemstack)) {
            int i2 = this.Z_();
            if (entityhuman instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityhuman;
                if (i2 == 0 && this.gO()) {
                    this.a(entityhuman, enumhand, itemstack);
                    this.h(entityplayer);
                    this.gN();
                    return EnumInteractionResult.b;
                }
            }
            if (this.g_()) {
                this.a(entityhuman, enumhand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                this.gN();
                return EnumInteractionResult.a;
            }
            if (this.ai().C) {
                return EnumInteractionResult.c;
            }
        }
        return super.b(entityhuman, enumhand);
    }

    protected void gN() {
    }

    protected void a(EntityHuman entityhuman, EnumHand enumhand, ItemStack itemstack) {
        int i2 = itemstack.M();
        UseRemainder useremainder = itemstack.a(DataComponents.x);
        itemstack.a(1, (EntityLiving)entityhuman);
        if (useremainder != null) {
            boolean flag = entityhuman.gc();
            Objects.requireNonNull(entityhuman);
            ItemStack itemstack1 = useremainder.a(itemstack, i2, flag, entityhuman::b);
            entityhuman.a(enumhand, itemstack1);
        }
    }

    public boolean gO() {
        return this.cl <= 0;
    }

    public void h(@Nullable EntityHuman entityhuman) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(entityhuman, this, 600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.cl = entityEnterLoveModeEvent.getTicksInLove();
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityhuman;
            this.cm = new EntityReference<EntityPlayer>(entityplayer);
        }
        this.breedItem = entityhuman.gs().g();
        this.ai().a((Entity)this, (byte)18);
    }

    public void r(int i2) {
        this.cl = i2;
    }

    public int gP() {
        return this.cl;
    }

    @Nullable
    public EntityPlayer gQ() {
        EntityReference<EntityPlayer> entityreference = this.cm;
        World world = this.ai();
        Objects.requireNonNull(world);
        return EntityReference.a(entityreference, (UUID uuid) -> (EntityPlayer)world.a(uuid), EntityPlayer.class);
    }

    public boolean gR() {
        return this.cl > 0;
    }

    public void gS() {
        this.cl = 0;
    }

    public boolean a(EntityAnimal entityanimal) {
        return entityanimal == this ? false : (entityanimal.getClass() != this.getClass() ? false : this.gR() && entityanimal.gR());
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal) {
        EntityAgeable entityageable = this.a(worldserver, (EntityAgeable)entityanimal);
        if (entityageable != null) {
            entityageable.a(true);
            entityageable.b(this.dC(), this.dE(), this.dI(), 0.0f, 0.0f);
            EntityPlayer breeder = Optional.ofNullable(this.gQ()).or(() -> Optional.ofNullable(entityanimal.gQ())).orElse(null);
            int experience = this.ec().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, entityanimal, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, experience);
            worldserver.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable) {
        this.finalizeSpawnChildFromBreeding(worldserver, entityanimal, entityageable, this.ec().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        Optional.ofNullable(this.gQ()).or(() -> Optional.ofNullable(entityanimal.gQ())).ifPresent(entityplayer -> {
            entityplayer.a(StatisticList.Q);
            CriterionTriggers.p.a((EntityPlayer)entityplayer, this, entityanimal, entityageable);
        });
        this.c_(6000);
        entityanimal.c_(6000);
        this.gS();
        entityanimal.gS();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.P().c(GameRules.g) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dC(), this.dE(), this.dI(), experience));
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ar.k() * 0.02;
                double d1 = this.ar.k() * 0.02;
                double d2 = this.ar.k() * 0.02;
                this.ai().a(Particles.S, this.d(1.0), this.dF() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(b0);
        }
    }
}

