/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.animal.AbstractCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityMushroomCow
extends AbstractCow
implements IShearable {
    private static final DataWatcherObject<Integer> ck = DataWatcher.a(EntityMushroomCow.class, DataWatcherRegistry.b);
    private static final int cl = 1024;
    private static final String cm = "stew_effects";
    @Nullable
    public SuspiciousStewEffects co;
    @Nullable
    private UUID cp;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> entitytypes, World world) {
        super((EntityTypes<? extends AbstractCow>)entitytypes, world);
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return iworldreader.a_(blockposition.e()).a(Blocks.fE) ? 10.0f : iworldreader.y(blockposition);
    }

    public static boolean c(EntityTypes<EntityMushroomCow> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cf) && EntityMushroomCow.a(generatoraccess, blockposition);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        UUID uuid = entitylightning.cK();
        if (!uuid.equals(this.cp)) {
            this.a(this.n() == Type.a ? Type.b : Type.a);
            this.cp = uuid;
            this.a(SoundEffects.pY, 2.0f, 1.0f);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ck, Type.c.h);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.py) && !this.g_()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.co != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.xA);
                itemstack1.b(DataComponents.T, this.co);
                this.co = null;
            } else {
                itemstack1 = new ItemStack(Items.qw);
            }
            ItemStack itemstack2 = ItemLiquidUtil.a(itemstack, entityhuman, itemstack1, false);
            entityhuman.a(enumhand, itemstack2);
            SoundEffect soundeffect = flag ? SoundEffects.qb : SoundEffects.qa;
            this.a(soundeffect, 1.0f, 1.0f);
            return EnumInteractionResult.a;
        }
        if (itemstack.a(Items.tu) && this.a()) {
            World world = this.ai();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                    return EnumInteractionResult.e;
                }
                this.a(worldserver, SoundCategory.h, itemstack);
                this.a(GameEvent.M, (Entity)entityhuman);
                itemstack.a(1, (EntityLiving)entityhuman, EntityMushroomCow.d(enumhand));
            }
            return EnumInteractionResult.a;
        }
        if (this.n() == Type.b) {
            Optional<SuspiciousStewEffects> optional = this.j(itemstack);
            if (optional.isEmpty()) {
                return super.b(entityhuman, enumhand);
            }
            if (this.co != null) {
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.ai().a(Particles.ah, this.dC() + this.ar.j() / 2.0, this.e(0.5), this.dI() + this.ar.j() / 2.0, 0.0, this.ar.j() / 5.0, 0.0);
                }
            } else {
                itemstack.a(1, (EntityLiving)entityhuman);
                for (int j2 = 0; j2 < 4; ++j2) {
                    this.ai().a(Particles.p, this.dC() + this.ar.j() / 2.0, this.e(0.5), this.dI() + this.ar.j() / 2.0, 0.0, this.ar.j() / 5.0, 0.0);
                }
                this.co = optional.get();
                this.a(SoundEffects.pZ, 2.0f, 1.0f);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    public void a(WorldServer worldserver, SoundCategory soundcategory, ItemStack itemstack) {
        worldserver.a((Entity)null, this, SoundEffects.qc, soundcategory, 1.0f, 1.0f);
        this.convertTo(EntityTypes.D, ConversionParams.a(this, false, false), entitycow -> {
            worldserver.a(Particles.w, this.dC(), this.e(0.5), this.dI(), 1, 0.0, 0.0, 0.0, 0.0);
            this.a(worldserver, LootTables.aR, itemstack, (WorldServer worldserver1, ItemStack itemstack1) -> {
                for (int i2 = 0; i2 < itemstack1.M(); ++i2) {
                    EntityItem entityitem = new EntityItem(this.ai(), this.dC(), this.e(1.0), this.dI(), itemstack1.c(1));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) continue;
                    worldserver1.b(entityitem);
                }
            });
        }, EntityTransformEvent.TransformReason.SHEARED, CreatureSpawnEvent.SpawnReason.SHEARED);
    }

    @Override
    public boolean a() {
        return this.bO() && !this.g_();
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Type", Type.d, this.n());
        valueoutput.b(cm, SuspiciousStewEffects.c, this.co);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Type", Type.d).orElse(Type.c));
        this.co = valueinput.a(cm, SuspiciousStewEffects.c).orElse(null);
    }

    private Optional<SuspiciousStewEffects> j(ItemStack itemstack) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.a(itemstack.h());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.c()) : Optional.empty();
    }

    public void a(Type entitymushroomcow_type) {
        this.ay.a(ck, entitymushroomcow_type.h);
    }

    public Type n() {
        return Type.a(this.ay.a(ck));
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aF ? EntityMushroomCow.c(datacomponenttype, this.n()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aF);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aF) {
            this.a(EntityMushroomCow.c(DataComponents.aF, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Nullable
    public EntityMushroomCow b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityMushroomCow entitymushroomcow = EntityTypes.aG.a(worldserver, EntitySpawnReason.e);
        if (entitymushroomcow != null) {
            entitymushroomcow.a(this.a((EntityMushroomCow)entityageable));
        }
        return entitymushroomcow;
    }

    private Type a(EntityMushroomCow entitymushroomcow) {
        Type entitymushroomcow_type1;
        Type entitymushroomcow_type = this.n();
        Type entitymushroomcow_type2 = entitymushroomcow_type == (entitymushroomcow_type1 = entitymushroomcow.n()) && this.ar.a(1024) == 0 ? (entitymushroomcow_type == Type.b ? Type.a : Type.b) : (this.ar.h() ? entitymushroomcow_type : entitymushroomcow_type1);
        return entitymushroomcow_type2;
    }

    public static enum Type implements INamable
    {
        a("red", 0, Blocks.cq.m()),
        b("brown", 1, Blocks.cp.m());

        public static final Type c;
        public static final Codec<Type> d;
        private static final IntFunction<Type> f;
        public static final StreamCodec<ByteBuf, Type> e;
        private final String g;
        final int h;
        private final IBlockData i;

        private Type(String s2, int i2, IBlockData iblockdata) {
            this.g = s2;
            this.h = i2;
            this.i = iblockdata;
        }

        public IBlockData a() {
            return this.i;
        }

        @Override
        public String c() {
            return this.g;
        }

        private int b() {
            return this.h;
        }

        static Type a(int i2) {
            return f.apply(i2);
        }

        static {
            c = a;
            d = INamable.a(Type::values);
            f = ByIdMap.a(Type::b, Type.values(), ByIdMap.a.c);
            e = ByteBufCodecs.a(f, Type::b);
        }
    }
}

