/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityParrot
extends EntityPerchable
implements EntityBird {
    private static final DataWatcherObject<Integer> cs = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> ct = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && cu.containsKey(entityinsentient.ap());
        }
    };
    static final Map<EntityTypes<?>, SoundEffect> cu = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.p, SoundEffects.tW);
        hashmap.put(EntityTypes.r, SoundEffects.tX);
        hashmap.put(EntityTypes.s, SoundEffects.tY);
        hashmap.put(EntityTypes.w, SoundEffects.uv);
        hashmap.put(EntityTypes.E, SoundEffects.tZ);
        hashmap.put(EntityTypes.F, SoundEffects.ua);
        hashmap.put(EntityTypes.L, SoundEffects.ub);
        hashmap.put(EntityTypes.N, SoundEffects.uc);
        hashmap.put(EntityTypes.Q, SoundEffects.ud);
        hashmap.put(EntityTypes.P, SoundEffects.ue);
        hashmap.put(EntityTypes.T, SoundEffects.uf);
        hashmap.put(EntityTypes.ae, SoundEffects.ug);
        hashmap.put(EntityTypes.af, SoundEffects.sj);
        hashmap.put(EntityTypes.ak, SoundEffects.uh);
        hashmap.put(EntityTypes.al, SoundEffects.ui);
        hashmap.put(EntityTypes.ao, SoundEffects.uj);
        hashmap.put(EntityTypes.ap, SoundEffects.uk);
        hashmap.put(EntityTypes.aB, SoundEffects.ul);
        hashmap.put(EntityTypes.aR, SoundEffects.um);
        hashmap.put(EntityTypes.aT, SoundEffects.un);
        hashmap.put(EntityTypes.aU, SoundEffects.uo);
        hashmap.put(EntityTypes.aV, SoundEffects.up);
        hashmap.put(EntityTypes.bb, SoundEffects.uq);
        hashmap.put(EntityTypes.be, SoundEffects.ur);
        hashmap.put(EntityTypes.bg, SoundEffects.us);
        hashmap.put(EntityTypes.bh, SoundEffects.ut);
        hashmap.put(EntityTypes.bj, SoundEffects.uu);
        hashmap.put(EntityTypes.bq, SoundEffects.uv);
        hashmap.put(EntityTypes.bu, SoundEffects.uw);
        hashmap.put(EntityTypes.bE, SoundEffects.ux);
        hashmap.put(EntityTypes.bG, SoundEffects.uy);
        hashmap.put(EntityTypes.bI, SoundEffects.uz);
        hashmap.put(EntityTypes.bK, SoundEffects.uA);
        hashmap.put(EntityTypes.bL, SoundEffects.uB);
        hashmap.put(EntityTypes.bM, SoundEffects.uC);
        hashmap.put(EntityTypes.bP, SoundEffects.uD);
        hashmap.put(EntityTypes.bQ, SoundEffects.uE);
        hashmap.put(EntityTypes.bS, SoundEffects.uF);
    });
    public float co;
    public float cp;
    public float cq;
    public float cr;
    private float cv = 1.0f;
    private float cw = 1.0f;
    private boolean cx;
    @Nullable
    private BlockPosition cy;

    public EntityParrot(EntityTypes<? extends EntityParrot> entitytypes, World world) {
        super((EntityTypes<? extends EntityPerchable>)entitytypes, world);
        this.ce = new ControllerMoveFlying(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.a(SystemUtils.a(Variant.values(), worldaccess.H_()));
        if (groupdataentity == null) {
            groupdataentity = new EntityAgeable.a(false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean g_() {
        return false;
    }

    @Override
    protected void H() {
        this.ch.a(0, new EntityTameableAnimal.a(1.25));
        this.ch.a(0, new PathfinderGoalFloat(this));
        this.ch.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.ch.a(2, new PathfinderGoalSit(this));
        this.ch.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f));
        this.ch.a(2, new a(this, 1.0));
        this.ch.a(3, new PathfinderGoalPerch(this));
        this.ch.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gT() {
        return EntityAnimal.gM().a(GenericAttributes.t, 6.0).a(GenericAttributes.m, 0.4f).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.d(false);
        navigationflying.a(true);
        return navigationflying;
    }

    @Override
    public void e_() {
        if (this.cy == null || !this.cy.a(this.dv(), 3.46) || !this.ai().a_(this.cy).a(Blocks.ek)) {
            this.cx = false;
            this.cy = null;
        }
        if (this.ai().A.a(400) == 0) {
            EntityParrot.a(this.ai(), this);
        }
        super.e_();
        this.gY();
    }

    @Override
    public void a(BlockPosition blockposition, boolean flag) {
        this.cy = blockposition;
        this.cx = flag;
    }

    public boolean gU() {
        return this.cx;
    }

    private void gY() {
        this.cr = this.co;
        this.cq = this.cp;
        this.cp += (float)(!this.aK() && !this.cc() ? 4 : -1) * 0.3f;
        this.cp = MathHelper.a(this.cp, 0.0f, 1.0f);
        if (!this.aK() && this.cv < 1.0f) {
            this.cv = 1.0f;
        }
        this.cv *= 0.9f;
        Vec3D vec3d = this.dA();
        if (!this.aK() && vec3d.e < 0.0) {
            this.i(vec3d.d(1.0, 0.6, 1.0));
        }
        this.co += this.cv * 2.0f;
    }

    public static boolean a(World world, Entity entity) {
        if (entity.bO() && !entity.be() && world.A.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, entity.cV().g(20.0), ct);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.A.a(list.size()))).be()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.ap());
                world.a((Entity)null, entity.dC(), entity.dE(), entity.dI(), soundeffect, entity.do(), 0.7f, EntityParrot.a(world.A));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!this.m() && itemstack.a(TagsItem.aV)) {
            this.a(entityhuman, enumhand, itemstack);
            if (!this.be()) {
                this.ai().a((Entity)null, this.dC(), this.dE(), this.dI(), SoundEffects.tT, this.do(), 1.0f, 1.0f + (this.ar.i() - this.ar.i()) * 0.2f);
            }
            if (!this.ai().C) {
                if (this.ar.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
                    this.g(entityhuman);
                    this.ai().a((Entity)this, (byte)7);
                } else {
                    this.ai().a((Entity)this, (byte)6);
                }
            }
            return EnumInteractionResult.a;
        }
        if (!itemstack.a(TagsItem.aW)) {
            if (!this.gW() && this.m() && this.j(entityhuman)) {
                if (!this.ai().C) {
                    this.z(!this.gH());
                }
                return EnumInteractionResult.a;
            }
            return super.b(entityhuman, enumhand);
        }
        this.a(entityhuman, enumhand, itemstack);
        this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
        if (entityhuman.gI() || !this.cG()) {
            this.a(this.ea().a(entityhuman), Float.MAX_VALUE);
        }
        return EnumInteractionResult.a;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return false;
    }

    public static boolean c(EntityTypes<EntityParrot> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.cg) && EntityParrot.a(generatoraccess, blockposition);
    }

    @Override
    protected void a(double d0, boolean flag, IBlockData iblockdata, BlockPosition blockposition) {
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer worldserver, EntityAgeable entityageable) {
        return null;
    }

    @Override
    @Nullable
    public SoundEffect p() {
        return EntityParrot.a(this.ai(), this.ai().A);
    }

    public static SoundEffect a(World world, RandomSource randomsource) {
        if (world.an() != EnumDifficulty.a && randomsource.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(cu.keySet());
            return EntityParrot.b((EntityTypes)list.get(randomsource.a(list.size())));
        }
        return SoundEffects.tR;
    }

    private static SoundEffect b(EntityTypes<?> entitytypes) {
        return cu.getOrDefault(entitytypes, SoundEffects.tR);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.tV;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.tS;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.uG, 0.15f, 1.0f);
    }

    @Override
    protected boolean bd() {
        return this.al > this.cw;
    }

    @Override
    protected void bc() {
        this.a(SoundEffects.tU, 0.15f, 1.0f);
        this.cw = this.al + this.cp / 2.0f;
    }

    @Override
    public float fl() {
        return EntityParrot.a(this.ar);
    }

    public static float a(RandomSource randomsource) {
        return (randomsource.i() - randomsource.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory do() {
        return SoundCategory.g;
    }

    @Override
    public boolean bL() {
        return super.bL();
    }

    @Override
    protected void E(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.E(entity);
        }
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    public Variant gV() {
        return Variant.a(this.ay.a(cs));
    }

    public void a(Variant entityparrot_variant) {
        this.ay.a(cs, entityparrot_variant.k);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aB ? EntityParrot.c(datacomponenttype, this.gV()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aB);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aB) {
            this.a(EntityParrot.c(DataComponents.aB, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cs, Variant.f.k);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Variant", Variant.h, this.gV());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.a(valueinput.a("Variant", Variant.h).orElse(Variant.f));
    }

    @Override
    public boolean gW() {
        return !this.aK();
    }

    @Override
    protected boolean gL() {
        return true;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.5f * this.cW(), this.ds() * 0.4f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Variant f;
        private static final IntFunction<Variant> j;
        public static final Codec<Variant> g;
        @Deprecated
        public static final Codec<Variant> h;
        public static final StreamCodec<ByteBuf, Variant> i;
        final int k;
        private final String l;

        private Variant(int i2, String s2) {
            this.k = i2;
            this.l = s2;
        }

        public int a() {
            return this.k;
        }

        public static Variant a(int i2) {
            return j.apply(i2);
        }

        @Override
        public String c() {
            return this.l;
        }

        static {
            f = a;
            j = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
            g = INamable.a(Variant::values);
            PrimitiveCodec primitivecodec = Codec.INT;
            IntFunction<Variant> intfunction = j;
            Objects.requireNonNull(intfunction);
            h = primitivecodec.xmap(intfunction::apply, Variant::a);
            i = ByteBufCodecs.a(j, Variant::a);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature entitycreature, double d0) {
            super(entitycreature, d0);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.bm()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.ec().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dx();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockposition1 : BlockPosition.b(MathHelper.a(this.b.dC() - 3.0), MathHelper.a(this.b.dE() - 6.0), MathHelper.a(this.b.dI() - 3.0), MathHelper.a(this.b.dC() + 3.0), MathHelper.a(this.b.dE() + 6.0), MathHelper.a(this.b.dI() + 3.0))) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.ai().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.D)) || !this.b.ai().w(blockposition1) || !this.b.ai().w(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

