/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> ck = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float cl = 6.0f;
    private float cm;
    private float co;
    private int cp;
    private static final UniformInt cq = TimeRange.a(20, 39);
    private int cr;
    @Nullable
    private UUID cs;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.aW.a(var0, EntitySpawnReason.e);
    }

    @Override
    public boolean i(ItemStack var0) {
        return false;
    }

    @Override
    protected void H() {
        super.H();
        this.ch.a(0, new PathfinderGoalFloat(this));
        this.ch.a(1, new c());
        this.ch.a(1, new PathfinderGoalPanic((EntityCreature)this, 2.0, var0 -> var0.g_() ? DamageTypeTags.F : DamageTypeTags.G));
        this.ch.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.ch.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.ch.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.ch.a(7, new PathfinderGoalRandomLookaround(this));
        this.ci.a(1, new b());
        this.ci.a(2, new a());
        this.ci.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ci.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.ci.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder m() {
        return EntityAnimal.gM().a(GenericAttributes.t, 30.0).a(GenericAttributes.n, 20.0).a(GenericAttributes.w, 0.25).a(GenericAttributes.c, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        Holder<BiomeBase> var5 = var1.v(var3);
        if (var5.a(BiomeTags.aq)) {
            return EntityPolarBear.a(var1, var3) && var1.a_(var3.e()).a(TagsBlock.ch);
        }
        return EntityPolarBear.b(var0, var1, var2, var3, var4);
    }

    @Override
    protected void a(ValueInput var0) {
        super.a(var0);
        this.a(this.ai(), var0);
    }

    @Override
    protected void a(ValueOutput var0) {
        super.a(var0);
        this.a_(var0);
    }

    @Override
    public void c() {
        this.a(cq.a(this.ar));
    }

    @Override
    public void a(int var0) {
        this.cr = var0;
    }

    @Override
    public int a() {
        return this.cr;
    }

    @Override
    public void a(@Nullable UUID var0) {
        this.cs = var0;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cs;
    }

    @Override
    protected SoundEffect p() {
        if (this.g_()) {
            return SoundEffects.vK;
        }
        return SoundEffects.vJ;
    }

    @Override
    protected SoundEffect e(DamageSource var0) {
        return SoundEffects.vM;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.vL;
    }

    @Override
    protected void b(BlockPosition var0, IBlockData var1) {
        this.a(SoundEffects.vN, 0.15f, 1.0f);
    }

    protected void n() {
        if (this.cp <= 0) {
            this.b(SoundEffects.vO);
            this.cp = 40;
        }
    }

    @Override
    protected void a(DataWatcher.a var0) {
        super.a(var0);
        var0.a(ck, false);
    }

    @Override
    public void g() {
        super.g();
        if (this.ai().C) {
            if (this.co != this.cm) {
                this.j_();
            }
            this.cm = this.co;
            this.co = this.t() ? MathHelper.a(this.co + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.co - 1.0f, 0.0f, 6.0f);
        }
        if (this.cp > 0) {
            --this.cp;
        }
        if (!this.ai().C) {
            this.a((WorldServer)this.ai(), true);
        }
    }

    @Override
    public EntitySize e(EntityPose var0) {
        if (this.co > 0.0f) {
            float var1 = this.co / 6.0f;
            float var2 = 1.0f + var1;
            return super.e(var0).a(1.0f, var2);
        }
        return super.e(var0);
    }

    public boolean t() {
        return this.ay.a(ck);
    }

    public void x(boolean var0) {
        this.ay.a(ck, var0);
    }

    public float J(float var0) {
        return MathHelper.h(var0, this.cm, this.co) / 6.0f;
    }

    @Override
    protected float fq() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity a(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        if (var3 == null) {
            var3 = new EntityAgeable.a(1.0f);
        }
        return super.a(var0, var1, var2, var3);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void a(EntityLiving var0) {
            if (this.b(var0)) {
                this.h();
                this.a.c(net.minecraft.world.entity.animal.EntityPolarBear$c.a(this.a), (Entity)var0);
                EntityPolarBear.this.x(false);
            } else if (this.a.g((Entity)var0) < (double)((var0.ds() + 3.0f) * (var0.ds() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.x(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.x(true);
                    EntityPolarBear.this.n();
                }
            } else {
                this.h();
                EntityPolarBear.this.x(false);
            }
        }

        @Override
        public void e() {
            EntityPolarBear.this.x(false);
            super.e();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void d() {
            super.d();
            if (EntityPolarBear.this.g_()) {
                this.h();
                this.e();
            }
        }

        @Override
        protected void a(EntityInsentient var0, EntityLiving var1) {
            if (var0 instanceof EntityPolarBear && !var0.g_()) {
                super.a(var0, var1);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean b() {
            if (EntityPolarBear.this.g_()) {
                return false;
            }
            if (super.b()) {
                List<EntityPolarBear> var0 = EntityPolarBear.this.ai().a(EntityPolarBear.class, EntityPolarBear.this.cV().c(8.0, 4.0, 8.0));
                for (EntityPolarBear var2 : var0) {
                    if (!var2.g_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

