/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> a = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte b = 16;
    private static final boolean c = true;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> entitytypes, World world) {
        super((EntityTypes<? extends EntityGolem>)entitytypes, world);
    }

    @Override
    protected void H() {
        this.ch.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.ch.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.ch.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.ch.a(4, new PathfinderGoalRandomLookaround(this));
        this.ci.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, (entityliving, worldserver) -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder l() {
        return EntityInsentient.I().a(GenericAttributes.t, 4.0).a(GenericAttributes.w, 0.2f);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, (byte)16);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("Pumpkin", this.m());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("Pumpkin", true));
    }

    @Override
    public boolean fx() {
        return true;
    }

    @Override
    public void e_() {
        super.e_();
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.ai().v(this.dx()).a(BiomeTags.ae)) {
                this.a(worldserver, this.ea().melting(), 1.0f);
            }
            if (!worldserver.P().c(GameRules.d)) {
                return;
            }
            IBlockData iblockdata = Blocks.ed.m();
            for (int i2 = 0; i2 < 4; ++i2) {
                int j2 = MathHelper.a(this.dC() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.a(this.dE());
                int l2 = MathHelper.a(this.dI() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (!this.ai().a_(blockposition).l() || !iblockdata.a((IWorldReader)this.ai(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.ai(), blockposition, iblockdata, this)) continue;
                this.ai().a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
            }
        }
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        double d0 = entityliving.dC() - this.dC();
        double d1 = entityliving.dG() - (double)1.1f;
        double d2 = entityliving.dI() - this.dI();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ItemStack itemstack = new ItemStack(Items.rJ);
            IProjectile.a(new EntitySnowball(worldserver, this, itemstack), worldserver, itemstack, entitysnowball -> entitysnowball.c(d0, d1 + d3 - entitysnowball.dE(), d2, 1.6f, 12.0f));
        }
        this.a(SoundEffects.Ai, 1.0f, 0.4f / (this.ec().i() * 0.4f + 0.8f));
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.tu) && this.a()) {
            World world = this.ai();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (!CraftEventFactory.handlePlayerShearEntityEvent(entityhuman, this, itemstack, enumhand)) {
                    return EnumInteractionResult.e;
                }
                this.a(worldserver, SoundCategory.h, itemstack);
                this.a(GameEvent.M, (Entity)entityhuman);
                itemstack.a(1, (EntityLiving)entityhuman, EntitySnowman.d(enumhand));
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void a(WorldServer worldserver, SoundCategory soundcategory, ItemStack itemstack) {
        worldserver.a((Entity)null, this, SoundEffects.Aj, soundcategory, 1.0f, 1.0f);
        this.x(false);
        this.a(worldserver, LootTables.aU, itemstack, (WorldServer worldserver1, ItemStack itemstack1) -> {
            this.forceDrops = true;
            this.a((WorldServer)worldserver1, (ItemStack)itemstack1, this.cW());
            this.forceDrops = false;
        });
    }

    @Override
    public boolean a() {
        return this.bO() && this.m();
    }

    public boolean m() {
        return (this.ay.a(a) & 0x10) != 0;
    }

    public void x(boolean flag) {
        byte b0 = this.ay.a(a);
        if (flag) {
            this.ay.a(a, (byte)(b0 | 0x10));
        } else {
            this.ay.a(a, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return SoundEffects.Af;
    }

    @Override
    @Nullable
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Ah;
    }

    @Override
    @Nullable
    protected SoundEffect f_() {
        return SoundEffects.Ag;
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.75f * this.cW(), this.ds() * 0.4f);
    }
}

