/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize ck = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int cr = 2;
    private static final int cs = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> cl = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.o, SensorType.f, SensorType.s);
    protected static final ImmutableList<MemoryModuleType<?>> cm = ImmutableList.of(MemoryModuleType.o, MemoryModuleType.h, MemoryModuleType.n, MemoryModuleType.F, MemoryModuleType.u, MemoryModuleType.aw, MemoryModuleType.s, MemoryModuleType.T, MemoryModuleType.U, MemoryModuleType.P, MemoryModuleType.L, MemoryModuleType.Q, (Object[])new MemoryModuleType[]{MemoryModuleType.S, MemoryModuleType.W, MemoryModuleType.X, MemoryModuleType.aa});
    public static final int co = 10;
    public static final double cp = 0.02;
    public static final double cq = (double)0.1f;
    private static final DataWatcherObject<Boolean> ct = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cu = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cv = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private static final boolean cw = false;
    private static final boolean cx = true;
    private static final boolean cy = true;
    private boolean cz;
    private int cA;

    public Goat(EntityTypes<? extends Goat> entitytypes, World world) {
        super((EntityTypes<? extends EntityAnimal>)entitytypes, world);
        this.S().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack m() {
        RandomSource randomsource = RandomSource.a(this.cK().hashCode());
        TagKey<Instrument> tagkey = this.gT() ? InstrumentTags.b : InstrumentTags.a;
        return this.ai().K_().f(Registries.aZ).a(tagkey, randomsource).map(holder -> InstrumentItem.a(Items.xM, holder)).orElseGet(() -> new ItemStack(Items.xM));
    }

    protected BehaviorController.b<Goat> ei() {
        return BehaviorController.a(cm, cl);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.ei().a(dynamic));
    }

    public static AttributeProvider.Builder n() {
        return EntityAnimal.gM().a(GenericAttributes.t, 10.0).a(GenericAttributes.w, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void h() {
        if (this.g_()) {
            this.h(GenericAttributes.c).a(1.0);
            this.gL();
        } else {
            this.h(GenericAttributes.c).a(2.0);
            this.gK();
        }
    }

    @Override
    protected int a(double d0, float f2) {
        return super.a(d0, f2) - 10;
    }

    @Override
    protected SoundEffect p() {
        return this.gT() ? SoundEffects.lK : SoundEffects.lB;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.gT() ? SoundEffects.lN : SoundEffects.lE;
    }

    @Override
    protected SoundEffect f_() {
        return this.gT() ? SoundEffects.lL : SoundEffects.lC;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.lS, 0.15f, 1.0f);
    }

    protected SoundEffect t() {
        return this.gT() ? SoundEffects.lP : SoundEffects.lG;
    }

    @Nullable
    public Goat b(WorldServer worldserver, EntityAgeable entityageable) {
        Goat goat = EntityTypes.aj.a(worldserver, EntitySpawnReason.e);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, worldserver.H_());
            EntityAgeable entityageable1 = worldserver.H_().h() ? this : entityageable;
            boolean flag = entityageable1 instanceof Goat && ((Goat)(goat1 = entityageable1)).gT() || !(worldserver.H_().j() >= 0.02);
            boolean flag1 = flag;
            goat.x(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> eh() {
        return super.eh();
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("goatBrain");
        this.eh().a(worldserver, this);
        gameprofilerfiller.c();
        gameprofilerfiller.a("goatActivityUpdate");
        GoatAi.a(this);
        gameprofilerfiller.c();
        super.a(worldserver);
    }

    @Override
    public int gh() {
        return 15;
    }

    @Override
    public void r(float f2) {
        int i2 = this.gh();
        float f1 = MathHelper.c(this.br, f2);
        float f22 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.r(this.br + f22);
    }

    @Override
    protected void gN() {
        this.ai().a((Entity)null, this, this.gT() ? SoundEffects.lM : SoundEffects.lD, SoundCategory.g, 1.0f, MathHelper.b(this.ai().A, 0.8f, 1.2f));
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.ax);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.rF) && !this.g_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)entityhuman.ai(), entityhuman, this.dx(), this.dx(), null, itemstack, Items.rL, enumhand);
            if (event.isCancelled()) {
                return EnumInteractionResult.e;
            }
            entityhuman.a(this.t(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, entityhuman, CraftItemStack.asNMSCopy(event.getItemStack()));
            entityhuman.a(enumhand, itemstack1);
            return EnumInteractionResult.a;
        }
        EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
        if (enuminteractionresult.a() && this.i(itemstack)) {
            this.gN();
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        RandomSource randomsource = worldaccess.H_();
        GoatAi.a(this, randomsource);
        this.x(randomsource.j() < 0.02);
        this.h();
        if (!this.g_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cu : cv;
            this.ay.a(datawatcherobject, false);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected void ah() {
        super.ah();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return entitypose == EntityPose.g ? ck.a(this.ep()) : super.e(entitypose);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("IsScreamingGoat", this.gT());
        valueoutput.a("HasLeftHorn", this.gH());
        valueoutput.a("HasRightHorn", this.gI());
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.x(valueinput.a("IsScreamingGoat", false));
        this.ay.a(cu, valueinput.a("HasLeftHorn", true));
        this.ay.a(cv, valueinput.a("HasRightHorn", true));
    }

    @Override
    public void b(byte b0) {
        if (b0 == 58) {
            this.cz = true;
        } else if (b0 == 59) {
            this.cz = false;
        } else {
            super.b(b0);
        }
    }

    @Override
    public void e_() {
        this.cA = this.cz ? ++this.cA : (this.cA -= 2);
        this.cA = MathHelper.a(this.cA, 0, 20);
        super.e_();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(ct, false);
        datawatcher_a.a(cu, true);
        datawatcher_a.a(cv, true);
    }

    public boolean gH() {
        return this.ay.a(cu);
    }

    public boolean gI() {
        return this.ay.a(cv);
    }

    public boolean gJ() {
        boolean flag = this.gH();
        boolean flag1 = this.gI();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? cv : (!flag1 ? cu : (this.ar.h() ? cu : cv));
        this.ay.a(datawatcherobject, false);
        Vec3D vec3d = this.dv();
        ItemStack itemstack = this.m();
        double d0 = MathHelper.b(this.ar, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ar, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.ar, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.ai(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        this.ai().b(entityitem);
        return true;
    }

    public void gK() {
        this.ay.a(cu, true);
        this.ay.a(cv, true);
    }

    public void gL() {
        this.ay.a(cu, false);
        this.ay.a(cv, false);
    }

    public boolean gT() {
        return this.ay.a(ct);
    }

    public void x(boolean flag) {
        this.ay.a(ct, flag);
    }

    public float gU() {
        return (float)this.cA / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.ce) && Goat.a(generatoraccess, blockposition);
    }
}

