/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.wolf;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> cq = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> cr = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> cs = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Holder<WolfVariant>> ct = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> cu = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.B);
    public static final PathfinderTargetCondition.a co = (entityliving, worldserver) -> {
        EntityTypes<?> entitytypes = entityliving.ap();
        return entitytypes == EntityTypes.bd || entitytypes == EntityTypes.ba || entitytypes == EntityTypes.ab;
    };
    private static final float cv = 8.0f;
    private static final float cw = 40.0f;
    private static final float cx = 0.125f;
    public static final float cp = 0.62831855f;
    private static final EnumColor cy = EnumColor.o;
    private float cz;
    private float cA;
    public boolean cB;
    private boolean cC;
    private float cD;
    private float cE;
    private static final UniformInt cF = TimeRange.a(20, 39);
    @Nullable
    private UUID cG;

    public EntityWolf(EntityTypes<? extends EntityWolf> entitytypes, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)entitytypes, world);
        this.a(false, false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void H() {
        this.ch.a(1, new PathfinderGoalFloat(this));
        this.ch.a(1, new EntityTameableAnimal.a(1.5, DamageTypeTags.G));
        this.ch.a(2, new PathfinderGoalSit(this));
        this.ch.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.ch.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.ch.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.ch.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.ch.a(7, new PathfinderGoalBreed(this, 1.0));
        this.ch.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.ch.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.ch.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.ch.a(10, new PathfinderGoalRandomLookaround(this));
        this.ci.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.ci.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.ci.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.ci.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a));
        this.ci.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, co));
        this.ci.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.ck));
        this.ci.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.ci.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public MinecraftKey gT() {
        WolfVariant wolfvariant = this.gY().a();
        return this.m() ? wolfvariant.b().b().b() : (this.ad_() ? wolfvariant.b().c().b() : wolfvariant.b().a().b());
    }

    public Holder<WolfVariant> gY() {
        return this.ay.a(ct);
    }

    public void b(Holder<WolfVariant> holder) {
        this.ay.a(ct, holder);
    }

    private Holder<WolfSoundVariant> gZ() {
        return this.ay.a(cu);
    }

    private void k(Holder<WolfSoundVariant> holder) {
        this.ay.a(cu, holder);
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.aw ? EntityWolf.c(datacomponenttype, this.gY()) : (datacomponenttype == DataComponents.ax ? EntityWolf.c(datacomponenttype, this.gZ()) : (datacomponenttype == DataComponents.ay ? EntityWolf.c(datacomponenttype, this.gW()) : super.a(datacomponenttype)));
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.aw);
        this.a(datacomponentgetter, DataComponents.ax);
        this.a(datacomponentgetter, DataComponents.ay);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.aw) {
            this.b(EntityWolf.c(DataComponents.aw, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.ax) {
            this.k(EntityWolf.c(DataComponents.ax, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.ay) {
            this.a(EntityWolf.c(DataComponents.ay, t0));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }

    public static AttributeProvider.Builder gU() {
        return EntityAnimal.gM().a(GenericAttributes.w, 0.3f).a(GenericAttributes.t, 8.0).a(GenericAttributes.c, 4.0);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        IRegistry<WolfSoundVariant> iregistry = this.eb().f(Registries.bs);
        datawatcher_a.a(ct, VariantUtils.a(this.eb(), WolfVariants.j));
        DataWatcherObject<Holder<WolfSoundVariant>> datawatcherobject = cu;
        Optional optional = iregistry.a(WolfSoundVariants.a);
        Objects.requireNonNull(iregistry);
        datawatcher_a.a(datawatcherobject, (Holder)optional.or(iregistry::a).orElseThrow());
        datawatcher_a.a(cq, false);
        datawatcher_a.a(cr, cy.a());
        datawatcher_a.a(cs, 0);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.Ep, 0.15f, 1.0f);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("CollarColor", EnumColor.s, this.gW());
        VariantUtils.a(valueoutput, this.gY());
        this.a_(valueoutput);
        this.gZ().e().ifPresent(resourcekey -> valueoutput.a("sound_variant", ResourceKey.a(Registries.bs), resourcekey));
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        VariantUtils.a(valueinput, Registries.br).ifPresent(this::b);
        this.a(valueinput.a("CollarColor", EnumColor.s).orElse(cy));
        this.a(this.ai(), valueinput);
        valueinput.a("sound_variant", ResourceKey.a(Registries.bs)).flatMap(resourcekey -> this.eb().f(Registries.bs).a((ResourceKey)resourcekey)).ifPresent(this::k);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (groupdataentity instanceof b) {
            b entitywolf_b = (b)groupdataentity;
            this.b(entitywolf_b.a);
        } else {
            Optional optional = VariantUtils.a(SpawnContext.a(worldaccess, this.dx()), Registries.br);
            if (optional.isPresent()) {
                this.b(optional.get());
                groupdataentity = new b(optional.get());
            }
        }
        this.k(WolfSoundVariants.a(this.eb(), worldaccess.H_()));
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    protected SoundEffect p() {
        return this.ad_() ? this.gZ().a().c().a() : (this.ar.a(3) == 0 ? (this.m() && this.eL() < 20.0f ? this.gZ().a().f().a() : this.gZ().a().e().a()) : this.gZ().a().a().a());
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return this.i(damagesource) ? SoundEffects.Em : this.gZ().a().d().a();
    }

    @Override
    protected SoundEffect f_() {
        return this.gZ().a().b().a();
    }

    @Override
    protected float fk() {
        return 0.4f;
    }

    @Override
    public void e_() {
        super.e_();
        if (!this.ai().C && this.cB && !this.cC && !this.gD() && this.aK()) {
            this.cC = true;
            this.cD = 0.0f;
            this.cE = 0.0f;
            this.ai().a((Entity)this, (byte)8);
        }
        if (!this.ai().C) {
            this.a((WorldServer)this.ai(), true);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.bO()) {
            this.cA = this.cz;
            this.cz = this.gX() ? (this.cz += (1.0f - this.cz) * 0.4f) : (this.cz += (0.0f - this.cz) * 0.4f);
            if (this.bo()) {
                this.cB = true;
                if (this.cC && !this.ai().C) {
                    this.ai().a((Entity)this, (byte)56);
                    this.ha();
                }
            } else if ((this.cB || this.cC) && this.cC) {
                if (this.cD == 0.0f) {
                    this.a(SoundEffects.Eo, this.fk(), (this.ar.i() - this.ar.i()) * 0.2f + 1.0f);
                    this.c(GameEvent.u);
                }
                this.cE = this.cD;
                this.cD += 0.05f;
                if (this.cE >= 2.0f) {
                    this.cB = false;
                    this.cC = false;
                    this.cE = 0.0f;
                    this.cD = 0.0f;
                }
                if (this.cD > 0.4f) {
                    float f2 = (float)this.dE();
                    int i2 = (int)(MathHelper.a((this.cD - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.dA();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.ar.i() * 2.0f - 1.0f) * this.ds() * 0.5f;
                        float f22 = (this.ar.i() * 2.0f - 1.0f) * this.ds() * 0.5f;
                        this.ai().a(Particles.ap, this.dC() + (double)f1, (double)(f2 + 0.8f), this.dI() + (double)f22, vec3d.d, vec3d.e, vec3d.f);
                    }
                }
            }
        }
    }

    private void ha() {
        this.cC = false;
        this.cD = 0.0f;
        this.cE = 0.0f;
    }

    @Override
    public void a(DamageSource damagesource) {
        this.cB = false;
        this.cC = false;
        this.cE = 0.0f;
        this.cD = 0.0f;
        super.a(damagesource);
    }

    public float J(float f2) {
        return !this.cB ? 1.0f : Math.min(0.75f + MathHelper.h(f2, this.cE, this.cD) / 2.0f * 0.25f, 1.0f);
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cE, this.cD);
    }

    public float L(float f2) {
        return MathHelper.h(f2, this.cA, this.cz) * 0.15f * (float)Math.PI;
    }

    @Override
    public int gg() {
        return this.t() ? 20 : super.gg();
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (this.a(worldserver, damagesource)) {
            return false;
        }
        boolean result = super.a(worldserver, damagesource, f2);
        if (!result) {
            return result;
        }
        this.z(false);
        return result;
    }

    @Override
    public boolean actuallyHurt(WorldServer worldserver, DamageSource damagesource, float f2, EntityDamageEvent event) {
        if (!this.i(damagesource)) {
            return super.actuallyHurt(worldserver, damagesource, f2, event);
        }
        if (event.isCancelled()) {
            return false;
        }
        ItemStack itemstack = this.gl();
        int i2 = itemstack.o();
        int j2 = itemstack.p();
        itemstack.a(MathHelper.f(f2), (EntityLiving)this, EnumItemSlot.g);
        if (Crackiness.b.a(i2, j2) != Crackiness.b.a(this.gl())) {
            this.a(SoundEffects.El);
            worldserver.a(new ParticleParamItem(Particles.U, Items.pv.m()), this.dC(), this.dE() + 1.0, this.dI(), 20, 0.2, 0.1, 0.2, 0.1);
        }
        return false;
    }

    private boolean i(DamageSource damagesource) {
        return this.gl().a(Items.pw) && !damagesource.a(DamageTypeTags.C);
    }

    @Override
    protected void n() {
        if (this.m()) {
            this.h(GenericAttributes.t).a(40.0);
            this.x(this.fa());
        } else {
            this.h(GenericAttributes.t).a(8.0);
        }
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.g);
    }

    @Override
    protected boolean a(EntityHuman entityhuman) {
        return this.j(entityhuman);
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        Item item = itemstack.h();
        if (this.m()) {
            if (this.i(itemstack) && this.eL() < this.fa()) {
                this.a(entityhuman, enumhand, itemstack);
                FoodInfo foodinfo = itemstack.a(DataComponents.v);
                float f2 = foodinfo != null ? (float)foodinfo.a() : 1.0f;
                this.heal(2.0f * f2, EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(entityhuman)) {
                    EnumColor enumcolor = itemdye.a();
                    if (enumcolor != this.gW()) {
                        this.a(enumcolor);
                        itemstack.a(1, (EntityLiving)entityhuman);
                        return EnumInteractionResult.a;
                    }
                    return super.b(entityhuman, enumhand);
                }
            }
            if (this.a(itemstack, EnumItemSlot.g) && !this.gn() && this.j(entityhuman) && !this.g_()) {
                this.h(itemstack.c(1));
                itemstack.a(1, (EntityLiving)entityhuman);
                return EnumInteractionResult.a;
            }
            if (this.t() && this.gn() && this.j(entityhuman) && this.gl().n() && this.gl().c(itemstack)) {
                itemstack.h(1);
                this.a(SoundEffects.En);
                ItemStack itemstack1 = this.gl();
                int i2 = (int)((float)itemstack1.p() * 0.125f);
                itemstack1.b(Math.max(0, itemstack1.o() - i2));
                return EnumInteractionResult.a;
            }
            EnumInteractionResult enuminteractionresult = super.b(entityhuman, enumhand);
            if (!enuminteractionresult.a() && this.j(entityhuman)) {
                this.z(!this.gH());
                this.bB = false;
                this.cg.n();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.a.b();
            }
            return enuminteractionresult;
        }
        if (!this.ai().C && itemstack.a(Items.sY) && !this.ad_()) {
            itemstack.a(1, (EntityLiving)entityhuman);
            this.i(entityhuman);
            return EnumInteractionResult.b;
        }
        return super.b(entityhuman, enumhand);
    }

    private void i(EntityHuman entityhuman) {
        if (this.ar.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, entityhuman).isCancelled()) {
            this.g(entityhuman);
            this.cg.n();
            this.g((EntityLiving)null);
            this.z(true);
            this.ai().a((Entity)this, (byte)7);
        } else {
            this.ai().a((Entity)this, (byte)6);
        }
    }

    @Override
    public void b(byte b0) {
        if (b0 == 8) {
            this.cC = true;
            this.cD = 0.0f;
            this.cE = 0.0f;
        } else if (b0 == 56) {
            this.ha();
        } else {
            super.b(b0);
        }
    }

    public float gV() {
        if (this.ad_()) {
            return 1.5393804f;
        }
        if (this.m()) {
            float f2 = this.fa();
            float f1 = (f2 - this.eL()) / f2;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean i(ItemStack itemstack) {
        return itemstack.a(TagsItem.az);
    }

    @Override
    public int gk() {
        return 8;
    }

    @Override
    public int a() {
        return this.ay.a(cs);
    }

    @Override
    public void a(int i2) {
        this.ay.a(cs, i2);
    }

    @Override
    public void c() {
        this.a(cF.a(this.ar));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cG;
    }

    @Override
    public void a(@Nullable UUID uuid) {
        this.cG = uuid;
    }

    public EnumColor gW() {
        return EnumColor.a(this.ay.a(cr));
    }

    public void a(EnumColor enumcolor) {
        this.ay.a(cr, enumcolor.a());
    }

    @Nullable
    public EntityWolf b(WorldServer worldserver, EntityAgeable entityageable) {
        EntityWolf entitywolf = EntityTypes.bO.a(worldserver, EntitySpawnReason.e);
        if (entitywolf != null && entityageable instanceof EntityWolf) {
            EntityWolf entitywolf1 = (EntityWolf)entityageable;
            if (this.ar.h()) {
                entitywolf.b(this.gY());
            } else {
                entitywolf.b(entitywolf1.gY());
            }
            if (this.m()) {
                ((EntityTameableAnimal)entitywolf).a(this.d());
                entitywolf.a(true, true);
                EnumColor enumcolor = this.gW();
                EnumColor enumcolor1 = entitywolf1.gW();
                entitywolf.a(EnumColor.a(worldserver, enumcolor, enumcolor1));
            }
            entitywolf.k(WolfSoundVariants.a(this.eb(), this.ar));
        }
        return entitywolf;
    }

    public void A(boolean flag) {
        this.ay.a(cq, flag);
    }

    @Override
    public boolean a(EntityAnimal entityanimal) {
        if (entityanimal == this) {
            return false;
        }
        if (!this.m()) {
            return false;
        }
        if (!(entityanimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)entityanimal;
        return !entitywolf.m() ? false : (entitywolf.t() ? false : this.gR() && entitywolf.gR());
    }

    public boolean gX() {
        return this.ay.a(cq);
    }

    @Override
    public boolean a(EntityLiving entityliving, EntityLiving entityliving1) {
        if (!(entityliving instanceof EntityCreeper || entityliving instanceof EntityGhast || entityliving instanceof EntityArmorStand)) {
            EntityTameableAnimal entitytameableanimal;
            EntityHorseAbstract entityhorseabstract;
            if (entityliving instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)entityliving;
                return !entitywolf.m() || entitywolf.U_() != entityliving1;
            }
            if (entityliving instanceof EntityHuman) {
                EntityHuman entityhuman1;
                EntityHuman entityhuman = (EntityHuman)entityliving;
                if (entityliving1 instanceof EntityHuman && !(entityhuman1 = (EntityHuman)entityliving1).a(entityhuman)) {
                    return false;
                }
            }
            if (entityliving instanceof EntityHorseAbstract && (entityhorseabstract = (EntityHorseAbstract)entityliving).gY()) {
                return false;
            }
            if (entityliving instanceof EntityTameableAnimal && (entitytameableanimal = (EntityTameableAnimal)entityliving).m()) {
                boolean flag = false;
                return flag;
            }
            boolean flag = true;
            return flag;
        }
        return false;
    }

    @Override
    public boolean v() {
        return !this.ad_();
    }

    @Override
    public Vec3D F() {
        return new Vec3D(0.0, 0.6f * this.cW(), this.ds() * 0.4f);
    }

    public static boolean c(EntityTypes<EntityWolf> entitytypes, GeneratorAccess generatoraccess, EntitySpawnReason entityspawnreason, BlockPosition blockposition, RandomSource randomsource) {
        return generatoraccess.a_(blockposition.e()).a(TagsBlock.ck) && EntityWolf.a(generatoraccess, blockposition);
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean b() {
            return super.b() && this.b instanceof EntityLlama ? !this.j.m() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama entityllama) {
            return entityllama.gL() >= EntityWolf.this.ar.a(5);
        }

        @Override
        public void d() {
            EntityWolf.this.g((EntityLiving)null);
            super.d();
        }

        @Override
        public void a() {
            EntityWolf.this.g((EntityLiving)null);
            super.a();
        }
    }

    public static class b
    extends EntityAgeable.a {
        public final Holder<WolfVariant> a;

        public b(Holder<WolfVariant> holder) {
            super(false);
            this.a = holder;
        }
    }
}

