/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerManager;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.IDragonController;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityEnderDragon
extends EntityInsentient
implements IMonster {
    private static final Logger cm = LogUtils.getLogger();
    public static final DataWatcherObject<Integer> a = DataWatcher.a(EntityEnderDragon.class, DataWatcherRegistry.b);
    private static final PathfinderTargetCondition cn = PathfinderTargetCondition.a().a(64.0);
    private static final int co = 200;
    private static final int cp = 400;
    private static final float cq = 0.25f;
    private static final String cr = "DragonDeathTime";
    private static final String cs = "DragonPhase";
    private static final int ct = 0;
    public final DragonFlightHistory b = new DragonFlightHistory();
    public final EntityComplexPart[] cu;
    public final EntityComplexPart c;
    private final EntityComplexPart cv;
    private final EntityComplexPart cw;
    private final EntityComplexPart cx;
    private final EntityComplexPart cy;
    private final EntityComplexPart cz;
    private final EntityComplexPart cA;
    private final EntityComplexPart cB;
    public float d;
    public float e;
    public boolean f;
    public int cj = 0;
    public float ck;
    @Nullable
    public EntityEnderCrystal cl;
    @Nullable
    private EnderDragonBattle cC;
    private BlockPosition cD = BlockPosition.c;
    private final DragonControllerManager cE;
    private int cF = 100;
    private float cG;
    private final PathPoint[] cH = new PathPoint[24];
    private final int[] cI = new int[24];
    private final Path cJ = new Path();
    private final Explosion explosionSource;

    public EntityEnderDragon(EntityTypes<? extends EntityEnderDragon> entitytypes, World world) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.Q, world);
        this.c = new EntityComplexPart(this, "head", 1.0f, 1.0f);
        this.cv = new EntityComplexPart(this, "neck", 3.0f, 3.0f);
        this.cw = new EntityComplexPart(this, "body", 5.0f, 3.0f);
        this.cx = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cy = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cz = new EntityComplexPart(this, "tail", 2.0f, 2.0f);
        this.cA = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cB = new EntityComplexPart(this, "wing", 4.0f, 2.0f);
        this.cu = new EntityComplexPart[]{this.c, this.cv, this.cw, this.cx, this.cy, this.cz, this.cA, this.cB};
        this.x(this.fa());
        this.aq = true;
        this.cE = new DragonControllerManager(this);
        this.explosionSource = new ServerExplosion(world.getMinecraftWorld(), this, null, null, new Vec3D(Double.NaN, Double.NaN, Double.NaN), Float.NaN, true, Explosion.Effect.b);
    }

    public void a(EnderDragonBattle enderdragonbattle) {
        this.cC = enderdragonbattle;
    }

    public void c(BlockPosition blockposition) {
        this.cD = blockposition;
    }

    public BlockPosition l() {
        return this.cD;
    }

    public static AttributeProvider.Builder m() {
        return EntityInsentient.I().a(GenericAttributes.t, 200.0).a(GenericAttributes.i, 16.0);
    }

    @Override
    public boolean bd() {
        float f2 = MathHelper.b(this.e * ((float)Math.PI * 2));
        float f1 = MathHelper.b(this.d * ((float)Math.PI * 2));
        return f1 <= -0.3f && f2 >= -0.3f;
    }

    @Override
    public void bc() {
        if (this.ai().C && !this.be()) {
            this.ai().a(this.dC(), this.dE(), this.dI(), SoundEffects.iK, this.do(), 5.0f, 0.8f + this.ar.i() * 0.3f, false);
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(a, DragonControllerPhase.k.b());
    }

    @Override
    public void e_() {
        WorldServer worldserver;
        EnderDragonBattle enderdragonbattle;
        World world;
        this.aR();
        if (this.ai().C) {
            this.x(this.eL());
            if (!this.be() && !this.cE.a().a() && --this.cF < 0) {
                this.ai().a(this.dC(), this.dE(), this.dI(), SoundEffects.iL, this.do(), 2.5f, 0.8f + this.ar.i() * 0.3f, false);
                this.cF = 200 + this.ar.a(200);
            }
        }
        if (this.cC == null && (world = this.ai()) instanceof WorldServer && (enderdragonbattle = (worldserver = (WorldServer)world).G()) != null && this.cK().equals(enderdragonbattle.i())) {
            this.cC = enderdragonbattle;
        }
        this.d = this.e;
        if (this.eM()) {
            float f2 = (this.ar.i() - 0.5f) * 8.0f;
            float f1 = (this.ar.i() - 0.5f) * 4.0f;
            float f22 = (this.ar.i() - 0.5f) * 8.0f;
            this.ai().a(Particles.w, this.dC() + (double)f2, this.dE() + 2.0 + (double)f1, this.dI() + (double)f22, 0.0, 0.0, 0.0);
        } else {
            this.gG();
            Vec3D vec3d = this.dA();
            float f3 = 0.2f / ((float)vec3d.i() * 10.0f + 1.0f);
            this.e = this.cE.a().a() ? (this.e += 0.1f) : (this.f ? (this.e += f3 * 0.5f) : (this.e += (f3 *= (float)Math.pow(2.0, vec3d.e))));
            this.v(MathHelper.h(this.dP()));
            if (this.gw()) {
                this.e = 0.5f;
            } else {
                this.b.a(this.dE(), this.dP());
                World world1 = this.ai();
                if (world1 instanceof WorldServer) {
                    Vec3D vec3d1;
                    WorldServer worldserver1 = (WorldServer)world1;
                    IDragonController idragoncontroller = this.cE.a();
                    idragoncontroller.a(worldserver1);
                    if (this.cE.a() != idragoncontroller) {
                        idragoncontroller = this.cE.a();
                        idragoncontroller.a(worldserver1);
                    }
                    if ((vec3d1 = idragoncontroller.f()) != null && idragoncontroller.h() != DragonControllerPhase.k) {
                        double d0 = vec3d1.d - this.dC();
                        double d1 = vec3d1.e - this.dE();
                        double d2 = vec3d1.f - this.dI();
                        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                        float f4 = idragoncontroller.e();
                        double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                        if (d4 > 0.0) {
                            d1 = MathHelper.a(d1 / d4, (double)(-f4), (double)f4);
                        }
                        this.i(this.dA().b(0.0, d1 * 0.01, 0.0));
                        this.v(MathHelper.h(this.dP()));
                        Vec3D vec3d2 = vec3d1.a(this.dC(), this.dE(), this.dI()).d();
                        Vec3D vec3d3 = new Vec3D(MathHelper.a(this.dP() * ((float)Math.PI / 180)), this.dA().e, -MathHelper.b(this.dP() * ((float)Math.PI / 180))).d();
                        float f5 = Math.max(((float)vec3d3.b(vec3d2) + 0.5f) / 1.5f, 0.0f);
                        if (Math.abs(d0) > (double)1.0E-5f || Math.abs(d2) > (double)1.0E-5f) {
                            float f6 = MathHelper.a(MathHelper.h(180.0f - (float)MathHelper.d(d0, d2) * 57.295776f - this.dP()), -50.0f, 50.0f);
                            this.ck *= 0.8f;
                            this.ck += f6 * idragoncontroller.g();
                            this.v(this.dP() + this.ck * 0.1f);
                        }
                        float f7 = (float)(2.0 / (d3 + 1.0));
                        float f8 = 0.06f;
                        this.a(0.06f * (f5 * f7 + (1.0f - f7)), new Vec3D(0.0, 0.0, -1.0));
                        if (this.f) {
                            this.a(EnumMoveType.a, this.dA().c((double)0.8f));
                        } else {
                            this.a(EnumMoveType.a, this.dA());
                        }
                        Vec3D vec3d4 = this.dA().d();
                        double d5 = 0.8 + 0.15 * (vec3d4.b(vec3d3) + 1.0) / 2.0;
                        this.i(this.dA().d(d5, 0.91f, d5));
                    }
                } else {
                    this.bF.e();
                    this.cE.a().b();
                }
                if (!this.ai().B_()) {
                    this.aL();
                }
                this.br = this.dP();
                Vec3D[] avec3d = new Vec3D[this.cu.length];
                for (int i2 = 0; i2 < this.cu.length; ++i2) {
                    avec3d[i2] = new Vec3D(this.cu[i2].dC(), this.cu[i2].dE(), this.cu[i2].dI());
                }
                float f9 = (float)(this.b.a(5).a() - this.b.a(10).a()) * 10.0f * ((float)Math.PI / 180);
                float f10 = MathHelper.b(f9);
                float f11 = MathHelper.a(f9);
                float f12 = this.dP() * ((float)Math.PI / 180);
                float f13 = MathHelper.a(f12);
                float f14 = MathHelper.b(f12);
                this.a(this.cw, (double)(f13 * 0.5f), 0.0, (double)(-f14 * 0.5f));
                this.a(this.cA, (double)(f14 * 4.5f), 2.0, (double)(f13 * 4.5f));
                this.a(this.cB, (double)(f14 * -4.5f), 2.0, (double)(f13 * -4.5f));
                World world2 = this.ai();
                if (world2 instanceof WorldServer) {
                    WorldServer worldserver2 = (WorldServer)world2;
                    if (this.bj == 0) {
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cA.cV().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.a(worldserver2, worldserver2.a((Entity)this, this.cB.cV().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.c.cV().g(1.0), IEntitySelector.e));
                        this.b(worldserver2, worldserver2.a((Entity)this, this.cv.cV().g(1.0), IEntitySelector.e));
                    }
                }
                float f15 = MathHelper.a(this.dP() * ((float)Math.PI / 180) - this.ck * 0.01f);
                float f16 = MathHelper.b(this.dP() * ((float)Math.PI / 180) - this.ck * 0.01f);
                float f17 = this.gF();
                this.a(this.c, (double)(f15 * 6.5f * f10), (double)(f17 + f11 * 6.5f), (double)(-f16 * 6.5f * f10));
                this.a(this.cv, (double)(f15 * 5.5f * f10), (double)(f17 + f11 * 5.5f), (double)(-f16 * 5.5f * f10));
                DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
                for (int j2 = 0; j2 < 3; ++j2) {
                    EntityComplexPart entitycomplexpart = null;
                    if (j2 == 0) {
                        entitycomplexpart = this.cx;
                    }
                    if (j2 == 1) {
                        entitycomplexpart = this.cy;
                    }
                    if (j2 == 2) {
                        entitycomplexpart = this.cz;
                    }
                    DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(12 + j2 * 2);
                    float f18 = this.dP() * ((float)Math.PI / 180) + this.i((double)(dragonflighthistory_a1.b() - dragonflighthistory_a.b())) * ((float)Math.PI / 180);
                    float f19 = MathHelper.a(f18);
                    float f20 = MathHelper.b(f18);
                    float f21 = 1.5f;
                    float f22 = (float)(j2 + 1) * 2.0f;
                    this.a(entitycomplexpart, (double)(-(f13 * 1.5f + f19 * f22) * f10), dragonflighthistory_a1.a() - dragonflighthistory_a.a() - (double)((f22 + 1.5f) * f11) + 1.5, (double)((f14 * 1.5f + f20 * f22) * f10));
                }
                World world3 = this.ai();
                if (world3 instanceof WorldServer) {
                    WorldServer worldserver3 = (WorldServer)world3;
                    this.f = this.a(worldserver3, this.c.cV()) | this.a(worldserver3, this.cv.cV()) | this.a(worldserver3, this.cw.cV());
                    if (this.cC != null) {
                        this.cC.b(this);
                    }
                }
                for (int k2 = 0; k2 < this.cu.length; ++k2) {
                    this.cu[k2].X = avec3d[k2].d;
                    this.cu[k2].Y = avec3d[k2].e;
                    this.cu[k2].Z = avec3d[k2].f;
                    this.cu[k2].an = avec3d[k2].d;
                    this.cu[k2].ao = avec3d[k2].e;
                    this.cu[k2].ap = avec3d[k2].f;
                }
            }
        }
    }

    private void a(EntityComplexPart entitycomplexpart, double d0, double d1, double d2) {
        entitycomplexpart.a_(this.dC() + d0, this.dE() + d1, this.dI() + d2);
    }

    private float gF() {
        if (this.cE.a().a()) {
            return -1.0f;
        }
        DragonFlightHistory.a dragonflighthistory_a = this.b.a(5);
        DragonFlightHistory.a dragonflighthistory_a1 = this.b.a(0);
        return (float)(dragonflighthistory_a.a() - dragonflighthistory_a1.a());
    }

    private void gG() {
        if (this.cl != null) {
            if (this.cl.dU()) {
                this.cl = null;
            } else if (this.as % 10 == 0 && this.eL() < this.fa()) {
                EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0, EntityRegainHealthEvent.RegainReason.ENDER_CRYSTAL);
                this.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.x((float)((double)this.eL() + event.getAmount()));
                }
            }
        }
        if (this.ar.a(10) == 0) {
            List<EntityEnderCrystal> list = this.ai().a(EntityEnderCrystal.class, this.cV().g(32.0));
            EntityEnderCrystal entityendercrystal = null;
            double d0 = Double.MAX_VALUE;
            for (EntityEnderCrystal entityendercrystal1 : list) {
                double d1 = entityendercrystal1.g(this);
                if (!(d1 < d0)) continue;
                d0 = d1;
                entityendercrystal = entityendercrystal1;
            }
            this.cl = entityendercrystal;
        }
    }

    private void a(WorldServer worldserver, List<Entity> list) {
        double d0 = (this.cw.cV().a + this.cw.cV().d) / 2.0;
        double d1 = (this.cw.cV().c + this.cw.cV().f) / 2.0;
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            double d2 = entity.dC() - d0;
            double d3 = entity.dI() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.i(d2 / d4 * 4.0, 0.2f, d3 / d4 * 4.0);
            if (this.cE.a().a() || entityliving.ey() >= entity.as - 2) continue;
            DamageSource damagesource = this.ea().b(this);
            entity.a(worldserver, damagesource, 5.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private void b(WorldServer worldserver, List<Entity> list) {
        for (Entity entity : list) {
            if (!(entity instanceof EntityLiving)) continue;
            DamageSource damagesource = this.ea().b(this);
            entity.a(worldserver, damagesource, 10.0f);
            EnchantmentManager.a(worldserver, entity, damagesource);
        }
    }

    private float i(double d0) {
        return (float)MathHelper.d(d0);
    }

    private boolean a(WorldServer worldserver, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.a(axisalignedbb.b);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.a(axisalignedbb.d);
        int i1 = MathHelper.a(axisalignedbb.e);
        int j1 = MathHelper.a(axisalignedbb.f);
        boolean flag = false;
        boolean flag1 = false;
        ArrayList<org.bukkit.block.Block> destroyedBlocks = new ArrayList<org.bukkit.block.Block>();
        for (int k1 = i2; k1 <= l2; ++k1) {
            for (int l1 = j2; l1 <= i1; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    BlockPosition blockposition = new BlockPosition(k1, l1, i22);
                    IBlockData iblockdata = worldserver.a_(blockposition);
                    if (iblockdata.l() || iblockdata.a(TagsBlock.aJ)) continue;
                    if (worldserver.P().c(GameRules.d) && !iblockdata.a(TagsBlock.aI)) {
                        flag1 = true;
                        destroyedBlocks.add(CraftBlock.at(worldserver, blockposition));
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (!flag1) {
            return flag;
        }
        EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this, destroyedBlocks, 0.0f, this.explosionSource.b());
        if (event.isCancelled()) {
            return flag;
        }
        if (event.getYield() == 0.0f) {
            for (org.bukkit.block.Block block : event.blockList()) {
                this.ai().a(new BlockPosition(block.getX(), block.getY(), block.getZ()), false);
            }
        } else {
            for (org.bukkit.block.Block block : event.blockList()) {
                Material blockId = block.getType();
                if (blockId.isAir()) continue;
                CraftBlock craftBlock = (CraftBlock)block;
                BlockPosition blockposition = craftBlock.getPosition();
                Block nmsBlock = craftBlock.getNMS().b();
                if (nmsBlock.a(this.explosionSource)) {
                    TileEntity tileentity = craftBlock.getNMS().x() ? this.ai().c_(blockposition) : null;
                    LootParams.a loottableinfo_builder = new LootParams.a((WorldServer)this.ai()).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).a(LootContextParameters.j, Float.valueOf(1.0f / event.getYield())).b(LootContextParameters.h, tileentity);
                    craftBlock.getNMS().a(loottableinfo_builder).forEach(itemstack -> Block.a(this.ai(), blockposition, itemstack));
                    craftBlock.getNMS().a((WorldServer)this.ai(), blockposition, ItemStack.l, false);
                }
                nmsBlock.a((WorldServer)this.ai(), blockposition, this.explosionSource);
                this.ai().a(blockposition, false);
            }
        }
        if (flag1) {
            BlockPosition blockposition1 = new BlockPosition(i2 + this.ar.a(l2 - i2 + 1), j2 + this.ar.a(i1 - j2 + 1), k2 + this.ar.a(j1 - k2 + 1));
            worldserver.c(2008, blockposition1, 0);
        }
        return flag;
    }

    public boolean a(WorldServer worldserver, EntityComplexPart entitycomplexpart, DamageSource damagesource, float f2) {
        if (this.cE.a().h() == DragonControllerPhase.j) {
            return false;
        }
        f2 = this.cE.a().a(damagesource, f2);
        if (entitycomplexpart != this.c) {
            f2 = f2 / 4.0f + Math.min(f2, 1.0f);
        }
        if (f2 < 0.01f) {
            return false;
        }
        if (damagesource.d() instanceof EntityHuman || damagesource.a(DamageTypeTags.y)) {
            float f1 = this.eL();
            this.d(worldserver, damagesource, f2);
            if (this.eM() && !this.cE.a().a()) {
                this.x(1.0f);
                this.cE.a(DragonControllerPhase.j);
            }
            if (this.cE.a().a()) {
                this.cG = this.cG + f1 - this.eL();
                if (this.cG > 0.25f * this.fa()) {
                    this.cG = 0.0f;
                    this.cE.a(DragonControllerPhase.e);
                }
            }
        }
        return true;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        return this.a(worldserver, this.cw, damagesource, f2);
    }

    protected void d(WorldServer worldserver, DamageSource damagesource, float f2) {
        super.a(worldserver, damagesource, f2);
    }

    @Override
    public void c(WorldServer worldserver) {
        this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.c(GameEvent.p);
        if (this.cC != null) {
            this.cC.b(this);
            this.cC.a(this);
        }
    }

    @Override
    public int getExpReward(WorldServer worldserver, Entity entity) {
        boolean flag = worldserver.P().c(GameRules.g);
        int short0 = 500;
        if (this.cC != null && !this.cC.f()) {
            short0 = 12000;
        }
        return flag ? short0 : 0;
    }

    @Override
    protected void es() {
        World world1;
        if (this.cC != null) {
            this.cC.b(this);
        }
        ++this.cj;
        if (this.cj >= 180 && this.cj <= 200) {
            float f2 = (this.ar.i() - 0.5f) * 8.0f;
            float f1 = (this.ar.i() - 0.5f) * 4.0f;
            float f22 = (this.ar.i() - 0.5f) * 8.0f;
            this.ai().a(Particles.v, this.dC() + (double)f2, this.dE() + 2.0 + (double)f1, this.dI() + (double)f22, 0.0, 0.0, 0.0);
        }
        int i2 = this.expToDrop;
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (this.cj > 150 && this.cj % 5 == 0) {
                EntityExperienceOrb.a(worldserver, this.dv(), MathHelper.d((float)i2 * 0.08f));
            }
            if (this.cj == 1 && !this.be()) {
                int viewDistance = worldserver.getCraftServer().getViewDistance() * 16;
                for (EntityPlayer player : worldserver.q().ag().l) {
                    double deltaX = this.dC() - player.dC();
                    double deltaZ = this.dI() - player.dI();
                    double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                    if (worldserver.spigotConfig.dragonDeathSoundRadius > 0 && distanceSquared > (double)(worldserver.spigotConfig.dragonDeathSoundRadius * worldserver.spigotConfig.dragonDeathSoundRadius)) continue;
                    if (distanceSquared > (double)(viewDistance * viewDistance)) {
                        double deltaLength = Math.sqrt(distanceSquared);
                        double relativeX = player.dC() + deltaX / deltaLength * (double)viewDistance;
                        double relativeZ = player.dI() + deltaZ / deltaLength * (double)viewDistance;
                        player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)relativeX, (int)this.dE(), (int)relativeZ), 0, true));
                        continue;
                    }
                    player.g.b(new PacketPlayOutWorldEvent(1028, new BlockPosition((int)this.dC(), (int)this.dE(), (int)this.dI()), 0, true));
                }
            }
        }
        Vec3D vec3d = new Vec3D(0.0, 0.1f, 0.0);
        this.a(EnumMoveType.a, vec3d);
        for (EntityComplexPart entitycomplexpart : this.cu) {
            entitycomplexpart.bC();
            entitycomplexpart.b(entitycomplexpart.dv().e(vec3d));
        }
        if (this.cj == 200 && (world1 = this.ai()) instanceof WorldServer) {
            WorldServer worldserver1 = (WorldServer)world1;
            EntityExperienceOrb.a(worldserver1, this.dv(), MathHelper.d((float)i2 * 0.2f));
            if (this.cC != null) {
                this.cC.a(this);
            }
            this.remove(Entity.RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
            this.c(GameEvent.p);
        }
    }

    public int n() {
        if (this.cH[0] == null) {
            for (int i2 = 0; i2 < 24; ++i2) {
                int l2;
                int k2;
                int j2 = 5;
                if (i2 < 12) {
                    k2 = MathHelper.d(60.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                    l2 = MathHelper.d(60.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)i2)));
                } else if (i2 < 20) {
                    int i1 = i2 - 12;
                    k2 = MathHelper.d(40.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    l2 = MathHelper.d(40.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)i1)));
                    j2 += 10;
                } else {
                    int j1 = i2 - 20;
                    k2 = MathHelper.d(20.0f * MathHelper.b(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                    l2 = MathHelper.d(20.0f * MathHelper.a(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)j1)));
                }
                int k1 = Math.max(73, this.ai().a(HeightMap.Type.f, new BlockPosition(k2, 0, l2)).v() + j2);
                this.cH[i2] = new PathPoint(k2, k1, l2);
            }
            this.cI[0] = 6146;
            this.cI[1] = 8197;
            this.cI[2] = 8202;
            this.cI[3] = 16404;
            this.cI[4] = 32808;
            this.cI[5] = 32848;
            this.cI[6] = 65696;
            this.cI[7] = 131392;
            this.cI[8] = 131712;
            this.cI[9] = 263424;
            this.cI[10] = 526848;
            this.cI[11] = 525313;
            this.cI[12] = 1581057;
            this.cI[13] = 3166214;
            this.cI[14] = 2138120;
            this.cI[15] = 6373424;
            this.cI[16] = 4358208;
            this.cI[17] = 12910976;
            this.cI[18] = 9044480;
            this.cI[19] = 9706496;
            this.cI[20] = 15216640;
            this.cI[21] = 0xD0E000;
            this.cI[22] = 11763712;
            this.cI[23] = 0x7E0000;
        }
        return this.q(this.dC(), this.dE(), this.dI());
    }

    public int q(double d0, double d1, double d2) {
        float f2 = 10000.0f;
        int i2 = 0;
        PathPoint pathpoint = new PathPoint(MathHelper.a(d0), MathHelper.a(d1), MathHelper.a(d2));
        int j2 = 0;
        if (this.cC == null || this.cC.e() == 0) {
            j2 = 12;
        }
        for (int k2 = j2; k2 < 24; ++k2) {
            float f1;
            if (this.cH[k2] == null || !((f1 = this.cH[k2].c(pathpoint)) < f2)) continue;
            f2 = f1;
            i2 = k2;
        }
        return i2;
    }

    @Nullable
    public PathEntity a(int i2, int j2, @Nullable PathPoint pathpoint) {
        for (int k2 = 0; k2 < 24; ++k2) {
            PathPoint pathpoint1 = this.cH[k2];
            pathpoint1.i = false;
            pathpoint1.g = 0.0f;
            pathpoint1.e = 0.0f;
            pathpoint1.f = 0.0f;
            pathpoint1.h = null;
            pathpoint1.d = -1;
        }
        PathPoint pathpoint2 = this.cH[i2];
        PathPoint pathpoint3 = this.cH[j2];
        pathpoint2.e = 0.0f;
        pathpoint2.g = pathpoint2.f = pathpoint2.a(pathpoint3);
        this.cJ.a();
        this.cJ.a(pathpoint2);
        PathPoint pathpoint4 = pathpoint2;
        int l2 = 0;
        if (this.cC == null || this.cC.e() == 0) {
            l2 = 12;
        }
        while (!this.cJ.e()) {
            PathPoint pathpoint5 = this.cJ.c();
            if (pathpoint5.equals(pathpoint3)) {
                if (pathpoint != null) {
                    pathpoint.h = pathpoint3;
                    pathpoint3 = pathpoint;
                }
                return this.a(pathpoint2, pathpoint3);
            }
            if (pathpoint5.a(pathpoint3) < pathpoint4.a(pathpoint3)) {
                pathpoint4 = pathpoint5;
            }
            pathpoint5.i = true;
            int i1 = 0;
            for (int j1 = 0; j1 < 24; ++j1) {
                if (this.cH[j1] != pathpoint5) continue;
                i1 = j1;
                break;
            }
            for (int k1 = l2; k1 < 24; ++k1) {
                if ((this.cI[i1] & 1 << k1) <= 0) continue;
                PathPoint pathpoint6 = this.cH[k1];
                if (pathpoint6.i) continue;
                float f2 = pathpoint5.e + pathpoint5.a(pathpoint6);
                if (pathpoint6.c() && !(f2 < pathpoint6.e)) continue;
                pathpoint6.h = pathpoint5;
                pathpoint6.e = f2;
                pathpoint6.f = pathpoint6.a(pathpoint3);
                if (pathpoint6.c()) {
                    this.cJ.a(pathpoint6, pathpoint6.e + pathpoint6.f);
                    continue;
                }
                pathpoint6.g = pathpoint6.e + pathpoint6.f;
                this.cJ.a(pathpoint6);
            }
        }
        if (pathpoint4 == pathpoint2) {
            return null;
        }
        cm.debug("Failed to find path from {} to {}", (Object)i2, (Object)j2);
        if (pathpoint != null) {
            pathpoint.h = pathpoint4;
            pathpoint4 = pathpoint;
        }
        return this.a(pathpoint2, pathpoint4);
    }

    private PathEntity a(PathPoint pathpoint, PathPoint pathpoint1) {
        ArrayList list = Lists.newArrayList();
        PathPoint pathpoint2 = pathpoint1;
        list.add(0, pathpoint1);
        while (pathpoint2.h != null) {
            pathpoint2 = pathpoint2.h;
            list.add(0, pathpoint2);
        }
        return new PathEntity(list, new BlockPosition(pathpoint1.a, pathpoint1.b, pathpoint1.c), true);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a(cs, this.cE.a().h().b());
        valueoutput.a(cr, this.cj);
        valueoutput.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        valueinput.e(cs).ifPresent(integer -> this.cE.a(DragonControllerPhase.a(integer)));
        this.cj = valueinput.a(cr, 0);
        this.expToDrop = valueinput.a("Bukkit.expToDrop", this.expToDrop);
    }

    @Override
    public void dJ() {
    }

    public EntityComplexPart[] t() {
        return this.cu;
    }

    @Override
    public boolean bK() {
        return false;
    }

    @Override
    public SoundCategory do() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect p() {
        return SoundEffects.iH;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.iM;
    }

    @Override
    protected float fk() {
        return 5.0f;
    }

    public Vec3D J(float f2) {
        Vec3D vec3d;
        IDragonController idragoncontroller = this.cE.a();
        DragonControllerPhase<? extends IDragonController> dragoncontrollerphase = idragoncontroller.h();
        if (dragoncontrollerphase != DragonControllerPhase.d && dragoncontrollerphase != DragonControllerPhase.e) {
            if (idragoncontroller.a()) {
                float f1 = this.dR();
                float f22 = 1.5f;
                this.w(-45.0f);
                vec3d = this.h(f2);
                this.w(f1);
            } else {
                vec3d = this.h(f2);
            }
        } else {
            BlockPosition blockposition = this.ai().a(HeightMap.Type.f, WorldGenEndTrophy.a(this.cD));
            float f3 = Math.max((float)Math.sqrt(blockposition.b(this.dv())) / 4.0f, 1.0f);
            float f4 = 6.0f / f3;
            float f5 = this.dR();
            float f6 = 1.5f;
            this.w(-f4 * 1.5f * 5.0f);
            vec3d = this.h(f2);
            this.w(f5);
        }
        return vec3d;
    }

    public void a(WorldServer worldserver, EntityEnderCrystal entityendercrystal, BlockPosition blockposition, DamageSource damagesource) {
        EntityHuman entityhuman1;
        Entity entity = damagesource.d();
        EntityHuman entityhuman = entity instanceof EntityHuman ? (entityhuman1 = (EntityHuman)entity) : worldserver.a(cn, (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (entityendercrystal == this.cl) {
            this.a(worldserver, this.c, this.ea().d(entityendercrystal, entityhuman), 10.0f);
        }
        this.cE.a().a(entityendercrystal, blockposition, damagesource, entityhuman);
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (a.equals(datawatcherobject) && this.ai().C) {
            this.cE.a(DragonControllerPhase.a(this.au().a(a)));
        }
        super.a(datawatcherobject);
    }

    public DragonControllerManager gD() {
        return this.cE;
    }

    @Nullable
    public EnderDragonBattle gE() {
        return this.cC;
    }

    @Override
    public boolean b(MobEffect mobeffect, @Nullable Entity entity) {
        return false;
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public boolean o(boolean flag) {
        return false;
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        EntityComplexPart[] aentitycomplexpart = this.t();
        for (int i2 = 0; i2 < aentitycomplexpart.length; ++i2) {
            aentitycomplexpart[i2].e(i2 + packetplayoutspawnentity.b() + 1);
        }
    }

    @Override
    public boolean c(EntityLiving entityliving) {
        return entityliving.eE();
    }

    @Override
    protected float c(float f2) {
        return 1.0f;
    }
}

