/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger f = LogUtils.getLogger();
    private static final IBlockData g = Blocks.L.m();
    private static final int h = 0;
    private static final float i = 0.0f;
    private static final int j = 40;
    private static final boolean k = true;
    private static final boolean l = false;
    private IBlockData m = g;
    public int a = 0;
    public boolean b = true;
    public boolean n = false;
    public boolean o;
    public int p = 40;
    public float q = 0.0f;
    @Nullable
    public NBTTagCompound c;
    public boolean d;
    protected static final DataWatcherObject<BlockPosition> e = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> entitytypes, World world) {
        super(entitytypes, world);
    }

    private EntityFallingBlock(World world, double d0, double d1, double d2, IBlockData iblockdata) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.Y, world);
        this.m = iblockdata;
        this.V = true;
        this.a_(d0, d1, d2);
        this.i(Vec3D.c);
        this.X = d0;
        this.Y = d1;
        this.Z = d2;
        this.a(this.dx());
    }

    public static EntityFallingBlock a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return EntityFallingBlock.fall(world, blockposition, iblockdata, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.I) ? (IBlockData)iblockdata.b(BlockProperties.I, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.y().g())) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.y().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cF() {
        return false;
    }

    @Override
    public final boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        if (!this.d(damagesource)) {
            this.bG();
        }
        return false;
    }

    public void a(BlockPosition blockposition) {
        this.ay.a(e, blockposition);
    }

    public BlockPosition e() {
        return this.ay.a(e);
    }

    @Override
    protected Entity.MovementEmission bj() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(e, BlockPosition.c);
    }

    @Override
    public boolean bK() {
        return !this.dU();
    }

    @Override
    protected double bg() {
        return 0.04;
    }

    @Override
    public void g() {
        if (this.m.l()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.m.b();
            ++this.a;
            this.bi();
            this.a(EnumMoveType.a, this.dA());
            this.aL();
            this.bZ();
            World world = this.ai();
            if (world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                if (this.bO() || this.d) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    BlockPosition blockposition = this.dx();
                    boolean flag = this.m.b() instanceof BlockConcretePowder;
                    boolean flag1 = flag && this.ai().b_(blockposition).a(TagsFluid.a);
                    double d0 = this.dA().h();
                    if (flag && d0 > 1.0 && (movingobjectpositionblock = this.ai().a(new RayTrace(new Vec3D(this.X, this.Y, this.Z), this.dv(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).d() != MovingObjectPosition.EnumMovingObjectType.a && this.ai().b_(movingobjectpositionblock.b()).a(TagsFluid.a)) {
                        blockposition = movingobjectpositionblock.b();
                        flag1 = true;
                    }
                    if (!this.aK() && !flag1) {
                        if (this.a > 100 && (blockposition.v() <= this.ai().L_() || blockposition.v() > this.ai().ao()) || this.a > 600) {
                            if (this.b && worldserver.P().c(GameRules.j)) {
                                this.a(worldserver, block);
                            }
                            this.discard(EntityRemoveEvent.Cause.DROP);
                        }
                    } else {
                        IBlockData iblockdata = this.ai().a_(blockposition);
                        this.i(this.dA().d(0.7, -0.5, 0.7));
                        if (!iblockdata.a(Blocks.ca)) {
                            if (!this.n) {
                                boolean flag4;
                                boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.ai(), blockposition, EnumDirection.a, ItemStack.l, EnumDirection.b));
                                boolean flag3 = BlockFalling.n(this.ai().a_(blockposition.e())) && (!flag || !flag1);
                                boolean bl = flag4 = this.m.a((IWorldReader)this.ai(), blockposition) && !flag3;
                                if (flag2 && flag4) {
                                    if (this.m.b(BlockProperties.I) && this.ai().b_(blockposition).a() == FluidTypes.c) {
                                        this.m = (IBlockData)this.m.b(BlockProperties.I, true);
                                    }
                                    if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.m)) {
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        return;
                                    }
                                    if (this.ai().a(blockposition, this.m, 3)) {
                                        TileEntity tileentity;
                                        ((WorldServer)this.ai()).n().a.a(this, new PacketPlayOutBlockChange(blockposition, this.ai().a_(blockposition)));
                                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                        if (block instanceof Fallable) {
                                            ((Fallable)((Object)block)).a(this.ai(), blockposition, this.m, iblockdata, this);
                                        }
                                        if (this.c != null && this.m.x() && (tileentity = this.ai().c_(blockposition)) != null) {
                                            try (ProblemReporter.j problemreporter_j = new ProblemReporter.j(tileentity.t(), f);){
                                                IRegistryCustom iregistrycustom = this.ai().K_();
                                                TagValueOutput tagvalueoutput = TagValueOutput.a(problemreporter_j, iregistrycustom);
                                                tileentity.e(tagvalueoutput);
                                                NBTTagCompound nbttagcompound = tagvalueoutput.b();
                                                this.c.a((String s2, NBTBase nbtbase) -> nbttagcompound.a((String)s2, nbtbase.d()));
                                                tileentity.b(TagValueInput.a((ProblemReporter)problemreporter_j, (HolderLookup.a)iregistrycustom, nbttagcompound));
                                            }
                                            catch (Exception exception) {
                                                f.error("Failed to load block entity from falling block", (Throwable)exception);
                                            }
                                            tileentity.e();
                                        }
                                    } else if (this.b && worldserver.P().c(GameRules.j)) {
                                        this.discard(EntityRemoveEvent.Cause.DROP);
                                        this.a(block, blockposition);
                                        this.a(worldserver, block);
                                    }
                                } else {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    if (this.b && worldserver.P().c(GameRules.j)) {
                                        this.a(block, blockposition);
                                        this.a(worldserver, block);
                                    }
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                this.a(block, blockposition);
                            }
                        }
                    }
                }
            }
            this.i(this.dA().c(0.98));
        }
    }

    public void a(Block block, BlockPosition blockposition) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.ai(), blockposition, this);
        }
    }

    @Override
    public boolean a(double d0, float f2, DamageSource damagesource) {
        DamageSource damagesource1;
        if (!this.o) {
            return false;
        }
        int i2 = MathHelper.c(d0 - 1.0);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.m.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.a(this);
        } else {
            damagesource1 = this.ea().a(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f1 = Math.min(MathHelper.d((float)i2 * this.q), this.p);
        this.ai().a((Entity)this, this.cV(), predicate).forEach(entity -> entity.a(damagesource2, f1));
        boolean flag = this.m.a(TagsBlock.J);
        if (flag && f1 > 0.0f && this.ar.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.m);
            if (iblockdata == null) {
                this.n = true;
            } else {
                this.m = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        valueoutput.a("BlockState", IBlockData.a, this.m);
        valueoutput.a("Time", this.a);
        valueoutput.a("DropItem", this.b);
        valueoutput.a("HurtEntities", this.o);
        valueoutput.a("FallHurtAmount", this.q);
        valueoutput.a("FallHurtMax", this.p);
        if (this.c != null) {
            valueoutput.a("TileEntityData", NBTTagCompound.a, this.c);
        }
        valueoutput.a("CancelDrop", this.n);
    }

    @Override
    protected void a(ValueInput valueinput) {
        this.m = valueinput.a("BlockState", IBlockData.a).orElse(g);
        this.a = valueinput.a("Time", 0);
        boolean flag = this.m.a(TagsBlock.J);
        this.o = valueinput.a("HurtEntities", flag);
        this.q = valueinput.a("FallHurtAmount", 0.0f);
        this.p = valueinput.a("FallHurtMax", 40);
        this.b = valueinput.a("DropItem", true);
        this.c = valueinput.a("TileEntityData", NBTTagCompound.a).orElse(null);
        this.n = valueinput.a("CancelDrop", false);
    }

    public void b(float f2, int i2) {
        this.o = true;
        this.q = f2;
        this.p = i2;
    }

    public void f() {
        this.n = true;
    }

    @Override
    public boolean cJ() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        super.a(crashreportsystemdetails);
        crashreportsystemdetails.a("Immitating BlockState", this.m.toString());
    }

    public IBlockData i() {
        return this.m;
    }

    @Override
    protected IChatBaseComponent cD() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.m.b().f());
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, Block.j(this.i()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.m = Block.a(packetplayoutspawnentity.p());
        this.V = true;
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        this.a_(d0, d1, d2);
        this.a(this.dx());
    }

    @Override
    @Nullable
    public Entity b(TeleportTransition teleporttransition) {
        ResourceKey<World> resourcekey = teleporttransition.b().aj();
        ResourceKey<World> resourcekey1 = this.ai().aj();
        boolean flag = (resourcekey1 == World.k || resourcekey == World.k) && resourcekey1 != resourcekey;
        Entity entity = super.b(teleporttransition);
        this.d = entity != null && flag;
        return entity;
    }
}

