/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Dynamic;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final int ck = 40;
    private static final int cl = 200;
    private static final int cm = 500;
    private static final float cn = 0.3f;
    private static final float co = 1.0f;
    private static final float cp = 1.5f;
    private static final int cq = 30;
    private static final int cr = 24;
    private static final DataWatcherObject<Integer> cs = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int ct = 200;
    private static final int cu = 260;
    private static final int cv = 20;
    private static final int cw = 120;
    private static final int cx = 20;
    private static final int cy = 35;
    private static final int cz = 10;
    private static final int cA = 20;
    private static final int cB = 100;
    private static final int cC = 20;
    private static final int cD = 30;
    private static final float cE = 4.5f;
    private static final float cF = 0.7f;
    private static final int cG = 30;
    private int cH;
    private int cI;
    private int cJ;
    private int cM;
    public AnimationState a = new AnimationState();
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState f = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cN = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cO = new a();
    private VibrationSystem.a cP = new VibrationSystem.a();
    AngerManagement cQ = new AngerManagement(this::G, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> entitytypes, World world) {
        super(entitytypes, world);
        this.cc = 5;
        this.S().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        if (packetplayoutspawnentity.p() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader iworldreader) {
        return super.a(iworldreader) && iworldreader.a((Entity)this, this.ap().n().a(this.dv()));
    }

    @Override
    public float a(BlockPosition blockposition, IWorldReader iworldreader) {
        return 0.0f;
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource) {
        return this.gK() && !damagesource.a(DamageTypeTags.d) ? true : super.a(worldserver, damagesource);
    }

    boolean gK() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean p(Entity entity) {
        return false;
    }

    @Override
    public float gb() {
        return 5.0f;
    }

    @Override
    protected float aX() {
        return this.ak + 0.55f;
    }

    public static AttributeProvider.Builder l() {
        return EntityMonster.gM().a(GenericAttributes.t, 500.0).a(GenericAttributes.w, 0.3f).a(GenericAttributes.q, 1.0).a(GenericAttributes.d, 1.5).a(GenericAttributes.c, 30.0).a(GenericAttributes.n, 24.0);
    }

    @Override
    public boolean bk() {
        return true;
    }

    @Override
    protected float fk() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return !this.c(EntityPose.l) && !this.gK() ? this.n().b() : null;
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Dq;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.Dm;
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(SoundEffects.DA, 10.0f, 1.0f);
    }

    @Override
    public boolean c(WorldServer worldserver, Entity entity) {
        worldserver.a((Entity)this, (byte)4);
        this.a(SoundEffects.Dl, 10.0f, this.fl());
        SonicBoom.a((EntityLiving)this, 40);
        return super.c(worldserver, entity);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cs, 0);
    }

    public int m() {
        return this.ay.a(cs);
    }

    private void gN() {
        this.ay.a(cs, this.gQ());
    }

    @Override
    public void g() {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cP, this.cO);
            if (this.gq() || this.af()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.g();
        if (this.ai().B_()) {
            if (this.as % this.gO() == 0) {
                this.cJ = 10;
                if (!this.be()) {
                    this.ai().a(this.dC(), this.dE(), this.dI(), SoundEffects.Dp, this.do(), 5.0f, this.fl(), false);
                }
            }
            this.cI = this.cH;
            if (this.cH > 0) {
                --this.cH;
            }
            this.cM = this.cJ;
            if (this.cJ > 0) {
                --this.cJ;
            }
            switch (this.aw()) {
                case n: {
                    this.a(this.c);
                    break;
                }
                case o: {
                    this.a(this.d);
                }
            }
        }
    }

    @Override
    protected void a(WorldServer worldserver) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("wardenBrain");
        this.eh().a(worldserver, this);
        gameprofilerfiller.c();
        super.a(worldserver);
        if ((this.as + this.ar()) % 120 == 0) {
            Warden.a(worldserver, this.dv(), this, 20);
        }
        if (this.as % 20 == 0) {
            this.cQ.a(worldserver, this::G);
            this.gN();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 4) {
            this.a.a();
            this.e.a(this.as);
        } else if (b0 == 61) {
            this.cH = 10;
        } else if (b0 == 62) {
            this.f.a(this.as);
        } else {
            super.b(b0);
        }
    }

    private int gO() {
        float f2 = (float)this.m() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float J(float f2) {
        return MathHelper.h(f2, this.cI, this.cH) / 10.0f;
    }

    public float K(float f2) {
        return MathHelper.h(f2, this.cM, this.cJ) / 10.0f;
    }

    private void a(AnimationState animationstate) {
        if ((float)animationstate.a((float)this.as) < 4500.0f) {
            RandomSource randomsource = this.ec();
            IBlockData iblockdata = this.bx();
            if (iblockdata.o() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dC() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.dE();
                    double d2 = this.dI() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.ai().a(new ParticleParamBlock(Particles.b, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> datawatcherobject) {
        if (aD.equals(datawatcherobject)) {
            switch (this.aw()) {
                case n: {
                    this.c.a(this.as);
                    break;
                }
                case o: {
                    this.d.a(this.as);
                    break;
                }
                case l: {
                    this.a.a(this.as);
                    break;
                }
                case m: {
                    this.b.a(this.as);
                }
            }
        }
        super.a(datawatcherobject);
    }

    @Override
    public boolean a(Explosion explosion) {
        return this.gK();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> eh() {
        return super.eh();
    }

    @Override
    protected void ah() {
        super.ah();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> biconsumer) {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            biconsumer.accept(this.cN, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean G(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.ai() == entity.ai() && IEntitySelector.e.test(entity) && !this.t(entity) && entityliving.ap() != EntityTypes.g && entityliving.ap() != EntityTypes.bI && !entityliving.cG() && !entityliving.eM() && this.ai().F_().a(entityliving.cV())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer worldserver, Vec3D vec3d, @Nullable Entity entity, int i2) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, i2, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("anger", AngerManagement.a(this::G), this.cQ);
        valueoutput.a("listener", VibrationSystem.a.a, this.cP);
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.cQ = valueinput.a("anger", AngerManagement.a(this::G)).orElseGet(() -> new AngerManagement(this::G, Collections.emptyList()));
        this.gN();
        this.cP = valueinput.a("listener", VibrationSystem.a.a).orElseGet(VibrationSystem.a::new);
    }

    private void gP() {
        if (!this.c(EntityPose.l)) {
            this.a(this.n().c(), 10.0f, this.fl());
        }
    }

    public AngerLevel n() {
        return AngerLevel.a(this.gQ());
    }

    private int gQ() {
        return this.cQ.b(this.e());
    }

    public void H(Entity entity) {
        this.cQ.a(entity);
    }

    public void I(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int i2, boolean flag) {
        if (!this.gw() && this.G(entity)) {
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.e() instanceof EntityHuman);
            int j2 = this.cQ.a(entity, i2);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.eh().b(MemoryModuleType.p);
            }
            if (flag) {
                this.gP();
            }
        }
    }

    public Optional<EntityLiving> t() {
        return this.n().d() ? this.cQ.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving e() {
        return this.U();
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        this.eh().a(MemoryModuleType.aF, Unit.a, 1200L);
        if (entityspawnreason == EntitySpawnReason.k) {
            this.b(EntityPose.n);
            this.eh().a(MemoryModuleType.aD, Unit.a, WardenAi.a);
            this.a(SoundEffects.Di, 5.0f, 1.0f);
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Override
    public boolean a(WorldServer worldserver, DamageSource damagesource, float f2) {
        boolean flag = super.a(worldserver, damagesource, f2);
        if (!this.gw() && !this.gK()) {
            Entity entity = damagesource.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bO.c(MemoryModuleType.p).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (damagesource.b() || this.a((Entity)entityliving, 5.0)) {
                    this.i(entityliving);
                }
            }
        }
        return flag;
    }

    public void i(EntityLiving entityliving) {
        this.eh().b(MemoryModuleType.az);
        this.eh().a(MemoryModuleType.p, entityliving);
        this.eh().b(MemoryModuleType.F);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        EntitySize entitysize = super.e(entitypose);
        return this.gK() ? EntitySize.c(entitysize.a(), 1.0f) : entitysize;
    }

    @Override
    public boolean bL() {
        return !this.gK() && super.bL();
    }

    @Override
    protected void E(Entity entity) {
        if (!this.gw() && !this.eh().a(MemoryModuleType.aI)) {
            this.eh().a(MemoryModuleType.aI, Unit.a, 20L);
            this.I(entity);
            WardenAi.a(this, entity.dx());
        }
        super.E(entity);
    }

    @VisibleForTesting
    public AngerManagement gH() {
        return this.cQ;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, this, world){

            @Override
            protected Pathfinder a(int i2) {
                this.o = new PathfinderNormal();
                return new Pathfinder(this, this.o, i2){

                    @Override
                    protected float a(PathPoint pathpoint, PathPoint pathpoint1) {
                        return pathpoint.b(pathpoint1);
                    }
                };
            }
        };
    }

    @Override
    public VibrationSystem.a gI() {
        return this.cP;
    }

    @Override
    public VibrationSystem.d gJ() {
        return this.cO;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cW());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, GameEvent.a gameevent_a) {
            if (!(Warden.this.gw() || Warden.this.eM() || Warden.this.eh().a(MemoryModuleType.aJ) || Warden.this.gK() || !worldserver.F_().a(blockposition))) {
                EntityLiving entityliving;
                Entity entity = gameevent_a.a();
                if (entity instanceof EntityLiving && !Warden.this.G(entityliving = (EntityLiving)entity)) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer worldserver, BlockPosition blockposition, Holder<GameEvent> holder, @Nullable Entity entity, @Nullable Entity entity1, float f2) {
            if (!Warden.this.eM()) {
                Warden.this.bO.a(MemoryModuleType.aJ, Unit.a, 40L);
                worldserver.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.DB, 5.0f, Warden.this.fl());
                BlockPosition blockposition1 = blockposition;
                if (entity1 != null) {
                    if (Warden.this.a(entity1, 30.0)) {
                        if (Warden.this.eh().a(MemoryModuleType.aB)) {
                            if (Warden.this.G(entity1)) {
                                blockposition1 = entity1.dx();
                            }
                            Warden.this.I(entity1);
                        } else {
                            Warden.this.a(entity1, 10, true);
                        }
                    }
                    Warden.this.eh().a(MemoryModuleType.aB, Unit.a, 100L);
                } else {
                    Warden.this.I(entity);
                }
                if (!Warden.this.n().d()) {
                    Optional<EntityLiving> optional = Warden.this.cQ.a();
                    if (entity1 != null || optional.isEmpty() || optional.get() == entity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

