/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillager;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger cq = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cr = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int cm = 12;
    public static final Map<Item, Integer> cn = ImmutableMap.of((Object)Items.qC, (Object)4, (Object)Items.vI, (Object)1, (Object)Items.vH, (Object)1, (Object)Items.wN, (Object)1);
    private static final int cs = 2;
    private static final int ct = 10;
    private static final int cu = 1200;
    private static final int cv = 24000;
    private static final int cw = 10;
    private static final int cx = 5;
    private static final long cy = 24000L;
    @VisibleForTesting
    public static final float co = 0.5f;
    private static final int cz = 0;
    private static final byte cA = 0;
    private static final int cB = 0;
    private static final int cC = 0;
    private static final int cD = 0;
    private static final boolean cE = false;
    private int cF;
    private boolean cG;
    @Nullable
    private EntityHuman cH;
    private boolean cI;
    private int cJ = 0;
    private final Reputation cM = new Reputation(this);
    private long cN;
    private long cO = 0L;
    private int cP = 0;
    private long cQ = 0L;
    private int cR = 0;
    private long cS;
    private boolean cT = false;
    private static final ImmutableList<MemoryModuleType<?>> cU = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.M, MemoryModuleType.aQ, (Object[])new MemoryModuleType[]{MemoryModuleType.n, MemoryModuleType.o, MemoryModuleType.r, MemoryModuleType.s, MemoryModuleType.u, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.z, MemoryModuleType.B, MemoryModuleType.f, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.F, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.K, MemoryModuleType.G});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cV = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> cp = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gR().b().a().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));
    public long gossipDecayInterval = 24000L;

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, ResourceKey<VillagerType> resourcekey) {
        this(entitytypes, world, world.K_().d(resourcekey));
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, Holder<VillagerType> holder) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        ((Navigation)this.S()).d(true);
        this.S().a(true);
        this.S().a(48.0f);
        this.a_(true);
        this.a(this.gR().a(holder).b(world.K_(), VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> eh() {
        return super.eh();
    }

    protected BehaviorController.b<EntityVillager> ei() {
        return BehaviorController.a(cU, cV);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.ei().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    public void g(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.eh();
        behaviorcontroller.b(worldserver, this);
        this.bO = behaviorcontroller.i();
        this.a(this.eh());
    }

    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        Holder<VillagerProfession> holder = this.gR().b();
        if (this.g_()) {
            behaviorcontroller.a(Schedule.e);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(Schedule.f);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(holder, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(holder, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(holder, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(holder, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(holder, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(holder, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(holder, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(holder, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.ai().af(), this.ai().ae());
    }

    @Override
    protected void h() {
        super.h();
        if (this.ai() instanceof WorldServer) {
            this.g((WorldServer)this.ai());
        }
    }

    public static AttributeProvider.Builder gQ() {
        return EntityInsentient.I().a(GenericAttributes.w, 0.5);
    }

    public boolean gS() {
        return this.cT;
    }

    @Override
    public void inactiveTick() {
        if (this.ai().spigotConfig.tickInactiveVillagers && this.dl()) {
            this.a((WorldServer)this.ai());
        }
        super.inactiveTick();
    }

    @Override
    protected void a(WorldServer worldserver) {
        Raid raid;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("villagerBrain");
        this.eh().a(worldserver, this);
        gameprofilerfiller.c();
        if (this.cT) {
            this.cT = false;
        }
        if (!this.gI() && this.cF > 0) {
            --this.cF;
            if (this.cF <= 0) {
                if (this.cG) {
                    this.ho();
                    this.cG = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cH != null) {
            worldserver.a(ReputationEvent.e, (Entity)this.cH, this);
            worldserver.a((Entity)this, (byte)14);
            this.cH = null;
        }
        if (!this.gw() && this.ar.a(100) == 0 && (raid = worldserver.d(this.dx())) != null && raid.r() && !raid.a()) {
            worldserver.a((Entity)this, (byte)42);
        }
        if (this.gR().b().a(VillagerProfession.b) && this.gI()) {
            this.gN();
        }
        super.a(worldserver);
    }

    @Override
    public void g() {
        super.g();
        if (this.m() > 0) {
            this.r(this.m() - 1);
        }
        this.hq();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.vj) && this.bO() && !this.gI() && !this.fY()) {
            if (this.g_()) {
                this.hd();
                return EnumInteractionResult.a;
            }
            if (!this.ai().C) {
                boolean flag = this.gJ().isEmpty();
                if (enumhand == EnumHand.a) {
                    if (flag) {
                        this.hd();
                    }
                    entityhuman.a(StatisticList.T);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.j(entityhuman);
            }
            return EnumInteractionResult.a;
        }
        return super.b(entityhuman, enumhand);
    }

    public void hd() {
        this.r(40);
        if (!this.ai().B_()) {
            this.b(SoundEffects.Cy);
        }
    }

    private void j(EntityHuman entityhuman) {
        this.k(entityhuman);
        this.g(entityhuman);
        this.a(entityhuman, this.Q_(), this.gR().c());
    }

    @Override
    public void g(@Nullable EntityHuman entityhuman) {
        boolean flag = this.gH() != null && entityhuman == null;
        super.g(entityhuman);
        if (flag) {
            this.gN();
        }
    }

    @Override
    protected void gN() {
        super.gN();
        this.he();
    }

    private void he() {
        if (!this.ai().B_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gT() {
        return true;
    }

    public void gU() {
        this.hj();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.hf();
        this.cQ = this.ai().ae();
        ++this.cR;
    }

    private void hf() {
        MerchantRecipeList merchantrecipelist = this.gJ();
        EntityHuman entityhuman = this.gH();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.cn.l, merchantrecipelist, this.gR().c(), this.t(), this.gK(), this.gT());
        }
    }

    private boolean hg() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
            if (!merchantrecipe.t()) continue;
            return true;
        }
        return false;
    }

    private boolean hh() {
        return this.cR == 0 || this.cR < 2 && this.ai().ae() > this.cQ + 2400L;
    }

    public boolean gV() {
        long i2 = this.cQ + 12000L;
        long j2 = this.ai().ae();
        boolean flag = j2 > i2;
        long k2 = this.ai().af();
        if (this.cS > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cS / 24000L;
            flag |= i1 > l2;
        }
        this.cS = k2;
        if (flag) {
            this.cQ = j2;
            this.hr();
        }
        return this.hh() && this.hg();
    }

    private void hi() {
        int i2 = 2 - this.cR;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.hj();
        }
        this.hf();
    }

    private void hj() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
            merchantrecipe.g();
        }
    }

    private void k(EntityHuman entityhuman) {
        int i2 = this.i(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gJ()) {
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.p()));
            }
        }
        if (entityhuman.d(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.e(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gJ()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().M());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cr, EntityVillager.gW());
    }

    public static VillagerData gW() {
        return new VillagerData(BuiltInRegistries.w.b(VillagerType.c), BuiltInRegistries.x.b(VillagerProfession.b), 1);
    }

    @Override
    protected void a(ValueOutput valueoutput) {
        super.a(valueoutput);
        valueoutput.a("VillagerData", VillagerData.c, this.gR());
        valueoutput.a("FoodLevel", (byte)this.cJ);
        valueoutput.a("Gossips", Reputation.a, this.cM);
        valueoutput.a("Xp", this.cP);
        valueoutput.a("LastRestock", this.cQ);
        valueoutput.a("LastGossipDecay", this.cO);
        valueoutput.a("RestocksToday", this.cR);
        if (this.cT) {
            valueoutput.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    protected void a(ValueInput valueinput) {
        super.a(valueinput);
        this.ay.a(cr, valueinput.a("VillagerData", VillagerData.c).orElseGet(EntityVillager::gW));
        this.cJ = valueinput.a("FoodLevel", (byte)0);
        this.cM.c();
        Optional<Reputation> optional = valueinput.a("Gossips", Reputation.a);
        Reputation reputation = this.cM;
        Objects.requireNonNull(this.cM);
        optional.ifPresent(reputation::a);
        this.cP = valueinput.a("Xp", 0);
        this.cQ = valueinput.a("LastRestock", 0L);
        this.cO = valueinput.a("LastGossipDecay", 0L);
        if (this.ai() instanceof WorldServer) {
            this.g((WorldServer)this.ai());
        }
        this.cR = valueinput.a("RestocksToday", 0);
        this.cT = valueinput.a("AssignProfessionWhenSpawned", false);
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect p() {
        return this.fY() ? null : (this.gI() ? SoundEffects.Cz : SoundEffects.Cu);
    }

    @Override
    protected SoundEffect e(DamageSource damagesource) {
        return SoundEffects.Cx;
    }

    @Override
    protected SoundEffect f_() {
        return SoundEffects.Cw;
    }

    public void gX() {
        this.b(this.gR().b().a().f());
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gR();
        if (!villagerdata1.b().equals(villagerdata.b())) {
            this.cl = null;
        }
        this.ay.a(cr, villagerdata);
    }

    @Override
    public VillagerData gR() {
        return this.ay.a(cr);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.ar.a(4);
        this.cP += merchantrecipe.q();
        this.cH = this.gH();
        if (this.hn()) {
            this.cF = 40;
            this.cG = true;
            i2 += 5;
        }
        if (merchantrecipe.u()) {
            this.ai().b(new EntityExperienceOrb(this.ai(), this.dC(), this.dE() + 0.5, this.dI(), i2));
        }
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.ai() instanceof WorldServer) {
            ((WorldServer)this.ai()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.bO() && entityliving instanceof EntityHuman) {
                this.ai().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            cq.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.G(entity);
        }
        this.hk();
        super.a(damagesource);
    }

    public void hk() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void G(Entity entity) {
        World world = this.ai();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bO.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.ai() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.ai()).q();
            this.bO.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.B();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = cp.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean Y_() {
        return this.cJ + this.hp() >= 12 && !this.fY() && this.Z_() == 0;
    }

    private boolean hl() {
        return this.cJ < 12;
    }

    private void hm() {
        if (this.hl() && this.hp() != 0) {
            for (int i2 = 0; i2 < this.n().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.n().a(i2);
                if (itemstack.f() || (integer = cn.get(itemstack.h())) == null) continue;
                for (int k2 = j2 = itemstack.M(); k2 > 0; --k2) {
                    this.cJ += integer.intValue();
                    this.n().a(i2, 1);
                    if (this.hl()) continue;
                    return;
                }
            }
        }
    }

    public int i(EntityHuman entityhuman) {
        return this.cM.a(entityhuman.cK(), (ReputationType reputationtype) -> true);
    }

    private void u(int i2) {
        this.cJ -= i2;
    }

    public void gY() {
        this.hm();
        this.u(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.cl = merchantrecipelist;
    }

    private boolean hn() {
        int i2 = this.gR().c();
        return VillagerData.d(i2) && this.cP >= VillagerData.c(i2);
    }

    public void ho() {
        this.a(this.gR().a(this.gR().c() + 1));
        this.gO();
    }

    @Override
    protected IChatBaseComponent cD() {
        return this.gR().b().a().a();
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.S);
        } else if (b0 == 13) {
            this.a(Particles.a);
        } else if (b0 == 14) {
            this.a(Particles.Q);
        } else if (b0 == 42) {
            this.a(Particles.ap);
        } else {
            super.b(b0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable GroupDataEntity groupdataentity) {
        if (entityspawnreason == EntitySpawnReason.e) {
            this.a(this.gR().b(worldaccess.K_(), VillagerProfession.b));
        }
        if (entityspawnreason == EntitySpawnReason.n || entityspawnreason == EntitySpawnReason.m || EntitySpawnReason.a(entityspawnreason) || entityspawnreason == EntitySpawnReason.o) {
            this.a(this.gR().a(worldaccess.K_(), VillagerType.a(worldaccess.v(this.dx()))));
        }
        if (entityspawnreason == EntitySpawnReason.d) {
            this.cT = true;
        }
        return super.a(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }

    @Nullable
    public EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.ar.j();
        Holder<VillagerType> holder = d0 < 0.5 ? worldserver.K_().d(VillagerType.a(worldserver.v(this.dx()))) : (d0 < 0.75 ? this.gR().a() : ((EntityVillager)entityageable).gR().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bF, (World)worldserver, holder);
        entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.dx()), EntitySpawnReason.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.an() != EnumDifficulty.a) {
            cq.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = this.convertTo(EntityTypes.bK, ConversionParams.a(this, false, false), entitywitch1 -> {
                entitywitch1.a((WorldAccess)worldserver, worldserver.d_(entitywitch1.dx()), EntitySpawnReason.i, (GroupDataEntity)null);
                entitywitch1.gp();
                this.hk();
            }, EntityTransformEvent.TransformReason.LIGHTNING, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            if (entitywitch == null) {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void a(WorldServer worldserver, EntityItem entityitem) {
        InventoryCarrier.a(worldserver, this, this, entityitem);
    }

    @Override
    public boolean c(WorldServer worldserver, ItemStack itemstack) {
        Item item = itemstack.h();
        return (itemstack.a(TagsItem.bS) || this.gR().b().a().d().contains((Object)item)) && this.n().c(itemstack);
    }

    public boolean gZ() {
        return this.hp() >= 24;
    }

    public boolean ha() {
        return this.hp() < 12;
    }

    private int hp() {
        InventorySubcontainer inventorysubcontainer = this.n();
        return cn.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean hb() {
        return this.n().a_((ItemStack itemstack) -> itemstack.a(TagsItem.bR));
    }

    @Override
    protected void gO() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap;
        VillagerData villagerdata = this.gR();
        ResourceKey resourcekey = villagerdata.b().e().orElse(null);
        if (resourcekey != null && (int2objectmap = this.ai().L().b(FeatureFlags.b) ? ((int2objectmap1 = VillagerTrades.c.get(resourcekey)) != null ? int2objectmap1 : VillagerTrades.a.get(resourcekey)) : VillagerTrades.a.get(resourcekey)) != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gJ();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cN && i2 < this.cN + 1200L || i2 >= entityvillager.cN && i2 < entityvillager.cN + 1200L)) {
            this.cM.a(entityvillager.cM, this.ar, 10);
            this.cN = i2;
            entityvillager.cN = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void hq() {
        long i2 = this.ai().ae();
        if (this.cO == 0L) {
            this.cO = i2;
        } else if (i2 >= this.cO + this.gossipDecayInterval) {
            this.cM.b();
            this.cO = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List<EntityVillager> list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.cV().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).toList()).size() >= j2 && !SpawnUtil.trySpawnMob(EntityTypes.ar, EntitySpawnReason.f, worldserver, this.dx(), 10, 8, 6, SpawnUtil.a.a, false, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isEmpty()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.ai().ae()) ? false : !this.bO.a(MemoryModuleType.G);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        Villager.ReputationEvent bukkitReputationEvent = CraftVillager.CraftReputationEvent.minecraftToBukkit(reputationevent);
        if (reputationevent == ReputationEvent.a) {
            this.cM.add(entity.cK(), ReputationType.d, 20, bukkitReputationEvent);
            this.cM.add(entity.cK(), ReputationType.c, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.e) {
            this.cM.add(entity.cK(), ReputationType.e, 2, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.c) {
            this.cM.add(entity.cK(), ReputationType.b, 25, bukkitReputationEvent);
        } else if (reputationevent == ReputationEvent.d) {
            this.cM.add(entity.cK(), ReputationType.a, 25, bukkitReputationEvent);
        }
    }

    @Override
    public int t() {
        return this.cP;
    }

    public void t(int i2) {
        this.cP = i2;
    }

    private void hr() {
        this.hi();
        this.cR = 0;
    }

    public Reputation hc() {
        return this.cM;
    }

    public void a(Reputation reputation) {
        this.cM.a(reputation);
    }

    @Override
    protected void ah() {
        super.ah();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.bO.a(MemoryModuleType.I, Long.valueOf(this.ai().ae()));
        this.bO.b(MemoryModuleType.n);
        this.bO.b(MemoryModuleType.F);
    }

    @Override
    public void fZ() {
        super.fZ();
        this.bO.a(MemoryModuleType.J, Long.valueOf(this.ai().ae()));
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.bO.c(MemoryModuleType.I);
        return optional.filter(olong -> i2 - olong < 24000L).isPresent();
    }

    @Override
    @Nullable
    public <T> T a(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.av ? EntityVillager.c(datacomponenttype, this.gR().a()) : super.a(datacomponenttype);
    }

    @Override
    protected void a(DataComponentGetter datacomponentgetter) {
        this.a(datacomponentgetter, DataComponents.av);
        super.a(datacomponentgetter);
    }

    @Override
    protected <T> boolean b(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.av) {
            Holder<VillagerType> holder = EntityVillager.c(DataComponents.av, t0);
            this.a(this.gR().a(holder));
            return true;
        }
        return super.b(datacomponenttype, t0);
    }
}

