/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.HashedStack;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.slf4j.Logger;

public abstract class Container {
    private static final Logger m = LogUtils.getLogger();
    public static final int a = -999;
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 0;
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = Integer.MAX_VALUE;
    public static final int i = 9;
    public static final int j = 18;
    public NonNullList<net.minecraft.world.item.ItemStack> n = NonNullList.a();
    public NonNullList<Slot> k = NonNullList.a();
    private final List<ContainerProperty> o = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack p = net.minecraft.world.item.ItemStack.l;
    public NonNullList<RemoteSlot> q = NonNullList.a();
    private final IntList r = new IntArrayList();
    private RemoteSlot s = RemoteSlot.a;
    private int t;
    @Nullable
    private final Containers<?> u;
    public final int l;
    private int v = -1;
    private int w;
    private final Set<Slot> x = Sets.newHashSet();
    private final List<ICrafting> y = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer z;
    private boolean A;
    public boolean checkReachable = true;
    private IChatBaseComponent title;
    protected boolean opened;

    public abstract InventoryView getBukkitView();

    public void transferTo(Container other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final IChatBaseComponent getTitle() {
        Preconditions.checkState((this.title != null ? 1 : 0) != 0, (Object)"Title not set");
        return this.title;
    }

    public final void setTitle(IChatBaseComponent title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    public void startOpen() {
        this.opened = true;
    }

    protected Container(@Nullable Containers<?> containers, int i2) {
        this.u = containers;
        this.l = i2;
    }

    protected void a(IInventory iinventory, int i2, int j2) {
        for (int k2 = 0; k2 < 9; ++k2) {
            this.a(new Slot(iinventory, k2, i2 + k2 * 18, j2));
        }
    }

    protected void b(IInventory iinventory, int i2, int j2) {
        for (int k2 = 0; k2 < 3; ++k2) {
            for (int l2 = 0; l2 < 9; ++l2) {
                this.a(new Slot(iinventory, l2 + (k2 + 1) * 9, i2 + l2 * 18, j2 + k2 * 18));
            }
        }
    }

    protected void c(IInventory iinventory, int i2, int j2) {
        this.b(iinventory, i2, j2);
        int k2 = 4;
        int l2 = 58;
        this.a(iinventory, i2, j2 + 58);
    }

    protected static boolean a(ContainerAccess containeraccess, EntityHuman entityhuman, Block block) {
        return containeraccess.a((World world, BlockPosition blockposition) -> !world.a_((BlockPosition)blockposition).a(block) ? false : entityhuman.a((BlockPosition)blockposition, 4.0), true);
    }

    public Containers<?> a() {
        if (this.u == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.u;
    }

    protected static void a(IInventory iinventory, int i2) {
        int j2 = iinventory.b();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container size " + j2 + " is smaller than expected " + i2);
        }
    }

    protected static void a(IContainerProperties icontainerproperties, int i2) {
        int j2 = icontainerproperties.a();
        if (j2 < i2) {
            throw new IllegalArgumentException("Container data count " + j2 + " is smaller than expected " + i2);
        }
    }

    public boolean a(int i2) {
        return i2 == -1 || i2 == -999 || i2 < this.k.size();
    }

    protected Slot a(Slot slot) {
        slot.d = this.k.size();
        this.k.add(slot);
        this.n.add(net.minecraft.world.item.ItemStack.l);
        this.q.add(this.z != null ? this.z.a() : RemoteSlot.a);
        return slot;
    }

    protected ContainerProperty a(ContainerProperty containerproperty) {
        this.o.add(containerproperty);
        this.r.add(0);
        return containerproperty;
    }

    protected void a(IContainerProperties icontainerproperties) {
        for (int i2 = 0; i2 < icontainerproperties.a(); ++i2) {
            this.a(ContainerProperty.a(icontainerproperties, i2));
        }
    }

    public void a(ICrafting icrafting) {
        if (!this.y.contains(icrafting)) {
            this.y.add(icrafting);
            this.d();
        }
    }

    public void a(ContainerSynchronizer containersynchronizer) {
        this.z = containersynchronizer;
        this.s = containersynchronizer.a();
        this.q.replaceAll(remoteslot -> containersynchronizer.a());
        this.b();
    }

    public void b() {
        ArrayList<net.minecraft.world.item.ItemStack> list = new ArrayList<net.minecraft.world.item.ItemStack>(this.k.size());
        int j2 = this.k.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            list.add(itemstack.v());
            this.q.get(i2).a(itemstack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.g();
        this.s.a(itemstack1);
        int l2 = this.o.size();
        for (int k2 = 0; k2 < l2; ++k2) {
            this.r.set(k2, this.o.get(k2).b());
        }
        if (this.z != null) {
            this.z.a(this, list, itemstack1.v(), this.r.toIntArray());
        }
    }

    public void broadcastCarriedItem() {
        net.minecraft.world.item.ItemStack itemstack = this.g().v();
        this.s.a(itemstack);
        if (this.z != null) {
            this.z.a(this, itemstack);
        }
    }

    public void b(ICrafting icrafting) {
        this.y.remove(icrafting);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.a();
        for (Slot slot : this.k) {
            nonnulllist.add(slot.g());
        }
        return nonnulllist;
    }

    public void d() {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::v);
            this.a(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.b(i2, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.l();
        for (int j2 = 0; j2 < this.o.size(); ++j2) {
            ContainerProperty containerproperty = this.o.get(j2);
            int k2 = containerproperty.b();
            if (containerproperty.c()) {
                this.d(j2, k2);
            }
            this.e(j2, k2);
        }
    }

    public void e() {
        for (int i2 = 0; i2 < this.k.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            Objects.requireNonNull(itemstack);
            this.a(i2, itemstack, itemstack::v);
        }
        for (int j2 = 0; j2 < this.o.size(); ++j2) {
            ContainerProperty containerproperty = this.o.get(j2);
            if (!containerproperty.c()) continue;
            this.d(j2, containerproperty.b());
        }
        this.b();
    }

    private void d(int i2, int j2) {
        for (ICrafting icrafting : this.y) {
            icrafting.a(this, i2, j2);
        }
    }

    private void a(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.n.get(i2);
        if (!net.minecraft.world.item.ItemStack.a(itemstack1, itemstack)) {
            net.minecraft.world.item.ItemStack itemstack2 = supplier.get();
            this.n.set(i2, itemstack2);
            for (ICrafting icrafting : this.y) {
                icrafting.a(this, i2, itemstack2);
            }
        }
    }

    private void b(int i2, net.minecraft.world.item.ItemStack itemstack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        RemoteSlot remoteslot;
        if (!this.A && !(remoteslot = this.q.get(i2)).b(itemstack)) {
            remoteslot.a(itemstack);
            if (this.z != null) {
                this.z.a(this, i2, supplier.get());
            }
        }
    }

    private void e(int i2, int j2) {
        int k2;
        if (!this.A && (k2 = this.r.getInt(i2)) != j2) {
            this.r.set(i2, j2);
            if (this.z != null) {
                this.z.a(this, i2, j2);
            }
        }
    }

    private void l() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.A && !this.s.b(itemstack = this.g())) {
            this.s.a(itemstack);
            if (this.z != null) {
                this.z.a(this, itemstack.v());
            }
        }
    }

    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        this.q.get(i2).a(itemstack);
    }

    public void a(int i2, HashedStack hashedstack) {
        if (i2 >= 0 && i2 < this.q.size()) {
            this.q.get(i2).a(hashedstack);
        } else {
            m.debug("Incorrect slot index: {} available slots: {}", (Object)i2, (Object)this.q.size());
        }
    }

    public void a(HashedStack hashedstack) {
        this.s.a(hashedstack);
    }

    public boolean a(EntityHuman entityhuman, int i2) {
        return false;
    }

    public Slot b(int i2) {
        return this.k.get(i2);
    }

    public abstract net.minecraft.world.item.ItemStack b(EntityHuman var1, int var2);

    public void a(int i2, int j2) {
        if (i2 >= 0 && i2 < this.k.size()) {
            net.minecraft.world.item.ItemStack itemstack = this.k.get(i2).g();
            BundleItem.a(itemstack, j2);
        }
    }

    public void a(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        try {
            this.b(i2, j2, inventoryclicktype, entityhuman);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.a(exception, "Container click");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Click info");
            crashreportsystemdetails.a("Menu Type", () -> this.u != null ? BuiltInRegistries.p.b(this.u).toString() : "<no type>");
            crashreportsystemdetails.a("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.a("Slot Count", this.k.size());
            crashreportsystemdetails.a("Slot", i2);
            crashreportsystemdetails.a("Button", j2);
            crashreportsystemdetails.a("Type", (Object)inventoryclicktype);
            throw new ReportedException(crashreport);
        }
    }

    private void b(int i2, int j2, InventoryClickType inventoryclicktype, EntityHuman entityhuman) {
        block48: {
            block60: {
                block56: {
                    net.minecraft.world.item.ItemStack itemstack7;
                    Slot slot4;
                    net.minecraft.world.item.ItemStack itemstack62;
                    PlayerInventory playerinventory;
                    block59: {
                        block58: {
                            block57: {
                                block53: {
                                    ClickAction clickaction;
                                    block55: {
                                        block54: {
                                            block52: {
                                                block46: {
                                                    block51: {
                                                        net.minecraft.world.item.ItemStack itemstack;
                                                        block50: {
                                                            block49: {
                                                                block47: {
                                                                    playerinventory = entityhuman.gs();
                                                                    if (inventoryclicktype != InventoryClickType.f) break block46;
                                                                    int k2 = this.w;
                                                                    this.w = Container.d(j2);
                                                                    if (k2 == 1 && this.w == 2 || k2 == this.w) break block47;
                                                                    this.f();
                                                                    break block48;
                                                                }
                                                                if (!this.g().f()) break block49;
                                                                this.f();
                                                                break block48;
                                                            }
                                                            if (this.w != 0) break block50;
                                                            this.v = Container.c(j2);
                                                            if (Container.a(this.v, entityhuman)) {
                                                                this.w = 1;
                                                                this.x.clear();
                                                            } else {
                                                                this.f();
                                                            }
                                                            break block48;
                                                        }
                                                        if (this.w != 1) break block51;
                                                        Slot slot = this.k.get(i2);
                                                        if (!Container.a(slot, itemstack = this.g(), true) || !slot.a(itemstack) || this.v != 2 && itemstack.M() <= this.x.size() || !this.b(slot)) break block48;
                                                        this.x.add(slot);
                                                        break block48;
                                                    }
                                                    if (this.w == 2) {
                                                        if (!this.x.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack1 = this.g().v();
                                                            if (itemstack1.f()) {
                                                                this.f();
                                                                return;
                                                            }
                                                            int i1 = this.g().M();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            for (Slot slot1 : this.x) {
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.g();
                                                                if (slot1 == null || !Container.a(slot1, itemstack2, true) || !slot1.a(itemstack2) || this.v != 2 && itemstack2.M() < this.x.size() || !this.b(slot1)) continue;
                                                                int j1 = slot1.h() ? slot1.g().M() : 0;
                                                                int k1 = Math.min(itemstack1.k(), slot1.b_(itemstack1));
                                                                int l1 = Math.min(Container.a(this.x, this.v, itemstack1) + j1, k1);
                                                                i1 -= l1 - j1;
                                                                draggedSlots.put(slot1.d, itemstack1.c(l1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack1);
                                                            newcursor.setAmount(i1);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.g();
                                                            this.a(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.v == 1, eventmap);
                                                            entityhuman.ai().getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.g() != null) {
                                                                    this.a(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.a(oldCursor);
                                                            }
                                                            if (needsUpdate && entityhuman instanceof EntityPlayer) {
                                                                this.b();
                                                            }
                                                        }
                                                        this.f();
                                                    } else {
                                                        this.f();
                                                    }
                                                    break block48;
                                                }
                                                if (this.w == 0) break block52;
                                                this.f();
                                                break block48;
                                            }
                                            if (inventoryclicktype != InventoryClickType.a && inventoryclicktype != InventoryClickType.b || j2 != 0 && j2 != 1) break block53;
                                            ClickAction clickAction = clickaction = j2 == 0 ? ClickAction.a : ClickAction.b;
                                            if (i2 != -999) break block54;
                                            if (this.g().f()) break block48;
                                            if (clickaction == ClickAction.a) {
                                                net.minecraft.world.item.ItemStack carried = this.g();
                                                this.a(net.minecraft.world.item.ItemStack.l);
                                                entityhuman.a(carried, true);
                                            } else {
                                                entityhuman.a(this.g().a(1), true);
                                            }
                                            break block48;
                                        }
                                        if (inventoryclicktype != InventoryClickType.b) break block55;
                                        if (i2 < 0) {
                                            return;
                                        }
                                        Slot slot2 = this.k.get(i2);
                                        if (!slot2.a(entityhuman)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.b(entityhuman, i2);
                                        while (!itemstack3.f() && net.minecraft.world.item.ItemStack.b(slot2.g(), itemstack3)) {
                                            itemstack3 = this.b(entityhuman, i2);
                                        }
                                        break block48;
                                    }
                                    if (i2 < 0) {
                                        return;
                                    }
                                    Slot slot3 = this.k.get(i2);
                                    net.minecraft.world.item.ItemStack itemstack4 = slot3.g();
                                    net.minecraft.world.item.ItemStack itemstack5 = this.g();
                                    entityhuman.a(itemstack5, slot3.g(), clickaction);
                                    if (!this.a(entityhuman, clickaction, slot3, itemstack4, itemstack5)) {
                                        if (itemstack4.f()) {
                                            if (!itemstack5.f()) {
                                                int i22 = clickaction == ClickAction.a ? itemstack5.M() : 1;
                                                this.a(slot3.b(itemstack5, i22));
                                            }
                                        } else if (slot3.a(entityhuman)) {
                                            if (itemstack5.f()) {
                                                int j22 = clickaction == ClickAction.a ? itemstack4.M() : (itemstack4.M() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot3.a(j22, Integer.MAX_VALUE, entityhuman);
                                                optional.ifPresent(itemstack6 -> {
                                                    this.a((net.minecraft.world.item.ItemStack)itemstack6);
                                                    slot3.a(entityhuman, (net.minecraft.world.item.ItemStack)itemstack6);
                                                });
                                            } else if (slot3.a(itemstack5)) {
                                                if (net.minecraft.world.item.ItemStack.c(itemstack4, itemstack5)) {
                                                    int k2 = clickaction == ClickAction.a ? itemstack5.M() : 1;
                                                    this.a(slot3.b(itemstack5, k2));
                                                } else if (itemstack5.M() <= slot3.b_(itemstack5)) {
                                                    this.a(itemstack4);
                                                    slot3.e(itemstack5);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.c(itemstack4, itemstack5)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot3.a(itemstack4.M(), itemstack5.k() - itemstack5.M(), entityhuman);
                                                optional1.ifPresent(itemstack6 -> {
                                                    itemstack5.g(itemstack6.M());
                                                    slot3.a(entityhuman, (net.minecraft.world.item.ItemStack)itemstack6);
                                                });
                                            }
                                        }
                                    }
                                    slot3.d();
                                    if (!(entityhuman instanceof EntityPlayer) || slot3.a() == 99) break block48;
                                    ((EntityPlayer)entityhuman).g.b(new PacketPlayOutSetSlot(this.l, this.k(), slot3.d, slot3.g()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((EntityPlayer)entityhuman).g.b(new PacketPlayOutSetSlot(this.l, this.k(), 0, this.b(0).g()));
                                    }
                                    break block48;
                                }
                                if (inventoryclicktype != InventoryClickType.c || (j2 < 0 || j2 >= 9) && j2 != 40) break block56;
                                itemstack62 = playerinventory.a(j2);
                                slot4 = this.k.get(i2);
                                itemstack7 = slot4.g();
                                if (itemstack62.f() && itemstack7.f()) break block48;
                                if (!itemstack62.f()) break block57;
                                if (!slot4.a(entityhuman)) break block48;
                                playerinventory.a(j2, itemstack7);
                                slot4.b(itemstack7.M());
                                slot4.e(net.minecraft.world.item.ItemStack.l);
                                slot4.a(entityhuman, itemstack7);
                                break block48;
                            }
                            if (!itemstack7.f()) break block58;
                            if (!slot4.a(itemstack62)) break block48;
                            int l2 = slot4.b_(itemstack62);
                            if (itemstack62.M() > l2) {
                                slot4.e(itemstack62.a(l2));
                            } else {
                                playerinventory.a(j2, net.minecraft.world.item.ItemStack.l);
                                slot4.e(itemstack62);
                            }
                            break block48;
                        }
                        if (!slot4.a(entityhuman) || !slot4.a(itemstack62)) break block48;
                        int i3 = slot4.b_(itemstack62);
                        if (itemstack62.M() <= i3) break block59;
                        slot4.e(itemstack62.a(i3));
                        slot4.a(entityhuman, itemstack7);
                        if (playerinventory.g(itemstack7)) break block48;
                        entityhuman.a(itemstack7, true);
                        break block48;
                    }
                    playerinventory.a(j2, itemstack7);
                    slot4.e(itemstack62);
                    slot4.a(entityhuman, itemstack7);
                    break block48;
                }
                if (inventoryclicktype != InventoryClickType.d || !entityhuman.gc() || !this.g().f() || i2 < 0) break block60;
                Slot slot5 = this.k.get(i2);
                if (!slot5.h()) break block48;
                net.minecraft.world.item.ItemStack itemstack8 = slot5.g();
                this.a(itemstack8.c(itemstack8.k()));
                break block48;
            }
            if (inventoryclicktype == InventoryClickType.e && this.g().f() && i2 >= 0) {
                int j3;
                Slot slot6 = this.k.get(i2);
                int n2 = j3 = j2 == 0 ? 1 : slot6.g().M();
                if (!entityhuman.gw()) {
                    return;
                }
                net.minecraft.world.item.ItemStack itemstack9 = slot6.b(j3, Integer.MAX_VALUE, entityhuman);
                entityhuman.a(itemstack9, true);
                entityhuman.g(itemstack9);
                if (j2 == 1) {
                    while (!itemstack9.f() && net.minecraft.world.item.ItemStack.b(slot6.g(), itemstack9)) {
                        if (!entityhuman.gw()) {
                            return;
                        }
                        itemstack9 = slot6.b(j3, Integer.MAX_VALUE, entityhuman);
                        if (entityhuman.a(itemstack9, true) != null) {
                            entityhuman.g(itemstack9);
                            continue;
                        }
                        break;
                    }
                }
            } else if (inventoryclicktype == InventoryClickType.g && i2 >= 0) {
                Slot slot7 = this.k.get(i2);
                net.minecraft.world.item.ItemStack itemstack10 = this.g();
                if (!(itemstack10.f() || slot7.h() && slot7.a(entityhuman))) {
                    int k3 = j2 == 0 ? 0 : this.k.size() - 1;
                    int l3 = j2 == 0 ? 1 : -1;
                    for (int i4 = 0; i4 < 2; ++i4) {
                        for (int j4 = k3; j4 >= 0 && j4 < this.k.size() && itemstack10.M() < itemstack10.k(); j4 += l3) {
                            Slot slot8 = this.k.get(j4);
                            if (!slot8.h() || !Container.a(slot8, itemstack10, true) || !slot8.a(entityhuman) || !this.a(itemstack10, slot8)) continue;
                            net.minecraft.world.item.ItemStack itemstack11 = slot8.g();
                            if (i4 == 0 && itemstack11.M() == itemstack11.k()) continue;
                            net.minecraft.world.item.ItemStack itemstack12 = slot8.b(itemstack11.M(), itemstack10.k() - itemstack10.M(), entityhuman);
                            itemstack10.g(itemstack12.M());
                        }
                    }
                }
            }
        }
    }

    private boolean a(EntityHuman entityhuman, ClickAction clickaction, Slot slot, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        FeatureFlagSet featureflagset = entityhuman.ai().L();
        return itemstack1.a(featureflagset) && itemstack1.a(slot, clickaction, entityhuman) ? true : itemstack.a(featureflagset) && itemstack.a(itemstack1, slot, clickaction, entityhuman, this.m());
    }

    private SlotAccess m() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack a() {
                return Container.this.g();
            }

            @Override
            public boolean a(net.minecraft.world.item.ItemStack itemstack) {
                Container.this.a(itemstack);
                return true;
            }
        };
    }

    public boolean a(net.minecraft.world.item.ItemStack itemstack, Slot slot) {
        return true;
    }

    public void a(EntityHuman entityhuman) {
        net.minecraft.world.item.ItemStack itemstack;
        if (entityhuman instanceof EntityPlayer && !(itemstack = this.g()).f()) {
            this.a(net.minecraft.world.item.ItemStack.l);
            Container.a(entityhuman, itemstack);
        }
    }

    private static void a(EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack) {
        EntityPlayer entityplayer;
        boolean flag = entityhuman.dU() && entityhuman.dV() != Entity.RemovalReason.e;
        boolean flag1 = entityhuman instanceof EntityPlayer && (entityplayer = (EntityPlayer)entityhuman).u();
        boolean flag2 = flag1;
        if (!flag && !flag2) {
            if (entityhuman instanceof EntityPlayer) {
                entityhuman.gs().h(itemstack);
            }
        } else {
            entityhuman.a(itemstack, false);
        }
    }

    protected void a(EntityHuman entityhuman, IInventory iinventory) {
        for (int i2 = 0; i2 < iinventory.b(); ++i2) {
            Container.a(entityhuman, iinventory.b(i2));
        }
    }

    public void a(IInventory iinventory) {
        this.d();
    }

    public void a(int i2, int j2, net.minecraft.world.item.ItemStack itemstack) {
        this.b(i2).f(itemstack);
        this.t = j2;
    }

    public void a(int i2, List<net.minecraft.world.item.ItemStack> list, net.minecraft.world.item.ItemStack itemstack) {
        for (int j2 = 0; j2 < list.size(); ++j2) {
            this.b(j2).f(list.get(j2));
        }
        this.p = itemstack;
        this.t = i2;
    }

    public void b(int i2, int j2) {
        this.o.get(i2).a(j2);
    }

    public abstract boolean b(EntityHuman var1);

    protected boolean a(net.minecraft.world.item.ItemStack itemstack, int i2, int j2, boolean flag) {
        boolean flag1 = false;
        int k2 = i2;
        if (flag) {
            k2 = j2 - 1;
        }
        if (itemstack.l()) {
            while (!itemstack.f() && !(!flag ? k2 >= j2 : k2 < i2)) {
                Slot slot = this.k.get(k2);
                net.minecraft.world.item.ItemStack itemstack1 = slot.g();
                if (!itemstack1.f() && net.minecraft.world.item.ItemStack.c(itemstack, itemstack1)) {
                    int i1;
                    int l2 = itemstack1.M() + itemstack.M();
                    if (l2 <= (i1 = slot.b_(itemstack1))) {
                        itemstack.e(0);
                        itemstack1.e(l2);
                        slot.d();
                        flag1 = true;
                    } else if (itemstack1.M() < i1) {
                        itemstack.h(i1 - itemstack1.M());
                        itemstack1.e(i1);
                        slot.d();
                        flag1 = true;
                    }
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        if (!itemstack.f()) {
            k2 = flag ? j2 - 1 : i2;
            while (!(!flag ? k2 >= j2 : k2 < i2)) {
                Slot slot1 = this.k.get(k2);
                net.minecraft.world.item.ItemStack itemstack2 = slot1.g();
                if (itemstack2.f() && slot1.a(itemstack)) {
                    int j1 = slot1.b_(itemstack);
                    slot1.e(itemstack.a(Math.min(itemstack.M(), j1)));
                    slot1.d();
                    flag1 = true;
                    break;
                }
                if (flag) {
                    --k2;
                    continue;
                }
                ++k2;
            }
        }
        return flag1;
    }

    public static int c(int i2) {
        return i2 >> 2 & 3;
    }

    public static int d(int i2) {
        return i2 & 3;
    }

    public static int c(int i2, int j2) {
        return i2 & 3 | (j2 & 3) << 2;
    }

    public static boolean a(int i2, EntityHuman entityhuman) {
        return i2 == 0 ? true : (i2 == 1 ? true : i2 == 2 && entityhuman.gc());
    }

    protected void f() {
        this.w = 0;
        this.x.clear();
    }

    public static boolean a(@Nullable Slot slot, net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.h();
        return !flag1 && net.minecraft.world.item.ItemStack.c(itemstack, slot.g()) ? slot.g().M() + (flag ? 0 : itemstack.M()) <= itemstack.k() : flag1;
    }

    public static int a(Set<Slot> set, int i2, net.minecraft.world.item.ItemStack itemstack) {
        return switch (i2) {
            case 0 -> MathHelper.d((float)itemstack.M() / (float)set.size());
            case 1 -> 1;
            case 2 -> itemstack.k();
            default -> itemstack.M();
        };
    }

    public boolean b(Slot slot) {
        return true;
    }

    public static int a(@Nullable TileEntity tileentity) {
        return tileentity instanceof IInventory ? Container.b((IInventory)((Object)tileentity)) : 0;
    }

    public static int b(@Nullable IInventory iinventory) {
        if (iinventory == null) {
            return 0;
        }
        float f2 = 0.0f;
        for (int i2 = 0; i2 < iinventory.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = iinventory.a(i2);
            if (itemstack.f()) continue;
            f2 += (float)itemstack.M() / (float)iinventory.f_(itemstack);
        }
        return MathHelper.b(f2 /= (float)iinventory.b(), 0, 15);
    }

    public void a(net.minecraft.world.item.ItemStack itemstack) {
        this.p = itemstack;
    }

    public net.minecraft.world.item.ItemStack g() {
        if (this.p.f()) {
            this.a(net.minecraft.world.item.ItemStack.l);
        }
        return this.p;
    }

    public void h() {
        this.A = true;
    }

    public void i() {
        this.A = false;
    }

    public void a(Container container) {
        HashBasedTable table = HashBasedTable.create();
        for (int i2 = 0; i2 < container.k.size(); ++i2) {
            Slot slot = container.k.get(i2);
            table.put((Object)slot.c, (Object)slot.i(), (Object)i2);
        }
        for (int j2 = 0; j2 < this.k.size(); ++j2) {
            Slot slot1 = this.k.get(j2);
            Integer integer = (Integer)table.get((Object)slot1.c, (Object)slot1.i());
            if (integer == null) continue;
            this.n.set(j2, container.n.get(integer));
            RemoteSlot remoteslot = container.q.get(integer);
            RemoteSlot remoteslot1 = this.q.get(j2);
            if (!(remoteslot instanceof RemoteSlot.a)) continue;
            RemoteSlot.a remoteslot_a = (RemoteSlot.a)remoteslot;
            if (!(remoteslot1 instanceof RemoteSlot.a)) continue;
            RemoteSlot.a remoteslot_a1 = (RemoteSlot.a)remoteslot1;
            remoteslot_a1.a(remoteslot_a);
        }
    }

    public OptionalInt b(IInventory iinventory, int i2) {
        for (int j2 = 0; j2 < this.k.size(); ++j2) {
            Slot slot = this.k.get(j2);
            if (slot.c != iinventory || i2 != slot.i()) continue;
            return OptionalInt.of(j2);
        }
        return OptionalInt.empty();
    }

    public int j() {
        return this.t;
    }

    public int k() {
        this.t = this.t + 1 & Short.MAX_VALUE;
        return this.t;
    }
}

