/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public final class ItemContainerContents
implements TooltipProvider {
    private static final int d = -1;
    private static final int e = 256;
    public static final ItemContainerContents a = new ItemContainerContents(NonNullList.a());
    public static final Codec<ItemContainerContents> b = net.minecraft.world.item.component.ItemContainerContents$a.a.sizeLimitedListOf(256).xmap(ItemContainerContents::b, ItemContainerContents::f);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> c = ItemStack.h.a(ByteBufCodecs.c(256)).a(ItemContainerContents::new, var0 -> var0.f);
    private final NonNullList<ItemStack> f;
    private final int g;

    private ItemContainerContents(NonNullList<ItemStack> var0) {
        if (var0.size() > 256) {
            throw new IllegalArgumentException("Got " + var0.size() + " items, but maximum is 256");
        }
        this.f = var0;
        this.g = ItemStack.a(var0);
    }

    private ItemContainerContents(int var0) {
        this(NonNullList.a(var0, ItemStack.l));
    }

    private ItemContainerContents(List<ItemStack> var0) {
        this(var0.size());
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            this.f.set(var1, var0.get(var1));
        }
    }

    private static ItemContainerContents b(List<a> var0) {
        OptionalInt var1 = var0.stream().mapToInt(a::a).max();
        if (var1.isEmpty()) {
            return a;
        }
        ItemContainerContents var2 = new ItemContainerContents(var1.getAsInt() + 1);
        for (a var4 : var0) {
            var2.f.set(var4.a(), var4.b());
        }
        return var2;
    }

    public static ItemContainerContents a(List<ItemStack> var0) {
        int var1 = ItemContainerContents.c(var0);
        if (var1 == -1) {
            return a;
        }
        ItemContainerContents var2 = new ItemContainerContents(var1 + 1);
        for (int var3 = 0; var3 <= var1; ++var3) {
            var2.f.set(var3, var0.get(var3).v());
        }
        return var2;
    }

    private static int c(List<ItemStack> var0) {
        for (int var1 = var0.size() - 1; var1 >= 0; --var1) {
            if (var0.get(var1).f()) continue;
            return var1;
        }
        return -1;
    }

    private List<a> f() {
        ArrayList<a> var0 = new ArrayList<a>();
        for (int var1 = 0; var1 < this.f.size(); ++var1) {
            ItemStack var2 = this.f.get(var1);
            if (var2.f()) continue;
            var0.add(new a(var1, var2));
        }
        return var0;
    }

    public void a(NonNullList<ItemStack> var0) {
        for (int var1 = 0; var1 < var0.size(); ++var1) {
            ItemStack var2 = var1 < this.f.size() ? this.f.get(var1) : ItemStack.l;
            var0.set(var1, var2.v());
        }
    }

    public ItemStack a() {
        return this.f.isEmpty() ? ItemStack.l : this.f.get(0).v();
    }

    public Stream<ItemStack> b() {
        return this.f.stream().map(ItemStack::v);
    }

    public Stream<ItemStack> c() {
        return this.f.stream().filter(var0 -> !var0.f()).map(ItemStack::v);
    }

    public Iterable<ItemStack> d() {
        return Iterables.filter(this.f, var0 -> !var0.f());
    }

    public Iterable<ItemStack> e() {
        return Iterables.transform(this.d(), ItemStack::v);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ItemContainerContents)) return false;
        ItemContainerContents var1 = (ItemContainerContents)var0;
        if (!ItemStack.a(this.f, var1.f)) return false;
        return true;
    }

    public int hashCode() {
        return this.g;
    }

    @Override
    public void a(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        int var4 = 0;
        int var5 = 0;
        for (ItemStack var7 : this.d()) {
            ++var5;
            if (var4 > 4) continue;
            ++var4;
            var1.accept(IChatBaseComponent.a("item.container.item_count", var7.y(), var7.M()));
        }
        if (var5 - var4 > 0) {
            var1.accept(IChatBaseComponent.a("item.container.more_items", var5 - var4).a(EnumChatFormat.u));
        }
    }

    static final class a
    extends Record {
        private final int b;
        private final ItemStack c;
        public static final Codec<a> a = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.intRange((int)0, (int)255).fieldOf("slot").forGetter(a::a), (App)ItemStack.b.fieldOf("item").forGetter(a::b)).apply((Applicative)var0, a::new));

        a(int var0, ItemStack var1) {
            this.b = var0;
            this.c = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "index;item", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "index;item", "b", "c"}, this, var0);
        }

        public int a() {
            return this.b;
        }

        public ItemStack b() {
            return this.c;
        }
    }
}

