/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments a = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap());
    private static final Codec<Integer> d = Codec.intRange((int)1, (int)255);
    public static final Codec<ItemEnchantments> b = Codec.unboundedMap(Enchantment.c, d).xmap(var0 -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(var0)), var0 -> var0.e);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> c = StreamCodec.a(ByteBufCodecs.a(Object2IntOpenHashMap::new, Enchantment.d, ByteBufCodecs.h), (C var0) -> var0.e, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> e;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> var0) {
        this.e = var0;
        for (Object2IntMap.Entry var2 : var0.object2IntEntrySet()) {
            int var3 = var2.getIntValue();
            if (var3 >= 0 && var3 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(var2.getKey()) + " has invalid level " + var3);
        }
    }

    public int a(Holder<Enchantment> var0) {
        return this.e.getInt(var0);
    }

    @Override
    public void a(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2, DataComponentGetter var3) {
        HolderLookup.a var4 = var0.a();
        HolderSet<Enchantment> var5 = ItemEnchantments.a(var4, Registries.aW, EnchantmentTags.a);
        for (Holder holder : var5) {
            int var8 = this.e.getInt((Object)holder);
            if (var8 <= 0) continue;
            var1.accept(Enchantment.a((Holder<Enchantment>)holder, var8));
        }
        for (Object2IntMap.Entry entry : this.e.object2IntEntrySet()) {
            Holder var8 = (Holder)entry.getKey();
            if (var5.a(var8)) continue;
            var1.accept(Enchantment.a((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> a(@Nullable HolderLookup.a var0, ResourceKey<IRegistry<T>> var1, TagKey<T> var2) {
        Optional<HolderSet.Named<T>> var3;
        if (var0 != null && (var3 = var0.e(var1).a(var2)).isPresent()) {
            return var3.get();
        }
        return HolderSet.a(new Holder[0]);
    }

    public Set<Holder<Enchantment>> a() {
        return Collections.unmodifiableSet(this.e.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> b() {
        return Collections.unmodifiableSet(this.e.object2IntEntrySet());
    }

    public int c() {
        return this.e.size();
    }

    public boolean d() {
        return this.e.isEmpty();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ItemEnchantments) {
            ItemEnchantments var1 = (ItemEnchantments)var0;
            return this.e.equals(var1.e);
        }
        return false;
    }

    public int hashCode() {
        return this.e.hashCode();
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.e) + "}";
    }

    public static class a {
        private final Object2IntOpenHashMap<Holder<Enchantment>> a = new Object2IntOpenHashMap();

        public a(ItemEnchantments var0) {
            this.a.putAll(var0.e);
        }

        public void a(Holder<Enchantment> var0, int var1) {
            if (var1 <= 0) {
                this.a.removeInt(var0);
            } else {
                this.a.put(var0, Math.min(var1, 255));
            }
        }

        public void b(Holder<Enchantment> var0, int var1) {
            if (var1 > 0) {
                this.a.merge(var0, Math.min(var1, 255), Integer::max);
            }
        }

        public void a(Predicate<Holder<Enchantment>> var0) {
            this.a.keySet().removeIf(var0);
        }

        public int a(Holder<Enchantment> var0) {
            return this.a.getOrDefault(var0, 0);
        }

        public Set<Holder<Enchantment>> a() {
            return this.a.keySet();
        }

        public ItemEnchantments b() {
            return new ItemEnchantments(this.a);
        }
    }
}

