/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.slf4j.Logger;

public class Block
extends BlockBase
implements IMaterial {
    public static final MapCodec<Block> j = Block.b(Block::new);
    private static final Logger a = LogUtils.getLogger();
    private final Holder.c<Block> b = BuiltInRegistries.e.f(this);
    public static final RegistryBlockID<IBlockData> k = new RegistryBlockID();
    private static final LoadingCache<VoxelShape, Boolean> c = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean a(VoxelShape voxelshape) {
            return !VoxelShapes.c(VoxelShapes.b(), voxelshape, OperatorBoolean.g);
        }
    });
    public static final int l = 1;
    public static final int m = 2;
    public static final int n = 4;
    public static final int o = 8;
    public static final int p = 16;
    public static final int q = 32;
    public static final int r = 64;
    public static final int s = 128;
    public static final int t = 256;
    public static final int u = 512;
    public static final int v = 260;
    public static final int w = 3;
    public static final int x = 11;
    public static final int y = 816;
    public static final float z = -1.0f;
    public static final float A = 0.0f;
    public static final int B = 512;
    protected final BlockStateList<Block, IBlockData> C;
    private IBlockData d;
    @Nullable
    private Item e;
    private static final int f = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> g = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<a>(256, 0.25f){

            protected void rehash(int i2) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    @Override
    protected MapCodec<? extends Block> a() {
        return j;
    }

    public static int j(@Nullable IBlockData iblockdata) {
        if (iblockdata == null) {
            return 0;
        }
        int i2 = k.a(iblockdata);
        return i2 == -1 ? 0 : i2;
    }

    public static IBlockData a(int i2) {
        IBlockData iblockdata = k.a(i2);
        return iblockdata == null ? Blocks.a.m() : iblockdata;
    }

    public static Block a(@Nullable Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).c() : Blocks.a;
    }

    public static IBlockData a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        VoxelShape voxelshape = VoxelShapes.b(iblockdata.g(generatoraccess, blockposition), iblockdata1.g(generatoraccess, blockposition), OperatorBoolean.c).a(blockposition);
        if (voxelshape.c()) {
            return iblockdata1;
        }
        for (Entity entity : generatoraccess.a_(null, voxelshape.a())) {
            double d0 = VoxelShapes.a(EnumDirection.EnumAxis.b, entity.cV().d(0.0, 1.0, 0.0), List.of(voxelshape), -1.0);
            entity.c(0.0, 1.0 + d0, 0.0);
        }
        return iblockdata1;
    }

    public static VoxelShape a(double d0, double d1, double d2, double d3, double d4, double d5) {
        return VoxelShapes.a(d0 / 16.0, d1 / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0);
    }

    public static VoxelShape[] a(int i2, IntFunction<VoxelShape> intfunction) {
        return (VoxelShape[])IntStream.rangeClosed(0, i2).mapToObj(intfunction).toArray(VoxelShape[]::new);
    }

    public static VoxelShape a(double d0) {
        return Block.a(d0, d0, d0);
    }

    public static VoxelShape a(double d0, double d1, double d2) {
        double d3 = d1 / 2.0;
        return Block.a(d0, d2, 8.0 - d3, 8.0 + d3);
    }

    public static VoxelShape b(double d0, double d1, double d2) {
        return Block.a(d0, d0, d1, d2);
    }

    public static VoxelShape a(double d0, double d1, double d2, double d3) {
        double d4 = d0 / 2.0;
        double d5 = d1 / 2.0;
        return Block.a(8.0 - d4, d2, 8.0 - d5, 8.0 + d4, d3, 8.0 + d5);
    }

    public static VoxelShape c(double d0, double d1, double d2) {
        return Block.b(d0, d0, d1, d2);
    }

    public static VoxelShape b(double d0, double d1, double d2, double d3) {
        double d4 = d1 / 2.0;
        return Block.a(d0, 8.0 - d4, 8.0 + d4, d2, d3);
    }

    public static VoxelShape a(double d0, double d1, double d2, double d3, double d4) {
        double d5 = d0 / 2.0;
        return Block.a(8.0 - d5, d1, d3, 8.0 + d5, d2, d4);
    }

    public static IBlockData b(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        IBlockData iblockdata1 = iblockdata;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : E) {
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection);
            iblockdata1 = iblockdata1.a(generatoraccess, generatoraccess, blockposition, enumdirection, blockposition_mutableblockposition, generatoraccess.a_(blockposition_mutableblockposition), generatoraccess.H_());
        }
        return iblockdata1;
    }

    public static void a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
        Block.a(iblockdata, iblockdata1, generatoraccess, blockposition, i2, 512);
    }

    public static void a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
        if (iblockdata1 != iblockdata) {
            if (iblockdata1.l()) {
                if (!generatoraccess.B_()) {
                    generatoraccess.a(blockposition, (i2 & 0x20) == 0, (Entity)null, j2);
                }
            } else {
                generatoraccess.a(blockposition, iblockdata1, i2 & 0xFFFFFFDF, j2);
            }
        }
    }

    public Block(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        String s2;
        BlockStateList.a<Block, IBlockData> blockstatelist_a = new BlockStateList.a<Block, IBlockData>(this);
        this.a(blockstatelist_a);
        this.C = blockstatelist_a.a(Block::m, IBlockData::new);
        this.l(this.C.b());
        if (SharedConstants.aZ && !(s2 = this.getClass().getSimpleName()).endsWith("Block")) {
            a.error("Block classes should end with Block and {} doesn't.", (Object)s2);
        }
    }

    public static boolean k(IBlockData iblockdata) {
        return iblockdata.b() instanceof BlockLeaves || iblockdata.a(Blocks.iy) || iblockdata.a(Blocks.ev) || iblockdata.a(Blocks.ew) || iblockdata.a(Blocks.fs) || iblockdata.a(Blocks.fr) || iblockdata.a(TagsBlock.ag);
    }

    public static boolean a(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        VoxelShape voxelshape = iblockdata1.a(enumdirection.g());
        if (voxelshape == VoxelShapes.b()) {
            return false;
        }
        if (iblockdata.a(iblockdata1, enumdirection)) {
            return false;
        }
        if (voxelshape == VoxelShapes.a()) {
            return true;
        }
        VoxelShape voxelshape1 = iblockdata.a(enumdirection);
        if (voxelshape1 == VoxelShapes.a()) {
            return true;
        }
        a block_a = new a(voxelshape1, voxelshape);
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = g.get();
        byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
        if (b0 != 127) {
            return b0 != 0;
        }
        boolean flag = VoxelShapes.c(voxelshape1, voxelshape, OperatorBoolean.e);
        if (object2bytelinkedopenhashmap.size() == 256) {
            object2bytelinkedopenhashmap.removeLastByte();
        }
        object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
        return flag;
    }

    public static boolean c(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.a_(blockposition).a(iblockaccess, blockposition, EnumDirection.b, EnumBlockSupport.c);
    }

    public static boolean a(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = iworldreader.a_(blockposition);
        return enumdirection == EnumDirection.a && iblockdata.a(TagsBlock.bc) ? false : iblockdata.a((IBlockAccess)iworldreader, blockposition, enumdirection, EnumBlockSupport.b);
    }

    public static boolean a(VoxelShape voxelshape, EnumDirection enumdirection) {
        VoxelShape voxelshape1 = voxelshape.a(enumdirection);
        return Block.a(voxelshape1);
    }

    public static boolean a(VoxelShape voxelshape) {
        return (Boolean)c.getUnchecked((Object)voxelshape);
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
    }

    public void a(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
    }

    public static List<ItemStack> a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, @Nullable TileEntity tileentity) {
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).b(LootContextParameters.h, tileentity);
        return iblockdata.a(lootparams_a);
    }

    public static List<ItemStack> a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, @Nullable TileEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, entity).b(LootContextParameters.h, tileentity);
        return iblockdata.a(lootparams_a);
    }

    public static void c(IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (world instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)world, blockposition, (TileEntity)null).forEach(itemstack -> Block.a(world, blockposition, itemstack));
            iblockdata.a((WorldServer)world, blockposition, ItemStack.l, true);
        }
    }

    public static void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, @Nullable TileEntity tileentity) {
        if (generatoraccess instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)generatoraccess, blockposition, tileentity).forEach(itemstack -> Block.a((World)((WorldServer)generatoraccess), blockposition, itemstack));
            iblockdata.a((WorldServer)generatoraccess, blockposition, ItemStack.l, true);
        }
    }

    public static void a(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable TileEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        if (world instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)world, blockposition, tileentity, entity, itemstack).forEach(itemstack1 -> Block.a(world, blockposition, itemstack1));
            iblockdata.a((WorldServer)world, blockposition, itemstack, true);
        }
    }

    public static void a(World world, BlockPosition blockposition, ItemStack itemstack) {
        double d0 = (double)EntityTypes.as.m() / 2.0;
        double d1 = (double)blockposition.u() + 0.5 + MathHelper.a(world.A, -0.25, 0.25);
        double d2 = (double)blockposition.v() + 0.5 + MathHelper.a(world.A, -0.25, 0.25) - d0;
        double d3 = (double)blockposition.w() + 0.5 + MathHelper.a(world.A, -0.25, 0.25);
        Block.a(world, () -> new EntityItem(world, d1, d2, d3, itemstack), itemstack);
    }

    public static void a(World world, BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        int i2 = enumdirection.j();
        int j2 = enumdirection.k();
        int k2 = enumdirection.l();
        double d0 = (double)EntityTypes.as.l() / 2.0;
        double d1 = (double)EntityTypes.as.m() / 2.0;
        double d2 = (double)blockposition.u() + 0.5 + (i2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)i2 * (0.5 + d0));
        double d3 = (double)blockposition.v() + 0.5 + (j2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)j2 * (0.5 + d1)) - d1;
        double d4 = (double)blockposition.w() + 0.5 + (k2 == 0 ? MathHelper.a(world.A, -0.25, 0.25) : (double)k2 * (0.5 + d0));
        double d5 = i2 == 0 ? MathHelper.a(world.A, -0.1, 0.1) : (double)i2 * 0.1;
        double d6 = j2 == 0 ? MathHelper.a(world.A, 0.0, 0.1) : (double)j2 * 0.1 + 0.1;
        double d7 = k2 == 0 ? MathHelper.a(world.A, -0.1, 0.1) : (double)k2 * 0.1;
        Block.a(world, () -> new EntityItem(world, d2, d3, d4, itemstack, d5, d6, d7), itemstack);
    }

    private static void a(World world, Supplier<EntityItem> supplier, ItemStack itemstack) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (!itemstack.f() && worldserver.P().c(GameRules.i)) {
                EntityItem entityitem = supplier.get();
                entityitem.i();
                if (world.captureDrops != null) {
                    world.captureDrops.add(entityitem);
                } else {
                    world.b(entityitem);
                }
                return;
            }
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, int i2) {
        if (worldserver.P().c(GameRules.i)) {
            EntityExperienceOrb.a(worldserver, Vec3D.b(blockposition), i2);
        }
    }

    public float e() {
        return this.G;
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, Explosion explosion) {
    }

    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity) {
    }

    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        return this.m();
    }

    public void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata, @Nullable TileEntity tileentity, ItemStack itemstack) {
        entityhuman.b(StatisticList.a.b(this));
        entityhuman.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        Block.a(iblockdata, world, blockposition, tileentity, (Entity)entityhuman, itemstack);
    }

    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
    }

    public boolean a(IBlockData iblockdata) {
        return !iblockdata.e() && !iblockdata.n();
    }

    public IChatMutableComponent f() {
        return IChatBaseComponent.c(this.v());
    }

    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, double d0) {
        entity.a(d0, 1.0f, entity.ea().l());
    }

    public void a(IBlockAccess iblockaccess, Entity entity) {
        entity.i(entity.dA().d(1.0, 0.0, 1.0));
    }

    public float g() {
        return this.J;
    }

    public float i() {
        return this.K;
    }

    public float j() {
        return this.L;
    }

    protected void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata) {
        world.a((Entity)entityhuman, 2001, blockposition, Block.j(iblockdata));
    }

    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        this.a(world, entityhuman, blockposition, iblockdata);
        if (iblockdata.a(TagsBlock.ba) && world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            PiglinAI.a(worldserver, entityhuman, false);
        }
        world.a(GameEvent.f, blockposition, GameEvent.a.a(entityhuman, iblockdata));
        return iblockdata;
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, BiomeBase.Precipitation biomebase_precipitation) {
    }

    public boolean a(Explosion explosion) {
        return true;
    }

    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
    }

    public BlockStateList<Block, IBlockData> l() {
        return this.C;
    }

    protected final void l(IBlockData iblockdata) {
        this.d = iblockdata;
    }

    public final IBlockData m() {
        return this.d;
    }

    public final IBlockData m(IBlockData iblockdata) {
        IBlockData iblockdata1 = this.m();
        for (IBlockState<?> iblockstate : iblockdata.b().l().d()) {
            if (!iblockdata1.b(iblockstate)) continue;
            iblockdata1 = Block.a(iblockdata, iblockdata1, iblockstate);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData iblockdata, IBlockData iblockdata1, IBlockState<T> iblockstate) {
        return (IBlockData)iblockdata1.b(iblockstate, iblockdata.c(iblockstate));
    }

    @Override
    public Item h() {
        if (this.e == null) {
            this.e = Item.a(this);
        }
        return this.e;
    }

    public boolean n() {
        return this.M;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.e.e(this).g() + "}";
    }

    @Override
    protected Block o() {
        return this;
    }

    protected Function<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> function) {
        ImmutableMap immutablemap = (ImmutableMap)this.C.a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
        Objects.requireNonNull(immutablemap);
        return arg_0 -> ((ImmutableMap)immutablemap).get(arg_0);
    }

    protected Function<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> function, IBlockState<?> ... aiblockstate) {
        Map<IBlockState, Comparable> map = Arrays.stream(aiblockstate).collect(Collectors.toMap(iblockstate -> iblockstate, iblockstate -> (Comparable)iblockstate.a().getFirst()));
        ImmutableMap immutablemap = (ImmutableMap)this.C.a().stream().filter(iblockdata -> map.entrySet().stream().allMatch(entry -> iblockdata.c((IBlockState)entry.getKey()) == entry.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), function));
        return iblockdata -> {
            for (Map.Entry map_entry : map.entrySet()) {
                iblockdata = Block.a(iblockdata, (IBlockState)map_entry.getKey(), map_entry.getValue());
            }
            return (VoxelShape)immutablemap.get(iblockdata);
        };
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S s0, IBlockState<T> iblockstate, Object object) {
        return (S)((IBlockDataHolder)s0.b(iblockstate, (Comparable)((Comparable)object)));
    }

    @Deprecated
    public Holder.c<Block> p() {
        return this.b;
    }

    protected int tryDropExperience(WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, IntProvider intprovider) {
        int i2 = EnchantmentManager.b(worldserver, itemstack, intprovider.a(worldserver.H_()));
        if (i2 > 0) {
            return i2;
        }
        return 0;
    }

    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        return 0;
    }

    public static float range(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    private record a(VoxelShape a, VoxelShape b) {
        @Override
        public boolean equals(Object object) {
            if (object instanceof a) {
                a block_a = (a)object;
                if (this.a == block_a.a && this.b == block_a.b) {
                    boolean flag = true;
                    return flag;
                }
            }
            boolean flag = false;
            return flag;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.a) * 31 + System.identityHashCode(this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "first;second", "a", "b"}, this);
        }
    }
}

