/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BlockMonsterEggs
extends Block {
    public static final MapCodec<BlockMonsterEggs> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("host").forGetter(BlockMonsterEggs::b), BlockMonsterEggs.t()).apply((Applicative)instance, BlockMonsterEggs::new));
    private final Block b;
    private static final Map<Block, Block> c = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> d = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> e = Maps.newIdentityHashMap();

    public MapCodec<? extends BlockMonsterEggs> a() {
        return a;
    }

    public BlockMonsterEggs(Block block, BlockBase.Info blockbase_info) {
        super(blockbase_info.e(block.x() / 2.0f).f(0.75f));
        this.b = block;
        c.put(block, this);
    }

    public Block b() {
        return this.b;
    }

    public static boolean o(IBlockData iblockdata) {
        return c.containsKey(iblockdata.b());
    }

    private void a(WorldServer worldserver, BlockPosition blockposition) {
        EntitySilverfish entitysilverfish = EntityTypes.bg.a(worldserver, EntitySpawnReason.k);
        if (entitysilverfish != null) {
            entitysilverfish.b((double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, 0.0f, 0.0f);
            worldserver.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            entitysilverfish.Y();
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.a(iblockdata, worldserver, blockposition, itemstack, flag);
        if (worldserver.P().c(GameRules.i) && !EnchantmentManager.a(itemstack, EnchantmentTags.t)) {
            this.a(worldserver, blockposition);
        }
    }

    public static IBlockData p(IBlockData iblockdata) {
        return BlockMonsterEggs.a(d, iblockdata, () -> c.get(iblockdata.b()).m());
    }

    public IBlockData q(IBlockData iblockdata) {
        return BlockMonsterEggs.a(e, iblockdata, () -> this.b().m());
    }

    private static IBlockData a(Map<IBlockData, IBlockData> map, IBlockData iblockdata, Supplier<IBlockData> supplier) {
        return map.computeIfAbsent(iblockdata, iblockdata1 -> {
            IBlockData iblockdata2 = (IBlockData)supplier.get();
            for (IBlockState<?> iblockstate : iblockdata1.F()) {
                iblockdata2 = iblockdata2.b(iblockstate) ? (IBlockData)iblockdata2.b(iblockstate, iblockdata1.c(iblockstate)) : iblockdata2;
            }
            return iblockdata2;
        });
    }
}

