/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final MapCodec<PointedDripstoneBlock> a = PointedDripstoneBlock.b(PointedDripstoneBlock::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.bq;
    public static final BlockStateEnum<DripstoneThickness> c = BlockProperties.br;
    public static final BlockStateBoolean d = BlockProperties.I;
    private static final int e = 11;
    private static final int f = 2;
    private static final float g = 0.02f;
    private static final float h = 0.12f;
    private static final int i = 11;
    private static final float D = 0.17578125f;
    private static final float R = 0.05859375f;
    private static final double S = 0.6;
    private static final float T = 1.0f;
    private static final int U = 40;
    private static final int V = 6;
    private static final float W = 2.5f;
    private static final int X = 2;
    private static final float Y = 5.0f;
    private static final float Z = 0.011377778f;
    private static final int aa = 7;
    private static final int ab = 10;
    private static final VoxelShape ac = Block.b(6.0, 0.0, 16.0);
    private static final VoxelShape ad = Block.b(6.0, 0.0, 11.0);
    private static final VoxelShape ae = Block.b(6.0, 5.0, 16.0);
    private static final VoxelShape af = Block.b(8.0, 0.0, 16.0);
    private static final VoxelShape ag = Block.b(10.0, 0.0, 16.0);
    private static final VoxelShape ah = Block.b(12.0, 0.0, 16.0);
    private static final double ai = ae.b(EnumDirection.EnumAxis.b);
    private static final float aj = (float)ah.b(EnumDirection.EnumAxis.a);
    private static final VoxelShape ak = Block.b(4.0, 0.0, 16.0);

    public MapCodec<PointedDripstoneBlock> a() {
        return a;
    }

    public PointedDripstoneBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b()).b(b, EnumDirection.b)).b(c, DripstoneThickness.b)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, c, d);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.c(iworldreader, blockposition, iblockdata.c(b));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, IWorldReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1, IBlockData iblockdata1, RandomSource randomsource) {
        if (iblockdata.c(d).booleanValue()) {
            scheduledtickaccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(iworldreader));
        }
        if (enumdirection != EnumDirection.b && enumdirection != EnumDirection.a) {
            return iblockdata;
        }
        EnumDirection enumdirection1 = iblockdata.c(b);
        if (enumdirection1 == EnumDirection.a && scheduledtickaccess.V().a(blockposition, this)) {
            return iblockdata;
        }
        if (enumdirection == enumdirection1.g() && !this.a(iblockdata, iworldreader, blockposition)) {
            if (enumdirection1 == EnumDirection.a) {
                scheduledtickaccess.a(blockposition, this, 2);
            } else {
                scheduledtickaccess.a(blockposition, this, 1);
            }
            return iblockdata;
        }
        boolean flag = iblockdata.c(c) == DripstoneThickness.a;
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a(iworldreader, blockposition, enumdirection1, flag);
        return (IBlockData)iblockdata.b(c, dripstonethickness);
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        if (!world.C) {
            WorldServer worldserver;
            BlockPosition blockposition = movingobjectpositionblock.b();
            if (world instanceof WorldServer && iprojectile.c(worldserver = (WorldServer)world, blockposition) && iprojectile.a(worldserver) && iprojectile instanceof EntityThrownTrident && iprojectile.dA().g() > 0.6) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(iprojectile, blockposition, Blocks.a.m())) {
                    return;
                }
                world.b(blockposition, true);
            }
        }
    }

    @Override
    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, double d0) {
        if (iblockdata.c(b) == EnumDirection.b && iblockdata.c(c) == DripstoneThickness.b) {
            entity.a(d0 + 2.5, 2.0f, world.al().w().directBlock(world, blockposition));
        } else {
            super.a(world, iblockdata, blockposition, entity, d0);
        }
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        float f2;
        if (PointedDripstoneBlock.o(iblockdata) && (f2 = randomsource.i()) <= 0.12f) {
            PointedDripstoneBlock.b(world, blockposition, iblockdata).filter(pointeddripstoneblock_a -> f2 < 0.02f || PointedDripstoneBlock.a(pointeddripstoneblock_a.b)).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, blockposition, iblockdata, pointeddripstoneblock_a.b));
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (PointedDripstoneBlock.r(iblockdata) && !this.a(iblockdata, (IWorldReader)worldserver, blockposition)) {
            worldserver.b(blockposition, true);
        } else {
            PointedDripstoneBlock.a(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, randomsource.i());
        if (randomsource.i() < 0.011377778f && PointedDripstoneBlock.b(iblockdata, (IWorldReader)worldserver, blockposition)) {
            PointedDripstoneBlock.c(iblockdata, worldserver, blockposition, randomsource);
        }
    }

    @VisibleForTesting
    public static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, float f2) {
        Optional<a> optional;
        if ((f2 <= 0.17578125f || f2 <= 0.05859375f) && PointedDripstoneBlock.b(iblockdata, (IWorldReader)worldserver, blockposition) && !(optional = PointedDripstoneBlock.b(worldserver, blockposition, iblockdata)).isEmpty()) {
            BlockPosition blockposition1;
            float f1;
            FluidType fluidtype = optional.get().b;
            if (fluidtype == FluidTypes.c) {
                f1 = 0.17578125f;
            } else {
                if (fluidtype != FluidTypes.e) {
                    return;
                }
                f1 = 0.05859375f;
            }
            if (f2 < f1 && (blockposition1 = PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, 11, false)) != null) {
                if (optional.get().c.a(Blocks.tt) && fluidtype == FluidTypes.c) {
                    IBlockData iblockdata1 = Blocks.ei.m();
                    worldserver.c(optional.get().a, iblockdata1);
                    Block.a(optional.get().c, iblockdata1, worldserver, optional.get().a);
                    worldserver.a(GameEvent.c, optional.get().a, GameEvent.a.a(iblockdata1));
                    worldserver.c(1504, blockposition1, 0);
                } else {
                    BlockPosition blockposition2 = PointedDripstoneBlock.a((World)worldserver, blockposition1, fluidtype);
                    if (blockposition2 != null) {
                        worldserver.c(1504, blockposition1, 0);
                        int i2 = blockposition1.v() - blockposition2.v();
                        int j2 = 50 + i2;
                        IBlockData iblockdata2 = worldserver.a_(blockposition2);
                        worldserver.a(blockposition2, iblockdata2.b(), j2);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        EnumDirection enumdirection;
        BlockPosition blockposition;
        World generatoraccess = blockactioncontext.q();
        EnumDirection enumdirection1 = PointedDripstoneBlock.b((IWorldReader)generatoraccess, blockposition = blockactioncontext.a(), enumdirection = blockactioncontext.e().g());
        if (enumdirection1 == null) {
            return null;
        }
        boolean flag = !blockactioncontext.h();
        DripstoneThickness dripstonethickness = PointedDripstoneBlock.a((IWorldReader)generatoraccess, blockposition, enumdirection1, flag);
        return dripstonethickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.m().b(b, enumdirection1)).b(c, dripstonethickness)).b(d, generatoraccess.b_(blockposition).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(d) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected VoxelShape d_(IBlockData iblockdata) {
        return VoxelShapes.a();
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        VoxelShape voxelshape1 = switch (iblockdata.c(c)) {
            case DripstoneThickness.a -> ac;
            case DripstoneThickness.b -> iblockdata.c(b) == EnumDirection.a ? ae : ad;
            case DripstoneThickness.c -> af;
            case DripstoneThickness.d -> ag;
            case DripstoneThickness.e -> ah;
            default -> throw new MatchException(null, null);
        };
        return voxelshape1.a(iblockdata.a(blockposition));
    }

    @Override
    protected boolean a_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return false;
    }

    @Override
    protected float ar_() {
        return aj;
    }

    @Override
    public void a(World world, BlockPosition blockposition, EntityFallingBlock entityfallingblock) {
        if (!entityfallingblock.be()) {
            world.c(1045, blockposition, 0);
        }
    }

    @Override
    public DamageSource a(Entity entity) {
        return entity.ea().c(entity);
    }

    private static void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        IBlockData iblockdata1 = iblockdata;
        while (PointedDripstoneBlock.q(iblockdata1)) {
            EntityFallingBlock entityfallingblock = EntityFallingBlock.a(worldserver, blockposition_mutableblockposition, iblockdata1);
            if (PointedDripstoneBlock.a(iblockdata1, true)) {
                int i2 = Math.max(1 + blockposition.v() - blockposition_mutableblockposition.v(), 6);
                float f2 = 1.0f * (float)i2;
                entityfallingblock.b(f2, 40);
                break;
            }
            blockposition_mutableblockposition.c(EnumDirection.a);
            iblockdata1 = worldserver.a_(blockposition_mutableblockposition);
        }
    }

    @VisibleForTesting
    public static void c(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        IBlockData iblockdata3;
        BlockPosition blockposition1;
        IBlockData iblockdata2;
        IBlockData iblockdata1 = worldserver.a_(blockposition.b(1));
        if (PointedDripstoneBlock.a(iblockdata1, iblockdata2 = worldserver.a_(blockposition.b(2))) && (blockposition1 = PointedDripstoneBlock.a(iblockdata, worldserver, blockposition, 7, false)) != null && PointedDripstoneBlock.o(iblockdata3 = worldserver.a_(blockposition1)) && PointedDripstoneBlock.b(iblockdata3, worldserver, blockposition1)) {
            if (randomsource.h()) {
                PointedDripstoneBlock.a(worldserver, blockposition1, EnumDirection.a);
            } else {
                PointedDripstoneBlock.b(worldserver, blockposition1);
            }
        }
    }

    private static void b(WorldServer worldserver, BlockPosition blockposition) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (int i2 = 0; i2 < 10; ++i2) {
            blockposition_mutableblockposition.c(EnumDirection.a);
            IBlockData iblockdata = worldserver.a_(blockposition_mutableblockposition);
            if (!iblockdata.y().c()) {
                return;
            }
            if (PointedDripstoneBlock.a(iblockdata, EnumDirection.b) && PointedDripstoneBlock.b(iblockdata, worldserver, (BlockPosition)blockposition_mutableblockposition)) {
                PointedDripstoneBlock.a(worldserver, (BlockPosition)blockposition_mutableblockposition, EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.c(worldserver, blockposition_mutableblockposition, EnumDirection.b) && !worldserver.B(blockposition_mutableblockposition.e())) {
                PointedDripstoneBlock.a(worldserver, blockposition_mutableblockposition.e(), EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.a((IBlockAccess)worldserver, (BlockPosition)blockposition_mutableblockposition, iblockdata)) continue;
            return;
        }
    }

    private static void a(WorldServer worldserver, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        IBlockData iblockdata = worldserver.a_(blockposition1);
        if (PointedDripstoneBlock.a(iblockdata, enumdirection.g())) {
            PointedDripstoneBlock.a(iblockdata, (GeneratorAccess)worldserver, blockposition1);
        } else if (iblockdata.l() || iblockdata.a(Blocks.J)) {
            PointedDripstoneBlock.createDripstone(worldserver, blockposition1, enumdirection, DripstoneThickness.b, blockposition);
        }
    }

    private static void createDripstone(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection enumdirection, DripstoneThickness dripstonethickness, BlockPosition source) {
        IBlockData iblockdata = (IBlockData)((IBlockData)((IBlockData)Blocks.tc.m().b(b, enumdirection)).b(c, dripstonethickness)).b(d, generatoraccess.b_(blockposition).a() == FluidTypes.c);
        CraftEventFactory.handleBlockSpreadEvent(generatoraccess, source, blockposition, iblockdata, 3);
    }

    private static void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        BlockPosition blockposition1;
        BlockPosition blockposition2;
        if (iblockdata.c(b) == EnumDirection.b) {
            blockposition2 = blockposition;
            blockposition1 = blockposition.d();
        } else {
            blockposition1 = blockposition;
            blockposition2 = blockposition.e();
        }
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition1, EnumDirection.a, DripstoneThickness.a, blockposition);
        PointedDripstoneBlock.createDripstone(generatoraccess, blockposition2, EnumDirection.b, DripstoneThickness.a, blockposition);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        PointedDripstoneBlock.b(world, blockposition, iblockdata).ifPresent(pointeddripstoneblock_a -> PointedDripstoneBlock.a(world, blockposition, iblockdata, pointeddripstoneblock_a.b));
    }

    private static void a(World world, BlockPosition blockposition, IBlockData iblockdata, FluidType fluidtype) {
        Vec3D vec3d = iblockdata.a(blockposition);
        double d0 = 0.0625;
        double d1 = (double)blockposition.u() + 0.5 + vec3d.d;
        double d2 = (double)blockposition.v() + ai - 0.0625;
        double d3 = (double)blockposition.w() + 0.5 + vec3d.f;
        FluidType fluidtype1 = PointedDripstoneBlock.a(world, fluidtype);
        ParticleType particleparam = fluidtype1.a(TagsFluid.b) ? Particles.aO : Particles.aQ;
        world.a(particleparam, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, boolean flag) {
        if (PointedDripstoneBlock.a(iblockdata, flag)) {
            return blockposition;
        }
        EnumDirection enumdirection = iblockdata.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.tc) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(generatoraccess, blockposition, enumdirection.f(), bipredicate, (IBlockData iblockdata1) -> PointedDripstoneBlock.a(iblockdata1, flag), i2).orElse(null);
    }

    @Nullable
    private static EnumDirection b(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        EnumDirection enumdirection1;
        if (PointedDripstoneBlock.c(iworldreader, blockposition, enumdirection)) {
            enumdirection1 = enumdirection;
        } else {
            if (!PointedDripstoneBlock.c(iworldreader, blockposition, enumdirection.g())) {
                return null;
            }
            enumdirection1 = enumdirection.g();
        }
        return enumdirection1;
    }

    private static DripstoneThickness a(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection, boolean flag) {
        EnumDirection enumdirection1 = enumdirection.g();
        IBlockData iblockdata = iworldreader.a_(blockposition.a(enumdirection));
        if (PointedDripstoneBlock.b(iblockdata, enumdirection1)) {
            return !flag && iblockdata.c(c) != DripstoneThickness.a ? DripstoneThickness.b : DripstoneThickness.a;
        }
        if (!PointedDripstoneBlock.b(iblockdata, enumdirection)) {
            return DripstoneThickness.b;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        if (dripstonethickness != DripstoneThickness.b && dripstonethickness != DripstoneThickness.a) {
            IBlockData iblockdata1 = iworldreader.a_(blockposition.a(enumdirection1));
            return !PointedDripstoneBlock.b(iblockdata1, enumdirection) ? DripstoneThickness.e : DripstoneThickness.d;
        }
        return DripstoneThickness.c;
    }

    public static boolean o(IBlockData iblockdata) {
        return PointedDripstoneBlock.q(iblockdata) && iblockdata.c(c) == DripstoneThickness.b && iblockdata.c(d) == false;
    }

    private static boolean b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition) {
        EnumDirection enumdirection = iblockdata.c(b);
        BlockPosition blockposition1 = blockposition.a(enumdirection);
        IBlockData iblockdata1 = worldserver.a_(blockposition1);
        return !iblockdata1.y().c() ? false : (iblockdata1.l() ? true : PointedDripstoneBlock.a(iblockdata1, enumdirection.g()));
    }

    private static Optional<BlockPosition> a(World world, BlockPosition blockposition, IBlockData iblockdata, int i2) {
        EnumDirection enumdirection = iblockdata.c(b);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata1) -> iblockdata1.a(Blocks.tc) && iblockdata1.c(b) == enumdirection;
        return PointedDripstoneBlock.a(world, blockposition, enumdirection.g().f(), bipredicate, (IBlockData iblockdata1) -> !iblockdata1.a(Blocks.tc), i2);
    }

    private static boolean c(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        IBlockData iblockdata = iworldreader.a_(blockposition1);
        return iblockdata.c((IBlockAccess)iworldreader, blockposition1, enumdirection) || PointedDripstoneBlock.b(iblockdata, enumdirection);
    }

    private static boolean a(IBlockData iblockdata, boolean flag) {
        if (!iblockdata.a(Blocks.tc)) {
            return false;
        }
        DripstoneThickness dripstonethickness = iblockdata.c(c);
        return dripstonethickness == DripstoneThickness.b || flag && dripstonethickness == DripstoneThickness.a;
    }

    private static boolean a(IBlockData iblockdata, EnumDirection enumdirection) {
        return PointedDripstoneBlock.a(iblockdata, false) && iblockdata.c(b) == enumdirection;
    }

    private static boolean q(IBlockData iblockdata) {
        return PointedDripstoneBlock.b(iblockdata, EnumDirection.a);
    }

    private static boolean r(IBlockData iblockdata) {
        return PointedDripstoneBlock.b(iblockdata, EnumDirection.b);
    }

    private static boolean b(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return PointedDripstoneBlock.q(iblockdata) && !iworldreader.a_(blockposition.d()).a(Blocks.tc);
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return false;
    }

    private static boolean b(IBlockData iblockdata, EnumDirection enumdirection) {
        return iblockdata.a(Blocks.tc) && iblockdata.c(b) == enumdirection;
    }

    @Nullable
    private static BlockPosition a(World world, BlockPosition blockposition, FluidType fluidtype) {
        Predicate<IBlockData> predicate = iblockdata -> iblockdata.b() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)iblockdata.b()).a(fluidtype);
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, blockposition, EnumDirection.a.f(), bipredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition a(World world, BlockPosition blockposition) {
        BiPredicate<BlockPosition, IBlockData> bipredicate = (blockposition1, iblockdata) -> PointedDripstoneBlock.a((IBlockAccess)world, blockposition1, iblockdata);
        return PointedDripstoneBlock.a(world, blockposition, EnumDirection.b.f(), bipredicate, PointedDripstoneBlock::o, 11).orElse(null);
    }

    public static FluidType a(WorldServer worldserver, BlockPosition blockposition) {
        return PointedDripstoneBlock.b(worldserver, blockposition, worldserver.a_(blockposition)).map(pointeddripstoneblock_a -> pointeddripstoneblock_a.b).filter(PointedDripstoneBlock::a).orElse(FluidTypes.a);
    }

    private static Optional<a> b(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return !PointedDripstoneBlock.q(iblockdata) ? Optional.empty() : PointedDripstoneBlock.a(world, blockposition, iblockdata, 11).map(blockposition1 -> {
            BlockPosition blockposition2 = blockposition1.d();
            IBlockData iblockdata1 = world.a_(blockposition2);
            FluidType fluidtype = iblockdata1.a(Blocks.tt) && !world.G_().i() ? FluidTypes.c : world.b_(blockposition2).a();
            return new a(blockposition2, fluidtype, iblockdata1);
        });
    }

    private static boolean a(FluidType fluidtype) {
        return fluidtype == FluidTypes.e || fluidtype == FluidTypes.c;
    }

    private static boolean a(IBlockData iblockdata, IBlockData iblockdata1) {
        return iblockdata.a(Blocks.td) && iblockdata1.a(Blocks.J) && iblockdata1.y().b();
    }

    private static FluidType a(World world, FluidType fluidtype) {
        return fluidtype.a(FluidTypes.a) ? (world.G_().i() ? FluidTypes.e : FluidTypes.c) : fluidtype;
    }

    private static Optional<BlockPosition> a(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxisDirection enumdirection_enumaxisdirection, BiPredicate<BlockPosition, IBlockData> bipredicate, Predicate<IBlockData> predicate, int i2) {
        EnumDirection enumdirection = EnumDirection.a(enumdirection_enumaxisdirection, EnumDirection.EnumAxis.b);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (int j2 = 1; j2 < i2; ++j2) {
            blockposition_mutableblockposition.c(enumdirection);
            IBlockData iblockdata = generatoraccess.a_(blockposition_mutableblockposition);
            if (predicate.test(iblockdata)) {
                return Optional.of(blockposition_mutableblockposition.j());
            }
            if (!generatoraccess.e(blockposition_mutableblockposition.v()) && bipredicate.test(blockposition_mutableblockposition, iblockdata)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.l()) {
            return true;
        }
        if (iblockdata.s()) {
            return false;
        }
        if (!iblockdata.y().c()) {
            return false;
        }
        VoxelShape voxelshape = iblockdata.g(iblockaccess, blockposition);
        return !VoxelShapes.c(ak, voxelshape, OperatorBoolean.i);
    }

    record a(BlockPosition a, FluidType b, IBlockData c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this, o2);
        }
    }
}

