/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import org.bukkit.craftbukkit.v1_21_R5.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftChest;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_21_R5.util.TransformerGeneratorAccess;
import org.bukkit.entity.EntityType;

public abstract class StructurePiece {
    protected static final IBlockData e = Blocks.nJ.m();
    protected StructureBoundingBox f;
    @Nullable
    private EnumDirection a;
    private EnumBlockMirror b;
    private EnumBlockRotation c;
    protected int g;
    private final WorldGenFeatureStructurePieceType d;
    public static final Set<Block> h = ImmutableSet.builder().add((Object)Blocks.fN).add((Object)Blocks.cz).add((Object)Blocks.cA).add((Object)Blocks.el).add((Object)Blocks.kH).add((Object)Blocks.kM).add((Object)Blocks.kN).add((Object)Blocks.kK).add((Object)Blocks.kI).add((Object)Blocks.kJ).add((Object)Blocks.da).add((Object)Blocks.fo).build();

    protected StructurePiece(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, int i2, StructureBoundingBox structureboundingbox) {
        this.d = worldgenfeaturestructurepiecetype;
        this.g = i2;
        this.f = structureboundingbox;
    }

    public StructurePiece(WorldGenFeatureStructurePieceType worldgenfeaturestructurepiecetype, NBTTagCompound nbttagcompound) {
        this(worldgenfeaturestructurepiecetype, nbttagcompound.b("GD", 0), nbttagcompound.a("BB", StructureBoundingBox.a).orElseThrow());
        int i2 = nbttagcompound.b("O", 0);
        this.a(i2 == -1 ? null : EnumDirection.b(i2));
    }

    protected static StructureBoundingBox a(int i2, int j2, int k2, EnumDirection enumdirection, int l2, int i1, int j1) {
        return enumdirection.o() == EnumDirection.EnumAxis.c ? new StructureBoundingBox(i2, j2, k2, i2 + l2 - 1, j2 + i1 - 1, k2 + j1 - 1) : new StructureBoundingBox(i2, j2, k2, i2 + j1 - 1, j2 + i1 - 1, k2 + l2 - 1);
    }

    protected static EnumDirection a(RandomSource randomsource) {
        return EnumDirection.EnumDirectionLimit.a.a(randomsource);
    }

    public final NBTTagCompound a(StructurePieceSerializationContext structurepieceserializationcontext) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("id", BuiltInRegistries.Q.b(this.k()).toString());
        nbttagcompound.a("BB", StructureBoundingBox.a, this.f);
        EnumDirection enumdirection = this.i();
        nbttagcompound.a("O", enumdirection == null ? -1 : enumdirection.e());
        nbttagcompound.a("GD", this.g);
        this.a(structurepieceserializationcontext, nbttagcompound);
        return nbttagcompound;
    }

    protected abstract void a(StructurePieceSerializationContext var1, NBTTagCompound var2);

    public void a(StructurePiece structurepiece, StructurePieceAccessor structurepieceaccessor, RandomSource randomsource) {
    }

    public abstract void a(GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, StructureBoundingBox var5, ChunkCoordIntPair var6, BlockPosition var7);

    public StructureBoundingBox f() {
        return this.f;
    }

    public int g() {
        return this.g;
    }

    public void a(int i2) {
        this.g = i2;
    }

    public boolean a(ChunkCoordIntPair chunkcoordintpair, int i2) {
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        return this.f.a(j2 - i2, k2 - i2, j2 + 15 + i2, k2 + 15 + i2);
    }

    public BlockPosition h() {
        return new BlockPosition(this.f.g());
    }

    protected BlockPosition.MutableBlockPosition b(int i2, int j2, int k2) {
        return new BlockPosition.MutableBlockPosition(this.a(i2, k2), this.b(j2), this.b(i2, k2));
    }

    protected int a(int i2, int j2) {
        EnumDirection enumdirection = this.i();
        if (enumdirection == null) {
            return i2;
        }
        switch (enumdirection) {
            case c: 
            case d: {
                return this.f.h() + i2;
            }
            case e: {
                return this.f.k() - j2;
            }
            case f: {
                return this.f.h() + j2;
            }
        }
        return i2;
    }

    protected int b(int i2) {
        return this.i() == null ? i2 : i2 + this.f.i();
    }

    protected int b(int i2, int j2) {
        EnumDirection enumdirection = this.i();
        if (enumdirection == null) {
            return j2;
        }
        switch (enumdirection) {
            case c: {
                return this.f.m() - j2;
            }
            case d: {
                return this.f.j() + j2;
            }
            case e: 
            case f: {
                return this.f.j() + i2;
            }
        }
        return j2;
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition = this.b(i2, j2, k2);
        if (structureboundingbox.b(blockposition) && this.a(generatoraccessseed, i2, j2, k2, structureboundingbox)) {
            if (this.b != EnumBlockMirror.a) {
                iblockdata = iblockdata.a(this.b);
            }
            if (this.c != EnumBlockRotation.a) {
                iblockdata = iblockdata.a(this.c);
            }
            generatoraccessseed.a((BlockPosition)blockposition, iblockdata, 2);
            if (generatoraccessseed instanceof TransformerGeneratorAccess) {
                return;
            }
            Fluid fluid = generatoraccessseed.b_(blockposition);
            if (!fluid.c()) {
                generatoraccessseed.a((BlockPosition)blockposition, fluid.a(), 0);
            }
            if (h.contains(iblockdata.b())) {
                generatoraccessseed.A(blockposition).e(blockposition);
            }
        }
    }

    protected boolean placeCraftBlockEntity(WorldAccess worldAccess, BlockPosition position, CraftBlockEntityState<?> craftBlockEntityState, int i2) {
        if (worldAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
            return transformerAccess.setCraftBlock(position, craftBlockEntityState, i2);
        }
        boolean result = worldAccess.a(position, craftBlockEntityState.getHandle(), i2);
        TileEntity tileEntity = worldAccess.c_(position);
        if (tileEntity != null) {
            tileEntity.b(craftBlockEntityState.getSnapshotInput());
        }
        return result;
    }

    protected void placeCraftSpawner(WorldAccess worldAccess, BlockPosition position, EntityType entityType, int i2) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)CraftBlockStates.getBlockState((IWorldReader)worldAccess, position, Blocks.cD.m(), null);
        spawner.setSpawnedType(entityType);
        this.placeCraftBlockEntity(worldAccess, position, spawner, i2);
    }

    protected void setCraftLootTable(WorldAccess worldAccess, BlockPosition position, RandomSource randomSource, ResourceKey<LootTable> loottableKey) {
        TileEntity tileEntity = worldAccess.c_(position);
        if (tileEntity instanceof TileEntityLootable) {
            TileEntityLootable tileEntityLootable = (TileEntityLootable)tileEntity;
            tileEntityLootable.a(loottableKey, randomSource.g());
            if (worldAccess instanceof TransformerGeneratorAccess) {
                TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)worldAccess;
                transformerAccess.setCraftBlock(position, (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)worldAccess, position, tileEntity.m(), tileEntityLootable.b(worldAccess.K_())), 3);
            }
        }
    }

    protected boolean a(IWorldReader iworldreader, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        return true;
    }

    protected IBlockData a(IBlockAccess iblockaccess, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition = this.b(i2, j2, k2);
        return !structureboundingbox.b(blockposition) ? Blocks.a.m() : iblockaccess.a_(blockposition);
    }

    protected boolean b(IWorldReader iworldreader, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition = this.b(i2, j2 + 1, k2);
        return !structureboundingbox.b(blockposition) ? false : blockposition.v() < iworldreader.a(HeightMap.Type.c, blockposition.u(), blockposition.w());
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    this.a(generatoraccessseed, Blocks.a.m(), l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (flag && this.a((IBlockAccess)generatoraccessseed, l1, k1, i22, structureboundingbox).l()) continue;
                    if (k1 != j2 && k1 != i1 && l1 != i2 && l1 != l2 && i22 != k2 && i22 != j1) {
                        this.a(generatoraccessseed, iblockdata1, l1, k1, i22, structureboundingbox);
                        continue;
                    }
                    this.a(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, StructureBoundingBox structureboundingbox1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag) {
        this.a(generatoraccessseed, structureboundingbox, structureboundingbox1.h(), structureboundingbox1.i(), structureboundingbox1.j(), structureboundingbox1.k(), structureboundingbox1.l(), structureboundingbox1.m(), iblockdata, iblockdata1, flag);
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, boolean flag, RandomSource randomsource, StructurePieceBlockSelector structurepiece_structurepieceblockselector) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (flag && this.a((IBlockAccess)generatoraccessseed, l1, k1, i22, structureboundingbox).l()) continue;
                    structurepiece_structurepieceblockselector.a(randomsource, l1, k1, i22, k1 == j2 || k1 == i1 || l1 == i2 || l1 == l2 || i22 == k2 || i22 == j1);
                    this.a(generatoraccessseed, structurepiece_structurepieceblockselector.a(), l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, StructureBoundingBox structureboundingbox1, boolean flag, RandomSource randomsource, StructurePieceBlockSelector structurepiece_structurepieceblockselector) {
        this.a(generatoraccessseed, structureboundingbox, structureboundingbox1.h(), structureboundingbox1.i(), structureboundingbox1.j(), structureboundingbox1.k(), structureboundingbox1.l(), structureboundingbox1.m(), flag, randomsource, structurepiece_structurepieceblockselector);
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, float f2, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, IBlockData iblockdata1, boolean flag, boolean flag1) {
        for (int k1 = j2; k1 <= i1; ++k1) {
            for (int l1 = i2; l1 <= l2; ++l1) {
                for (int i22 = k2; i22 <= j1; ++i22) {
                    if (!(randomsource.i() <= f2) || flag && this.a((IBlockAccess)generatoraccessseed, l1, k1, i22, structureboundingbox).l() || flag1 && !this.b(generatoraccessseed, l1, k1, i22, structureboundingbox)) continue;
                    if (k1 != j2 && k1 != i1 && l1 != i2 && l1 != l2 && i22 != k2 && i22 != j1) {
                        this.a(generatoraccessseed, iblockdata1, l1, k1, i22, structureboundingbox);
                        continue;
                    }
                    this.a(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, float f2, int i2, int j2, int k2, IBlockData iblockdata) {
        if (randomsource.i() < f2) {
            this.a(generatoraccessseed, iblockdata, i2, j2, k2, structureboundingbox);
        }
    }

    protected void a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, int i2, int j2, int k2, int l2, int i1, int j1, IBlockData iblockdata, boolean flag) {
        float f2 = l2 - i2 + 1;
        float f1 = i1 - j2 + 1;
        float f22 = j1 - k2 + 1;
        float f3 = (float)i2 + f2 / 2.0f;
        float f4 = (float)k2 + f22 / 2.0f;
        for (int k1 = j2; k1 <= i1; ++k1) {
            float f5 = (float)(k1 - j2) / f1;
            for (int l1 = i2; l1 <= l2; ++l1) {
                float f6 = ((float)l1 - f3) / (f2 * 0.5f);
                for (int i22 = k2; i22 <= j1; ++i22) {
                    float f8;
                    float f7 = ((float)i22 - f4) / (f22 * 0.5f);
                    if (flag && this.a((IBlockAccess)generatoraccessseed, l1, k1, i22, structureboundingbox).l() || !((f8 = f6 * f6 + f5 * f5 + f7 * f7) <= 1.05f)) continue;
                    this.a(generatoraccessseed, iblockdata, l1, k1, i22, structureboundingbox);
                }
            }
        }
    }

    protected void b(GeneratorAccessSeed generatoraccessseed, IBlockData iblockdata, int i2, int j2, int k2, StructureBoundingBox structureboundingbox) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = this.b(i2, j2, k2);
        if (structureboundingbox.b(blockposition_mutableblockposition)) {
            while (this.a(generatoraccessseed.a_(blockposition_mutableblockposition)) && blockposition_mutableblockposition.v() > generatoraccessseed.L_() + 1) {
                generatoraccessseed.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 2);
                blockposition_mutableblockposition.c(EnumDirection.a);
            }
        }
    }

    protected boolean a(IBlockData iblockdata) {
        return iblockdata.l() || iblockdata.n() || iblockdata.a(Blocks.fy) || iblockdata.a(Blocks.bG) || iblockdata.a(Blocks.bH);
    }

    protected boolean a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, int i2, int j2, int k2, ResourceKey<LootTable> resourcekey) {
        return this.a((WorldAccess)generatoraccessseed, structureboundingbox, randomsource, this.b(i2, j2, k2), resourcekey, (IBlockData)null);
    }

    public static IBlockData a(IBlockAccess iblockaccess, BlockPosition blockposition, IBlockData iblockdata) {
        EnumDirection enumdirection = null;
        for (EnumDirection enumdirection1 : EnumDirection.EnumDirectionLimit.a) {
            BlockPosition blockposition1 = blockposition.a(enumdirection1);
            IBlockData iblockdata1 = iblockaccess.a_(blockposition1);
            if (iblockdata1.a(Blocks.cG)) {
                return iblockdata;
            }
            if (!iblockdata1.s()) continue;
            if (enumdirection != null) {
                enumdirection = null;
                break;
            }
            enumdirection = enumdirection1;
        }
        if (enumdirection != null) {
            return (IBlockData)iblockdata.b(BlockFacingHorizontal.f, enumdirection.g());
        }
        EnumDirection enumdirection2 = iblockdata.c(BlockFacingHorizontal.f);
        BlockPosition blockposition2 = blockposition.a(enumdirection2);
        if (iblockaccess.a_(blockposition2).s()) {
            enumdirection2 = enumdirection2.g();
            blockposition2 = blockposition.a(enumdirection2);
        }
        if (iblockaccess.a_(blockposition2).s()) {
            enumdirection2 = enumdirection2.h();
            blockposition2 = blockposition.a(enumdirection2);
        }
        if (iblockaccess.a_(blockposition2).s()) {
            enumdirection2 = enumdirection2.g();
            blockposition.a(enumdirection2);
        }
        return (IBlockData)iblockdata.b(BlockFacingHorizontal.f, enumdirection2);
    }

    protected boolean a(WorldAccess worldaccess, StructureBoundingBox structureboundingbox, RandomSource randomsource, BlockPosition blockposition, ResourceKey<LootTable> resourcekey, @Nullable IBlockData iblockdata) {
        if (structureboundingbox.b(blockposition) && !worldaccess.a_(blockposition).a(Blocks.cG)) {
            if (iblockdata == null) {
                iblockdata = StructurePiece.a(worldaccess, blockposition, Blocks.cG.m());
            }
            CraftChest chestState = (CraftChest)CraftBlockStates.getBlockState((IWorldReader)worldaccess, blockposition, iblockdata, null);
            chestState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            chestState.setSeed(randomsource.g());
            this.placeCraftBlockEntity(worldaccess, blockposition, chestState, 2);
            return true;
        }
        return false;
    }

    protected boolean a(GeneratorAccessSeed generatoraccessseed, StructureBoundingBox structureboundingbox, RandomSource randomsource, int i2, int j2, int k2, EnumDirection enumdirection, ResourceKey<LootTable> resourcekey) {
        BlockPosition.MutableBlockPosition blockposition = this.b(i2, j2, k2);
        if (structureboundingbox.b(blockposition) && !generatoraccessseed.a_(blockposition).a(Blocks.bb)) {
            if (!this.a(generatoraccessseed, i2, j2, k2, structureboundingbox)) {
                return true;
            }
            IBlockData iblockdata = (IBlockData)Blocks.bb.m().b(BlockDispenser.b, enumdirection);
            if (this.b != EnumBlockMirror.a) {
                iblockdata = iblockdata.a(this.b);
            }
            if (this.c != EnumBlockRotation.a) {
                iblockdata = iblockdata.a(this.c);
            }
            CraftDispenser dispenserState = (CraftDispenser)CraftBlockStates.getBlockState((IWorldReader)generatoraccessseed, (BlockPosition)blockposition, iblockdata, null);
            dispenserState.setLootTable(CraftLootTable.minecraftToBukkit(resourcekey));
            dispenserState.setSeed(randomsource.g());
            this.placeCraftBlockEntity(generatoraccessseed, blockposition, dispenserState, 2);
            return true;
        }
        return false;
    }

    public void a(int i2, int j2, int k2) {
        this.f.a(i2, j2, k2);
    }

    public static StructureBoundingBox a(Stream<StructurePiece> stream) {
        Stream<StructureBoundingBox> stream1 = stream.map(StructurePiece::f);
        Objects.requireNonNull(stream1);
        return StructureBoundingBox.b(stream1::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece a(List<StructurePiece> list, StructureBoundingBox structureboundingbox) {
        for (StructurePiece structurepiece : list) {
            if (!structurepiece.f().a(structureboundingbox)) continue;
            return structurepiece;
        }
        return null;
    }

    @Nullable
    public EnumDirection i() {
        return this.a;
    }

    public void a(@Nullable EnumDirection enumdirection) {
        this.a = enumdirection;
        if (enumdirection == null) {
            this.c = EnumBlockRotation.a;
            this.b = EnumBlockMirror.a;
        } else {
            switch (enumdirection) {
                case d: {
                    this.b = EnumBlockMirror.b;
                    this.c = EnumBlockRotation.a;
                    break;
                }
                case e: {
                    this.b = EnumBlockMirror.b;
                    this.c = EnumBlockRotation.b;
                    break;
                }
                case f: {
                    this.b = EnumBlockMirror.a;
                    this.c = EnumBlockRotation.b;
                    break;
                }
                default: {
                    this.b = EnumBlockMirror.a;
                    this.c = EnumBlockRotation.a;
                }
            }
        }
    }

    public EnumBlockRotation a() {
        return this.c;
    }

    public EnumBlockMirror j() {
        return this.b;
    }

    public WorldGenFeatureStructurePieceType k() {
        return this.d;
    }

    public static abstract class StructurePieceBlockSelector {
        protected IBlockData a = Blocks.a.m();

        public abstract void a(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public IBlockData a() {
            return this.a;
        }
    }
}

