/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class JigsawStructure
extends Structure {
    public static final DimensionPadding d = DimensionPadding.b;
    public static final LiquidSettings e = LiquidSettings.b;
    public static final int f = 128;
    public static final int g = 0;
    public static final int h = 20;
    public static final MapCodec<JigsawStructure> i = RecordCodecBuilder.mapCodec(var02 -> var02.group(JigsawStructure.a(var02), (App)WorldGenFeatureDefinedStructurePoolTemplate.b.fieldOf("start_pool").forGetter(var0 -> var0.j), (App)MinecraftKey.a.optionalFieldOf("start_jigsaw_name").forGetter(var0 -> var0.k), (App)Codec.intRange((int)0, (int)20).fieldOf("size").forGetter(var0 -> var0.l), (App)HeightProvider.c.fieldOf("start_height").forGetter(var0 -> var0.m), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(var0 -> var0.n), (App)HeightMap.Type.g.optionalFieldOf("project_start_to_heightmap").forGetter(var0 -> var0.o), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(var0 -> var0.p), (App)Codec.list(PoolAliasBinding.b).optionalFieldOf("pool_aliases", List.of()).forGetter(var0 -> var0.q), (App)DimensionPadding.a.optionalFieldOf("dimension_padding", (Object)d).forGetter(var0 -> var0.r), (App)LiquidSettings.c.optionalFieldOf("liquid_settings", (Object)e).forGetter(var0 -> var0.s)).apply((Applicative)var02, JigsawStructure::new)).validate(JigsawStructure::a);
    private final Holder<WorldGenFeatureDefinedStructurePoolTemplate> j;
    private final Optional<MinecraftKey> k;
    private final int l;
    private final HeightProvider m;
    private final boolean n;
    private final Optional<HeightMap.Type> o;
    private final int p;
    private final List<PoolAliasBinding> q;
    private final DimensionPadding r;
    private final LiquidSettings s;

    private static DataResult<JigsawStructure> a(JigsawStructure var0) {
        int var1;
        switch (var0.d()) {
            default: {
                throw new MatchException(null, null);
            }
            case a: {
                int n2 = 0;
                break;
            }
            case b: 
            case c: 
            case d: 
            case e: {
                int n2 = var1 = 12;
            }
        }
        if (var0.p + var1 > 128) {
            return DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128");
        }
        return DataResult.success((Object)var0);
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, Optional<MinecraftKey> var2, int var3, HeightProvider var4, boolean var5, Optional<HeightMap.Type> var6, int var7, List<PoolAliasBinding> var8, DimensionPadding var9, LiquidSettings var10) {
        super(var0);
        this.j = var1;
        this.k = var2;
        this.l = var3;
        this.m = var4;
        this.n = var5;
        this.o = var6;
        this.p = var7;
        this.q = var8;
        this.r = var9;
        this.s = var10;
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, int var2, HeightProvider var3, boolean var4, HeightMap.Type var5) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.of(var5), 80, List.of(), d, e);
    }

    public JigsawStructure(Structure.c var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, int var2, HeightProvider var3, boolean var4) {
        this(var0, var1, Optional.empty(), var2, var3, var4, Optional.empty(), 80, List.of(), d, e);
    }

    @Override
    public Optional<Structure.b> a(Structure.a var0) {
        ChunkCoordIntPair var1 = var0.h();
        int var2 = this.m.a(var0.f(), new WorldGenerationContext(var0.b(), var0.i()));
        BlockPosition var3 = new BlockPosition(var1.d(), var2, var1.e());
        return WorldGenFeatureDefinedStructureJigsawPlacement.a(var0, this.j, this.k, this.l, var3, this.n, this.o, this.p, PoolAliasLookup.create(this.q, var3, var0.g()), this.r, this.s);
    }

    @Override
    public StructureType<?> e() {
        return StructureType.f;
    }

    @VisibleForTesting
    public Holder<WorldGenFeatureDefinedStructurePoolTemplate> f() {
        return this.j;
    }

    @VisibleForTesting
    public List<PoolAliasBinding> g() {
        return this.q;
    }
}

