/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.OptionalDynamic;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger f = LogUtils.getLogger();
    public static final String a = "LevelName";
    protected static final String b = "Player";
    protected static final String c = "WorldGenSettings";
    public WorldSettings g;
    private final WorldOptions h;
    private final a i;
    private final Lifecycle j;
    private BlockPosition k;
    private float l;
    private long m;
    private long n;
    @Nullable
    private final NBTTagCompound o;
    private final int p;
    private int q;
    private boolean r;
    private int s;
    private boolean t;
    private int u;
    private boolean v;
    private boolean w;
    private WorldBorder.d x;
    private EnderDragonBattle.a y;
    @Nullable
    private NBTTagCompound z;
    private int A;
    private int B;
    @Nullable
    private UUID C;
    private final Set<String> D;
    private boolean E;
    private final Set<String> F;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> G;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable NBTTagCompound nbttagcompound, boolean flag, BlockPosition blockposition, float f2, long i2, long j2, int k2, int l2, int i1, boolean flag1, int j1, boolean flag2, boolean flag3, boolean flag4, WorldBorder.d worldborder_d, int k1, int l1, @Nullable UUID uuid, Set<String> set, Set<String> set1, CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue, @Nullable NBTTagCompound nbttagcompound1, EnderDragonBattle.a enderdragonbattle_a, WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this.E = flag;
        this.k = blockposition;
        this.l = f2;
        this.m = i2;
        this.n = j2;
        this.p = k2;
        this.q = l2;
        this.s = i1;
        this.r = flag1;
        this.u = j1;
        this.t = flag2;
        this.v = flag3;
        this.w = flag4;
        this.x = worldborder_d;
        this.A = k1;
        this.B = l1;
        this.C = uuid;
        this.D = set;
        this.F = set1;
        this.o = nbttagcompound;
        this.G = customfunctioncallbacktimerqueue;
        this.z = nbttagcompound1;
        this.y = enderdragonbattle_a;
        this.g = worldsettings;
        this.h = worldoptions;
        this.i = worlddataserver_a;
        this.j = lifecycle;
    }

    public WorldDataServer(WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this(null, false, BlockPosition.c, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.d, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, worldsettings.h(), worldoptions, worlddataserver_a, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, WorldSettings worldsettings, a worlddataserver_a, WorldOptions worldoptions, Lifecycle lifecycle) {
        long i2 = dynamic.get("Time").asLong(0L);
        OptionalDynamic optionaldynamic = dynamic.get(b);
        Codec<NBTTagCompound> codec = NBTTagCompound.a;
        Objects.requireNonNull(codec);
        NBTTagCompound nbttagcompound = optionaldynamic.flatMap(arg_0 -> codec.parse(arg_0)).result().orElse(null);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        BlockPosition blockposition = new BlockPosition(dynamic.get("SpawnX").asInt(0), dynamic.get("SpawnY").asInt(0), dynamic.get("SpawnZ").asInt(0));
        float f2 = dynamic.get("SpawnAngle").asFloat(0.0f);
        long j2 = dynamic.get("DayTime").asLong(i2);
        int k2 = LevelVersion.a(dynamic).a();
        int l2 = dynamic.get("clearWeatherTime").asInt(0);
        int i1 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int j1 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        WorldBorder.d worldborder_d = WorldBorder.d.a(dynamic, WorldBorder.d);
        int k1 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int l1 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream());
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EnderDragonBattle.a.a);
        Logger logger = f;
        Objects.requireNonNull(logger);
        return new WorldDataServer(nbttagcompound, flag, blockposition, f2, i2, j2, k2, l2, i1, flag1, j1, flag2, flag3, flag4, worldborder_d, k1, l1, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EnderDragonBattle.a.b), worldsettings, worldoptions, worlddataserver_a, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom iregistrycustom, @Nullable NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            nbttagcompound = this.o;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(iregistrycustom, nbttagcompound1, nbttagcompound);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom iregistrycustom, NBTTagCompound nbttagcompound, @Nullable NBTTagCompound nbttagcompound1) {
        nbttagcompound.a("ServerBrands", WorldDataServer.a(this.D));
        nbttagcompound.a("WasModded", this.E);
        if (!this.F.isEmpty()) {
            nbttagcompound.a("removed_features", WorldDataServer.a(this.F));
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().a().b());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().f());
        nbttagcompound2.a("Series", SharedConstants.b().a().c());
        nbttagcompound.a("Version", nbttagcompound2);
        GameProfileSerializer.e(nbttagcompound);
        RegistryOps<NBTBase> dynamicops = iregistrycustom.a(DynamicOpsNBT.a);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.h, new WorldDimensions(this.customDimensions != null ? this.customDimensions : iregistrycustom.f(Registries.bv)));
        Logger logger = f;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> nbttagcompound.a(c, (NBTBase)nbtbase));
        nbttagcompound.a("GameType", this.g.b().a());
        nbttagcompound.a("SpawnX", this.k.u());
        nbttagcompound.a("SpawnY", this.k.v());
        nbttagcompound.a("SpawnZ", this.k.w());
        nbttagcompound.a("SpawnAngle", this.l);
        nbttagcompound.a("Time", this.m);
        nbttagcompound.a("DayTime", this.n);
        nbttagcompound.a("LastPlayed", SystemUtils.e());
        nbttagcompound.a(a, this.g.a());
        nbttagcompound.a("version", 19133);
        nbttagcompound.a("clearWeatherTime", this.q);
        nbttagcompound.a("rainTime", this.s);
        nbttagcompound.a("raining", this.r);
        nbttagcompound.a("thunderTime", this.u);
        nbttagcompound.a("thundering", this.t);
        nbttagcompound.a("hardcore", this.g.c());
        nbttagcompound.a("allowCommands", this.g.e());
        nbttagcompound.a("initialized", this.v);
        this.x.a(nbttagcompound);
        nbttagcompound.a("Difficulty", (byte)this.g.d().a());
        nbttagcompound.a("DifficultyLocked", this.w);
        nbttagcompound.a("GameRules", this.g.f().a());
        nbttagcompound.a("DragonFight", EnderDragonBattle.a.a, this.y);
        if (nbttagcompound1 != null) {
            nbttagcompound.a(b, nbttagcompound1);
        }
        nbttagcompound.a(WorldDataConfiguration.b, this.g.g());
        if (this.z != null) {
            nbttagcompound.a("CustomBossEvents", this.z);
        }
        nbttagcompound.a("ScheduledEvents", this.G.b());
        nbttagcompound.a("WanderingTraderSpawnDelay", this.A);
        nbttagcompound.a("WanderingTraderSpawnChance", this.B);
        nbttagcompound.b("WanderingTraderId", UUIDUtil.a, this.C);
        nbttagcompound.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(nbttagcompound);
    }

    private static NBTTagList a(Set<String> set) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = set.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public BlockPosition a() {
        return this.k;
    }

    @Override
    public float b() {
        return this.l;
    }

    @Override
    public long c() {
        return this.m;
    }

    @Override
    public long d() {
        return this.n;
    }

    @Override
    @Nullable
    public NBTTagCompound w() {
        return this.o;
    }

    @Override
    public void a(long i2) {
        this.m = i2;
    }

    @Override
    public void b(long i2) {
        this.n = i2;
    }

    @Override
    public void a(BlockPosition blockposition, float f2) {
        this.k = blockposition.j();
        this.l = f2;
    }

    @Override
    public String e() {
        return this.g.a();
    }

    @Override
    public int x() {
        return this.p;
    }

    @Override
    public int f() {
        return this.q;
    }

    @Override
    public void a(int i2) {
        this.q = i2;
    }

    @Override
    public boolean g() {
        return this.t;
    }

    @Override
    public void a(boolean flag) {
        if (this.t == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.t = flag;
    }

    @Override
    public int h() {
        return this.u;
    }

    @Override
    public void b(int i2) {
        this.u = i2;
    }

    @Override
    public boolean i() {
        return this.r;
    }

    @Override
    public void b(boolean flag) {
        if (this.r == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.e());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.r = flag;
    }

    @Override
    public int j() {
        return this.s;
    }

    @Override
    public void c(int i2) {
        this.s = i2;
    }

    @Override
    public EnumGamemode k() {
        return this.g.b();
    }

    @Override
    public void a(EnumGamemode enumgamemode) {
        this.g = this.g.a(enumgamemode);
    }

    @Override
    public boolean l() {
        return this.g.c();
    }

    @Override
    public boolean m() {
        return this.g.e();
    }

    @Override
    public boolean n() {
        return this.v;
    }

    @Override
    public void c(boolean flag) {
        this.v = flag;
    }

    @Override
    public GameRules o() {
        return this.g.f();
    }

    @Override
    public WorldBorder.d p() {
        return this.x;
    }

    @Override
    public void a(WorldBorder.d worldborder_d) {
        this.x = worldborder_d;
    }

    @Override
    public EnumDifficulty q() {
        return this.g.d();
    }

    @Override
    public void a(EnumDifficulty enumdifficulty) {
        this.g = this.g.a(enumdifficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.q(), this.r());
        for (EntityPlayer player : this.world.A()) {
            player.g.b(packet);
        }
    }

    @Override
    public boolean r() {
        return this.w;
    }

    @Override
    public void d(boolean flag) {
        this.w = flag;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> s() {
        return this.G;
    }

    @Override
    public void a(CrashReportSystemDetails crashreportsystemdetails, LevelHeightAccessor levelheightaccessor) {
        IWorldDataServer.super.a(crashreportsystemdetails, levelheightaccessor);
        SaveData.super.a(crashreportsystemdetails);
    }

    @Override
    public WorldOptions y() {
        return this.h;
    }

    @Override
    public boolean z() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean A() {
        return this.i == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle B() {
        return this.j;
    }

    @Override
    public EnderDragonBattle.a C() {
        return this.y;
    }

    @Override
    public void a(EnderDragonBattle.a enderdragonbattle_a) {
        this.y = enderdragonbattle_a;
    }

    @Override
    public WorldDataConfiguration D() {
        return this.g.g();
    }

    @Override
    public void a(WorldDataConfiguration worlddataconfiguration) {
        this.g = this.g.a(worlddataconfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound E() {
        return this.z;
    }

    @Override
    public void a(@Nullable NBTTagCompound nbttagcompound) {
        this.z = nbttagcompound;
    }

    @Override
    public int t() {
        return this.A;
    }

    @Override
    public void d(int i2) {
        this.A = i2;
    }

    @Override
    public int u() {
        return this.B;
    }

    @Override
    public void e(int i2) {
        this.B = i2;
    }

    @Override
    @Nullable
    public UUID v() {
        return this.C;
    }

    @Override
    public void a(UUID uuid) {
        this.C = uuid;
    }

    @Override
    public void a(String s2, boolean flag) {
        this.D.add(s2);
        this.E |= flag;
    }

    @Override
    public boolean F() {
        return this.E;
    }

    @Override
    public Set<String> G() {
        return ImmutableSet.copyOf(this.D);
    }

    @Override
    public Set<String> H() {
        return Set.copyOf(this.F);
    }

    @Override
    public IWorldDataServer I() {
        return this;
    }

    @Override
    public WorldSettings J() {
        return this.g.h();
    }

    public void checkName(String name) {
        if (!this.g.a.equals(name)) {
            this.g.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

