/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongMaps;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickList;

public class TickListServer<T>
implements LevelTickAccess<T> {
    private static final Comparator<LevelChunkTicks<?>> a = (var0, var1) -> NextTickListEntry.b.compare(var0.b(), var1.b());
    private final LongPredicate b;
    private final Long2ObjectMap<LevelChunkTicks<T>> c = new Long2ObjectOpenHashMap();
    private final Long2LongMap d = (Long2LongMap)SystemUtils.a(new Long2LongOpenHashMap(), (? super T var0) -> var0.defaultReturnValue(Long.MAX_VALUE));
    private final Queue<LevelChunkTicks<T>> e = new PriorityQueue(a);
    private final Queue<NextTickListEntry<T>> f = new ArrayDeque<NextTickListEntry<T>>();
    private final List<NextTickListEntry<T>> g = new ArrayList<NextTickListEntry<T>>();
    private final Set<NextTickListEntry<?>> h = new ObjectOpenCustomHashSet(NextTickListEntry.c);
    private final BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> i = (var0, var1) -> {
        if (var1.equals(var0.b())) {
            this.b((NextTickListEntry<T>)var1);
        }
    };

    public TickListServer(LongPredicate var02) {
        this.b = var02;
    }

    public void a(ChunkCoordIntPair var0, LevelChunkTicks<T> var1) {
        long var2 = var0.a();
        this.c.put(var2, var1);
        NextTickListEntry<T> var4 = var1.b();
        if (var4 != null) {
            this.d.put(var2, var4.c());
        }
        var1.a(this.i);
    }

    public void a(ChunkCoordIntPair var0) {
        long var1 = var0.a();
        LevelChunkTicks var3 = (LevelChunkTicks)this.c.remove(var1);
        this.d.remove(var1);
        if (var3 != null) {
            var3.a(null);
        }
    }

    @Override
    public void a(NextTickListEntry<T> var0) {
        long var1 = ChunkCoordIntPair.a(var0.b());
        LevelChunkTicks var3 = (LevelChunkTicks)this.c.get(var1);
        if (var3 == null) {
            SystemUtils.b("Trying to schedule tick in not loaded position " + String.valueOf(var0.b()));
            return;
        }
        var3.a(var0);
    }

    public void a(long var0, int var2, BiConsumer<BlockPosition, T> var3) {
        GameProfilerFiller var4 = Profiler.a();
        var4.a("collect");
        this.a(var0, var2, var4);
        var4.b("run");
        var4.a("ticksToRun", this.f.size());
        this.a(var3);
        var4.b("cleanup");
        this.c();
        var4.c();
    }

    private void a(long var0, int var2, GameProfilerFiller var3) {
        this.a(var0);
        var3.a("containersToTick", this.e.size());
        this.a(var0, var2);
        this.b();
    }

    private void a(long var0) {
        ObjectIterator var2 = Long2LongMaps.fastIterator((Long2LongMap)this.d);
        while (var2.hasNext()) {
            Long2LongMap.Entry var3 = (Long2LongMap.Entry)var2.next();
            long var4 = var3.getLongKey();
            long var6 = var3.getLongValue();
            if (var6 > var0) continue;
            LevelChunkTicks var8 = (LevelChunkTicks)this.c.get(var4);
            if (var8 == null) {
                var2.remove();
                continue;
            }
            NextTickListEntry var9 = var8.b();
            if (var9 == null) {
                var2.remove();
                continue;
            }
            if (var9.c() > var0) {
                var3.setValue(var9.c());
                continue;
            }
            if (!this.b.test(var4)) continue;
            var2.remove();
            this.e.add(var8);
        }
    }

    private void a(long var0, int var2) {
        LevelChunkTicks<T> var3;
        while (this.a(var2) && (var3 = this.e.poll()) != null) {
            NextTickListEntry<T> var4 = var3.c();
            this.c(var4);
            this.a(this.e, var3, var0, var2);
            NextTickListEntry<T> var5 = var3.b();
            if (var5 == null) continue;
            if (var5.c() <= var0 && this.a(var2)) {
                this.e.add(var3);
                continue;
            }
            this.b(var5);
        }
    }

    private void b() {
        for (LevelChunkTicks levelChunkTicks : this.e) {
            this.b(levelChunkTicks.b());
        }
    }

    private void b(NextTickListEntry<T> var0) {
        this.d.put(ChunkCoordIntPair.a(var0.b()), var0.c());
    }

    private void a(Queue<LevelChunkTicks<T>> var0, LevelChunkTicks<T> var1, long var2, int var4) {
        NextTickListEntry<T> var7;
        NextTickListEntry<T> var6;
        if (!this.a(var4)) {
            return;
        }
        LevelChunkTicks<T> var5 = var0.peek();
        NextTickListEntry<T> nextTickListEntry = var6 = var5 != null ? var5.b() : null;
        while (this.a(var4) && (var7 = var1.b()) != null && var7.c() <= var2 && (var6 == null || NextTickListEntry.b.compare(var7, var6) <= 0)) {
            var1.c();
            this.c(var7);
        }
    }

    private void c(NextTickListEntry<T> var0) {
        this.f.add(var0);
    }

    private boolean a(int var0) {
        return this.f.size() < var0;
    }

    private void a(BiConsumer<BlockPosition, T> var0) {
        while (!this.f.isEmpty()) {
            NextTickListEntry<T> var1 = this.f.poll();
            if (!this.h.isEmpty()) {
                this.h.remove(var1);
            }
            this.g.add(var1);
            var0.accept(var1.b(), (BlockPosition)var1.a());
        }
    }

    private void c() {
        this.f.clear();
        this.e.clear();
        this.g.clear();
        this.h.clear();
    }

    @Override
    public boolean a(BlockPosition var0, T var1) {
        LevelChunkTicks var2 = (LevelChunkTicks)this.c.get(ChunkCoordIntPair.a(var0));
        return var2 != null && var2.a(var0, var1);
    }

    @Override
    public boolean b(BlockPosition var0, T var1) {
        this.d();
        return this.h.contains(NextTickListEntry.a(var1, var0));
    }

    private void d() {
        if (this.h.isEmpty() && !this.f.isEmpty()) {
            this.h.addAll(this.f);
        }
    }

    private void a(StructureBoundingBox var0, a<T> var1) {
        int var2 = SectionPosition.a((double)var0.h());
        int var3 = SectionPosition.a((double)var0.j());
        int var4 = SectionPosition.a((double)var0.k());
        int var5 = SectionPosition.a((double)var0.m());
        for (int var6 = var2; var6 <= var4; ++var6) {
            for (int var7 = var3; var7 <= var5; ++var7) {
                long var8 = ChunkCoordIntPair.c(var6, var7);
                LevelChunkTicks var10 = (LevelChunkTicks)this.c.get(var8);
                if (var10 == null) continue;
                var1.accept(var8, var10);
            }
        }
    }

    public void a(StructureBoundingBox var0) {
        Predicate<NextTickListEntry> var12 = var1 -> var0.b(var1.b());
        this.a(var0, (long var1, LevelChunkTicks<T> var3) -> {
            NextTickListEntry var4 = var3.b();
            var3.a(var12);
            NextTickListEntry var5 = var3.b();
            if (var5 != var4) {
                if (var5 != null) {
                    this.b(var5);
                } else {
                    this.d.remove(var1);
                }
            }
        });
        this.g.removeIf(var12);
        this.f.removeIf(var12);
    }

    public void a(StructureBoundingBox var0, BaseBlockPosition var1) {
        this.a(this, var0, var1);
    }

    public void a(TickListServer<T> var0, StructureBoundingBox var12, BaseBlockPosition var22) {
        ArrayList var3 = new ArrayList();
        Predicate<NextTickListEntry> var42 = var1 -> var12.b(var1.b());
        var0.g.stream().filter(var42).forEach(var3::add);
        var0.f.stream().filter(var42).forEach(var3::add);
        var0.a(var12, (long var2, LevelChunkTicks<T> var4) -> var4.d().filter(var42).forEach(var3::add));
        LongSummaryStatistics var52 = var3.stream().mapToLong(NextTickListEntry::e).summaryStatistics();
        long var6 = var52.getMin();
        long var8 = var52.getMax();
        var3.forEach(var5 -> this.a(new NextTickListEntry(var5.a(), var5.b().a(var22), var5.c(), var5.d(), var5.e() - var6 + var8 + 1L)));
    }

    @Override
    public int a() {
        return this.c.values().stream().mapToInt(TickList::a).sum();
    }

    @FunctionalInterface
    static interface a<T> {
        public void accept(long var1, LevelChunkTicks<T> var3);
    }
}

