/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityTypes;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R5.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected net.minecraft.world.entity.Entity entity;
    private final EntityType entityType;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final Entity.Spigot spigot = new Entity.Spigot(this){

        public void sendMessage(BaseComponent component) {
        }

        public void sendMessage(BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public CraftEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
        this.entityType = CraftEntityType.minecraftToBukkit(entity.ap());
    }

    public static <T extends net.minecraft.world.entity.Entity> CraftEntity getEntity(CraftServer server, T entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Unknown entity");
        if (entity instanceof EntityHuman && !(entity instanceof EntityPlayer)) {
            return new CraftHumanEntity(server, (EntityHuman)entity);
        }
        if (entity instanceof EntityComplexPart) {
            EntityComplexPart complexPart = (EntityComplexPart)entity;
            if (complexPart.a instanceof EntityEnderDragon) {
                return new CraftEnderDragonPart(server, complexPart);
            }
            return new CraftComplexPart(server, complexPart);
        }
        CraftEntityTypes.EntityTypeData entityTypeData = CraftEntityTypes.getEntityTypeData(CraftEntityType.minecraftToBukkit(entity.ap()));
        if (entityTypeData != null) {
            return (CraftEntity)entityTypeData.convertFunction().apply(server, entity);
        }
        throw new AssertionError((Object)("Unknown entity " + String.valueOf(entity == null ? null : entity.getClass())));
    }

    public Location getLocation() {
        return CraftLocation.toBukkit(this.entity.dv(), this.getWorld(), this.entity.getBukkitYaw(), this.entity.dR());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.dC());
            loc.setY(this.entity.dE());
            loc.setZ(this.entity.dI());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.dR());
        }
        return loc;
    }

    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.dA());
    }

    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        this.entity.i(CraftVector.toNMS(velocity));
        this.entity.ag = true;
    }

    public double getHeight() {
        return this.getHandle().dt();
    }

    public double getWidth() {
        return this.getHandle().ds();
    }

    public BoundingBox getBoundingBox() {
        AxisAlignedBB bb = this.getHandle().cV();
        return new BoundingBox(bb.a, bb.b, bb.c, bb.d, bb.e, bb.f);
    }

    public boolean isOnGround() {
        if (this.entity instanceof EntityArrow) {
            return ((EntityArrow)this.entity).e();
        }
        return this.entity.aK();
    }

    public boolean isInWater() {
        return this.entity.bm();
    }

    public World getWorld() {
        return this.entity.ai().getWorld();
    }

    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite((float)pitch, (String)"pitch not finite");
        NumberConversions.checkFinite((float)yaw, (String)"yaw not finite");
        yaw = Location.normalizeYaw((float)yaw);
        pitch = Location.normalizePitch((float)pitch);
        this.entity.v(yaw);
        this.entity.w(pitch);
        this.entity.aa = yaw;
        this.entity.ab = pitch;
        this.entity.r(yaw);
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        location.checkFinite();
        if (this.entity.cd() || this.entity.dU()) {
            return false;
        }
        this.entity.bS();
        if (location.getWorld() != null && !location.getWorld().equals((Object)this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.b(new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), Vec3D.c, location.getPitch(), location.getYaw(), Set.of(), TeleportTransition.a, PlayerTeleportEvent.TeleportCause.PLUGIN));
            return true;
        }
        this.entity.a(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.r(location.getYaw());
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public List<Entity> getNearbyEntities(double x2, double y2, double z2) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List<net.minecraft.world.entity.Entity> notchEntityList = this.entity.ai().a(this.entity, this.entity.cV().c(x2, y2, z2), (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.world.entity.Entity e2 : notchEntityList) {
            bukkitEntityList.add(e2.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    public int getEntityId() {
        return this.entity.ar();
    }

    public int getFireTicks() {
        return this.entity.aH();
    }

    public int getMaxFireTicks() {
        return this.entity.dp();
    }

    public void setFireTicks(int ticks) {
        this.entity.h(ticks);
    }

    public void setVisualFire(boolean fire) {
        this.getHandle().bD = fire;
    }

    public boolean isVisualFire() {
        return this.getHandle().bD;
    }

    public int getFreezeTicks() {
        return this.getHandle().cy();
    }

    public int getMaxFreezeTicks() {
        return this.getHandle().cB();
    }

    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (String)"Ticks (%s) cannot be less than 0", (int)ticks);
        this.getHandle().k(ticks);
    }

    public boolean isFrozen() {
        return this.getHandle().cA();
    }

    public void remove() {
        this.entity.pluginRemoved = true;
        this.entity.discard(this.getHandle().generation ? null : EntityRemoveEvent.Cause.PLUGIN);
    }

    public boolean isDead() {
        return !this.entity.bO();
    }

    public boolean isValid() {
        return this.entity.bO() && this.entity.valid && this.entity.isChunkLoaded() && this.isInWorld();
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.entity.persist;
    }

    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : ((net.minecraft.world.entity.Entity)this.getHandle().aR.get(0)).getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().o(this.getHandle());
        }
        return false;
    }

    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform(this.getHandle().aR, input -> input.getBukkitEntity()));
    }

    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().a(this.getHandle(), true);
    }

    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"Entity passenger cannot be null");
        ((CraftEntity)passenger).getHandle().bS();
        return true;
    }

    public boolean isEmpty() {
        return !this.getHandle().cd();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().bR();
        return true;
    }

    public float getFallDistance() {
        return (float)this.getHandle().am;
    }

    public void setFallDistance(float distance) {
        this.getHandle().am = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.getHandle().cK();
    }

    public int getTicksLived() {
        return this.getHandle().as;
    }

    public void setTicksLived(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Age value (%s) must be greater than 0", (int)value);
        this.getHandle().as = value;
    }

    public net.minecraft.world.entity.Entity getHandle() {
        return this.entity;
    }

    public final EntityType getType() {
        return this.entityType;
    }

    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().ai().a(this.getHandle(), type.getData());
        }
    }

    public Sound getSwimSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSound0());
    }

    public Sound getSwimSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimSplashSound0());
    }

    public Sound getSwimHighSpeedSplashSound() {
        return CraftSound.minecraftToBukkit(this.getHandle().getSwimHighSpeedSplashSound0());
    }

    public void setHandle(net.minecraft.world.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getEntityId() == other.getEntityId();
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + this.getEntityId();
        return hash;
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().cc();
    }

    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().bS();
        return true;
    }

    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().dm().getBukkitEntity();
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().b(CraftChatMessage.fromStringOrNull(name));
    }

    public String getCustomName() {
        IChatBaseComponent name = this.getHandle().al();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    public void setCustomNameVisible(boolean flag) {
        this.getHandle().p(flag);
    }

    public boolean isCustomNameVisible() {
        return this.getHandle().cP();
    }

    public void setVisibleByDefault(boolean visible) {
        if (this.getHandle().visibleByDefault != visible) {
            if (visible) {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndShowEntity(this);
                }
            } else {
                for (Player player : this.server.getOnlinePlayers()) {
                    ((CraftPlayer)player).resetAndHideEntity(this);
                }
            }
            this.getHandle().visibleByDefault = visible;
        }
    }

    public boolean isVisibleByDefault() {
        return this.getHandle().visibleByDefault;
    }

    public Set<Player> getTrackedBy() {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get tracking players during world generation");
        ImmutableSet.Builder players = ImmutableSet.builder();
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.n().a.L.get(this.getEntityId());
        if (entityTracker != null) {
            for (ServerPlayerConnection connection : entityTracker.f) {
                players.add((Object)connection.o().getBukkitEntity());
            }
        }
        return players.build();
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(String ... messages) {
    }

    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().aj());
    }

    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    public void setGlowing(boolean flag) {
        this.getHandle().k(flag);
    }

    public boolean isGlowing() {
        return this.getHandle().cr();
    }

    public void setInvulnerable(boolean flag) {
        this.getHandle().n(flag);
    }

    public boolean isInvulnerable() {
        return this.getHandle().d(this.getHandle().ea().p());
    }

    public boolean isSilent() {
        return this.getHandle().be();
    }

    public void setSilent(boolean flag) {
        this.getHandle().f(flag);
    }

    public boolean hasGravity() {
        return !this.getHandle().bf();
    }

    public void setGravity(boolean gravity) {
        this.getHandle().g(!gravity);
    }

    public int getPortalCooldown() {
        return this.getHandle().bs;
    }

    public void setPortalCooldown(int cooldown) {
        this.getHandle().bs = cooldown;
    }

    public Set<String> getScoreboardTags() {
        return this.getHandle().as();
    }

    public boolean addScoreboardTag(String tag) {
        return this.getHandle().a(tag);
    }

    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().b(tag);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getHandle().k_().ordinal());
    }

    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().cT());
    }

    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Pose getPose() {
        return Pose.values()[this.getHandle().aw().ordinal()];
    }

    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().ap().f());
    }

    public boolean isInWorld() {
        return this.getHandle().inWorld;
    }

    public String getAsString() {
        TagValueOutput tag = TagValueOutput.a(ProblemReporter.a, this.getHandle().eb());
        if (!this.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return tag.b().toString();
    }

    public EntitySnapshot createSnapshot() {
        return CraftEntitySnapshot.create(this);
    }

    public Entity copy() {
        net.minecraft.world.entity.Entity copy = this.copy(this.getHandle().ai());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        return copy.getBukkitEntity();
    }

    public Entity copy(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity copy = this.copy(((CraftWorld)location.getWorld()).getHandle());
        Preconditions.checkArgument((copy != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        copy.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)copy.getBukkitEntity());
    }

    private net.minecraft.world.entity.Entity copy(net.minecraft.world.level.World level) {
        TagValueOutput compoundTag = TagValueOutput.a(ProblemReporter.a, this.getHandle().eb());
        this.getHandle().saveAsPassenger(compoundTag, false);
        return EntityTypes.a(compoundTag.b(), level, EntitySpawnReason.r, Function.identity());
    }

    public void storeBukkitValues(ValueOutput output) {
        if (!this.persistentDataContainer.isEmpty()) {
            this.persistentDataContainer.store(output.a("BukkitValues"));
        }
    }

    public void readBukkitValues(ValueInput input) {
        input.a("BukkitValues").ifPresent(base -> this.persistentDataContainer.putAll((ValueInput)base));
    }

    protected NBTTagCompound save() {
        TagValueOutput nbttagcompound = TagValueOutput.a(ProblemReporter.a, this.getHandle().eb());
        nbttagcompound.a("id", this.getHandle().bN());
        this.getHandle().d(nbttagcompound);
        return nbttagcompound.b();
    }

    protected void update() {
        if (!this.getHandle().bO()) {
            return;
        }
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.n().a.L.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.a(this.getHandle().a(entityTracker.b));
    }

    public void update(EntityPlayer player) {
        if (!this.getHandle().bO()) {
            return;
        }
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.n().a.L.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        player.g.b(this.getHandle().a(entityTracker.b));
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                public boolean isOp() {
                    return false;
                }

                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    public Entity.Spigot spigot() {
        return this.spigot;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

