/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final NBTTagCompound data;
    private final EntityType type;

    private CraftEntitySnapshot(NBTTagCompound data, EntityType type) {
        this.data = data;
        this.type = type;
    }

    public EntityType getEntityType() {
        return this.type;
    }

    public Entity createEntity(World world) {
        net.minecraft.world.entity.Entity internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity internal = this.createInternal(location.getWorld());
        internal.a_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity((Entity)internal.getBukkitEntity());
    }

    public String getAsString() {
        return this.data.toString();
    }

    private net.minecraft.world.entity.Entity createInternal(World world) {
        WorldServer nms = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity internal = EntityTypes.a(this.data, (net.minecraft.world.level.World)nms, EntitySpawnReason.r, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).a(nms, EntitySpawnReason.r);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        ValueInput val = TagValueInput.a(ProblemReporter.a, (HolderLookup.a)nms.K_(), this.data);
        internal.e(val);
        return internal;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        TagValueOutput tag = TagValueOutput.a(ProblemReporter.a, entity.getHandle().eb());
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag.b(), entity.getType());
    }

    public static CraftEntitySnapshot create(NBTTagCompound tag, EntityType type) {
        if (tag == null || tag.j() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(NBTTagCompound tag) {
        EntityType type = tag.a("id", EntityTypes.a).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }
}

