/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.Display;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftDisplay;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.entity.TextDisplay;

public class CraftTextDisplay
extends CraftDisplay
implements TextDisplay {
    public CraftTextDisplay(CraftServer server, Display.TextDisplay entity) {
        super(server, entity);
    }

    @Override
    public Display.TextDisplay getHandle() {
        return (Display.TextDisplay)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftTextDisplay";
    }

    public String getText() {
        return CraftChatMessage.fromComponent(this.getHandle().m());
    }

    public void setText(String text) {
        this.getHandle().a(CraftChatMessage.fromString(text, true)[0]);
    }

    public int getLineWidth() {
        return this.getHandle().n();
    }

    public void setLineWidth(int width) {
        this.getHandle().au().a(Display.TextDisplay.aW, width);
    }

    public Color getBackgroundColor() {
        int color = this.getHandle().q();
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.getHandle().au().a(Display.TextDisplay.aX, -1);
        } else {
            this.getHandle().au().a(Display.TextDisplay.aX, color.asARGB());
        }
    }

    public byte getTextOpacity() {
        return this.getHandle().p();
    }

    public void setTextOpacity(byte opacity) {
        this.getHandle().c(opacity);
    }

    public boolean isShadowed() {
        return this.getFlag(1);
    }

    public void setShadowed(boolean shadow) {
        this.setFlag(1, shadow);
    }

    public boolean isSeeThrough() {
        return this.getFlag(2);
    }

    public void setSeeThrough(boolean seeThrough) {
        this.setFlag(2, seeThrough);
    }

    public boolean isDefaultBackground() {
        return this.getFlag(4);
    }

    public void setDefaultBackground(boolean defaultBackground) {
        this.setFlag(4, defaultBackground);
    }

    public TextDisplay.TextAlignment getAlignment() {
        Display.TextDisplay.Align nms = Display.TextDisplay.a(this.getHandle().s());
        return TextDisplay.TextAlignment.valueOf((String)nms.name());
    }

    public void setAlignment(TextDisplay.TextAlignment alignment) {
        Preconditions.checkArgument((alignment != null ? 1 : 0) != 0, (Object)"Alignment cannot be null");
        switch (alignment) {
            case LEFT: {
                this.setFlag(8, true);
                this.setFlag(16, false);
                break;
            }
            case RIGHT: {
                this.setFlag(8, false);
                this.setFlag(16, true);
                break;
            }
            case CENTER: {
                this.setFlag(8, false);
                this.setFlag(16, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown alignment " + String.valueOf(alignment));
            }
        }
    }

    private boolean getFlag(int flag) {
        return (this.getHandle().s() & flag) != 0;
    }

    private void setFlag(int flag, boolean set) {
        byte flagBits = this.getHandle().s();
        flagBits = set ? (byte)(flagBits | flag) : (byte)(flagBits & ~flag);
        this.getHandle().d(flagBits);
    }
}

