/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.WardenAi;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftMonster;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;

public class CraftWarden
extends CraftMonster
implements Warden {
    public CraftWarden(CraftServer server, net.minecraft.world.entity.monster.warden.Warden entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.monster.warden.Warden getHandle() {
        return (net.minecraft.world.entity.monster.warden.Warden)this.entity;
    }

    @Override
    public String toString() {
        return "CraftWarden";
    }

    public int getAnger() {
        return this.getHandle().gH().b(this.getHandle().e());
    }

    public int getAnger(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getHandle().gH().b(((CraftEntity)entity).getHandle());
    }

    public void increaseAnger(Entity entity, int increase) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().gH().a(((CraftEntity)entity).getHandle(), increase);
    }

    public void setAnger(Entity entity, int anger) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().H(((CraftEntity)entity).getHandle());
        this.getHandle().gH().a(((CraftEntity)entity).getHandle(), anger);
    }

    public void clearAnger(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().H(((CraftEntity)entity).getHandle());
    }

    public LivingEntity getEntityAngryAt() {
        return this.getHandle().t().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    public void setDisturbanceLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        WardenAi.a(this.getHandle(), BlockPosition.a(location.getX(), location.getY(), location.getZ()));
    }

    public Warden.AngerLevel getAngerLevel() {
        return switch (this.getHandle().n()) {
            default -> throw new MatchException(null, null);
            case AngerLevel.a -> Warden.AngerLevel.CALM;
            case AngerLevel.b -> Warden.AngerLevel.AGITATED;
            case AngerLevel.c -> Warden.AngerLevel.ANGRY;
        };
    }
}

