/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R5.inventory;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_21_R5.inventory.SerializableMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ShieldMeta;

@DelegateDeserialization(value=SerializableMeta.class)
public class CraftMetaShield
extends CraftMetaItem
implements ShieldMeta,
BlockStateMeta {
    static final CraftMetaItem.ItemMetaKeyType<EnumColor> BASE_COLOR = new CraftMetaItem.ItemMetaKeyType<EnumColor>(DataComponents.an, "Base", "base-color");
    private Banner banner;

    CraftMetaShield(CraftMetaItem meta) {
        super(meta);
        BlockState blockState;
        CraftMetaBlockState state;
        if (meta instanceof CraftMetaShield) {
            CraftMetaShield craftMetaShield = (CraftMetaShield)meta;
            if (craftMetaShield.banner != null) {
                this.banner = (Banner)craftMetaShield.banner.copy();
            }
        } else if (meta instanceof CraftMetaBlockState && (state = (CraftMetaBlockState)meta).hasBlockState() && (blockState = state.getBlockState()) instanceof Banner) {
            Banner banner = (Banner)blockState;
            this.banner = (Banner)banner.copy();
        }
    }

    CraftMetaShield(DataComponentPatch tag) {
        super(tag);
        CraftMetaShield.getOrEmpty(tag, BASE_COLOR).ifPresent(color -> {
            this.banner = CraftMetaShield.getBlockState(DyeColor.getByWoolData((byte)((byte)color.a())));
        });
        CraftMetaShield.getOrEmpty(tag, CraftMetaBanner.PATTERNS).ifPresent(entityTag -> {
            List<BannerPatternLayers.b> patterns = entityTag.b();
            for (int i2 = 0; i2 < Math.min(patterns.size(), 20); ++i2) {
                BannerPatternLayers.b p2 = patterns.get(i2);
                DyeColor color = DyeColor.getByWoolData((byte)((byte)p2.c().a()));
                PatternType pattern = CraftPatternType.minecraftHolderToBukkit(p2.b());
                if (color == null || pattern == null) continue;
                this.addPattern(new Pattern(color, pattern));
            }
        });
    }

    CraftMetaShield(Map<String, Object> map) {
        super(map);
        Iterable rawPatternList;
        String baseColor = SerializableMeta.getString(map, CraftMetaShield.BASE_COLOR.BUKKIT, true);
        if (baseColor != null) {
            this.banner = CraftMetaShield.getBlockState(DyeColor.valueOf((String)baseColor));
        }
        if ((rawPatternList = SerializableMeta.getObject(Iterable.class, map, CraftMetaBanner.PATTERNS.BUKKIT, true)) == null) {
            return;
        }
        for (Object obj : rawPatternList) {
            Preconditions.checkArgument((boolean)(obj instanceof Pattern), (String)"Object (%s) in pattern list is not valid", obj.getClass());
            this.addPattern((Pattern)obj);
        }
    }

    @Override
    void applyToItem(CraftMetaItem.Applicator tag) {
        super.applyToItem(tag);
        if (this.banner != null) {
            tag.put(BASE_COLOR, EnumColor.a(this.banner.getBaseColor().getWoolData()));
            if (this.banner.numberOfPatterns() > 0) {
                ArrayList<BannerPatternLayers.b> newPatterns = new ArrayList<BannerPatternLayers.b>();
                for (Pattern p2 : this.banner.getPatterns()) {
                    newPatterns.add(new BannerPatternLayers.b(CraftPatternType.bukkitToMinecraftHolder(p2.getPattern()), EnumColor.a(p2.getColor().getWoolData())));
                }
                tag.put(CraftMetaBanner.PATTERNS, new BannerPatternLayers(newPatterns));
            }
        }
    }

    public List<Pattern> getPatterns() {
        if (this.banner == null) {
            return new ArrayList<Pattern>();
        }
        return this.banner.getPatterns();
    }

    public void setPatterns(List<Pattern> patterns) {
        if (this.banner == null) {
            if (patterns.isEmpty()) {
                return;
            }
            this.banner = CraftMetaShield.getBlockState(null);
        }
        this.banner.setPatterns(patterns);
    }

    public void addPattern(Pattern pattern) {
        if (this.banner == null) {
            this.banner = CraftMetaShield.getBlockState(null);
        }
        this.banner.addPattern(pattern);
    }

    public Pattern getPattern(int i2) {
        if (this.banner == null) {
            throw new IndexOutOfBoundsException(i2);
        }
        return this.banner.getPattern(i2);
    }

    public Pattern removePattern(int i2) {
        if (this.banner == null) {
            throw new IndexOutOfBoundsException(i2);
        }
        return this.banner.removePattern(i2);
    }

    public void setPattern(int i2, Pattern pattern) {
        if (this.banner == null) {
            throw new IndexOutOfBoundsException(i2);
        }
        this.banner.setPattern(i2, pattern);
    }

    public int numberOfPatterns() {
        if (this.banner == null) {
            return 0;
        }
        return this.banner.numberOfPatterns();
    }

    public DyeColor getBaseColor() {
        if (this.banner == null) {
            return null;
        }
        return this.banner.getBaseColor();
    }

    public void setBaseColor(DyeColor baseColor) {
        if (baseColor == null) {
            if (this.banner.numberOfPatterns() > 0) {
                this.banner.setBaseColor(DyeColor.WHITE);
            } else {
                this.banner = null;
            }
        } else {
            if (this.banner == null) {
                this.banner = CraftMetaShield.getBlockState(baseColor);
            }
            this.banner.setBaseColor(baseColor);
        }
    }

    @Override
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        super.serialize(builder);
        if (this.banner != null) {
            builder.put((Object)CraftMetaShield.BASE_COLOR.BUKKIT, (Object)this.banner.getBaseColor().toString());
            if (this.banner.numberOfPatterns() > 0) {
                builder.put((Object)CraftMetaBanner.PATTERNS.BUKKIT, (Object)this.banner.getPatterns());
            }
        }
        return builder;
    }

    @Override
    int applyHash() {
        int original;
        int hash = original = super.applyHash();
        if (this.banner != null) {
            hash = 61 * hash + this.banner.hashCode();
        }
        return original != hash ? CraftMetaShield.class.hashCode() ^ hash : hash;
    }

    @Override
    boolean equalsCommon(CraftMetaItem meta) {
        if (!super.equalsCommon(meta)) {
            return false;
        }
        if (meta instanceof CraftMetaShield) {
            CraftMetaShield that = (CraftMetaShield)meta;
            return Objects.equal((Object)this.banner, (Object)that.banner);
        }
        return true;
    }

    @Override
    boolean notUncommon(CraftMetaItem meta) {
        return super.notUncommon(meta) && (meta instanceof CraftMetaShield || this.banner == null);
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.banner == null;
    }

    public boolean hasBlockState() {
        return this.banner != null;
    }

    public BlockState getBlockState() {
        return this.banner != null ? this.banner.copy() : CraftMetaShield.getBlockState(null);
    }

    public void setBlockState(BlockState blockState) {
        Preconditions.checkArgument((blockState != null ? 1 : 0) != 0, (Object)"blockState must not be null");
        Preconditions.checkArgument((boolean)(blockState instanceof Banner), (Object)"Invalid blockState");
        this.banner = (Banner)blockState;
    }

    private static Banner getBlockState(DyeColor color) {
        BlockPosition pos = BlockPosition.c;
        Material stateMaterial = CraftMetaShield.shieldToBannerHack(color);
        return (Banner)CraftBlockStates.getBlockState(pos, stateMaterial, null);
    }

    @Override
    public CraftMetaShield clone() {
        CraftMetaShield meta = (CraftMetaShield)super.clone();
        if (this.banner != null) {
            meta.banner = (Banner)this.banner.copy();
        }
        return meta;
    }

    static Material shieldToBannerHack(DyeColor color) {
        if (color == null) {
            return Material.WHITE_BANNER;
        }
        return switch (color) {
            case DyeColor.WHITE -> Material.WHITE_BANNER;
            case DyeColor.ORANGE -> Material.ORANGE_BANNER;
            case DyeColor.MAGENTA -> Material.MAGENTA_BANNER;
            case DyeColor.LIGHT_BLUE -> Material.LIGHT_BLUE_BANNER;
            case DyeColor.YELLOW -> Material.YELLOW_BANNER;
            case DyeColor.LIME -> Material.LIME_BANNER;
            case DyeColor.PINK -> Material.PINK_BANNER;
            case DyeColor.GRAY -> Material.GRAY_BANNER;
            case DyeColor.LIGHT_GRAY -> Material.LIGHT_GRAY_BANNER;
            case DyeColor.CYAN -> Material.CYAN_BANNER;
            case DyeColor.PURPLE -> Material.PURPLE_BANNER;
            case DyeColor.BLUE -> Material.BLUE_BANNER;
            case DyeColor.BROWN -> Material.BROWN_BANNER;
            case DyeColor.GREEN -> Material.GREEN_BANNER;
            case DyeColor.RED -> Material.RED_BANNER;
            case DyeColor.BLACK -> Material.BLACK_BANNER;
            default -> throw new IllegalArgumentException("Unknown banner colour");
        };
    }
}

