/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public record WrappedMinMaxBounds(@Nullable Float min, @Nullable Float max) {
    public static final WrappedMinMaxBounds ANY = new WrappedMinMaxBounds(null, null);
    public static final SimpleCommandExceptionType ERROR_INTS_ONLY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.ints"));

    public static WrappedMinMaxBounds exactly(float var0) {
        return new WrappedMinMaxBounds(Float.valueOf(var0), Float.valueOf(var0));
    }

    public static WrappedMinMaxBounds between(float var0, float var1) {
        return new WrappedMinMaxBounds(Float.valueOf(var0), Float.valueOf(var1));
    }

    public static WrappedMinMaxBounds atLeast(float var0) {
        return new WrappedMinMaxBounds(Float.valueOf(var0), null);
    }

    public static WrappedMinMaxBounds atMost(float var0) {
        return new WrappedMinMaxBounds(null, Float.valueOf(var0));
    }

    public boolean matches(float var0) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && this.min.floatValue() > var0 && this.max.floatValue() < var0) {
            return false;
        }
        if (this.min != null && this.min.floatValue() > var0) {
            return false;
        }
        return this.max == null || !(this.max.floatValue() < var0);
    }

    public boolean matchesSqr(double var0) {
        if (this.min != null && this.max != null && this.min.floatValue() > this.max.floatValue() && (double)(this.min.floatValue() * this.min.floatValue()) > var0 && (double)(this.max.floatValue() * this.max.floatValue()) < var0) {
            return false;
        }
        if (this.min != null && (double)(this.min.floatValue() * this.min.floatValue()) > var0) {
            return false;
        }
        return this.max == null || !((double)(this.max.floatValue() * this.max.floatValue()) < var0);
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        if (this.min != null && this.max != null && this.min.equals(this.max)) {
            return new JsonPrimitive((Number)this.min);
        }
        JsonObject var0 = new JsonObject();
        if (this.min != null) {
            var0.addProperty("min", (Number)this.min);
        }
        if (this.max != null) {
            var0.addProperty("max", (Number)this.min);
        }
        return var0;
    }

    public static WrappedMinMaxBounds fromJson(@Nullable JsonElement var0) {
        if (var0 == null || var0.isJsonNull()) {
            return ANY;
        }
        if (GsonHelper.isNumberValue(var0)) {
            float var1 = GsonHelper.convertToFloat(var0, "value");
            return new WrappedMinMaxBounds(Float.valueOf(var1), Float.valueOf(var1));
        }
        JsonObject var1 = GsonHelper.convertToJsonObject(var0, "value");
        Float var2 = var1.has("min") ? Float.valueOf(GsonHelper.getAsFloat(var1, "min")) : null;
        Float var3 = var1.has("max") ? Float.valueOf(GsonHelper.getAsFloat(var1, "max")) : null;
        return new WrappedMinMaxBounds(var2, var3);
    }

    public static WrappedMinMaxBounds fromReader(StringReader var02, boolean var1) throws CommandSyntaxException {
        return WrappedMinMaxBounds.fromReader(var02, var1, var0 -> var0);
    }

    public static WrappedMinMaxBounds fromReader(StringReader var0, boolean var1, Function<Float, Float> var2) throws CommandSyntaxException {
        Float var5;
        if (!var0.canRead()) {
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
        }
        int var3 = var0.getCursor();
        Float var4 = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(var0, var1), var2);
        if (var0.canRead(2) && var0.peek() == '.' && var0.peek(1) == '.') {
            var0.skip();
            var0.skip();
            var5 = WrappedMinMaxBounds.optionallyFormat(WrappedMinMaxBounds.readNumber(var0, var1), var2);
            if (var4 == null && var5 == null) {
                var0.setCursor(var3);
                throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
            }
        } else {
            if (!var1 && var0.canRead() && var0.peek() == '.') {
                var0.setCursor(var3);
                throw ERROR_INTS_ONLY.createWithContext((ImmutableStringReader)var0);
            }
            var5 = var4;
        }
        if (var4 == null && var5 == null) {
            var0.setCursor(var3);
            throw MinMaxBounds.ERROR_EMPTY.createWithContext((ImmutableStringReader)var0);
        }
        return new WrappedMinMaxBounds(var4, var5);
    }

    @Nullable
    private static Float readNumber(StringReader var0, boolean var1) throws CommandSyntaxException {
        int var2 = var0.getCursor();
        while (var0.canRead() && WrappedMinMaxBounds.isAllowedNumber(var0, var1)) {
            var0.skip();
        }
        String var3 = var0.getString().substring(var2, var0.getCursor());
        if (var3.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(var3));
        }
        catch (NumberFormatException var4) {
            if (var1) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidDouble().createWithContext((ImmutableStringReader)var0, (Object)var3);
            }
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)var0, (Object)var3);
        }
    }

    private static boolean isAllowedNumber(StringReader var0, boolean var1) {
        char var2 = var0.peek();
        if (var2 >= '0' && var2 <= '9' || var2 == '-') {
            return true;
        }
        if (var1 && var2 == '.') {
            return !var0.canRead(2) || var0.peek(1) != '.';
        }
        return false;
    }

    @Nullable
    private static Float optionallyFormat(@Nullable Float var0, Function<Float, Float> var1) {
        return var0 == null ? null : var1.apply(var0);
    }
}

