/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector.options;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.WrappedMinMaxBounds;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public class EntitySelectorOptions {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Option> OPTIONS = Maps.newHashMap();
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_OPTION = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.entity.options.unknown", var0));
    public static final DynamicCommandExceptionType ERROR_INAPPLICABLE_OPTION = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.entity.options.inapplicable", var0));
    public static final SimpleCommandExceptionType ERROR_RANGE_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.distance.negative"));
    public static final SimpleCommandExceptionType ERROR_LEVEL_NEGATIVE = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.level.negative"));
    public static final SimpleCommandExceptionType ERROR_LIMIT_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("argument.entity.options.limit.toosmall"));
    public static final DynamicCommandExceptionType ERROR_SORT_UNKNOWN = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.entity.options.sort.irreversible", var0));
    public static final DynamicCommandExceptionType ERROR_GAME_MODE_INVALID = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.entity.options.mode.invalid", var0));
    public static final DynamicCommandExceptionType ERROR_ENTITY_TYPE_INVALID = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.entity.options.type.invalid", var0));

    private static void register(String var0, Modifier var1, Predicate<EntitySelectorParser> var2, Component var3) {
        OPTIONS.put(var0, new Option(var1, var2, var3));
    }

    public static void bootStrap() {
        if (!OPTIONS.isEmpty()) {
            return;
        }
        EntitySelectorOptions.register("name", var0 -> {
            int var1 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            String var3 = var0.getReader().readString();
            if (var0.hasNameNotEquals() && !var22) {
                var0.getReader().setCursor(var1);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"name");
            }
            if (var22) {
                var0.setHasNameNotEquals(true);
            } else {
                var0.setHasNameEquals(true);
            }
            var0.addPredicate(var2 -> var2.getName().getString().equals(var3) != var22);
        }, var0 -> !var0.hasNameEquals(), Component.translatable("argument.entity.options.name.description"));
        EntitySelectorOptions.register("distance", var0 -> {
            int var1 = var0.getReader().getCursor();
            MinMaxBounds.Doubles var2 = MinMaxBounds.Doubles.fromReader(var0.getReader());
            if (var2.min().isPresent() && var2.min().get() < 0.0 || var2.max().isPresent() && var2.max().get() < 0.0) {
                var0.getReader().setCursor(var1);
                throw ERROR_RANGE_NEGATIVE.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setDistance(var2);
            var0.setWorldLimited();
        }, var0 -> var0.getDistance().isAny(), Component.translatable("argument.entity.options.distance.description"));
        EntitySelectorOptions.register("level", var0 -> {
            int var1 = var0.getReader().getCursor();
            MinMaxBounds.Ints var2 = MinMaxBounds.Ints.fromReader(var0.getReader());
            if (var2.min().isPresent() && var2.min().get() < 0 || var2.max().isPresent() && var2.max().get() < 0) {
                var0.getReader().setCursor(var1);
                throw ERROR_LEVEL_NEGATIVE.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setLevel(var2);
            var0.setIncludesEntities(false);
        }, var0 -> var0.getLevel().isAny(), Component.translatable("argument.entity.options.level.description"));
        EntitySelectorOptions.register("x", var0 -> {
            var0.setWorldLimited();
            var0.setX(var0.getReader().readDouble());
        }, var0 -> var0.getX() == null, Component.translatable("argument.entity.options.x.description"));
        EntitySelectorOptions.register("y", var0 -> {
            var0.setWorldLimited();
            var0.setY(var0.getReader().readDouble());
        }, var0 -> var0.getY() == null, Component.translatable("argument.entity.options.y.description"));
        EntitySelectorOptions.register("z", var0 -> {
            var0.setWorldLimited();
            var0.setZ(var0.getReader().readDouble());
        }, var0 -> var0.getZ() == null, Component.translatable("argument.entity.options.z.description"));
        EntitySelectorOptions.register("dx", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaX(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaX() == null, Component.translatable("argument.entity.options.dx.description"));
        EntitySelectorOptions.register("dy", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaY(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaY() == null, Component.translatable("argument.entity.options.dy.description"));
        EntitySelectorOptions.register("dz", var0 -> {
            var0.setWorldLimited();
            var0.setDeltaZ(var0.getReader().readDouble());
        }, var0 -> var0.getDeltaZ() == null, Component.translatable("argument.entity.options.dz.description"));
        EntitySelectorOptions.register("x_rotation", var0 -> var0.setRotX(WrappedMinMaxBounds.fromReader(var0.getReader(), true, Mth::wrapDegrees)), var0 -> var0.getRotX() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.x_rotation.description"));
        EntitySelectorOptions.register("y_rotation", var0 -> var0.setRotY(WrappedMinMaxBounds.fromReader(var0.getReader(), true, Mth::wrapDegrees)), var0 -> var0.getRotY() == WrappedMinMaxBounds.ANY, Component.translatable("argument.entity.options.y_rotation.description"));
        EntitySelectorOptions.register("limit", var0 -> {
            int var1 = var0.getReader().getCursor();
            int var2 = var0.getReader().readInt();
            if (var2 < 1) {
                var0.getReader().setCursor(var1);
                throw ERROR_LIMIT_TOO_SMALL.createWithContext((ImmutableStringReader)var0.getReader());
            }
            var0.setMaxResults(var2);
            var0.setLimited(true);
        }, var0 -> !var0.isCurrentEntity() && !var0.isLimited(), Component.translatable("argument.entity.options.limit.description"));
        EntitySelectorOptions.register("sort", var02 -> {
            int var12 = var02.getReader().getCursor();
            String var2 = var02.getReader().readUnquotedString();
            var02.setSuggestions((var0, var1) -> SharedSuggestionProvider.suggest(Arrays.asList("nearest", "furthest", "random", "arbitrary"), var0));
            var02.setOrder(switch (var2) {
                case "nearest" -> EntitySelectorParser.ORDER_NEAREST;
                case "furthest" -> EntitySelectorParser.ORDER_FURTHEST;
                case "random" -> EntitySelectorParser.ORDER_RANDOM;
                case "arbitrary" -> EntitySelector.ORDER_ARBITRARY;
                default -> {
                    var02.getReader().setCursor(var12);
                    throw ERROR_SORT_UNKNOWN.createWithContext((ImmutableStringReader)var02.getReader(), (Object)var2);
                }
            });
            var02.setSorted(true);
        }, var0 -> !var0.isCurrentEntity() && !var0.isSorted(), Component.translatable("argument.entity.options.sort.description"));
        EntitySelectorOptions.register("gamemode", var0 -> {
            var0.setSuggestions((var1, var2) -> {
                String var3 = var1.getRemaining().toLowerCase(Locale.ROOT);
                boolean var4 = !var0.hasGamemodeNotEquals();
                boolean var5 = true;
                if (!var3.isEmpty()) {
                    if (var3.charAt(0) == '!') {
                        var4 = false;
                        var3 = var3.substring(1);
                    } else {
                        var5 = false;
                    }
                }
                for (GameType var9 : GameType.values()) {
                    if (!var9.getName().toLowerCase(Locale.ROOT).startsWith(var3)) continue;
                    if (var5) {
                        var1.suggest("!" + var9.getName());
                    }
                    if (!var4) continue;
                    var1.suggest(var9.getName());
                }
                return var1.buildFuture();
            });
            int var12 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            if (var0.hasGamemodeNotEquals() && !var22) {
                var0.getReader().setCursor(var12);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"gamemode");
            }
            String var3 = var0.getReader().readUnquotedString();
            GameType var4 = GameType.byName(var3, null);
            if (var4 == null) {
                var0.getReader().setCursor(var12);
                throw ERROR_GAME_MODE_INVALID.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var3);
            }
            var0.setIncludesEntities(false);
            var0.addPredicate(var2 -> {
                if (var2 instanceof ServerPlayer) {
                    ServerPlayer var3 = (ServerPlayer)var2;
                    GameType var4 = var3.gameMode();
                    return var4 == var4 ^ var22;
                }
                return false;
            });
            if (var22) {
                var0.setHasGamemodeNotEquals(true);
            } else {
                var0.setHasGamemodeEquals(true);
            }
        }, var0 -> !var0.hasGamemodeEquals(), Component.translatable("argument.entity.options.gamemode.description"));
        EntitySelectorOptions.register("team", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            String var22 = var0.getReader().readUnquotedString();
            var0.addPredicate(var2 -> {
                PlayerTeam var3 = var2.getTeam();
                String var4 = var3 == null ? "" : ((Team)var3).getName();
                return var4.equals(var22) != var1;
            });
            if (var1) {
                var0.setHasTeamNotEquals(true);
            } else {
                var0.setHasTeamEquals(true);
            }
        }, var0 -> !var0.hasTeamEquals(), Component.translatable("argument.entity.options.team.description"));
        EntitySelectorOptions.register("type", var0 -> {
            var0.setSuggestions((var1, var2) -> {
                SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), var1, String.valueOf('!'));
                SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(var0 -> var0.key().location()), var1, "!#");
                if (!var0.isTypeLimitedInversely()) {
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.keySet(), var1);
                    SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.getTags().map(var0 -> var0.key().location()), var1, String.valueOf('#'));
                }
                return var1.buildFuture();
            });
            int var12 = var0.getReader().getCursor();
            boolean var22 = var0.shouldInvertValue();
            if (var0.isTypeLimitedInversely() && !var22) {
                var0.getReader().setCursor(var12);
                throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)"type");
            }
            if (var22) {
                var0.setTypeLimitedInversely();
            }
            if (var0.isTag()) {
                TagKey<EntityType<?>> var3 = TagKey.create(Registries.ENTITY_TYPE, ResourceLocation.read(var0.getReader()));
                var0.addPredicate(var2 -> var2.getType().is(var3) != var22);
            } else {
                ResourceLocation var3 = ResourceLocation.read(var0.getReader());
                EntityType var4 = (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(var3).orElseThrow(() -> {
                    var0.getReader().setCursor(var12);
                    return ERROR_ENTITY_TYPE_INVALID.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var3.toString());
                });
                if (Objects.equals(EntityType.PLAYER, var4) && !var22) {
                    var0.setIncludesEntities(false);
                }
                var0.addPredicate(var2 -> Objects.equals(var4, var2.getType()) != var22);
                if (!var22) {
                    var0.limitToType(var4);
                }
            }
        }, var0 -> !var0.isTypeLimited(), Component.translatable("argument.entity.options.type.description"));
        EntitySelectorOptions.register("tag", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            String var22 = var0.getReader().readUnquotedString();
            var0.addPredicate(var2 -> {
                if ("".equals(var22)) {
                    return var2.getTags().isEmpty() != var1;
                }
                return var2.getTags().contains(var22) != var1;
            });
        }, var0 -> true, Component.translatable("argument.entity.options.tag.description"));
        EntitySelectorOptions.register("nbt", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            CompoundTag var22 = TagParser.parseCompoundAsArgument(var0.getReader());
            var0.addPredicate(var2 -> {
                try (ProblemReporter.ScopedCollector var3 = new ProblemReporter.ScopedCollector(var2.problemPath(), LOGGER);){
                    ServerPlayer var5;
                    ItemStack var6;
                    TagValueOutput var4 = TagValueOutput.createWithContext(var3, var2.registryAccess());
                    var2.saveWithoutId(var4);
                    if (var2 instanceof ServerPlayer && !(var6 = (var5 = (ServerPlayer)var2).getInventory().getSelectedItem()).isEmpty()) {
                        var4.store("SelectedItem", ItemStack.CODEC, var6);
                    }
                    boolean bl = NbtUtils.compareNbt(var22, var4.buildResult(), true) != var1;
                    return bl;
                }
            });
        }, var0 -> true, Component.translatable("argument.entity.options.nbt.description"));
        EntitySelectorOptions.register("scores", var0 -> {
            StringReader var12 = var0.getReader();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                String var3 = var12.readUnquotedString();
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                MinMaxBounds.Ints var4 = MinMaxBounds.Ints.fromReader(var12);
                var2.put(var3, var4);
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.addPredicate(var1 -> {
                    ServerScoreboard var2 = var1.getServer().getScoreboard();
                    for (Map.Entry var4 : var2.entrySet()) {
                        Objective var5 = var2.getObjective((String)var4.getKey());
                        if (var5 == null) {
                            return false;
                        }
                        ReadOnlyScoreInfo var6 = var2.getPlayerScoreInfo((ScoreHolder)var1, var5);
                        if (var6 == null) {
                            return false;
                        }
                        if (((MinMaxBounds.Ints)var4.getValue()).matches(var6.value())) continue;
                        return false;
                    }
                    return true;
                });
            }
            var0.setHasScores(true);
        }, var0 -> !var0.hasScores(), Component.translatable("argument.entity.options.scores.description"));
        EntitySelectorOptions.register("advancements", var0 -> {
            StringReader var12 = var0.getReader();
            HashMap var2 = Maps.newHashMap();
            var12.expect('{');
            var12.skipWhitespace();
            while (var12.canRead() && var12.peek() != '}') {
                var12.skipWhitespace();
                ResourceLocation var3 = ResourceLocation.read(var12);
                var12.skipWhitespace();
                var12.expect('=');
                var12.skipWhitespace();
                if (var12.canRead() && var12.peek() == '{') {
                    HashMap var4 = Maps.newHashMap();
                    var12.skipWhitespace();
                    var12.expect('{');
                    var12.skipWhitespace();
                    while (var12.canRead() && var12.peek() != '}') {
                        var12.skipWhitespace();
                        String var5 = var12.readUnquotedString();
                        var12.skipWhitespace();
                        var12.expect('=');
                        var12.skipWhitespace();
                        boolean var6 = var12.readBoolean();
                        var4.put(var5, var1 -> var1.isDone() == var6);
                        var12.skipWhitespace();
                        if (!var12.canRead() || var12.peek() != ',') continue;
                        var12.skip();
                    }
                    var12.skipWhitespace();
                    var12.expect('}');
                    var12.skipWhitespace();
                    var2.put(var3, var1 -> {
                        for (Map.Entry var3 : var4.entrySet()) {
                            CriterionProgress var4 = var1.getCriterion((String)var3.getKey());
                            if (var4 != null && ((Predicate)var3.getValue()).test(var4)) continue;
                            return false;
                        }
                        return true;
                    });
                } else {
                    boolean var4 = var12.readBoolean();
                    var2.put(var3, var1 -> var1.isDone() == var4);
                }
                var12.skipWhitespace();
                if (!var12.canRead() || var12.peek() != ',') continue;
                var12.skip();
            }
            var12.expect('}');
            if (!var2.isEmpty()) {
                var0.addPredicate(var1 -> {
                    if (!(var1 instanceof ServerPlayer)) {
                        return false;
                    }
                    ServerPlayer var2 = (ServerPlayer)var1;
                    PlayerAdvancements var3 = var2.getAdvancements();
                    ServerAdvancementManager var4 = var2.getServer().getAdvancements();
                    for (Map.Entry var6 : var2.entrySet()) {
                        AdvancementHolder var7 = var4.get((ResourceLocation)var6.getKey());
                        if (var7 != null && ((Predicate)var6.getValue()).test(var3.getOrStartProgress(var7))) continue;
                        return false;
                    }
                    return true;
                });
                var0.setIncludesEntities(false);
            }
            var0.setHasAdvancements(true);
        }, var0 -> !var0.hasAdvancements(), Component.translatable("argument.entity.options.advancements.description"));
        EntitySelectorOptions.register("predicate", var0 -> {
            boolean var1 = var0.shouldInvertValue();
            ResourceKey<LootItemCondition> var22 = ResourceKey.create(Registries.PREDICATE, ResourceLocation.read(var0.getReader()));
            var0.addPredicate(var2 -> {
                if (!(var2.level() instanceof ServerLevel)) {
                    return false;
                }
                ServerLevel var3 = (ServerLevel)var2.level();
                Optional<LootItemCondition> var4 = var3.getServer().reloadableRegistries().lookup().get(var22).map(Holder::value);
                if (var4.isEmpty()) {
                    return false;
                }
                LootParams var5 = new LootParams.Builder(var3).withParameter(LootContextParams.THIS_ENTITY, var2).withParameter(LootContextParams.ORIGIN, var2.position()).create(LootContextParamSets.SELECTOR);
                LootContext var6 = new LootContext.Builder(var5).create(Optional.empty());
                var6.pushVisitedElement(LootContext.createVisitedEntry(var4.get()));
                return var1 ^ var4.get().test(var6);
            });
        }, var0 -> true, Component.translatable("argument.entity.options.predicate.description"));
    }

    public static Modifier get(EntitySelectorParser var0, String var1, int var2) throws CommandSyntaxException {
        Option var3 = OPTIONS.get(var1);
        if (var3 != null) {
            if (var3.canUse.test(var0)) {
                return var3.modifier;
            }
            throw ERROR_INAPPLICABLE_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var1);
        }
        var0.getReader().setCursor(var2);
        throw ERROR_UNKNOWN_OPTION.createWithContext((ImmutableStringReader)var0.getReader(), (Object)var1);
    }

    public static void suggestNames(EntitySelectorParser var0, SuggestionsBuilder var1) {
        String var2 = var1.getRemaining().toLowerCase(Locale.ROOT);
        for (Map.Entry<String, Option> var4 : OPTIONS.entrySet()) {
            if (!var4.getValue().canUse.test(var0) || !var4.getKey().toLowerCase(Locale.ROOT).startsWith(var2)) continue;
            var1.suggest(var4.getKey() + "=", (Message)var4.getValue().description);
        }
    }

    static final class Option
    extends Record {
        final Modifier modifier;
        final Predicate<EntitySelectorParser> canUse;
        final Component description;

        Option(Modifier var0, Predicate<EntitySelectorParser> var1, Component var2) {
            this.modifier = var0;
            this.canUse = var1;
            this.description = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Option.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Option.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Option.class, "modifier;canUse;description", "modifier", "canUse", "description"}, this, var0);
        }

        public Modifier modifier() {
            return this.modifier;
        }

        public Predicate<EntitySelectorParser> canUse() {
            return this.canUse;
        }

        public Component description() {
            return this.description;
        }
    }

    public static interface Modifier {
        public void handle(EntitySelectorParser var1) throws CommandSyntaxException;
    }
}

