/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("#"), var0 -> {
        var0.setMaximumFractionDigits(15);
        var0.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    });
    private static final int MAX_CACHE_ENTRIES = 8;
    private final List<String> parameters;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> cache = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final ResourceLocation id;
    private final List<Entry<T>> entries;

    public MacroFunction(ResourceLocation var0, List<Entry<T>> var1, List<String> var2) {
        this.id = var0;
        this.entries = var1;
        this.parameters = var2;
    }

    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    public InstantiatedFunction<T> instantiate(@Nullable CompoundTag var0, CommandDispatcher<T> var1) throws FunctionInstantiationException {
        if (var0 == null) {
            throw new FunctionInstantiationException(Component.translatable("commands.function.error.missing_arguments", Component.translationArg(this.id())));
        }
        ArrayList<String> var2 = new ArrayList<String>(this.parameters.size());
        for (String string : this.parameters) {
            Tag var5 = var0.get(string);
            if (var5 == null) {
                throw new FunctionInstantiationException(Component.translatable("commands.function.error.missing_argument", Component.translationArg(this.id()), string));
            }
            var2.add(MacroFunction.stringify(var5));
        }
        InstantiatedFunction var3 = (InstantiatedFunction)this.cache.getAndMoveToLast(var2);
        if (var3 != null) {
            return var3;
        }
        if (this.cache.size() >= 8) {
            this.cache.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction = this.substituteAndParse(this.parameters, var2, var1);
        this.cache.put(var2, instantiatedFunction);
        return instantiatedFunction;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String stringify(Tag var0) {
        String string;
        Tag tag = var0;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FloatTag.class, DoubleTag.class, ByteTag.class, ShortTag.class, LongTag.class, StringTag.class}, (Object)tag2, n)) {
            case 0: {
                float var4;
                FloatTag floatTag = (FloatTag)tag2;
                try {
                    float f;
                    var4 = f = floatTag.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                string = DECIMAL_FORMAT.format(var4);
                return string;
            }
            case 1: {
                double var6;
                DoubleTag doubleTag = (DoubleTag)tag2;
                {
                    double d;
                    var6 = d = doubleTag.value();
                }
                string = DECIMAL_FORMAT.format(var6);
                return string;
            }
            case 2: {
                byte var9;
                ByteTag byteTag = (ByteTag)tag2;
                {
                    byte by;
                    var9 = by = byteTag.value();
                }
                string = String.valueOf(var9);
                return string;
            }
            case 3: {
                short var11;
                ShortTag shortTag = (ShortTag)tag2;
                {
                    short s;
                    var11 = s = shortTag.value();
                }
                string = String.valueOf(var11);
                return string;
            }
            case 4: {
                long var13;
                LongTag longTag = (LongTag)tag2;
                {
                    long l;
                    var13 = l = longTag.value();
                }
                string = String.valueOf(var13);
                return string;
            }
            case 5: {
                StringTag stringTag = (StringTag)tag2;
                {
                    String string2;
                    String var16;
                    string = var16 = (string2 = stringTag.value());
                    return string;
                }
            }
        }
        string = var0.toString();
        return string;
    }

    private static void lookupValues(List<String> var0, IntList var1, List<String> var22) {
        var22.clear();
        var1.forEach(var2 -> var22.add((String)var0.get(var2)));
    }

    private InstantiatedFunction<T> substituteAndParse(List<String> var0, List<String> var12, CommandDispatcher<T> var2) throws FunctionInstantiationException {
        ArrayList var3 = new ArrayList(this.entries.size());
        ArrayList<String> var4 = new ArrayList<String>(var12.size());
        for (Entry<T> var6 : this.entries) {
            MacroFunction.lookupValues(var12, var6.parameters(), var4);
            var3.add(var6.instantiate(var4, var2, this.id));
        }
        return new PlainTextFunction(this.id().withPath(var1 -> var1 + "/" + var0.hashCode()), var3);
    }

    static interface Entry<T> {
        public IntList parameters();

        public UnboundEntryAction<T> instantiate(List<String> var1, CommandDispatcher<T> var2, ResourceLocation var3) throws FunctionInstantiationException;
    }

    static class MacroEntry<T extends ExecutionCommandSource<T>>
    implements Entry<T> {
        private final StringTemplate template;
        private final IntList parameters;
        private final T compilationContext;

        public MacroEntry(StringTemplate var0, IntList var1, T var2) {
            this.template = var0;
            this.parameters = var1;
            this.compilationContext = var2;
        }

        @Override
        public IntList parameters() {
            return this.parameters;
        }

        @Override
        public UnboundEntryAction<T> instantiate(List<String> var0, CommandDispatcher<T> var1, ResourceLocation var2) throws FunctionInstantiationException {
            String var3 = this.template.substitute(var0);
            try {
                return CommandFunction.parseCommand(var1, this.compilationContext, new StringReader(var3));
            }
            catch (CommandSyntaxException var4) {
                throw new FunctionInstantiationException(Component.translatable("commands.function.error.parse", Component.translationArg(var2), var3, var4.getMessage()));
            }
        }
    }

    static class PlainTextEntry<T>
    implements Entry<T> {
        private final UnboundEntryAction<T> compiledAction;

        public PlainTextEntry(UnboundEntryAction<T> var0) {
            this.compiledAction = var0;
        }

        @Override
        public IntList parameters() {
            return IntLists.emptyList();
        }

        @Override
        public UnboundEntryAction<T> instantiate(List<String> var0, CommandDispatcher<T> var1, ResourceLocation var2) {
            return this.compiledAction;
        }
    }
}

